# This file has been autogenerated by the pywayland scanner

# Copyright © 2022 Joshua Ashton
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class XwaylandSurfaceV1(Interface):
    """Interface for associating xwayland windows to wl_surfaces

    An Xwayland surface is a surface managed by an Xwayland server. It is used
    for associating surfaces to Xwayland windows.

    The Xwayland server associated with actions in this interface is determined
    by the Wayland client making the request.

    The client must call :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` on the corresponding
    :class:`~pywayland.protocol.wayland.WlSurface` for the
    :class:`XwaylandSurfaceV1` state to take effect.
    """

    name = "xwayland_surface_v1"
    version = 1

    class error(enum.IntEnum):
        already_associated = 0
        invalid_serial = 1


class XwaylandSurfaceV1Proxy(Proxy[XwaylandSurfaceV1]):
    interface = XwaylandSurfaceV1

    @XwaylandSurfaceV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_serial(self, serial_lo: int, serial_hi: int) -> None:
        """Associates a xwayland window to a :class:`~pywayland.protocol.wayland.WlSurface`

        Associates an Xwayland window to a
        :class:`~pywayland.protocol.wayland.WlSurface`. The association state
        is double-buffered and will be applied at the time
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` of the corresponding
        :class:`~pywayland.protocol.wayland.WlSurface` is called.

        The `serial_lo` and `serial_hi` parameters specify a non-zero monotonic
        serial number which is entirely unique and provided by the Xwayland
        server equal to the serial value provided by a client message with a
        message type of the `WL_SURFACE_SERIAL` atom on the X11 window for this
        surface to be associated to.

        The serial value in the `WL_SURFACE_SERIAL` client message is specified
        as having the lo-bits specified in `l[0]` and the hi-bits specified in
        `l[1]`.

        If the serial value provided by `serial_lo` and `serial_hi` is not
        valid, the `invalid_serial` protocol error will be raised.

        An X11 window may be associated with multiple surfaces throughout its
        lifespan. (eg. unmapping and remapping a window).

        For each :class:`~pywayland.protocol.wayland.WlSurface`, this state
        must not be committed more than once, otherwise the
        `already_associated` protocol error will be raised.

        :param serial_lo:
            The lower 32-bits of the serial number associated with the X11
            window
        :type serial_lo:
            `ArgumentType.Uint`
        :param serial_hi:
            The upper 32-bits of the serial number associated with the X11
            window
        :type serial_hi:
            `ArgumentType.Uint`
        """
        self._marshal(0, serial_lo, serial_hi)

    @XwaylandSurfaceV1.request()
    def destroy(self) -> None:
        """Destroy the xwayland surface object

        Destroy the :class:`XwaylandSurfaceV1` object.

        Any already existing associations are unaffected by this action.
        """
        self._marshal(1)
        self._destroy()


class XwaylandSurfaceV1Resource(Resource):
    interface = XwaylandSurfaceV1


class XwaylandSurfaceV1Global(Global):
    interface = XwaylandSurfaceV1


XwaylandSurfaceV1._gen_c()
XwaylandSurfaceV1.proxy_class = XwaylandSurfaceV1Proxy
XwaylandSurfaceV1.resource_class = XwaylandSurfaceV1Resource
XwaylandSurfaceV1.global_class = XwaylandSurfaceV1Global
