/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.KNNMethod;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodResolver;
import org.opensearch.knn.index.engine.NativeLibrary;
import org.opensearch.knn.index.engine.ResolvedMethodContext;
import org.opensearch.knn.index.engine.faiss.FaissHNSWMethod;
import org.opensearch.knn.index.engine.faiss.FaissIVFMethod;
import org.opensearch.knn.index.engine.faiss.FaissMethodResolver;

public class Faiss
extends NativeLibrary {
    public static final String FAISS_BINARY_INDEX_DESCRIPTION_PREFIX = "B";
    Map<SpaceType, Function<Float, Float>> scoreTransform;
    private static final String CURRENT_VERSION = "165";
    private static final Map<SpaceType, Function<Float, Float>> SCORE_TRANSLATIONS = ImmutableMap.of((Object)((Object)SpaceType.INNER_PRODUCT), rawScore -> Float.valueOf(SpaceType.INNER_PRODUCT.scoreTranslation(-1.0f * rawScore.floatValue())));
    private static final Map<SpaceType, Function<Float, Float>> SCORE_TO_DISTANCE_TRANSFORMATIONS = ImmutableMap.builder().put((Object)SpaceType.INNER_PRODUCT, score -> Float.valueOf(score.floatValue() > 1.0f ? 1.0f - score.floatValue() : 1.0f / score.floatValue() - 1.0f)).build();
    static final Map<String, KNNMethod> METHODS = ImmutableMap.of((Object)"hnsw", (Object)new FaissHNSWMethod(), (Object)"ivf", (Object)new FaissIVFMethod());
    public static final Faiss INSTANCE = new Faiss(METHODS, SCORE_TRANSLATIONS, "165", ".faiss", SCORE_TO_DISTANCE_TRANSFORMATIONS);
    private final MethodResolver methodResolver;

    private Faiss(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String currentVersion, String extension, Map<SpaceType, Function<Float, Float>> scoreTransform) {
        super(methods, scoreTranslation, currentVersion, extension);
        this.scoreTransform = scoreTransform;
        this.methodResolver = new FaissMethodResolver();
    }

    @Override
    public Float distanceToRadialThreshold(Float distance, SpaceType spaceType) {
        return distance;
    }

    @Override
    public Float scoreToRadialThreshold(Float score, SpaceType spaceType) {
        if (this.scoreTransform.containsKey((Object)spaceType)) {
            return this.scoreTransform.get((Object)spaceType).apply(score);
        }
        return Float.valueOf(spaceType.scoreToDistanceTranslation(score.floatValue()));
    }

    @Override
    public ResolvedMethodContext resolveMethod(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext, boolean shouldRequireTraining, SpaceType spaceType) {
        return this.methodResolver.resolveMethod(knnMethodContext, knnMethodConfigContext, shouldRequireTraining, spaceType);
    }
}

