/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.spark.cluster.FlintIndexRetention;
import org.opensearch.sql.spark.cluster.FlintStreamingJobHouseKeeperTask;
import org.opensearch.sql.spark.cluster.IndexCleanup;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOpFactory;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class ClusterManagerEventListener
implements LocalNodeClusterManagerListener {
    private Scheduler.Cancellable flintIndexRetentionCron;
    private Scheduler.Cancellable flintStreamingJobHouseKeeperCron;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private Clock clock;
    private DataSourceService dataSourceService;
    private FlintIndexMetadataService flintIndexMetadataService;
    private FlintIndexOpFactory flintIndexOpFactory;
    private Duration sessionTtlDuration;
    private Duration resultTtlDuration;
    private TimeValue streamingJobHouseKeepingInterval;
    private boolean isAutoIndexManagementEnabled;

    public ClusterManagerEventListener(ClusterService clusterService, ThreadPool threadPool, Client client, Clock clock, Setting<TimeValue> sessionTtl, Setting<TimeValue> resultTtl, Setting<TimeValue> streamingJobHouseKeepingInterval, Setting<Boolean> isAutoIndexManagementEnabledSetting, Settings settings, DataSourceService dataSourceService, FlintIndexMetadataService flintIndexMetadataService, FlintIndexOpFactory flintIndexOpFactory) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        this.clock = clock;
        this.dataSourceService = dataSourceService;
        this.flintIndexMetadataService = flintIndexMetadataService;
        this.flintIndexOpFactory = flintIndexOpFactory;
        this.sessionTtlDuration = ClusterManagerEventListener.toDuration((TimeValue)sessionTtl.get(settings));
        this.resultTtlDuration = ClusterManagerEventListener.toDuration((TimeValue)resultTtl.get(settings));
        this.streamingJobHouseKeepingInterval = (TimeValue)streamingJobHouseKeepingInterval.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(sessionTtl, it -> {
            this.sessionTtlDuration = ClusterManagerEventListener.toDuration(it);
            this.cancel(this.flintIndexRetentionCron);
            this.reInitializeFlintIndexRetention();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(resultTtl, it -> {
            this.resultTtlDuration = ClusterManagerEventListener.toDuration(it);
            this.cancel(this.flintIndexRetentionCron);
            this.reInitializeFlintIndexRetention();
        });
        this.isAutoIndexManagementEnabled = (Boolean)isAutoIndexManagementEnabledSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(isAutoIndexManagementEnabledSetting, it -> {
            if (this.isAutoIndexManagementEnabled != it) {
                this.isAutoIndexManagementEnabled = it;
                if (it.booleanValue()) {
                    this.onClusterManager();
                } else {
                    this.offClusterManager();
                }
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(streamingJobHouseKeepingInterval, it -> {
            this.streamingJobHouseKeepingInterval = it;
            this.cancel(this.flintStreamingJobHouseKeeperCron);
            this.initializeStreamingJobHouseKeeperCron();
        });
    }

    public void onClusterManager() {
        if (this.isAutoIndexManagementEnabled && this.flintIndexRetentionCron == null) {
            this.reInitializeFlintIndexRetention();
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.flintIndexRetentionCron);
                    ClusterManagerEventListener.this.flintIndexRetentionCron = null;
                }
            });
        }
        if (this.flintStreamingJobHouseKeeperCron == null) {
            this.initializeStreamingJobHouseKeeperCron();
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.flintStreamingJobHouseKeeperCron);
                    ClusterManagerEventListener.this.flintStreamingJobHouseKeeperCron = null;
                }
            });
        }
    }

    private void initializeStreamingJobHouseKeeperCron() {
        this.flintStreamingJobHouseKeeperCron = this.threadPool.scheduleWithFixedDelay((Runnable)new FlintStreamingJobHouseKeeperTask(this.dataSourceService, this.flintIndexMetadataService, this.flintIndexOpFactory), this.streamingJobHouseKeepingInterval, this.executorName());
    }

    private void reInitializeFlintIndexRetention() {
        IndexCleanup indexCleanup = new IndexCleanup(this.client, this.clusterService);
        this.flintIndexRetentionCron = this.threadPool.scheduleWithFixedDelay((Runnable)new FlintIndexRetention(this.sessionTtlDuration, this.resultTtlDuration, this.clock, indexCleanup, ".query_execution_request*", "query_execution_result*"), TimeValue.timeValueHours((long)24L), this.executorName());
    }

    public void offClusterManager() {
        this.cancel(this.flintIndexRetentionCron);
        this.flintIndexRetentionCron = null;
        this.cancel(this.flintStreamingJobHouseKeeperCron);
        this.flintStreamingJobHouseKeeperCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }

    @VisibleForTesting
    public List<Scheduler.Cancellable> getFlintIndexRetentionCron() {
        return Arrays.asList(this.flintIndexRetentionCron);
    }

    private String executorName() {
        return "generic";
    }

    public static Duration toDuration(TimeValue timeValue) {
        return Duration.ofMillis(timeValue.millis());
    }
}

