/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.scheduler.parser;

import java.io.IOException;
import java.time.Instant;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.sql.spark.rest.model.LangType;
import org.opensearch.sql.spark.scheduler.model.ScheduledAsyncQueryJobRequest;

public class OpenSearchScheduleQueryJobRequestParser {
    private static Instant parseInstantValue(XContentParser parser) throws IOException {
        if (XContentParser.Token.VALUE_NULL.equals((Object)parser.currentToken())) {
            return null;
        }
        if (parser.currentToken().isValue()) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
        return null;
    }

    public static ScheduledJobParser getJobParser() {
        return (parser, id, jobDocVersion) -> {
            ScheduledAsyncQueryJobRequest.ScheduledAsyncQueryJobRequestBuilder builder = ScheduledAsyncQueryJobRequest.builder();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            block26: while (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
                String fieldName = parser.currentName();
                parser.nextToken();
                switch (fieldName) {
                    case "accountId": {
                        builder.accountId(parser.text());
                        continue block26;
                    }
                    case "jobId": {
                        builder.jobId(parser.text());
                        continue block26;
                    }
                    case "dataSource": {
                        builder.dataSource(parser.text());
                        continue block26;
                    }
                    case "scheduledQuery": {
                        builder.scheduledQuery(parser.text());
                        continue block26;
                    }
                    case "queryLang": {
                        builder.queryLang(LangType.fromString((String)parser.text()));
                        continue block26;
                    }
                    case "enabled": {
                        builder.enabled(parser.booleanValue());
                        continue block26;
                    }
                    case "enabledTime": {
                        builder.enabledTime(OpenSearchScheduleQueryJobRequestParser.parseInstantValue(parser));
                        continue block26;
                    }
                    case "lastUpdateTime": {
                        builder.lastUpdateTime(OpenSearchScheduleQueryJobRequestParser.parseInstantValue(parser));
                        continue block26;
                    }
                    case "schedule": {
                        builder.schedule(ScheduleParser.parse((XContentParser)parser));
                        continue block26;
                    }
                    case "lockDurationSeconds": {
                        builder.lockDurationSeconds(parser.longValue());
                        continue block26;
                    }
                    case "jitter": {
                        builder.jitter(parser.doubleValue());
                        continue block26;
                    }
                }
                XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
            }
            return builder.build();
        };
    }
}

