/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.MLTaskRequest;

public class MLDeployModelRequest
extends MLTaskRequest {
    private static final String NODE_IDS_FIELD = "node_ids";
    private final String modelId;
    private final String[] modelNodeIds;
    private final boolean async;
    private final boolean isUserInitiatedDeployRequest;

    public MLDeployModelRequest(String modelId, String[] modelNodeIds, boolean async, boolean dispatchTask, boolean isUserInitiatedDeployRequest) {
        super(dispatchTask);
        this.modelId = modelId;
        this.modelNodeIds = modelNodeIds;
        this.async = async;
        this.isUserInitiatedDeployRequest = isUserInitiatedDeployRequest;
    }

    public MLDeployModelRequest(String modelId, boolean async) {
        this(modelId, null, async, true, true);
    }

    public MLDeployModelRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readString();
        this.modelNodeIds = in.readOptionalStringArray();
        this.async = in.readBoolean();
        this.isUserInitiatedDeployRequest = in.readBoolean();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.modelId == null) {
            exception = ValidateActions.addValidationError((String)"ML model id can't be null", exception);
        }
        return exception;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelId);
        out.writeOptionalStringArray(this.modelNodeIds);
        out.writeBoolean(this.async);
        out.writeBoolean(this.isUserInitiatedDeployRequest);
    }

    public static MLDeployModelRequest parse(XContentParser parser, String modelId) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        ArrayList<String> nodeIdList = new ArrayList<String>();
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        nodeIdList.add(parser.text());
                    }
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        String[] nodeIds = nodeIdList == null ? null : nodeIdList.toArray(new String[0]);
        return new MLDeployModelRequest(modelId, nodeIds, false, true, true);
    }

    /*
     * Exception decompiling
     */
    public static MLDeployModelRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public static MLDeployModelRequestBuilder builder() {
        return new MLDeployModelRequestBuilder();
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String[] getModelNodeIds() {
        return this.modelNodeIds;
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Generated
    public boolean isUserInitiatedDeployRequest() {
        return this.isUserInitiatedDeployRequest;
    }

    @Generated
    public String toString() {
        return "MLDeployModelRequest(modelId=" + this.getModelId() + ", modelNodeIds=" + Arrays.deepToString(this.getModelNodeIds()) + ", async=" + this.isAsync() + ", isUserInitiatedDeployRequest=" + this.isUserInitiatedDeployRequest() + ")";
    }

    @Generated
    public static class MLDeployModelRequestBuilder {
        @Generated
        private String modelId;
        @Generated
        private String[] modelNodeIds;
        @Generated
        private boolean async;
        @Generated
        private boolean dispatchTask;
        @Generated
        private boolean isUserInitiatedDeployRequest;

        @Generated
        MLDeployModelRequestBuilder() {
        }

        @Generated
        public MLDeployModelRequestBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLDeployModelRequestBuilder modelNodeIds(String[] modelNodeIds) {
            this.modelNodeIds = modelNodeIds;
            return this;
        }

        @Generated
        public MLDeployModelRequestBuilder async(boolean async) {
            this.async = async;
            return this;
        }

        @Generated
        public MLDeployModelRequestBuilder dispatchTask(boolean dispatchTask) {
            this.dispatchTask = dispatchTask;
            return this;
        }

        @Generated
        public MLDeployModelRequestBuilder isUserInitiatedDeployRequest(boolean isUserInitiatedDeployRequest) {
            this.isUserInitiatedDeployRequest = isUserInitiatedDeployRequest;
            return this;
        }

        @Generated
        public MLDeployModelRequest build() {
            return new MLDeployModelRequest(this.modelId, this.modelNodeIds, this.async, this.dispatchTask, this.isUserInitiatedDeployRequest);
        }

        @Generated
        public String toString() {
            return "MLDeployModelRequest.MLDeployModelRequestBuilder(modelId=" + this.modelId + ", modelNodeIds=" + Arrays.deepToString(this.modelNodeIds) + ", async=" + this.async + ", dispatchTask=" + this.dispatchTask + ", isUserInitiatedDeployRequest=" + this.isUserInitiatedDeployRequest + ")";
        }
    }
}

