/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

public class NeuQuant {
    public static final int ncycles = 100;
    public static final int netsize = 255;
    public static final int specials = 3;
    public static final int bgColour = 2;
    public static final int cutnetsize = 252;
    public static final int maxnetpos = 254;
    public static final int initrad = 31;
    public static final int radiusbiasshift = 6;
    public static final int radiusbias = 64;
    public static final int initBiasRadius = 1984;
    public static final int radiusdec = 30;
    public static final int alphabiasshift = 10;
    public static final int initalpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betagamma = 1.0;
    private double[][] network = new double[255][3];
    protected int[][] colormap = new int[255][4];
    private int[] netindex = new int[256];
    private double[] bias = new double[255];
    private double[] freq = new double[255];
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxprime = 503;
    protected int[][] pixels = null;
    private int samplefac = 0;

    public NeuQuant(int sample, int[][] pixels) {
        if (sample < 1) {
            throw new RuntimeException("Sample must be 1..30");
        }
        if (sample > 30) {
            throw new RuntimeException("Sample must be 1..30");
        }
        this.samplefac = sample;
        this.setPixels(pixels);
        this.setUpArrays();
    }

    public int getColorCount() {
        return 255;
    }

    public int[] getColorMap() {
        int[] c = new int[256];
        c[0] = 0;
        for (int i = 0; i < 255; ++i) {
            c[i + 1] = this.colormap[i][0] | this.colormap[i][1] << 8 | this.colormap[i][2] << 16 | 0xFF000000;
        }
        return c;
    }

    protected void setUpArrays() {
        int i;
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 1.0;
        this.network[1][1] = 1.0;
        this.network[1][2] = 1.0;
        for (i = 0; i < 3; ++i) {
            this.freq[i] = 0.00392156862745098;
            this.bias[i] = 0.0;
        }
        for (i = 3; i < 255; ++i) {
            double[] p = this.network[i];
            p[0] = 256.0 * (double)(i - 3) / 252.0;
            p[1] = 256.0 * (double)(i - 3) / 252.0;
            p[2] = 256.0 * (double)(i - 3) / 252.0;
            this.freq[i] = 0.00392156862745098;
            this.bias[i] = 0.0;
        }
    }

    private void setPixels(int[][] pixels) {
        if (pixels.length * pixels[0].length < 503) {
            throw new RuntimeException("Image is too small");
        }
        this.pixels = pixels;
    }

    public void init() {
        this.learn();
        this.fix();
        this.inxbuild();
    }

    private void altersingle(double alpha, int i, double b, double g, double r) {
        double[] n = this.network[i];
        n[0] = n[0] - alpha * (n[0] - b);
        n[1] = n[1] - alpha * (n[1] - g);
        n[2] = n[2] - alpha * (n[2] - r);
    }

    private void alterneigh(double alpha, int rad, int i, double b, double g, double r) {
        int hi;
        int lo = i - rad;
        if (lo < 2) {
            lo = 2;
        }
        if ((hi = i + rad) > 255) {
            hi = 255;
        }
        int j = i + 1;
        int k = i - 1;
        int q = 0;
        while (j < hi || k > lo) {
            double[] p;
            double a = alpha * (double)(rad * rad - q * q) / (double)(rad * rad);
            ++q;
            if (j < hi) {
                p = this.network[j];
                p[0] = p[0] - a * (p[0] - b);
                p[1] = p[1] - a * (p[1] - g);
                p[2] = p[2] - a * (p[2] - r);
                ++j;
            }
            if (k <= lo) continue;
            p = this.network[k];
            p[0] = p[0] - a * (p[0] - b);
            p[1] = p[1] - a * (p[1] - g);
            p[2] = p[2] - a * (p[2] - r);
            --k;
        }
    }

    private int contest(double b, double g, double r) {
        int bestpos;
        double bestd;
        double bestbiasd = bestd = 3.4028234663852886E38;
        int bestbiaspos = bestpos = -1;
        for (int i = 3; i < 255; ++i) {
            double biasdist;
            double a;
            double[] n = this.network[i];
            double dist = n[0] - b;
            if (dist < 0.0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0.0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0.0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i;
            }
            if ((biasdist = dist - this.bias[i]) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i;
            }
            int n2 = i;
            this.freq[n2] = this.freq[n2] - 9.765625E-4 * this.freq[i];
            int n3 = i;
            this.bias[n3] = this.bias[n3] + 1.0 * this.freq[i];
        }
        int n = bestpos;
        this.freq[n] = this.freq[n] + 9.765625E-4;
        int n4 = bestpos;
        this.bias[n4] = this.bias[n4] - 1.0;
        return bestbiaspos;
    }

    private int specialFind(double b, double g, double r) {
        for (int i = 0; i < 3; ++i) {
            double[] n = this.network[i];
            if (n[0] != b || n[1] != g || n[2] != r) continue;
            return i;
        }
        return -1;
    }

    private void learn() {
        int biasRadius = 1984;
        int alphadec = 30 + (this.samplefac - 1) / 3;
        int lengthcount = this.pixels.length * this.pixels[0].length;
        int samplepixels = lengthcount / this.samplefac;
        int delta = samplepixels / 100;
        int alpha = 1024;
        int i = 0;
        int rad = biasRadius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        int step = 0;
        int pos = 0;
        step = lengthcount % 499 != 0 ? 499 : (lengthcount % 491 != 0 ? 491 : (lengthcount % 487 != 0 ? 487 : 503));
        i = 0;
        while (i < samplepixels) {
            int j;
            int p = this.pixels[pos / this.pixels[0].length][pos % this.pixels[0].length];
            int red = p >> 16 & 0xFF;
            int green = p >> 8 & 0xFF;
            int blue = p & 0xFF;
            double b = blue;
            double g = green;
            double r = red;
            if (i == 0) {
                this.network[2][0] = b;
                this.network[2][1] = g;
                this.network[2][2] = r;
            }
            int n = j = (j = this.specialFind(b, g, r)) < 0 ? this.contest(b, g, r) : j;
            if (j >= 3) {
                double a = 1.0 * (double)alpha / 1024.0;
                this.altersingle(a, j, b, g, r);
                if (rad > 0) {
                    this.alterneigh(a, rad, j, b, g, r);
                }
            }
            pos += step;
            while (pos >= lengthcount) {
                pos -= lengthcount;
            }
            if (++i % delta != 0) continue;
            alpha -= alpha / alphadec;
            if ((rad = (biasRadius -= biasRadius / 30) >> 6) > 1) continue;
            rad = 0;
        }
    }

    private void fix() {
        for (int i = 0; i < 255; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x = (int)(0.5 + this.network[i][j]);
                if (x < 0) {
                    x = 0;
                }
                if (x > 255) {
                    x = 255;
                }
                this.colormap[i][j] = x;
            }
            this.colormap[i][3] = i;
        }
    }

    private void inxbuild() {
        int previouscol = 0;
        int startpos = 0;
        for (int i = 0; i < 255; ++i) {
            int j;
            int[] p = this.colormap[i];
            int[] q = null;
            int smallpos = i;
            int smallval = p[1];
            for (j = i + 1; j < 255; ++j) {
                q = this.colormap[j];
                if (q[1] >= smallval) continue;
                smallpos = j;
                smallval = q[1];
            }
            q = this.colormap[smallpos];
            if (i != smallpos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval == previouscol) continue;
            this.netindex[previouscol] = startpos + i >> 1;
            for (j = previouscol + 1; j < smallval; ++j) {
                this.netindex[j] = i;
            }
            previouscol = smallval;
            startpos = i;
        }
        this.netindex[previouscol] = startpos + 254 >> 1;
        for (int j = previouscol + 1; j < 256; ++j) {
            this.netindex[j] = 254;
        }
    }

    public int convert(int pixel) {
        int alfa = pixel >> 24 & 0xFF;
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int i = this.inxsearch(b, g, r);
        int bb = this.colormap[i][0];
        int gg = this.colormap[i][1];
        int rr = this.colormap[i][2];
        return alfa << 24 | rr << 16 | gg << 8 | bb;
    }

    public int lookup(int pixel) {
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int i = this.inxsearch(b, g, r);
        return i + 1;
    }

    private int not_used_slow_inxsearch(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        for (int i = 0; i < 255; ++i) {
            int a;
            int[] p = this.colormap[i];
            int dist = p[1] - g;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            dist += a;
            a = p[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) >= bestd) continue;
            bestd = dist;
            best = i;
        }
        return best;
    }

    protected int inxsearch(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        int i = this.netindex[g];
        int j = i - 1;
        while (i < 255 || j >= 0) {
            int a;
            int dist;
            int[] p;
            if (i < 255) {
                p = this.colormap[i];
                dist = p[1] - g;
                if (dist >= bestd) {
                    i = 255;
                } else {
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestd) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            bestd = dist;
                            best = i;
                        }
                    }
                    ++i;
                }
            }
            if (j < 0) continue;
            p = this.colormap[j];
            dist = g - p[1];
            if (dist >= bestd) {
                j = -1;
                continue;
            }
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                a = p[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) < bestd) {
                    bestd = dist;
                    best = j;
                }
            }
            --j;
        }
        return best;
    }
}

