/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.CombinedRealm;
import org.apache.catalina.realm.RealmBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class LockOutRealm
extends CombinedRealm {
    private static final Log log = LogFactory.getLog(LockOutRealm.class);
    protected static final String name = "LockOutRealm";
    protected int failureCount = 5;
    protected int lockOutTime = 300;
    protected int cacheSize = 1000;
    protected int cacheRemovalWarningTime = 3600;
    protected Map<String, LockRecord> failedUsers = null;

    @Override
    protected void startInternal() throws LifecycleException {
        this.failedUsers = new LinkedHashMap<String, LockRecord>(this.cacheSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LockRecord> entry) {
                if (this.size() > LockOutRealm.this.cacheSize) {
                    long l = (System.currentTimeMillis() - entry.getValue().getLastFailureTime()) / 1000L;
                    if (l < (long)LockOutRealm.this.cacheRemovalWarningTime) {
                        log.warn((Object)RealmBase.sm.getString("lockOutRealm.removeWarning", new Object[]{entry.getKey(), l}));
                    }
                    return true;
                }
                return false;
            }
        };
        super.startInternal();
    }

    @Override
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        Principal principal = super.authenticate(string, string2, string3, string4, string5, string6, string7, string8, string9);
        return this.filterLockedAccounts(string, principal);
    }

    @Override
    public Principal authenticate(String string, String string2) {
        Principal principal = super.authenticate(string, string2);
        return this.filterLockedAccounts(string, principal);
    }

    @Override
    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        String string = null;
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            string = x509CertificateArray[0].getSubjectX500Principal().toString();
        }
        Principal principal = super.authenticate(x509CertificateArray);
        return this.filterLockedAccounts(string, principal);
    }

    @Override
    public Principal authenticate(GSSContext gSSContext, boolean bl) {
        if (gSSContext.isEstablished()) {
            String string = null;
            GSSName gSSName = null;
            try {
                gSSName = gSSContext.getSrcName();
            }
            catch (GSSException gSSException) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)gSSException);
                return null;
            }
            string = gSSName.toString();
            Principal principal = super.authenticate(gSSContext, bl);
            return this.filterLockedAccounts(string, principal);
        }
        return null;
    }

    @Override
    public Principal authenticate(GSSName gSSName, GSSCredential gSSCredential) {
        String string = gSSName.toString();
        Principal principal = super.authenticate(gSSName, gSSCredential);
        return this.filterLockedAccounts(string, principal);
    }

    private Principal filterLockedAccounts(String string, Principal principal) {
        if (principal == null && this.isAvailable()) {
            this.registerAuthFailure(string);
        }
        if (this.isLocked(string)) {
            log.warn((Object)sm.getString("lockOutRealm.authLockedUser", new Object[]{string}));
            return null;
        }
        if (principal != null) {
            this.registerAuthSuccess(string);
        }
        return principal;
    }

    public void unlock(String string) {
        this.registerAuthSuccess(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(String string) {
        LockRecord lockRecord = null;
        LockOutRealm lockOutRealm = this;
        synchronized (lockOutRealm) {
            lockRecord = this.failedUsers.get(string);
        }
        if (lockRecord == null) {
            return false;
        }
        return lockRecord.getFailures() >= this.failureCount && (System.currentTimeMillis() - lockRecord.getLastFailureTime()) / 1000L < (long)this.lockOutTime;
    }

    private synchronized void registerAuthSuccess(String string) {
        this.failedUsers.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAuthFailure(String string) {
        LockRecord lockRecord = null;
        LockOutRealm lockOutRealm = this;
        synchronized (lockOutRealm) {
            if (!this.failedUsers.containsKey(string)) {
                lockRecord = new LockRecord();
                this.failedUsers.put(string, lockRecord);
            } else {
                lockRecord = this.failedUsers.get(string);
                if (lockRecord.getFailures() >= this.failureCount && (System.currentTimeMillis() - lockRecord.getLastFailureTime()) / 1000L > (long)this.lockOutTime) {
                    lockRecord.setFailures(0);
                }
            }
        }
        lockRecord.registerFailure();
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int n) {
        this.failureCount = n;
    }

    public int getLockOutTime() {
        return this.lockOutTime;
    }

    @Override
    protected String getName() {
        return name;
    }

    public void setLockOutTime(int n) {
        this.lockOutTime = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheRemovalWarningTime() {
        return this.cacheRemovalWarningTime;
    }

    public void setCacheRemovalWarningTime(int n) {
        this.cacheRemovalWarningTime = n;
    }

    protected static class LockRecord {
        private final AtomicInteger failures = new AtomicInteger(0);
        private long lastFailureTime = 0L;

        protected LockRecord() {
        }

        public int getFailures() {
            return this.failures.get();
        }

        public void setFailures(int n) {
            this.failures.set(n);
        }

        public long getLastFailureTime() {
            return this.lastFailureTime;
        }

        public void registerFailure() {
            this.failures.incrementAndGet();
            this.lastFailureTime = System.currentTimeMillis();
        }
    }
}

