/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sapling;

import java.util.Objects;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.sapling.SaplingNode;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;

public class SaplingProcessingInstruction
extends SaplingNode {
    private final String name;
    private final String value;

    public SaplingProcessingInstruction(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue() {
        return this.value;
    }

    @Override
    public int getNodeKind() {
        return 7;
    }

    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        receiver.processingInstruction(this.name, StringView.of(this.value), Loc.NONE, 0);
    }
}

