/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class MultiValueCellRenderer
extends JLabel
implements TableCellRenderer {
    private final ImageIcon iconDecided;
    private final ImageIcon iconUndecided;
    private final JosmComboBoxModel<Object> model;
    private final JosmComboBox<Object> cbDecisionRenderer;

    public MultiValueCellRenderer() {
        this.setOpaque(true);
        this.iconDecided = ImageProvider.get("dialogs/conflict", "tagconflictresolved");
        this.iconUndecided = ImageProvider.get("dialogs/conflict", "tagconflictunresolved");
        this.model = new JosmComboBoxModel();
        this.cbDecisionRenderer = new JosmComboBox<Object>(this.model);
    }

    protected void renderColors(MultiValueResolutionDecision decision, boolean selected, boolean conflict) {
        if (selected) {
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
        } else {
            block0 : switch (decision.getDecisionType()) {
                case UNDECIDED: {
                    this.setForeground(ConflictColors.FGCOLOR_UNDECIDED.get());
                    this.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
                    break;
                }
                case KEEP_NONE: {
                    this.setForeground(ConflictColors.FGCOLOR_TAG_KEEP_NONE.get());
                    this.setBackground(ConflictColors.BGCOLOR_TAG_KEEP_NONE.get());
                    break;
                }
                default: {
                    if (conflict) {
                        switch (decision.getDecisionType()) {
                            case KEEP_ONE: {
                                this.setForeground(ConflictColors.FGCOLOR_TAG_KEEP_ONE.get());
                                this.setBackground(ConflictColors.BGCOLOR_TAG_KEEP_ONE.get());
                                break block0;
                            }
                            case KEEP_ALL: {
                                this.setForeground(ConflictColors.FGCOLOR_TAG_KEEP_ALL.get());
                                this.setBackground(ConflictColors.BGCOLOR_TAG_KEEP_ALL.get());
                                break block0;
                            }
                            case SUM_ALL_NUMERIC: {
                                this.setForeground(ConflictColors.FGCOLOR_TAG_SUM_ALL_NUM.get());
                                this.setBackground(ConflictColors.BGCOLOR_TAG_SUM_ALL_NUM.get());
                                break block0;
                            }
                        }
                        Logging.error("Unknown decision type in renderColors(): " + decision.getDecisionType());
                        break;
                    }
                    this.setForeground(UIManager.getColor("Table.foreground"));
                    this.setBackground(UIManager.getColor("Table.background"));
                }
            }
        }
    }

    protected void renderValue(MultiValueResolutionDecision decision) {
        this.model.removeAllElements();
        switch (decision.getDecisionType()) {
            case UNDECIDED: {
                this.model.addElement(I18n.tr("Choose a value", new Object[0]));
                this.cbDecisionRenderer.setFont(this.getFont().deriveFont(2));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_NONE: {
                this.model.addElement(I18n.tr("deleted", new Object[0]));
                this.cbDecisionRenderer.setFont(this.getFont().deriveFont(2));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_ONE: 
            case KEEP_ALL: 
            case SUM_ALL_NUMERIC: {
                this.model.addElement(decision.getChosenValue());
                this.cbDecisionRenderer.setFont(this.getFont());
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            default: {
                Logging.error("Unknown decision type in renderValue(): " + decision.getDecisionType());
            }
        }
    }

    protected void renderToolTipText(MultiValueResolutionDecision decision) {
        String toolTipText = null;
        switch (decision.getDecisionType()) {
            case UNDECIDED: {
                toolTipText = I18n.tr("Please decide which values to keep", new Object[0]);
                break;
            }
            case KEEP_ONE: {
                toolTipText = I18n.tr("Value ''{0}'' is going to be applied for key ''{1}''", decision.getChosenValue(), decision.getKey());
                break;
            }
            case SUM_ALL_NUMERIC: {
                toolTipText = I18n.tr("All numeric values sumed as ''{0}'' are going to be applied for key ''{1}''", decision.getChosenValue(), decision.getKey());
                break;
            }
            case KEEP_NONE: {
                toolTipText = I18n.tr("The key ''{0}'' and all its values are going to be removed", decision.getKey());
                break;
            }
            case KEEP_ALL: {
                toolTipText = I18n.tr("All values joined as ''{0}'' are going to be applied for key ''{1}''", decision.getChosenValue(), decision.getKey());
            }
        }
        this.setToolTipText(toolTipText);
        this.cbDecisionRenderer.setToolTipText(toolTipText);
    }

    protected void reset() {
        this.setFont(UIManager.getFont("Table.font"));
        this.setIcon(null);
        this.setText("");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        if (value == null) {
            return this;
        }
        MultiValueResolutionDecision decision = (MultiValueResolutionDecision)value;
        TagConflictResolverModel tagModel = (TagConflictResolverModel)table.getModel();
        boolean conflict = tagModel.getKeysWithConflicts().contains(tagModel.getKey(row));
        this.renderColors(decision, isSelected, conflict);
        this.renderToolTipText(decision);
        switch (column) {
            case 0: {
                if (decision.isDecided()) {
                    this.setIcon(this.iconDecided);
                } else {
                    this.setIcon(this.iconUndecided);
                }
                return this;
            }
            case 1: {
                this.setText(decision.getKey());
                return this;
            }
            case 2: {
                this.renderValue(decision);
                return this.cbDecisionRenderer;
            }
        }
        return this;
    }
}

