/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated Go wrapper file in order to allow an easy
use of the 3MF Library.

Interface version: 2.3.0

*/

// Code generated by Automatic Component Toolkit (ACT); DO NOT EDIT.

package lib3mf

/*
#cgo linux LDFLAGS: -ldl
#include "lib3mf_dynamic.cc"

Lib3MFHandle loadLib3MFLibrary (const char * pFileName)
{
	Lib3MFResult nResult;
	sLib3MFDynamicWrapperTable * pWrapperTable = (sLib3MFDynamicWrapperTable *) malloc (sizeof (sLib3MFDynamicWrapperTable));
	if (pWrapperTable != NULL) {
		nResult = InitLib3MFWrapperTable (pWrapperTable);
		if (nResult != LIB3MF_SUCCESS) {
			free (pWrapperTable);
			return 0;
		}

		nResult = LoadLib3MFWrapperTable (pWrapperTable, pFileName);
		if (nResult != LIB3MF_SUCCESS) {
			free (pWrapperTable);
			return 0;
		}

		return (Lib3MFHandle) pWrapperTable;
	}
}

void unloadLib3MFLibrary (Lib3MFHandle nLibraryHandle)
{
	sLib3MFDynamicWrapperTable * pWrapperTable = (sLib3MFDynamicWrapperTable *) malloc (sizeof (sLib3MFDynamicWrapperTable));
	if (pWrapperTable != NULL) {
		ReleaseLib3MFWrapperTable (pWrapperTable);
		free (pWrapperTable);
	}
}


Lib3MFResult CCall_lib3mf_base_classtypeid(Lib3MFHandle libraryHandle, Lib3MF_Base pBase, Lib3MF_uint64 * pClassTypeId)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Base_ClassTypeId (pBase, pClassTypeId);
}


Lib3MFResult CCall_lib3mf_writer_writetofile(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, const char * pFilename)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_WriteToFile (pWriter, pFilename);
}


Lib3MFResult CCall_lib3mf_writer_getstreamsize(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint64 * pStreamSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetStreamSize (pWriter, pStreamSize);
}


Lib3MFResult CCall_lib3mf_writer_writetobuffer(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_WriteToBuffer (pWriter, nBufferBufferSize, pBufferNeededCount, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_writer_writetocallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MFWriteCallback pTheWriteCallback, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_WriteToCallback (pWriter, pTheWriteCallback, pTheSeekCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_writer_setprogresscallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetProgressCallback (pWriter, pProgressCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_writer_getdecimalprecision(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 * pDecimalPrecision)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetDecimalPrecision (pWriter, pDecimalPrecision);
}


Lib3MFResult CCall_lib3mf_writer_setdecimalprecision(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 nDecimalPrecision)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetDecimalPrecision (pWriter, nDecimalPrecision);
}


Lib3MFResult CCall_lib3mf_writer_setstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, bool bStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetStrictModeActive (pWriter, bStrictModeActive);
}


Lib3MFResult CCall_lib3mf_writer_getstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, bool * pStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetStrictModeActive (pWriter, pStrictModeActive);
}


Lib3MFResult CCall_lib3mf_writer_getwarning(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetWarning (pWriter, nIndex, pErrorCode, nWarningBufferSize, pWarningNeededChars, pWarningBuffer);
}


Lib3MFResult CCall_lib3mf_writer_getwarningcount(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetWarningCount (pWriter, pCount);
}


Lib3MFResult CCall_lib3mf_writer_addkeywrappingcallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_AddKeyWrappingCallback (pWriter, pConsumerID, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_writer_setcontentencryptioncallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetContentEncryptionCallback (pWriter, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_readfromfile(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pFilename)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_ReadFromFile (pReader, pFilename);
}


Lib3MFResult CCall_lib3mf_reader_readfrombuffer(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_ReadFromBuffer (pReader, nBufferBufferSize, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_reader_readfromcallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_ReadFromCallback (pReader, pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_setprogresscallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_SetProgressCallback (pReader, pProgressCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_addrelationtoread(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pRelationShipType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_AddRelationToRead (pReader, pRelationShipType);
}


Lib3MFResult CCall_lib3mf_reader_removerelationtoread(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pRelationShipType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_RemoveRelationToRead (pReader, pRelationShipType);
}


Lib3MFResult CCall_lib3mf_reader_setstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, bool bStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_SetStrictModeActive (pReader, bStrictModeActive);
}


Lib3MFResult CCall_lib3mf_reader_getstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, bool * pStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_GetStrictModeActive (pReader, pStrictModeActive);
}


Lib3MFResult CCall_lib3mf_reader_getwarning(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_GetWarning (pReader, nIndex, pErrorCode, nWarningBufferSize, pWarningNeededChars, pWarningBuffer);
}


Lib3MFResult CCall_lib3mf_reader_getwarningcount(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_GetWarningCount (pReader, pCount);
}


Lib3MFResult CCall_lib3mf_reader_addkeywrappingcallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_AddKeyWrappingCallback (pReader, pConsumerID, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_setcontentencryptioncallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_SetContentEncryptionCallback (pReader, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_packagepart_getpath(Lib3MFHandle libraryHandle, Lib3MF_PackagePart pPackagePart, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_PackagePart_GetPath (pPackagePart, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_packagepart_setpath(Lib3MFHandle libraryHandle, Lib3MF_PackagePart pPackagePart, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_PackagePart_SetPath (pPackagePart, pPath);
}


Lib3MFResult CCall_lib3mf_resource_getresourceid(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_GetResourceID (pResource, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_resource_getuniqueresourceid(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_GetUniqueResourceID (pResource, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_resource_packagepart(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_PackagePart * pPackagePart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_PackagePart (pResource, pPackagePart);
}


Lib3MFResult CCall_lib3mf_resource_setpackagepart(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_PackagePart pPackagePart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_SetPackagePart (pResource, pPackagePart);
}


Lib3MFResult CCall_lib3mf_resource_getmodelresourceid(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_uint32 * pModelResourceId)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_GetModelResourceID (pResource, pModelResourceId);
}


Lib3MFResult CCall_lib3mf_resourceiterator_movenext(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, bool * pHasNext)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_MoveNext (pResourceIterator, pHasNext);
}


Lib3MFResult CCall_lib3mf_resourceiterator_moveprevious(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, bool * pHasPrevious)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_MovePrevious (pResourceIterator, pHasPrevious);
}


Lib3MFResult CCall_lib3mf_resourceiterator_getcurrent(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, Lib3MF_Resource * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_GetCurrent (pResourceIterator, pResource);
}


Lib3MFResult CCall_lib3mf_resourceiterator_clone(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, Lib3MF_ResourceIterator * pOutResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_Clone (pResourceIterator, pOutResourceIterator);
}


Lib3MFResult CCall_lib3mf_resourceiterator_count(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_Count (pResourceIterator, pCount);
}


Lib3MFResult CCall_lib3mf_slicestackiterator_getcurrentslicestack(Lib3MFHandle libraryHandle, Lib3MF_SliceStackIterator pSliceStackIterator, Lib3MF_SliceStack * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStackIterator_GetCurrentSliceStack (pSliceStackIterator, pResource);
}


Lib3MFResult CCall_lib3mf_objectiterator_getcurrentobject(Lib3MFHandle libraryHandle, Lib3MF_ObjectIterator pObjectIterator, Lib3MF_Object * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ObjectIterator_GetCurrentObject (pObjectIterator, pResource);
}


Lib3MFResult CCall_lib3mf_meshobjectiterator_getcurrentmeshobject(Lib3MFHandle libraryHandle, Lib3MF_MeshObjectIterator pMeshObjectIterator, Lib3MF_MeshObject * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObjectIterator_GetCurrentMeshObject (pMeshObjectIterator, pResource);
}


Lib3MFResult CCall_lib3mf_componentsobjectiterator_getcurrentcomponentsobject(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObjectIterator pComponentsObjectIterator, Lib3MF_ComponentsObject * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject (pComponentsObjectIterator, pResource);
}


Lib3MFResult CCall_lib3mf_texture2diterator_getcurrenttexture2d(Lib3MFHandle libraryHandle, Lib3MF_Texture2DIterator pTexture2DIterator, Lib3MF_Texture2D * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DIterator_GetCurrentTexture2D (pTexture2DIterator, pResource);
}


Lib3MFResult CCall_lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroupIterator pBaseMaterialGroupIterator, Lib3MF_BaseMaterialGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup (pBaseMaterialGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_colorgroupiterator_getcurrentcolorgroup(Lib3MFHandle libraryHandle, Lib3MF_ColorGroupIterator pColorGroupIterator, Lib3MF_ColorGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroupIterator_GetCurrentColorGroup (pColorGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroupIterator pTexture2DGroupIterator, Lib3MF_Texture2DGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup (pTexture2DGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_compositematerialsiterator_getcurrentcompositematerials(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterialsIterator pCompositeMaterialsIterator, Lib3MF_CompositeMaterials * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials (pCompositeMaterialsIterator, pResource);
}


Lib3MFResult CCall_lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroupIterator pMultiPropertyGroupIterator, Lib3MF_MultiPropertyGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup (pMultiPropertyGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_metadata_getnamespace(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameSpaceBufferSize, Lib3MF_uint32* pNameSpaceNeededChars, char * pNameSpaceBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetNameSpace (pMetaData, nNameSpaceBufferSize, pNameSpaceNeededChars, pNameSpaceBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_setnamespace(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pNameSpace)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetNameSpace (pMetaData, pNameSpace);
}


Lib3MFResult CCall_lib3mf_metadata_getname(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetName (pMetaData, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_setname(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetName (pMetaData, pName);
}


Lib3MFResult CCall_lib3mf_metadata_getkey(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nKeyBufferSize, Lib3MF_uint32* pKeyNeededChars, char * pKeyBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetKey (pMetaData, nKeyBufferSize, pKeyNeededChars, pKeyBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_getmustpreserve(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, bool * pMustPreserve)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetMustPreserve (pMetaData, pMustPreserve);
}


Lib3MFResult CCall_lib3mf_metadata_setmustpreserve(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, bool bMustPreserve)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetMustPreserve (pMetaData, bMustPreserve);
}


Lib3MFResult CCall_lib3mf_metadata_gettype(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nTypeBufferSize, Lib3MF_uint32* pTypeNeededChars, char * pTypeBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetType (pMetaData, nTypeBufferSize, pTypeNeededChars, pTypeBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_settype(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetType (pMetaData, pType);
}


Lib3MFResult CCall_lib3mf_metadata_getvalue(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nValueBufferSize, Lib3MF_uint32* pValueNeededChars, char * pValueBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetValue (pMetaData, nValueBufferSize, pValueNeededChars, pValueBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_setvalue(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetValue (pMetaData, pValue);
}


Lib3MFResult CCall_lib3mf_metadatagroup_getmetadatacount(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_GetMetaDataCount (pMetaDataGroup, pCount);
}


Lib3MFResult CCall_lib3mf_metadatagroup_getmetadata(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex, Lib3MF_MetaData * pMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_GetMetaData (pMetaDataGroup, nIndex, pMetaData);
}


Lib3MFResult CCall_lib3mf_metadatagroup_getmetadatabykey(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, Lib3MF_MetaData * pMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_GetMetaDataByKey (pMetaDataGroup, pNameSpace, pName, pMetaData);
}


Lib3MFResult CCall_lib3mf_metadatagroup_removemetadatabyindex(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex (pMetaDataGroup, nIndex);
}


Lib3MFResult CCall_lib3mf_metadatagroup_removemetadata(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_MetaData pTheMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_RemoveMetaData (pMetaDataGroup, pTheMetaData);
}


Lib3MFResult CCall_lib3mf_metadatagroup_addmetadata(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, const char * pValue, const char * pType, bool bMustPreserve, Lib3MF_MetaData * pMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_AddMetaData (pMetaDataGroup, pNameSpace, pName, pValue, pType, bMustPreserve, pMetaData);
}


Lib3MFResult CCall_lib3mf_object_gettype(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFObjectType * pObjectType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetType (pObject, pObjectType);
}


Lib3MFResult CCall_lib3mf_object_settype(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFObjectType eObjectType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetType (pObject, eObjectType);
}


Lib3MFResult CCall_lib3mf_object_getname(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetName (pObject, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_object_setname(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetName (pObject, pName);
}


Lib3MFResult CCall_lib3mf_object_getpartnumber(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetPartNumber (pObject, nPartNumberBufferSize, pPartNumberNeededChars, pPartNumberBuffer);
}


Lib3MFResult CCall_lib3mf_object_setpartnumber(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const char * pPartNumber)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetPartNumber (pObject, pPartNumber);
}


Lib3MFResult CCall_lib3mf_object_ismeshobject(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsMeshObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsMeshObject (pObject, pIsMeshObject);
}


Lib3MFResult CCall_lib3mf_object_iscomponentsobject(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsComponentsObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsComponentsObject (pObject, pIsComponentsObject);
}


Lib3MFResult CCall_lib3mf_object_isvalid(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsValid)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsValid (pObject, pIsValid);
}


Lib3MFResult CCall_lib3mf_object_setattachmentasthumbnail(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_Attachment pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetAttachmentAsThumbnail (pObject, pAttachment);
}


Lib3MFResult CCall_lib3mf_object_getthumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetThumbnailAttachment (pObject, pAttachment);
}


Lib3MFResult CCall_lib3mf_object_clearthumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Object pObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_ClearThumbnailAttachment (pObject);
}


Lib3MFResult CCall_lib3mf_object_getoutbox(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, sLib3MFBox * pOutbox)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetOutbox (pObject, pOutbox);
}


Lib3MFResult CCall_lib3mf_object_getuuid(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetUUID (pObject, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_object_setuuid(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetUUID (pObject, pUUID);
}


Lib3MFResult CCall_lib3mf_object_getmetadatagroup(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetMetaDataGroup (pObject, pMetaDataGroup);
}


Lib3MFResult CCall_lib3mf_object_setslicesmeshresolution(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFSlicesMeshResolution eMeshResolution)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetSlicesMeshResolution (pObject, eMeshResolution);
}


Lib3MFResult CCall_lib3mf_object_getslicesmeshresolution(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFSlicesMeshResolution * pMeshResolution)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetSlicesMeshResolution (pObject, pMeshResolution);
}


Lib3MFResult CCall_lib3mf_object_hasslices(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool bRecursive, bool * pHasSlices)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_HasSlices (pObject, bRecursive, pHasSlices);
}


Lib3MFResult CCall_lib3mf_object_clearslicestack(Lib3MFHandle libraryHandle, Lib3MF_Object pObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_ClearSliceStack (pObject);
}


Lib3MFResult CCall_lib3mf_object_getslicestack(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_SliceStack * pSliceStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetSliceStack (pObject, pSliceStackInstance);
}


Lib3MFResult CCall_lib3mf_object_assignslicestack(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_SliceStack pSliceStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_AssignSliceStack (pObject, pSliceStackInstance);
}


Lib3MFResult CCall_lib3mf_meshobject_getvertexcount(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVertexCount (pMeshObject, pVertexCount);
}


Lib3MFResult CCall_lib3mf_meshobject_gettrianglecount(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleCount (pMeshObject, pVertexCount);
}


Lib3MFResult CCall_lib3mf_meshobject_getvertex(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFPosition * pCoordinates)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVertex (pMeshObject, nIndex, pCoordinates);
}


Lib3MFResult CCall_lib3mf_meshobject_setvertex(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFPosition * pCoordinates)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetVertex (pMeshObject, nIndex, pCoordinates);
}


Lib3MFResult CCall_lib3mf_meshobject_addvertex(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const sLib3MFPosition * pCoordinates, Lib3MF_uint32 * pNewIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_AddVertex (pMeshObject, pCoordinates, pNewIndex);
}


Lib3MFResult CCall_lib3mf_meshobject_getvertices(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition * pVerticesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVertices (pMeshObject, nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangle(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangle * pIndices)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangle (pMeshObject, nIndex, pIndices);
}


Lib3MFResult CCall_lib3mf_meshobject_settriangle(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangle * pIndices)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetTriangle (pMeshObject, nIndex, pIndices);
}


Lib3MFResult CCall_lib3mf_meshobject_addtriangle(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const sLib3MFTriangle * pIndices, Lib3MF_uint32 * pNewIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_AddTriangle (pMeshObject, pIndices, pNewIndex);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangleindices(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, sLib3MFTriangle * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleIndices (pMeshObject, nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_setobjectlevelproperty(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nUniqueResourceID, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetObjectLevelProperty (pMeshObject, nUniqueResourceID, nPropertyID);
}


Lib3MFResult CCall_lib3mf_meshobject_getobjectlevelproperty(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pUniqueResourceID, Lib3MF_uint32 * pPropertyID, bool * pHasObjectLevelProperty)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetObjectLevelProperty (pMeshObject, pUniqueResourceID, pPropertyID, pHasObjectLevelProperty);
}


Lib3MFResult CCall_lib3mf_meshobject_settriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangleProperties * pProperties)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetTriangleProperties (pMeshObject, nIndex, pProperties);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangleProperties * pProperty)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleProperties (pMeshObject, nIndex, pProperty);
}


Lib3MFResult CCall_lib3mf_meshobject_setalltriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nPropertiesArrayBufferSize, const sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetAllTriangleProperties (pMeshObject, nPropertiesArrayBufferSize, pPropertiesArrayBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_getalltriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetAllTriangleProperties (pMeshObject, nPropertiesArrayBufferSize, pPropertiesArrayNeededCount, pPropertiesArrayBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_clearallproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_ClearAllProperties (pMeshObject);
}


Lib3MFResult CCall_lib3mf_meshobject_setgeometry(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition * pVerticesBuffer, Lib3MF_uint64 nIndicesBufferSize, const sLib3MFTriangle * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetGeometry (pMeshObject, nVerticesBufferSize, pVerticesBuffer, nIndicesBufferSize, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_ismanifoldandoriented(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, bool * pIsManifoldAndOriented)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_IsManifoldAndOriented (pMeshObject, pIsManifoldAndOriented);
}


Lib3MFResult CCall_lib3mf_meshobject_beamlattice(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_BeamLattice * pTheBeamLattice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_BeamLattice (pMeshObject, pTheBeamLattice);
}


Lib3MFResult CCall_lib3mf_beamlattice_getminlength(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_double * pMinLength)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetMinLength (pBeamLattice, pMinLength);
}


Lib3MFResult CCall_lib3mf_beamlattice_setminlength(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_double dMinLength)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetMinLength (pBeamLattice, dMinLength);
}


Lib3MFResult CCall_lib3mf_beamlattice_getclipping(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode * pClipMode, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetClipping (pBeamLattice, pClipMode, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_setclipping(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode eClipMode, Lib3MF_uint32 nUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetClipping (pBeamLattice, eClipMode, nUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_getrepresentation(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, bool * pHasRepresentation, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetRepresentation (pBeamLattice, pHasRepresentation, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_setrepresentation(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetRepresentation (pBeamLattice, nUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_getballoptions(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode * pBallMode, Lib3MF_double * pBallRadius)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBallOptions (pBeamLattice, pBallMode, pBallRadius);
}


Lib3MFResult CCall_lib3mf_beamlattice_setballoptions(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode eBallMode, Lib3MF_double dBallRadius)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBallOptions (pBeamLattice, eBallMode, dBallRadius);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeamcount(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeamCount (pBeamLattice, pCount);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeam(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBeam * pBeamInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeam (pBeamLattice, nIndex, pBeamInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_addbeam(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const sLib3MFBeam * pBeamInfo, Lib3MF_uint32 * pIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_AddBeam (pBeamLattice, pBeamInfo, pIndex);
}


Lib3MFResult CCall_lib3mf_beamlattice_setbeam(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBeam * pBeamInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBeam (pBeamLattice, nIndex, pBeamInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_setbeams(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBeamInfoBufferSize, const sLib3MFBeam * pBeamInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBeams (pBeamLattice, nBeamInfoBufferSize, pBeamInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeams(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, sLib3MFBeam * pBeamInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeams (pBeamLattice, nBeamInfoBufferSize, pBeamInfoNeededCount, pBeamInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getballcount(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBallCount (pBeamLattice, pCount);
}


Lib3MFResult CCall_lib3mf_beamlattice_getball(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBall * pBallInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBall (pBeamLattice, nIndex, pBallInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_addball(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const sLib3MFBall * pBallInfo, Lib3MF_uint32 * pIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_AddBall (pBeamLattice, pBallInfo, pIndex);
}


Lib3MFResult CCall_lib3mf_beamlattice_setball(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBall * pBallInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBall (pBeamLattice, nIndex, pBallInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_setballs(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBallInfoBufferSize, const sLib3MFBall * pBallInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBalls (pBeamLattice, nBallInfoBufferSize, pBallInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getballs(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, sLib3MFBall * pBallInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBalls (pBeamLattice, nBallInfoBufferSize, pBallInfoNeededCount, pBallInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeamsetcount(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeamSetCount (pBeamLattice, pCount);
}


Lib3MFResult CCall_lib3mf_beamlattice_addbeamset(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_BeamSet * pBeamSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_AddBeamSet (pBeamLattice, pBeamSet);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeamset(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, Lib3MF_BeamSet * pBeamSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeamSet (pBeamLattice, nIndex, pBeamSet);
}


Lib3MFResult CCall_lib3mf_component_getobjectresource(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, Lib3MF_Object * pObjectResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetObjectResource (pComponent, pObjectResource);
}


Lib3MFResult CCall_lib3mf_component_getobjectresourceid(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetObjectResourceID (pComponent, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_component_getuuid(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetUUID (pComponent, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_component_setuuid(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_SetUUID (pComponent, pUUID);
}


Lib3MFResult CCall_lib3mf_component_hastransform(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, bool * pHasTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_HasTransform (pComponent, pHasTransform);
}


Lib3MFResult CCall_lib3mf_component_gettransform(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetTransform (pComponent, pTransform);
}


Lib3MFResult CCall_lib3mf_component_settransform(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, const sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_SetTransform (pComponent, pTransform);
}


Lib3MFResult CCall_lib3mf_componentsobject_addcomponent(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObject pComponentsObject, Lib3MF_Object pObjectResource, const sLib3MFTransform * pTransform, Lib3MF_Component * pComponentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObject_AddComponent (pComponentsObject, pObjectResource, pTransform, pComponentInstance);
}


Lib3MFResult CCall_lib3mf_componentsobject_getcomponent(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 nIndex, Lib3MF_Component * pComponentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObject_GetComponent (pComponentsObject, nIndex, pComponentInstance);
}


Lib3MFResult CCall_lib3mf_componentsobject_getcomponentcount(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObject_GetComponentCount (pComponentsObject, pCount);
}


Lib3MFResult CCall_lib3mf_beamset_setname(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetName (pBeamSet, pName);
}


Lib3MFResult CCall_lib3mf_beamset_getname(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetName (pBeamSet, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_setidentifier(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const char * pIdentifier)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetIdentifier (pBeamSet, pIdentifier);
}


Lib3MFResult CCall_lib3mf_beamset_getidentifier(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetIdentifier (pBeamSet, nIdentifierBufferSize, pIdentifierNeededChars, pIdentifierBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getreferencecount(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetReferenceCount (pBeamSet, pCount);
}


Lib3MFResult CCall_lib3mf_beamset_setreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetReferences (pBeamSet, nReferencesBufferSize, pReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetReferences (pBeamSet, nReferencesBufferSize, pReferencesNeededCount, pReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getballreferencecount(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetBallReferenceCount (pBeamSet, pCount);
}


Lib3MFResult CCall_lib3mf_beamset_setballreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetBallReferences (pBeamSet, nBallReferencesBufferSize, pBallReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getballreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetBallReferences (pBeamSet, nBallReferencesBufferSize, pBallReferencesNeededCount, pBallReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetCount (pBaseMaterialGroup, pCount);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs (pBaseMaterialGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_addmaterial(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const char * pName, const sLib3MFColor * pDisplayColor, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_AddMaterial (pBaseMaterialGroup, pName, pDisplayColor, pPropertyID);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_removematerial(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_RemoveMaterial (pBaseMaterialGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getname(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetName (pBaseMaterialGroup, nPropertyID, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_setname(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_SetName (pBaseMaterialGroup, nPropertyID, pName);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_setdisplaycolor(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_SetDisplayColor (pBaseMaterialGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getdisplaycolor(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetDisplayColor (pBaseMaterialGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_colorgroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_GetCount (pColorGroup, pCount);
}


Lib3MFResult CCall_lib3mf_colorgroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_GetAllPropertyIDs (pColorGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_colorgroup_addcolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, const sLib3MFColor * pTheColor, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_AddColor (pColorGroup, pTheColor, pPropertyID);
}


Lib3MFResult CCall_lib3mf_colorgroup_removecolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_RemoveColor (pColorGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_colorgroup_setcolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_SetColor (pColorGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_colorgroup_getcolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_GetColor (pColorGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetCount (pTexture2DGroup, pCount);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetAllPropertyIDs (pTexture2DGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_addtex2coord(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, const sLib3MFTex2Coord * pUVCoordinate, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_AddTex2Coord (pTexture2DGroup, pUVCoordinate, pPropertyID);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_gettex2coord(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID, sLib3MFTex2Coord * pUVCoordinate)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetTex2Coord (pTexture2DGroup, nPropertyID, pUVCoordinate);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_removetex2coord(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_RemoveTex2Coord (pTexture2DGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_gettexture2d(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_Texture2D * pTexture2DInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetTexture2D (pTexture2DGroup, pTexture2DInstance);
}


Lib3MFResult CCall_lib3mf_compositematerials_getcount(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetCount (pCompositeMaterials, pCount);
}


Lib3MFResult CCall_lib3mf_compositematerials_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetAllPropertyIDs (pCompositeMaterials, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_compositematerials_getbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetBaseMaterialGroup (pCompositeMaterials, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_compositematerials_addcomposite(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint64 nCompositeBufferSize, const sLib3MFCompositeConstituent * pCompositeBuffer, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_AddComposite (pCompositeMaterials, nCompositeBufferSize, pCompositeBuffer, pPropertyID);
}


Lib3MFResult CCall_lib3mf_compositematerials_removecomposite(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_RemoveComposite (pCompositeMaterials, nPropertyID);
}


Lib3MFResult CCall_lib3mf_compositematerials_getcomposite(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, sLib3MFCompositeConstituent * pCompositeBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetComposite (pCompositeMaterials, nPropertyID, nCompositeBufferSize, pCompositeNeededCount, pCompositeBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetCount (pMultiPropertyGroup, pCount);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs (pMultiPropertyGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_addmultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_AddMultiProperty (pMultiPropertyGroup, nPropertyIDsBufferSize, pPropertyIDsBuffer, pPropertyID);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_setmultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_SetMultiProperty (pMultiPropertyGroup, nPropertyID, nPropertyIDsBufferSize, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getmultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetMultiProperty (pMultiPropertyGroup, nPropertyID, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_removemultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_RemoveMultiProperty (pMultiPropertyGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getlayercount(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetLayerCount (pMultiPropertyGroup, pCount);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_addlayer(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const sLib3MFMultiPropertyLayer * pTheLayer, Lib3MF_uint32 * pLayerIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_AddLayer (pMultiPropertyGroup, pTheLayer, pLayerIndex);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getlayer(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex, sLib3MFMultiPropertyLayer * pTheLayer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetLayer (pMultiPropertyGroup, nLayerIndex, pTheLayer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_removelayer(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_RemoveLayer (pMultiPropertyGroup, nLayerIndex);
}


Lib3MFResult CCall_lib3mf_attachment_getpath(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_GetPath (pAttachment, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_attachment_setpath(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_SetPath (pAttachment, pPath);
}


Lib3MFResult CCall_lib3mf_attachment_packagepart(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MF_PackagePart * pPackagePart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_PackagePart (pAttachment, pPackagePart);
}


Lib3MFResult CCall_lib3mf_attachment_getrelationshiptype(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_GetRelationShipType (pAttachment, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_attachment_setrelationshiptype(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_SetRelationShipType (pAttachment, pPath);
}


Lib3MFResult CCall_lib3mf_attachment_writetofile(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pFileName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_WriteToFile (pAttachment, pFileName);
}


Lib3MFResult CCall_lib3mf_attachment_readfromfile(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pFileName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_ReadFromFile (pAttachment, pFileName);
}


Lib3MFResult CCall_lib3mf_attachment_readfromcallback(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_ReadFromCallback (pAttachment, pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_attachment_getstreamsize(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MF_uint64 * pStreamSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_GetStreamSize (pAttachment, pStreamSize);
}


Lib3MFResult CCall_lib3mf_attachment_writetobuffer(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_WriteToBuffer (pAttachment, nBufferBufferSize, pBufferNeededCount, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_attachment_readfrombuffer(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_ReadFromBuffer (pAttachment, nBufferBufferSize, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_texture2d_getattachment(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetAttachment (pTexture2D, pAttachment);
}


Lib3MFResult CCall_lib3mf_texture2d_setattachment(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetAttachment (pTexture2D, pAttachment);
}


Lib3MFResult CCall_lib3mf_texture2d_getcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureType * pContentType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetContentType (pTexture2D, pContentType);
}


Lib3MFResult CCall_lib3mf_texture2d_setcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureType eContentType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetContentType (pTexture2D, eContentType);
}


Lib3MFResult CCall_lib3mf_texture2d_gettilestyleuv(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetTileStyleUV (pTexture2D, pTileStyleU, pTileStyleV);
}


Lib3MFResult CCall_lib3mf_texture2d_settilestyleuv(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetTileStyleUV (pTexture2D, eTileStyleU, eTileStyleV);
}


Lib3MFResult CCall_lib3mf_texture2d_getfilter(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter * pFilter)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetFilter (pTexture2D, pFilter);
}


Lib3MFResult CCall_lib3mf_texture2d_setfilter(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter eFilter)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetFilter (pTexture2D, eFilter);
}


Lib3MFResult CCall_lib3mf_builditem_getobjectresource(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, Lib3MF_Object * pObjectResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetObjectResource (pBuildItem, pObjectResource);
}


Lib3MFResult CCall_lib3mf_builditem_getuuid(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetUUID (pBuildItem, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_builditem_setuuid(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_SetUUID (pBuildItem, pUUID);
}


Lib3MFResult CCall_lib3mf_builditem_getobjectresourceid(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetObjectResourceID (pBuildItem, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_builditem_hasobjecttransform(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, bool * pHasTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_HasObjectTransform (pBuildItem, pHasTransform);
}


Lib3MFResult CCall_lib3mf_builditem_getobjecttransform(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetObjectTransform (pBuildItem, pTransform);
}


Lib3MFResult CCall_lib3mf_builditem_setobjecttransform(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_SetObjectTransform (pBuildItem, pTransform);
}


Lib3MFResult CCall_lib3mf_builditem_getpartnumber(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetPartNumber (pBuildItem, nPartNumberBufferSize, pPartNumberNeededChars, pPartNumberBuffer);
}


Lib3MFResult CCall_lib3mf_builditem_setpartnumber(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const char * pSetPartnumber)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_SetPartNumber (pBuildItem, pSetPartnumber);
}


Lib3MFResult CCall_lib3mf_builditem_getmetadatagroup(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetMetaDataGroup (pBuildItem, pMetaDataGroup);
}


Lib3MFResult CCall_lib3mf_builditem_getoutbox(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, sLib3MFBox * pOutbox)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetOutbox (pBuildItem, pOutbox);
}


Lib3MFResult CCall_lib3mf_builditemiterator_movenext(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasNext)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_MoveNext (pBuildItemIterator, pHasNext);
}


Lib3MFResult CCall_lib3mf_builditemiterator_moveprevious(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasPrevious)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_MovePrevious (pBuildItemIterator, pHasPrevious);
}


Lib3MFResult CCall_lib3mf_builditemiterator_getcurrent(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItem * pBuildItem)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_GetCurrent (pBuildItemIterator, pBuildItem);
}


Lib3MFResult CCall_lib3mf_builditemiterator_clone(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItemIterator * pOutBuildItemIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_Clone (pBuildItemIterator, pOutBuildItemIterator);
}


Lib3MFResult CCall_lib3mf_builditemiterator_count(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_Count (pBuildItemIterator, pCount);
}


Lib3MFResult CCall_lib3mf_slice_setvertices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition2D * pVerticesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_SetVertices (pSlice, nVerticesBufferSize, pVerticesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getvertices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition2D * pVerticesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetVertices (pSlice, nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getvertexcount(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetVertexCount (pSlice, pCount);
}


Lib3MFResult CCall_lib3mf_slice_addpolygon(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer, Lib3MF_uint64 * pIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_AddPolygon (pSlice, nIndicesBufferSize, pIndicesBuffer, pIndex);
}


Lib3MFResult CCall_lib3mf_slice_getpolygoncount(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetPolygonCount (pSlice, pCount);
}


Lib3MFResult CCall_lib3mf_slice_setpolygonindices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_SetPolygonIndices (pSlice, nIndex, nIndicesBufferSize, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getpolygonindices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetPolygonIndices (pSlice, nIndex, nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getpolygonindexcount(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetPolygonIndexCount (pSlice, nIndex, pCount);
}


Lib3MFResult CCall_lib3mf_slice_getztop(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_double * pZTop)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetZTop (pSlice, pZTop);
}


Lib3MFResult CCall_lib3mf_slicestack_getbottomz(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_double * pZBottom)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetBottomZ (pSliceStack, pZBottom);
}


Lib3MFResult CCall_lib3mf_slicestack_getslicecount(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSliceCount (pSliceStack, pCount);
}


Lib3MFResult CCall_lib3mf_slicestack_getslice(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceIndex, Lib3MF_Slice * pTheSlice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSlice (pSliceStack, nSliceIndex, pTheSlice);
}


Lib3MFResult CCall_lib3mf_slicestack_addslice(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_double dZTop, Lib3MF_Slice * pTheSlice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_AddSlice (pSliceStack, dZTop, pTheSlice);
}


Lib3MFResult CCall_lib3mf_slicestack_getslicerefcount(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSliceRefCount (pSliceStack, pCount);
}


Lib3MFResult CCall_lib3mf_slicestack_addslicestackreference(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_SliceStack pTheSliceStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_AddSliceStackReference (pSliceStack, pTheSliceStack);
}


Lib3MFResult CCall_lib3mf_slicestack_getslicestackreference(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceRefIndex, Lib3MF_SliceStack * pTheSliceStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSliceStackReference (pSliceStack, nSliceRefIndex, pTheSliceStack);
}


Lib3MFResult CCall_lib3mf_slicestack_collapseslicereferences(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_CollapseSliceReferences (pSliceStack);
}


Lib3MFResult CCall_lib3mf_slicestack_setownpath(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_SetOwnPath (pSliceStack, pPath);
}


Lib3MFResult CCall_lib3mf_slicestack_getownpath(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetOwnPath (pSliceStack, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_consumer_getconsumerid(Lib3MFHandle libraryHandle, Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nConsumerIDBufferSize, Lib3MF_uint32* pConsumerIDNeededChars, char * pConsumerIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Consumer_GetConsumerID (pConsumer, nConsumerIDBufferSize, pConsumerIDNeededChars, pConsumerIDBuffer);
}


Lib3MFResult CCall_lib3mf_consumer_getkeyid(Lib3MFHandle libraryHandle, Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyIDBufferSize, Lib3MF_uint32* pKeyIDNeededChars, char * pKeyIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Consumer_GetKeyID (pConsumer, nKeyIDBufferSize, pKeyIDNeededChars, pKeyIDBuffer);
}


Lib3MFResult CCall_lib3mf_consumer_getkeyvalue(Lib3MFHandle libraryHandle, Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyValueBufferSize, Lib3MF_uint32* pKeyValueNeededChars, char * pKeyValueBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Consumer_GetKeyValue (pConsumer, nKeyValueBufferSize, pKeyValueNeededChars, pKeyValueBuffer);
}


Lib3MFResult CCall_lib3mf_accessright_getconsumer(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetConsumer (pAccessRight, pConsumer);
}


Lib3MFResult CCall_lib3mf_accessright_getwrappingalgorithm(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, eLib3MFWrappingAlgorithm * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetWrappingAlgorithm (pAccessRight, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_accessright_getmgfalgorithm(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, eLib3MFMgfAlgorithm * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetMgfAlgorithm (pAccessRight, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_accessright_getdigestmethod(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, eLib3MFDigestMethod * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetDigestMethod (pAccessRight, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getencryptionalgorithm(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, eLib3MFEncryptionAlgorithm * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm (pContentEncryptionParams, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getkey(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetKey (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getinitializationvector(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetInitializationVector (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getauthenticationtag(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetAuthenticationTag (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_setauthenticationtag(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_SetAuthenticationTag (pContentEncryptionParams, nByteDataBufferSize, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getadditionalauthenticationdata(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getdescriptor(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 * pDescriptor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetDescriptor (pContentEncryptionParams, pDescriptor);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getkeyuuid(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetKeyUUID (pContentEncryptionParams, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_resourcedata_getpath(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, Lib3MF_PackagePart * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetPath (pResourceData, pPath);
}


Lib3MFResult CCall_lib3mf_resourcedata_getencryptionalgorithm(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, eLib3MFEncryptionAlgorithm * pEncryptionAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetEncryptionAlgorithm (pResourceData, pEncryptionAlgorithm);
}


Lib3MFResult CCall_lib3mf_resourcedata_getcompression(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, eLib3MFCompression * pCompression)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetCompression (pResourceData, pCompression);
}


Lib3MFResult CCall_lib3mf_resourcedata_getadditionalauthenticationdata(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetAdditionalAuthenticationData (pResourceData, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_getkeyuuid(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_GetKeyUUID (pResourceDataGroup, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_addaccessright(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, eLib3MFWrappingAlgorithm eWrappingAlgorithm, eLib3MFMgfAlgorithm eMgfAlgorithm, eLib3MFDigestMethod eDigestMethod, Lib3MF_AccessRight * pTheAccessRight)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_AddAccessRight (pResourceDataGroup, pConsumer, eWrappingAlgorithm, eMgfAlgorithm, eDigestMethod, pTheAccessRight);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_findaccessrightbyconsumer(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, Lib3MF_AccessRight * pTheAccessRight)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer (pResourceDataGroup, pConsumer, pTheAccessRight);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_removeaccessright(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_RemoveAccessRight (pResourceDataGroup, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_addconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, const char * pConsumerID, const char * pKeyID, const char * pKeyValue, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_AddConsumer (pKeyStore, pConsumerID, pKeyID, pKeyValue, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_getconsumercount(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetConsumerCount (pKeyStore, pCount);
}


Lib3MFResult CCall_lib3mf_keystore_getconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nConsumerIndex, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetConsumer (pKeyStore, nConsumerIndex, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_removeconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_Consumer pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_RemoveConsumer (pKeyStore, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_findconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, const char * pConsumerID, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_FindConsumer (pKeyStore, pConsumerID, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedatagroupcount(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceDataGroupCount (pKeyStore, pCount);
}


Lib3MFResult CCall_lib3mf_keystore_addresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_AddResourceDataGroup (pKeyStore, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceDataGroup (pKeyStore, nResourceDataIndex, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_removeresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_RemoveResourceDataGroup (pKeyStore, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_findresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pPartPath, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_FindResourceDataGroup (pKeyStore, pPartPath, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_addresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_PackagePart pPartPath, eLib3MFEncryptionAlgorithm eAlgorithm, eLib3MFCompression eCompression, Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer, Lib3MF_ResourceData * pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_AddResourceData (pKeyStore, pResourceDataGroup, pPartPath, eAlgorithm, eCompression, nAdditionalAuthenticationDataBufferSize, pAdditionalAuthenticationDataBuffer, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_removeresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceData pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_RemoveResourceData (pKeyStore, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_findresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pResourcePath, Lib3MF_ResourceData * pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_FindResourceData (pKeyStore, pResourcePath, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedatacount(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceDataCount (pKeyStore, pCount);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceData * pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceData (pKeyStore, nResourceDataIndex, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_getuuid(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetUUID (pKeyStore, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_keystore_setuuid(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_SetUUID (pKeyStore, pUUID);
}


Lib3MFResult CCall_lib3mf_model_rootmodelpart(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_PackagePart * pRootModelPart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RootModelPart (pModel, pRootModelPart);
}


Lib3MFResult CCall_lib3mf_model_findorcreatepackagepart(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pAbsolutePath, Lib3MF_PackagePart * pModelPart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_FindOrCreatePackagePart (pModel, pAbsolutePath, pModelPart);
}


Lib3MFResult CCall_lib3mf_model_setunit(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, eLib3MFModelUnit eUnit)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetUnit (pModel, eUnit);
}


Lib3MFResult CCall_lib3mf_model_getunit(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, eLib3MFModelUnit * pUnit)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetUnit (pModel, pUnit);
}


Lib3MFResult CCall_lib3mf_model_getlanguage(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const Lib3MF_uint32 nLanguageBufferSize, Lib3MF_uint32* pLanguageNeededChars, char * pLanguageBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetLanguage (pModel, nLanguageBufferSize, pLanguageNeededChars, pLanguageBuffer);
}


Lib3MFResult CCall_lib3mf_model_setlanguage(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pLanguage)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetLanguage (pModel, pLanguage);
}


Lib3MFResult CCall_lib3mf_model_querywriter(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pWriterClass, Lib3MF_Writer * pWriterInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_QueryWriter (pModel, pWriterClass, pWriterInstance);
}


Lib3MFResult CCall_lib3mf_model_queryreader(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pReaderClass, Lib3MF_Reader * pReaderInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_QueryReader (pModel, pReaderClass, pReaderInstance);
}


Lib3MFResult CCall_lib3mf_model_getresourcebyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Resource * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetResourceByID (pModel, nUniqueResourceID, pResource);
}


Lib3MFResult CCall_lib3mf_model_gettexture2dbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2D * pTextureInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2DByID (pModel, nUniqueResourceID, pTextureInstance);
}


Lib3MFResult CCall_lib3mf_model_getpropertytypebyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, eLib3MFPropertyType * pThePropertyType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetPropertyTypeByID (pModel, nUniqueResourceID, pThePropertyType);
}


Lib3MFResult CCall_lib3mf_model_getbasematerialgroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBaseMaterialGroupByID (pModel, nUniqueResourceID, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_gettexture2dgroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2DGroupByID (pModel, nUniqueResourceID, pTexture2DGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_getcompositematerialsbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetCompositeMaterialsByID (pModel, nUniqueResourceID, pCompositeMaterialsInstance);
}


Lib3MFResult CCall_lib3mf_model_getmultipropertygroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMultiPropertyGroupByID (pModel, nUniqueResourceID, pMultiPropertyGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_getmeshobjectbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MeshObject * pMeshObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMeshObjectByID (pModel, nUniqueResourceID, pMeshObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_getcomponentsobjectbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetComponentsObjectByID (pModel, nUniqueResourceID, pComponentsObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_getcolorgroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ColorGroup * pColorGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetColorGroupByID (pModel, nUniqueResourceID, pColorGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_getslicestackbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_SliceStack * pSliceStacInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetSliceStackByID (pModel, nUniqueResourceID, pSliceStacInstance);
}


Lib3MFResult CCall_lib3mf_model_getbuilduuid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBuildUUID (pModel, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_model_setbuilduuid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetBuildUUID (pModel, pUUID);
}


Lib3MFResult CCall_lib3mf_model_getbuilditems(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BuildItemIterator * pBuildItemIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBuildItems (pModel, pBuildItemIterator);
}


Lib3MFResult CCall_lib3mf_model_getoutbox(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, sLib3MFBox * pOutbox)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetOutbox (pModel, pOutbox);
}


Lib3MFResult CCall_lib3mf_model_getresources(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ResourceIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetResources (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getobjects(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ObjectIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetObjects (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getmeshobjects(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MeshObjectIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMeshObjects (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getcomponentsobjects(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ComponentsObjectIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetComponentsObjects (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_gettexture2ds(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Texture2DIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2Ds (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getbasematerialgroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BaseMaterialGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBaseMaterialGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getcolorgroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ColorGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetColorGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_gettexture2dgroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Texture2DGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2DGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getcompositematerials(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_CompositeMaterialsIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetCompositeMaterials (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getmultipropertygroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MultiPropertyGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMultiPropertyGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getslicestacks(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_SliceStackIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetSliceStacks (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_mergetomodel(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Model * pMergedModelInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_MergeToModel (pModel, pMergedModelInstance);
}


Lib3MFResult CCall_lib3mf_model_addmeshobject(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MeshObject * pMeshObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddMeshObject (pModel, pMeshObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_addcomponentsobject(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddComponentsObject (pModel, pComponentsObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_addslicestack(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_double dZBottom, Lib3MF_SliceStack * pSliceStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddSliceStack (pModel, dZBottom, pSliceStackInstance);
}


Lib3MFResult CCall_lib3mf_model_addtexture2dfromattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment pTextureAttachment, Lib3MF_Texture2D * pTexture2DInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddTexture2DFromAttachment (pModel, pTextureAttachment, pTexture2DInstance);
}


Lib3MFResult CCall_lib3mf_model_addbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddBaseMaterialGroup (pModel, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addcolorgroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ColorGroup * pColorGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddColorGroup (pModel, pColorGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addtexture2dgroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Texture2D pTexture2DInstance, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddTexture2DGroup (pModel, pTexture2DInstance, pTexture2DGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addcompositematerials(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddCompositeMaterials (pModel, pBaseMaterialGroupInstance, pCompositeMaterialsInstance);
}


Lib3MFResult CCall_lib3mf_model_addmultipropertygroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddMultiPropertyGroup (pModel, pMultiPropertyGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addbuilditem(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Object pObject, const sLib3MFTransform * pTransform, Lib3MF_BuildItem * pBuildItemInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddBuildItem (pModel, pObject, pTransform, pBuildItemInstance);
}


Lib3MFResult CCall_lib3mf_model_removebuilditem(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BuildItem pBuildItemInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveBuildItem (pModel, pBuildItemInstance);
}


Lib3MFResult CCall_lib3mf_model_getmetadatagroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MetaDataGroup * pTheMetaDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMetaDataGroup (pModel, pTheMetaDataGroup);
}


Lib3MFResult CCall_lib3mf_model_addattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pURI, const char * pRelationShipType, Lib3MF_Attachment * pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddAttachment (pModel, pURI, pRelationShipType, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_removeattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveAttachment (pModel, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_getattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetAttachment (pModel, nIndex, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_findattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pURI, Lib3MF_Attachment * pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_FindAttachment (pModel, pURI, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_getattachmentcount(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 * pAttachmentCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetAttachmentCount (pModel, pAttachmentCount);
}


Lib3MFResult CCall_lib3mf_model_haspackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, bool * pHasThumbnail)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_HasPackageThumbnailAttachment (pModel, pHasThumbnail);
}


Lib3MFResult CCall_lib3mf_model_createpackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_CreatePackageThumbnailAttachment (pModel, pAttachment);
}


Lib3MFResult CCall_lib3mf_model_getpackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetPackageThumbnailAttachment (pModel, pAttachment);
}


Lib3MFResult CCall_lib3mf_model_removepackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemovePackageThumbnailAttachment (pModel);
}


Lib3MFResult CCall_lib3mf_model_addcustomcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pExtension, const char * pContentType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddCustomContentType (pModel, pExtension, pContentType);
}


Lib3MFResult CCall_lib3mf_model_removecustomcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pExtension)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveCustomContentType (pModel, pExtension);
}


Lib3MFResult CCall_lib3mf_model_setrandomnumbercallback(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MFRandomNumberCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetRandomNumberCallback (pModel, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_model_getkeystore(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_KeyStore * pKeyStore)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetKeyStore (pModel, pKeyStore);
}


Lib3MFResult CCall_lib3mf_getlibraryversion(Lib3MFHandle libraryHandle, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetLibraryVersion (pMajor, pMinor, pMicro);
}


Lib3MFResult CCall_lib3mf_getprereleaseinformation(Lib3MFHandle libraryHandle, bool * pHasPrereleaseInfo, const Lib3MF_uint32 nPrereleaseInfoBufferSize, Lib3MF_uint32* pPrereleaseInfoNeededChars, char * pPrereleaseInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetPrereleaseInformation (pHasPrereleaseInfo, nPrereleaseInfoBufferSize, pPrereleaseInfoNeededChars, pPrereleaseInfoBuffer);
}


Lib3MFResult CCall_lib3mf_getbuildinformation(Lib3MFHandle libraryHandle, bool * pHasBuildInfo, const Lib3MF_uint32 nBuildInformationBufferSize, Lib3MF_uint32* pBuildInformationNeededChars, char * pBuildInformationBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetBuildInformation (pHasBuildInfo, nBuildInformationBufferSize, pBuildInformationNeededChars, pBuildInformationBuffer);
}


Lib3MFResult CCall_lib3mf_getspecificationversion(Lib3MFHandle libraryHandle, const char * pSpecificationURL, bool * pIsSupported, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetSpecificationVersion (pSpecificationURL, pIsSupported, pMajor, pMinor, pMicro);
}


Lib3MFResult CCall_lib3mf_createmodel(Lib3MFHandle libraryHandle, Lib3MF_Model * pModel)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CreateModel (pModel);
}


Lib3MFResult CCall_lib3mf_release(Lib3MFHandle libraryHandle, Lib3MF_Base pInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Release (pInstance);
}


Lib3MFResult CCall_lib3mf_acquire(Lib3MFHandle libraryHandle, Lib3MF_Base pInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Acquire (pInstance);
}


Lib3MFResult CCall_lib3mf_setjournal(Lib3MFHandle libraryHandle, const char * pJournalPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SetJournal (pJournalPath);
}


Lib3MFResult CCall_lib3mf_getlasterror(Lib3MFHandle libraryHandle, Lib3MF_Base pInstance, const Lib3MF_uint32 nLastErrorStringBufferSize, Lib3MF_uint32* pLastErrorStringNeededChars, char * pLastErrorStringBuffer, bool * pHasLastError)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetLastError (pInstance, nLastErrorStringBufferSize, pLastErrorStringNeededChars, pLastErrorStringBuffer, pHasLastError);
}


Lib3MFResult CCall_lib3mf_getsymbollookupmethod(Lib3MFHandle libraryHandle, Lib3MF_pvoid * pSymbolLookupMethod)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetSymbolLookupMethod (pSymbolLookupMethod);
}


Lib3MFResult CCall_lib3mf_retrieveprogressmessage(Lib3MFHandle libraryHandle, eLib3MFProgressIdentifier eTheProgressIdentifier, const Lib3MF_uint32 nProgressMessageBufferSize, Lib3MF_uint32* pProgressMessageNeededChars, char * pProgressMessageBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_RetrieveProgressMessage (eTheProgressIdentifier, nProgressMessageBufferSize, pProgressMessageNeededChars, pProgressMessageBuffer);
}


Lib3MFResult CCall_lib3mf_rgbatocolor(Lib3MFHandle libraryHandle, Lib3MF_uint8 nRed, Lib3MF_uint8 nGreen, Lib3MF_uint8 nBlue, Lib3MF_uint8 nAlpha, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_RGBAToColor (nRed, nGreen, nBlue, nAlpha, pTheColor);
}


Lib3MFResult CCall_lib3mf_floatrgbatocolor(Lib3MFHandle libraryHandle, Lib3MF_single fRed, Lib3MF_single fGreen, Lib3MF_single fBlue, Lib3MF_single fAlpha, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FloatRGBAToColor (fRed, fGreen, fBlue, fAlpha, pTheColor);
}


Lib3MFResult CCall_lib3mf_colortorgba(Lib3MFHandle libraryHandle, const sLib3MFColor * pTheColor, Lib3MF_uint8 * pRed, Lib3MF_uint8 * pGreen, Lib3MF_uint8 * pBlue, Lib3MF_uint8 * pAlpha)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorToRGBA (pTheColor, pRed, pGreen, pBlue, pAlpha);
}


Lib3MFResult CCall_lib3mf_colortofloatrgba(Lib3MFHandle libraryHandle, const sLib3MFColor * pTheColor, Lib3MF_single * pRed, Lib3MF_single * pGreen, Lib3MF_single * pBlue, Lib3MF_single * pAlpha)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorToFloatRGBA (pTheColor, pRed, pGreen, pBlue, pAlpha);
}


Lib3MFResult CCall_lib3mf_getidentitytransform(Lib3MFHandle libraryHandle, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetIdentityTransform (pTransform);
}


Lib3MFResult CCall_lib3mf_getuniformscaletransform(Lib3MFHandle libraryHandle, Lib3MF_single fFactor, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetUniformScaleTransform (fFactor, pTransform);
}


Lib3MFResult CCall_lib3mf_getscaletransform(Lib3MFHandle libraryHandle, Lib3MF_single fFactorX, Lib3MF_single fFactorY, Lib3MF_single fFactorZ, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetScaleTransform (fFactorX, fFactorY, fFactorZ, pTransform);
}


Lib3MFResult CCall_lib3mf_gettranslationtransform(Lib3MFHandle libraryHandle, Lib3MF_single fVectorX, Lib3MF_single fVectorY, Lib3MF_single fVectorZ, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetTranslationTransform (fVectorX, fVectorY, fVectorZ, pTransform);
}

*/
import "C"

import (
	"fmt"
	"unsafe"
	"runtime"
)

type ref = C.Lib3MFHandle


// PropertyType represents a Lib3MF enum.
type PropertyType int

const (
	PropertyType_NoPropertyType = 0
	PropertyType_BaseMaterial = 1
	PropertyType_TexCoord = 2
	PropertyType_Colors = 3
	PropertyType_Composite = 4
	PropertyType_Multi = 5
)

// SlicesMeshResolution represents a Lib3MF enum.
type SlicesMeshResolution int

const (
	SlicesMeshResolution_Fullres = 0
	SlicesMeshResolution_Lowres = 1
)

// ModelUnit represents a Lib3MF enum.
type ModelUnit int

const (
	ModelUnit_MicroMeter = 0
	ModelUnit_MilliMeter = 1
	ModelUnit_CentiMeter = 2
	ModelUnit_Inch = 3
	ModelUnit_Foot = 4
	ModelUnit_Meter = 5
)

// ObjectType represents a Lib3MF enum.
type ObjectType int

const (
	ObjectType_Other = 0
	ObjectType_Model = 1
	ObjectType_Support = 2
	ObjectType_SolidSupport = 3
)

// TextureType represents a Lib3MF enum.
type TextureType int

const (
	TextureType_Unknown = 0
	TextureType_PNG = 1
	TextureType_JPEG = 2
)

// TextureTileStyle represents a Lib3MF enum.
type TextureTileStyle int

const (
	TextureTileStyle_Wrap = 0
	TextureTileStyle_Mirror = 1
	TextureTileStyle_Clamp = 2
	TextureTileStyle_NoTileStyle = 3
)

// TextureFilter represents a Lib3MF enum.
type TextureFilter int

const (
	TextureFilter_Auto = 0
	TextureFilter_Linear = 1
	TextureFilter_Nearest = 2
)

// BeamLatticeCapMode represents a Lib3MF enum.
type BeamLatticeCapMode int

const (
	BeamLatticeCapMode_Sphere = 0
	BeamLatticeCapMode_HemiSphere = 1
	BeamLatticeCapMode_Butt = 2
)

// BeamLatticeClipMode represents a Lib3MF enum.
type BeamLatticeClipMode int

const (
	BeamLatticeClipMode_NoClipMode = 0
	BeamLatticeClipMode_Inside = 1
	BeamLatticeClipMode_Outside = 2
)

// BeamLatticeBallMode represents a Lib3MF enum.
type BeamLatticeBallMode int

const (
	BeamLatticeBallMode_None = 0
	BeamLatticeBallMode_Mixed = 1
	BeamLatticeBallMode_All = 2
)

// ProgressIdentifier represents a Lib3MF enum.
type ProgressIdentifier int

const (
	ProgressIdentifier_QUERYCANCELED = 0
	ProgressIdentifier_DONE = 1
	ProgressIdentifier_CLEANUP = 2
	ProgressIdentifier_READSTREAM = 3
	ProgressIdentifier_EXTRACTOPCPACKAGE = 4
	ProgressIdentifier_READNONROOTMODELS = 5
	ProgressIdentifier_READROOTMODEL = 6
	ProgressIdentifier_READRESOURCES = 7
	ProgressIdentifier_READMESH = 8
	ProgressIdentifier_READSLICES = 9
	ProgressIdentifier_READBUILD = 10
	ProgressIdentifier_READCUSTOMATTACHMENT = 11
	ProgressIdentifier_READTEXTURETACHMENTS = 12
	ProgressIdentifier_CREATEOPCPACKAGE = 13
	ProgressIdentifier_WRITEMODELSTOSTREAM = 14
	ProgressIdentifier_WRITEROOTMODEL = 15
	ProgressIdentifier_WRITENONROOTMODELS = 16
	ProgressIdentifier_WRITEATTACHMENTS = 17
	ProgressIdentifier_WRITECONTENTTYPES = 18
	ProgressIdentifier_WRITENOBJECTS = 19
	ProgressIdentifier_WRITENODES = 20
	ProgressIdentifier_WRITETRIANGLES = 21
	ProgressIdentifier_WRITESLICES = 22
	ProgressIdentifier_WRITEKEYSTORE = 23
)

// BlendMethod represents a Lib3MF enum.
type BlendMethod int

const (
	BlendMethod_NoBlendMethod = 0
	BlendMethod_Mix = 1
	BlendMethod_Multiply = 2
)

// EncryptionAlgorithm represents a Lib3MF enum.
type EncryptionAlgorithm int

const (
	EncryptionAlgorithm_AES256_GCM = 1
)

// WrappingAlgorithm represents a Lib3MF enum.
type WrappingAlgorithm int

const (
	WrappingAlgorithm_RSA_OAEP = 0
)

// MgfAlgorithm represents a Lib3MF enum.
type MgfAlgorithm int

const (
	MgfAlgorithm_MGF1_SHA1 = 160
	MgfAlgorithm_MGF1_SHA224 = 224
	MgfAlgorithm_MGF1_SHA256 = 256
	MgfAlgorithm_MGF1_SHA384 = 384
	MgfAlgorithm_MGF1_SHA512 = 512
)

// DigestMethod represents a Lib3MF enum.
type DigestMethod int

const (
	DigestMethod_SHA1 = 160
	DigestMethod_SHA256 = 256
)

// Compression represents a Lib3MF enum.
type Compression int

const (
	Compression_NoCompression = 0
	Compression_Deflate = 1
)

// Triangle represents a Lib3MF struct.
type Triangle struct {
	Indices[3] uint32
}

// TriangleProperties represents a Lib3MF struct.
type TriangleProperties struct {
	ResourceID uint32
	PropertyIDs[3] uint32
}

// Position represents a Lib3MF struct.
type Position struct {
	Coordinates[3] float32
}

// Position2D represents a Lib3MF struct.
type Position2D struct {
	Coordinates[2] float32
}

// CompositeConstituent represents a Lib3MF struct.
type CompositeConstituent struct {
	PropertyID uint32
	MixingRatio float64
}

// MultiPropertyLayer represents a Lib3MF struct.
type MultiPropertyLayer struct {
	ResourceID uint32
	TheBlendMethod BlendMethod
}

// Tex2Coord represents a Lib3MF struct.
type Tex2Coord struct {
	U float64
	V float64
}

// Transform represents a Lib3MF struct.
type Transform struct {
	Fields[4][3] float32
}

// Box represents a Lib3MF struct.
type Box struct {
	MinCoordinate[3] float32
	MaxCoordinate[3] float32
}

// Color represents a Lib3MF struct.
type Color struct {
	Red uint8
	Green uint8
	Blue uint8
	Alpha uint8
}

// Beam represents a Lib3MF struct.
type Beam struct {
	Indices[2] uint32
	Radii[2] float64
	CapModes[2] BeamLatticeCapMode
}

// Ball represents a Lib3MF struct.
type Ball struct {
	Index uint32
	Radius float64
}

// Error constants for Lib3MF.
const LIB3MF_ERROR_NOTIMPLEMENTED = 1;
const LIB3MF_ERROR_INVALIDPARAM = 2;
const LIB3MF_ERROR_INVALIDCAST = 3;
const LIB3MF_ERROR_BUFFERTOOSMALL = 4;
const LIB3MF_ERROR_GENERICEXCEPTION = 5;
const LIB3MF_ERROR_COULDNOTLOADLIBRARY = 6;
const LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT = 7;
const LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION = 8;
const LIB3MF_ERROR_CALCULATIONABORTED = 10;
const LIB3MF_ERROR_SHOULDNOTBECALLED = 11;
const LIB3MF_ERROR_READERCLASSUNKNOWN = 100;
const LIB3MF_ERROR_WRITERCLASSUNKNOWN = 101;
const LIB3MF_ERROR_ITERATORINVALIDINDEX = 102;
const LIB3MF_ERROR_INVALIDMODELRESOURCE = 103;
const LIB3MF_ERROR_RESOURCENOTFOUND = 104;
const LIB3MF_ERROR_INVALIDMODEL = 105;
const LIB3MF_ERROR_INVALIDOBJECT = 106;
const LIB3MF_ERROR_INVALIDMESHOBJECT = 107;
const LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT = 108;
const LIB3MF_ERROR_INVALIDCOMPONENT = 109;
const LIB3MF_ERROR_INVALIDBUILDITEM = 110;
const LIB3MF_ERROR_INVALIDBASEMATERIALGROUP = 111;
const LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE = 112;
const LIB3MF_ERROR_INVALIDTEXTURERESOURCE = 113;
const LIB3MF_ERROR_INVALIDCOLORGROUP = 114;
const LIB3MF_ERROR_INVALIDTEXTURE2DGROUP = 115;
const LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS = 116;
const LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP = 117;
const LIB3MF_ERROR_INVALIDRESOURCEINDEX = 120;
const LIB3MF_ERROR_ATTACHMENTNOTFOUND = 121;
const LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE = 130;
const LIB3MF_ERROR_INVALIDATTACHMENTSTREAM = 131;
const LIB3MF_ERROR_INVALIDPROPERTYCOUNT = 132;
const LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER = 140;
const LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT = 141;
const LIB3MF_ERROR_INVALIDRESOURCE = 142;
const LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE = 2000;
const LIB3MF_ERROR_INVALIDKEYSTORE = 3000;
const LIB3MF_ERROR_INVALIDKEYSTORECONSUMER = 3001;
const LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND = 3002;
const LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND = 3003;
const LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED = 3004;
const LIB3MF_ERROR_INVALIDKEYSIZE = 3005;

// WrappedError is an error that wraps a Lib3MF error.
type WrappedError struct {
	Code uint32
	Message string
}

func (e *WrappedError) Error() string {
	return fmt.Sprintf("lib3mf: %s (%d)", e.Message, e.Code)
}

func errorMessage(errorcode uint32) string {
	switch (errorcode) {
	case LIB3MF_ERROR_NOTIMPLEMENTED:
		return "functionality not implemented";
	case LIB3MF_ERROR_INVALIDPARAM:
		return "an invalid parameter was passed";
	case LIB3MF_ERROR_INVALIDCAST:
		return "a type cast failed";
	case LIB3MF_ERROR_BUFFERTOOSMALL:
		return "a provided buffer is too small";
	case LIB3MF_ERROR_GENERICEXCEPTION:
		return "a generic exception occurred";
	case LIB3MF_ERROR_COULDNOTLOADLIBRARY:
		return "the library could not be loaded";
	case LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT:
		return "a required exported symbol could not be found in the library";
	case LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION:
		return "the version of the binary interface does not match the bindings interface";
	case LIB3MF_ERROR_CALCULATIONABORTED:
		return "a calculation has been aborted";
	case LIB3MF_ERROR_SHOULDNOTBECALLED:
		return "functionality should not be called";
	case LIB3MF_ERROR_READERCLASSUNKNOWN:
		return "the queried reader class is unknown";
	case LIB3MF_ERROR_WRITERCLASSUNKNOWN:
		return "the queried writer class is unknown";
	case LIB3MF_ERROR_ITERATORINVALIDINDEX:
		return "the current index of an iterator is invalid";
	case LIB3MF_ERROR_INVALIDMODELRESOURCE:
		return "no Model Resource has been given";
	case LIB3MF_ERROR_RESOURCENOTFOUND:
		return "Resource not found";
	case LIB3MF_ERROR_INVALIDMODEL:
		return "A model is invalid";
	case LIB3MF_ERROR_INVALIDOBJECT:
		return "An object is invalid";
	case LIB3MF_ERROR_INVALIDMESHOBJECT:
		return "A mesh object is invalid";
	case LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT:
		return "A components object is invalid";
	case LIB3MF_ERROR_INVALIDCOMPONENT:
		return "A component is invalid";
	case LIB3MF_ERROR_INVALIDBUILDITEM:
		return "A build item is invalid";
	case LIB3MF_ERROR_INVALIDBASEMATERIALGROUP:
		return "A basematerialgroup is invalid";
	case LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE:
		return "A slicestack resource is invalid";
	case LIB3MF_ERROR_INVALIDTEXTURERESOURCE:
		return "A texture resource is invalid";
	case LIB3MF_ERROR_INVALIDCOLORGROUP:
		return "A color group resource is invalid";
	case LIB3MF_ERROR_INVALIDTEXTURE2DGROUP:
		return "A texture2d group resource is invalid";
	case LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS:
		return "A composite materials resource is invalid";
	case LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP:
		return "A MultiPropertyGroup resource is invalid";
	case LIB3MF_ERROR_INVALIDRESOURCEINDEX:
		return "A resource index is invalid";
	case LIB3MF_ERROR_ATTACHMENTNOTFOUND:
		return "Attachment not found";
	case LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE:
		return "A component references one of its ancestors";
	case LIB3MF_ERROR_INVALIDATTACHMENTSTREAM:
		return "An attachment stream is invalid";
	case LIB3MF_ERROR_INVALIDPROPERTYCOUNT:
		return "Invalid property count.";
	case LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER:
		return "A progress identifier is unknown";
	case LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT:
		return "An element buffer exceeds its spec limit";
	case LIB3MF_ERROR_INVALIDRESOURCE:
		return "A resource is invalid";
	case LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE:
		return "This object type is not valid for beamlattices";
	case LIB3MF_ERROR_INVALIDKEYSTORE:
		return "The keystore object is invalid";
	case LIB3MF_ERROR_INVALIDKEYSTORECONSUMER:
		return "The consumer keystore object is invalid";
	case LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND:
		return "A consumer has not been found";
	case LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND:
		return "A resource data has not been found";
	case LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED:
		return "A Key or Conentent encryption callback has not been registered";
	case LIB3MF_ERROR_INVALIDKEYSIZE:
		return "The key siue is invalid";
	default:
		return "unknown";
	}
}

func makeError(errorcode uint32) error {
	return &WrappedError{errorcode, errorMessage(uint32(errorcode))}
}

// ProgressCallbackFunc a callback function.
type ProgressCallbackFunc = func(abort *bool, progressValue float64, progressIdentifier ProgressIdentifier, userData uintptr)

var progressCallbackFunc ProgressCallbackFunc

//export progressCallback
func progressCallback(abort *C.bool, progressValue C.double, progressIdentifier C.eLib3MFProgressIdentifier, userData C.Lib3MF_pvoid) {
	if progressCallbackFunc == nil {
		return
	}
	progressCallbackFunc((*bool)(abort), float64(progressValue), ProgressIdentifier(progressIdentifier), uintptr(userData))
}

// WriteCallbackFunc callback to call for writing a data chunk.
type WriteCallbackFunc = func(byteData uint64, numBytes uint64, userData uintptr)

var writeCallbackFunc WriteCallbackFunc

//export writeCallback
func writeCallback(byteData C.uint64_t, numBytes C.uint64_t, userData C.Lib3MF_pvoid) {
	if writeCallbackFunc == nil {
		return
	}
	writeCallbackFunc(uint64(byteData), uint64(numBytes), uintptr(userData))
}

// ReadCallbackFunc callback to call for reading a data chunk.
type ReadCallbackFunc = func(byteData uint64, numBytes uint64, userData uintptr)

var readCallbackFunc ReadCallbackFunc

//export readCallback
func readCallback(byteData C.uint64_t, numBytes C.uint64_t, userData C.Lib3MF_pvoid) {
	if readCallbackFunc == nil {
		return
	}
	readCallbackFunc(uint64(byteData), uint64(numBytes), uintptr(userData))
}

// SeekCallbackFunc callback to call for seeking in the stream.
type SeekCallbackFunc = func(position uint64, userData uintptr)

var seekCallbackFunc SeekCallbackFunc

//export seekCallback
func seekCallback(position C.uint64_t, userData C.Lib3MF_pvoid) {
	if seekCallbackFunc == nil {
		return
	}
	seekCallbackFunc(uint64(position), uintptr(userData))
}

// RandomNumberCallbackFunc callback to generate random numbers.
type RandomNumberCallbackFunc = func(byteData uint64, numBytes uint64, userData uintptr, bytesWritten *uint64)

var randomNumberCallbackFunc RandomNumberCallbackFunc

//export randomNumberCallback
func randomNumberCallback(byteData C.uint64_t, numBytes C.uint64_t, userData C.Lib3MF_pvoid, bytesWritten *C.uint64_t) {
	if randomNumberCallbackFunc == nil {
		return
	}
	randomNumberCallbackFunc(uint64(byteData), uint64(numBytes), uintptr(userData), (*uint64)(bytesWritten))
}

// KeyWrappingCallbackFunc a callback used to wrap (encrypt) the content key available in keystore resource group.
type KeyWrappingCallbackFunc = func(kEKParams AccessRight, inBuffer []uint8, outBuffer []uint8, userData uintptr, status *uint64)

var keyWrappingCallbackFunc KeyWrappingCallbackFunc

//export keyWrappingCallback
func keyWrappingCallback(kEKParams C.Lib3MF_AccessRight, inBuffer *C.uint8_t, outBuffer *C.uint8_t, userData C.Lib3MF_pvoid, status *C.uint64_t) {
	if keyWrappingCallbackFunc == nil {
		return
	}
	keyWrappingCallbackFunc(, ([][]uint8)(unsafe.Pointer(&inBuffer[0])), ([][]uint8)(unsafe.Pointer(&outBuffer[0])), uintptr(userData), (*uint64)(status))
}

// ContentEncryptionCallbackFunc a callback to encrypt/decrypt content called on each resource encrypted. This might be called several times depending on content size. If Input is not available(either null or size is 0), clients must return the result of authenticated tag generation/validation.
type ContentEncryptionCallbackFunc = func(cEKParams ContentEncryptionParams, input []uint8, output []uint8, userData uintptr, status *uint64)

var contentEncryptionCallbackFunc ContentEncryptionCallbackFunc

//export contentEncryptionCallback
func contentEncryptionCallback(cEKParams C.Lib3MF_ContentEncryptionParams, input *C.uint8_t, output *C.uint8_t, userData C.Lib3MF_pvoid, status *C.uint64_t) {
	if contentEncryptionCallbackFunc == nil {
		return
	}
	contentEncryptionCallbackFunc(, ([][]uint8)(unsafe.Pointer(&input[0])), ([][]uint8)(unsafe.Pointer(&output[0])), uintptr(userData), (*uint64)(status))
}

// Wrapper represents the number wrapper
type Wrapper struct {
	_ [0]func() // uncomparable; to make == not compile
	LibraryHandle ref
}

// Base represents a Lib3MF class.
type Base struct {
	_     		[0]func() // uncomparable; to make == not compile
	Ref   		ref       // identifies a C value, see ref type
	wrapperRef Wrapper
	gcPtr 		*ref      // used to trigger the finalizer when the Value is not referenced any more
}

// NewBase creates a new Base.
// The wrapped C pointer will be freed when the Go pointer is finalized,
// but one can release it manually calling Release.
func (wrapper Wrapper) NewBase(r ref) Base {
	gcPtr := new(ref)
	*gcPtr = r
	runtime.SetFinalizer(gcPtr, wrapper.releaseC)
	return Base{Ref: r, gcPtr: gcPtr, wrapperRef: wrapper}
}

// Release releases the C pointer.
func (inst Base) Release() error {
	err := inst.wrapperRef.Release(inst)
	*inst.gcPtr = nil
	return err
}

// Equal reports whether inst and w refer to the same C pointer.
func (inst Base) Equal(w Base) bool {
	return inst.Ref == w.Ref
}
// ClassTypeId get Class Type Id.
func (inst Base) ClassTypeId() (uint64, error) {
	var classTypeId C.uint64_t
	ret := C.CCall_lib3mf_base_classtypeid(inst.wrapperRef.LibraryHandle, inst.Ref, &classTypeId)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(classTypeId), nil
}


// Writer represents a Lib3MF class.
type Writer struct {
	Base
}

func (wrapper Wrapper) NewWriter(r ref) Writer {
	return Writer{wrapper.NewBase(r)}
}

// WriteToFile writes out the model as file. The file type is specified by the Model Writer class.
func (inst Writer) WriteToFile(filename string) error {
	ret := C.CCall_lib3mf_writer_writetofile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(filename)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetStreamSize retrieves the size of the full 3MF file stream.
func (inst Writer) GetStreamSize() (uint64, error) {
	var streamSize C.uint64_t
	ret := C.CCall_lib3mf_writer_getstreamsize(inst.wrapperRef.LibraryHandle, inst.Ref, &streamSize)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(streamSize), nil
}

// WriteToBuffer writes out the 3MF file into a memory buffer.
func (inst Writer) WriteToBuffer(buffer []uint8) ([]uint8, error) {
	var neededforbuffer C.uint64_t
	ret := C.CCall_lib3mf_writer_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbuffer, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(buffer) < int(neededforbuffer) {
	 buffer = append(buffer, make([]uint8, int(neededforbuffer)-len(buffer))...)
	}
	ret = C.CCall_lib3mf_writer_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbuffer, nil, (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return buffer[:int(neededforbuffer)], nil
}

// WriteToCallback writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
func (inst Writer) WriteToCallback(theWriteCallback WriteCallbackFunc, theSeekCallback SeekCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_writetocallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFWriteCallback)(unsafe.Pointer(C.Lib3MFWriteCallback_cgo)), (C.Lib3MFSeekCallback)(unsafe.Pointer(C.Lib3MFSeekCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	writeCallbackFunc = theWriteCallback
	seekCallbackFunc = theSeekCallback
	return nil
}

// SetProgressCallback set the progress callback for calls to this writer.
func (inst Writer) SetProgressCallback(progressCallback ProgressCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_setprogresscallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFProgressCallback)(unsafe.Pointer(C.Lib3MFProgressCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	progressCallbackFunc = progressCallback
	return nil
}

// GetDecimalPrecision returns the number of digits after the decimal point to be written in each vertex coordinate-value.
func (inst Writer) GetDecimalPrecision() (uint32, error) {
	var decimalPrecision C.uint32_t
	ret := C.CCall_lib3mf_writer_getdecimalprecision(inst.wrapperRef.LibraryHandle, inst.Ref, &decimalPrecision)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(decimalPrecision), nil
}

// SetDecimalPrecision sets the number of digits after the decimal point to be written in each vertex coordinate-value.
func (inst Writer) SetDecimalPrecision(decimalPrecision uint32) error {
	ret := C.CCall_lib3mf_writer_setdecimalprecision(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(decimalPrecision))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetStrictModeActive activates (deactivates) the strict mode of the reader.
func (inst Writer) SetStrictModeActive(strictModeActive bool) error {
	ret := C.CCall_lib3mf_writer_setstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(strictModeActive))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetStrictModeActive queries whether the strict mode of the reader is active or not.
func (inst Writer) GetStrictModeActive() (bool, error) {
	var strictModeActive C.bool
	ret := C.CCall_lib3mf_writer_getstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, &strictModeActive)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(strictModeActive), nil
}

// GetWarning returns Warning and Error Information of the read process.
func (inst Writer) GetWarning(index uint32) (uint32, string, error) {
	var errorCode C.uint32_t
	var neededforwarning C.uint32_t
	var filledinwarning C.uint32_t
	ret := C.CCall_lib3mf_writer_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, 0, &neededforwarning, nil)
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	bufferSizewarning := neededforwarning
	bufferwarning := make([]byte, bufferSizewarning)
	ret = C.CCall_lib3mf_writer_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, bufferSizewarning, &filledinwarning, (*C.char)(unsafe.Pointer(&bufferwarning[0])))
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	return uint32(errorCode), string(bufferwarning[:(filledinwarning-1)]), nil
}

// GetWarningCount returns Warning and Error Count of the read process.
func (inst Writer) GetWarningCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_writer_getwarningcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddKeyWrappingCallback registers a callback to deal with data key encryption/decryption from keystore.
func (inst Writer) AddKeyWrappingCallback(consumerID string, theCallback KeyWrappingCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_addkeywrappingcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), (C.Lib3MFKeyWrappingCallback)(unsafe.Pointer(C.Lib3MFKeyWrappingCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	keyWrappingCallbackFunc = theCallback
	return nil
}

// SetContentEncryptionCallback registers a callback to deal with encryption of content.
func (inst Writer) SetContentEncryptionCallback(theCallback ContentEncryptionCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_setcontentencryptioncallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFContentEncryptionCallback)(unsafe.Pointer(C.Lib3MFContentEncryptionCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	contentEncryptionCallbackFunc = theCallback
	return nil
}


// Reader represents a Lib3MF class.
type Reader struct {
	Base
}

func (wrapper Wrapper) NewReader(r ref) Reader {
	return Reader{wrapper.NewBase(r)}
}

// ReadFromFile reads a model from a file. The file type is specified by the Model Reader class.
func (inst Reader) ReadFromFile(filename string) error {
	ret := C.CCall_lib3mf_reader_readfromfile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(filename)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromBuffer reads a model from a memory buffer.
func (inst Reader) ReadFromBuffer(buffer []uint8) error {
	ret := C.CCall_lib3mf_reader_readfrombuffer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(buffer)), (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromCallback reads a model and from the data provided by a callback function.
func (inst Reader) ReadFromCallback(theReadCallback ReadCallbackFunc, streamSize uint64, theSeekCallback SeekCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_readfromcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFReadCallback)(unsafe.Pointer(C.Lib3MFReadCallback_cgo)), C.uint64_t(streamSize), (C.Lib3MFSeekCallback)(unsafe.Pointer(C.Lib3MFSeekCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	readCallbackFunc = theReadCallback
	seekCallbackFunc = theSeekCallback
	return nil
}

// SetProgressCallback set the progress callback for calls to this writer.
func (inst Reader) SetProgressCallback(progressCallback ProgressCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_setprogresscallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFProgressCallback)(unsafe.Pointer(C.Lib3MFProgressCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	progressCallbackFunc = progressCallback
	return nil
}

// AddRelationToRead adds a relationship type which shall be read as attachment in memory while loading.
func (inst Reader) AddRelationToRead(relationShipType string) error {
	ret := C.CCall_lib3mf_reader_addrelationtoread(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(relationShipType)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveRelationToRead removes a relationship type which shall be read as attachment in memory while loading.
func (inst Reader) RemoveRelationToRead(relationShipType string) error {
	ret := C.CCall_lib3mf_reader_removerelationtoread(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(relationShipType)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetStrictModeActive activates (deactivates) the strict mode of the reader.
func (inst Reader) SetStrictModeActive(strictModeActive bool) error {
	ret := C.CCall_lib3mf_reader_setstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(strictModeActive))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetStrictModeActive queries whether the strict mode of the reader is active or not.
func (inst Reader) GetStrictModeActive() (bool, error) {
	var strictModeActive C.bool
	ret := C.CCall_lib3mf_reader_getstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, &strictModeActive)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(strictModeActive), nil
}

// GetWarning returns Warning and Error Information of the read process.
func (inst Reader) GetWarning(index uint32) (uint32, string, error) {
	var errorCode C.uint32_t
	var neededforwarning C.uint32_t
	var filledinwarning C.uint32_t
	ret := C.CCall_lib3mf_reader_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, 0, &neededforwarning, nil)
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	bufferSizewarning := neededforwarning
	bufferwarning := make([]byte, bufferSizewarning)
	ret = C.CCall_lib3mf_reader_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, bufferSizewarning, &filledinwarning, (*C.char)(unsafe.Pointer(&bufferwarning[0])))
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	return uint32(errorCode), string(bufferwarning[:(filledinwarning-1)]), nil
}

// GetWarningCount returns Warning and Error Count of the read process.
func (inst Reader) GetWarningCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_reader_getwarningcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddKeyWrappingCallback registers a callback to deal with key wrapping mechanism from keystore.
func (inst Reader) AddKeyWrappingCallback(consumerID string, theCallback KeyWrappingCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_addkeywrappingcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), (C.Lib3MFKeyWrappingCallback)(unsafe.Pointer(C.Lib3MFKeyWrappingCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	keyWrappingCallbackFunc = theCallback
	return nil
}

// SetContentEncryptionCallback registers a callback to deal with encryption of content.
func (inst Reader) SetContentEncryptionCallback(theCallback ContentEncryptionCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_setcontentencryptioncallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFContentEncryptionCallback)(unsafe.Pointer(C.Lib3MFContentEncryptionCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	contentEncryptionCallbackFunc = theCallback
	return nil
}


// PackagePart represents a Lib3MF class.
type PackagePart struct {
	Base
}

func (wrapper Wrapper) NewPackagePart(r ref) PackagePart {
	return PackagePart{wrapper.NewBase(r)}
}

// GetPath returns the absolute path of this PackagePart.
func (inst PackagePart) GetPath() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_packagepart_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_packagepart_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}

// SetPath sets the absolute path of this PackagePart.
func (inst PackagePart) SetPath(path string) error {
	ret := C.CCall_lib3mf_packagepart_setpath(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Resource represents a Lib3MF class.
type Resource struct {
	Base
}

func (wrapper Wrapper) NewResource(r ref) Resource {
	return Resource{wrapper.NewBase(r)}
}

// GetResourceID retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID.
func (inst Resource) GetResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_resource_getresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// GetUniqueResourceID retrieves the unique id of this resource within a package.
func (inst Resource) GetUniqueResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_resource_getuniqueresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// PackagePart returns the PackagePart within which this resource resides.
func (inst Resource) PackagePart() (PackagePart, error) {
	var packagePart ref
	ret := C.CCall_lib3mf_resource_packagepart(inst.wrapperRef.LibraryHandle, inst.Ref, &packagePart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(packagePart), nil
}

// SetPackagePart sets the new PackagePart within which this resource resides.
func (inst Resource) SetPackagePart(packagePart PackagePart) error {
	ret := C.CCall_lib3mf_resource_setpackagepart(inst.wrapperRef.LibraryHandle, inst.Ref, packagePart.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetModelResourceID retrieves the id of this resource within a model.
func (inst Resource) GetModelResourceID() (uint32, error) {
	var modelResourceId C.uint32_t
	ret := C.CCall_lib3mf_resource_getmodelresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &modelResourceId)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(modelResourceId), nil
}


// ResourceIterator represents a Lib3MF class.
type ResourceIterator struct {
	Base
}

func (wrapper Wrapper) NewResourceIterator(r ref) ResourceIterator {
	return ResourceIterator{wrapper.NewBase(r)}
}

// MoveNext iterates to the next resource in the list.
func (inst ResourceIterator) MoveNext() (bool, error) {
	var hasNext C.bool
	ret := C.CCall_lib3mf_resourceiterator_movenext(inst.wrapperRef.LibraryHandle, inst.Ref, &hasNext)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasNext), nil
}

// MovePrevious iterates to the previous resource in the list.
func (inst ResourceIterator) MovePrevious() (bool, error) {
	var hasPrevious C.bool
	ret := C.CCall_lib3mf_resourceiterator_moveprevious(inst.wrapperRef.LibraryHandle, inst.Ref, &hasPrevious)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasPrevious), nil
}

// GetCurrent returns the resource the iterator points at.
func (inst ResourceIterator) GetCurrent() (Resource, error) {
	var resource ref
	ret := C.CCall_lib3mf_resourceiterator_getcurrent(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Resource{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResource(resource), nil
}

// Clone creates a new resource iterator with the same resource list.
func (inst ResourceIterator) Clone() (ResourceIterator, error) {
	var outResourceIterator ref
	ret := C.CCall_lib3mf_resourceiterator_clone(inst.wrapperRef.LibraryHandle, inst.Ref, &outResourceIterator)
	if ret != 0 {
		return ResourceIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceIterator(outResourceIterator), nil
}

// Count returns the number of resoucres the iterator captures.
func (inst ResourceIterator) Count() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_resourceiterator_count(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}


// SliceStackIterator represents a Lib3MF class.
type SliceStackIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewSliceStackIterator(r ref) SliceStackIterator {
	return SliceStackIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentSliceStack returns the SliceStack the iterator points at.
func (inst SliceStackIterator) GetCurrentSliceStack() (SliceStack, error) {
	var resource ref
	ret := C.CCall_lib3mf_slicestackiterator_getcurrentslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(resource), nil
}


// ObjectIterator represents a Lib3MF class.
type ObjectIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewObjectIterator(r ref) ObjectIterator {
	return ObjectIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentObject returns the Object the iterator points at.
func (inst ObjectIterator) GetCurrentObject() (Object, error) {
	var resource ref
	ret := C.CCall_lib3mf_objectiterator_getcurrentobject(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Object{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObject(resource), nil
}


// MeshObjectIterator represents a Lib3MF class.
type MeshObjectIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewMeshObjectIterator(r ref) MeshObjectIterator {
	return MeshObjectIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentMeshObject returns the MeshObject the iterator points at.
func (inst MeshObjectIterator) GetCurrentMeshObject() (MeshObject, error) {
	var resource ref
	ret := C.CCall_lib3mf_meshobjectiterator_getcurrentmeshobject(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return MeshObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObject(resource), nil
}


// ComponentsObjectIterator represents a Lib3MF class.
type ComponentsObjectIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewComponentsObjectIterator(r ref) ComponentsObjectIterator {
	return ComponentsObjectIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentComponentsObject returns the ComponentsObject the iterator points at.
func (inst ComponentsObjectIterator) GetCurrentComponentsObject() (ComponentsObject, error) {
	var resource ref
	ret := C.CCall_lib3mf_componentsobjectiterator_getcurrentcomponentsobject(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return ComponentsObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObject(resource), nil
}


// Texture2DIterator represents a Lib3MF class.
type Texture2DIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewTexture2DIterator(r ref) Texture2DIterator {
	return Texture2DIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentTexture2D returns the Texture2D the iterator points at.
func (inst Texture2DIterator) GetCurrentTexture2D() (Texture2D, error) {
	var resource ref
	ret := C.CCall_lib3mf_texture2diterator_getcurrenttexture2d(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(resource), nil
}


// BaseMaterialGroupIterator represents a Lib3MF class.
type BaseMaterialGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewBaseMaterialGroupIterator(r ref) BaseMaterialGroupIterator {
	return BaseMaterialGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentBaseMaterialGroup returns the MaterialGroup the iterator points at.
func (inst BaseMaterialGroupIterator) GetCurrentBaseMaterialGroup() (BaseMaterialGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(resource), nil
}


// ColorGroupIterator represents a Lib3MF class.
type ColorGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewColorGroupIterator(r ref) ColorGroupIterator {
	return ColorGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentColorGroup returns the ColorGroup the iterator points at.
func (inst ColorGroupIterator) GetCurrentColorGroup() (ColorGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_colorgroupiterator_getcurrentcolorgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return ColorGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroup(resource), nil
}


// Texture2DGroupIterator represents a Lib3MF class.
type Texture2DGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewTexture2DGroupIterator(r ref) Texture2DGroupIterator {
	return Texture2DGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentTexture2DGroup returns the Texture2DGroup the iterator points at.
func (inst Texture2DGroupIterator) GetCurrentTexture2DGroup() (Texture2DGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Texture2DGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroup(resource), nil
}


// CompositeMaterialsIterator represents a Lib3MF class.
type CompositeMaterialsIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewCompositeMaterialsIterator(r ref) CompositeMaterialsIterator {
	return CompositeMaterialsIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentCompositeMaterials returns the CompositeMaterials the iterator points at.
func (inst CompositeMaterialsIterator) GetCurrentCompositeMaterials() (CompositeMaterials, error) {
	var resource ref
	ret := C.CCall_lib3mf_compositematerialsiterator_getcurrentcompositematerials(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return CompositeMaterials{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterials(resource), nil
}


// MultiPropertyGroupIterator represents a Lib3MF class.
type MultiPropertyGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewMultiPropertyGroupIterator(r ref) MultiPropertyGroupIterator {
	return MultiPropertyGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentMultiPropertyGroup returns the MultiPropertyGroup the iterator points at.
func (inst MultiPropertyGroupIterator) GetCurrentMultiPropertyGroup() (MultiPropertyGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return MultiPropertyGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroup(resource), nil
}


// MetaData represents a Lib3MF class.
type MetaData struct {
	Base
}

func (wrapper Wrapper) NewMetaData(r ref) MetaData {
	return MetaData{wrapper.NewBase(r)}
}

// GetNameSpace returns the namespace URL of the metadata.
func (inst MetaData) GetNameSpace() (string, error) {
	var neededfornameSpace C.uint32_t
	var filledinnameSpace C.uint32_t
	ret := C.CCall_lib3mf_metadata_getnamespace(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfornameSpace, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizenameSpace := neededfornameSpace
	buffernameSpace := make([]byte, bufferSizenameSpace)
	ret = C.CCall_lib3mf_metadata_getnamespace(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizenameSpace, &filledinnameSpace, (*C.char)(unsafe.Pointer(&buffernameSpace[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffernameSpace[:(filledinnameSpace-1)]), nil
}

// SetNameSpace sets a new namespace URL of the metadata.
func (inst MetaData) SetNameSpace(nameSpace string) error {
	ret := C.CCall_lib3mf_metadata_setnamespace(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(nameSpace)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName returns the name of a metadata.
func (inst MetaData) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_metadata_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_metadata_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets a new name of a metadata.
func (inst MetaData) SetName(name string) error {
	ret := C.CCall_lib3mf_metadata_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetKey returns the (namespace+name) of a metadata.
func (inst MetaData) GetKey() (string, error) {
	var neededforkey C.uint32_t
	var filledinkey C.uint32_t
	ret := C.CCall_lib3mf_metadata_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforkey, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizekey := neededforkey
	bufferkey := make([]byte, bufferSizekey)
	ret = C.CCall_lib3mf_metadata_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizekey, &filledinkey, (*C.char)(unsafe.Pointer(&bufferkey[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferkey[:(filledinkey-1)]), nil
}

// GetMustPreserve returns, whether a metadata must be preserved.
func (inst MetaData) GetMustPreserve() (bool, error) {
	var mustPreserve C.bool
	ret := C.CCall_lib3mf_metadata_getmustpreserve(inst.wrapperRef.LibraryHandle, inst.Ref, &mustPreserve)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(mustPreserve), nil
}

// SetMustPreserve sets whether a metadata must be preserved.
func (inst MetaData) SetMustPreserve(mustPreserve bool) error {
	ret := C.CCall_lib3mf_metadata_setmustpreserve(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(mustPreserve))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetType returns the type of a metadata.
func (inst MetaData) GetType() (string, error) {
	var neededfor_type C.uint32_t
	var filledin_type C.uint32_t
	ret := C.CCall_lib3mf_metadata_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfor_type, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSize_type := neededfor_type
	buffer_type := make([]byte, bufferSize_type)
	ret = C.CCall_lib3mf_metadata_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSize_type, &filledin_type, (*C.char)(unsafe.Pointer(&buffer_type[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffer_type[:(filledin_type-1)]), nil
}

// SetType sets a new type of a metadata. This must be a simple XML type.
func (inst MetaData) SetType(_type string) error {
	ret := C.CCall_lib3mf_metadata_settype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(_type)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetValue returns the value of the metadata.
func (inst MetaData) GetValue() (string, error) {
	var neededforvalue C.uint32_t
	var filledinvalue C.uint32_t
	ret := C.CCall_lib3mf_metadata_getvalue(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforvalue, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizevalue := neededforvalue
	buffervalue := make([]byte, bufferSizevalue)
	ret = C.CCall_lib3mf_metadata_getvalue(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizevalue, &filledinvalue, (*C.char)(unsafe.Pointer(&buffervalue[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffervalue[:(filledinvalue-1)]), nil
}

// SetValue sets a new value of the metadata.
func (inst MetaData) SetValue(value string) error {
	ret := C.CCall_lib3mf_metadata_setvalue(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(value)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// MetaDataGroup represents a Lib3MF class.
type MetaDataGroup struct {
	Base
}

func (wrapper Wrapper) NewMetaDataGroup(r ref) MetaDataGroup {
	return MetaDataGroup{wrapper.NewBase(r)}
}

// GetMetaDataCount returns the number of metadata in this metadatagroup.
func (inst MetaDataGroup) GetMetaDataCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_metadatagroup_getmetadatacount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetMetaData returns a metadata value within this metadatagroup.
func (inst MetaDataGroup) GetMetaData(index uint32) (MetaData, error) {
	var metaData ref
	ret := C.CCall_lib3mf_metadatagroup_getmetadata(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &metaData)
	if ret != 0 {
		return MetaData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaData(metaData), nil
}

// GetMetaDataByKey returns a metadata value within this metadatagroup.
func (inst MetaDataGroup) GetMetaDataByKey(nameSpace string, name string) (MetaData, error) {
	var metaData ref
	ret := C.CCall_lib3mf_metadatagroup_getmetadatabykey(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(nameSpace)[0])), (*C.char)(unsafe.Pointer(&[]byte(name)[0])), &metaData)
	if ret != 0 {
		return MetaData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaData(metaData), nil
}

// RemoveMetaDataByIndex removes metadata by index from the model.
func (inst MetaDataGroup) RemoveMetaDataByIndex(index uint32) error {
	ret := C.CCall_lib3mf_metadatagroup_removemetadatabyindex(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveMetaData removes metadata from the model.
func (inst MetaDataGroup) RemoveMetaData(theMetaData MetaData) error {
	ret := C.CCall_lib3mf_metadatagroup_removemetadata(inst.wrapperRef.LibraryHandle, inst.Ref, theMetaData.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddMetaData adds a new metadata to this metadatagroup.
func (inst MetaDataGroup) AddMetaData(nameSpace string, name string, value string, _type string, mustPreserve bool) (MetaData, error) {
	var metaData ref
	ret := C.CCall_lib3mf_metadatagroup_addmetadata(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(nameSpace)[0])), (*C.char)(unsafe.Pointer(&[]byte(name)[0])), (*C.char)(unsafe.Pointer(&[]byte(value)[0])), (*C.char)(unsafe.Pointer(&[]byte(_type)[0])), C.bool(mustPreserve), &metaData)
	if ret != 0 {
		return MetaData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaData(metaData), nil
}


// Object represents a Lib3MF class.
type Object struct {
	Resource
}

func (wrapper Wrapper) NewObject(r ref) Object {
	return Object{wrapper.NewResource(r)}
}

// GetType retrieves an object's type.
func (inst Object) GetType() (ObjectType, error) {
	var objectType C.eLib3MFObjectType
	ret := C.CCall_lib3mf_object_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, &objectType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return ObjectType(objectType), nil
}

// SetType sets an object's type.
func (inst Object) SetType(objectType ObjectType) error {
	ret := C.CCall_lib3mf_object_settype(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFObjectType(objectType))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName retrieves an object's name.
func (inst Object) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_object_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_object_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets an object's name string.
func (inst Object) SetName(name string) error {
	ret := C.CCall_lib3mf_object_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPartNumber retrieves an object's part number.
func (inst Object) GetPartNumber() (string, error) {
	var neededforpartNumber C.uint32_t
	var filledinpartNumber C.uint32_t
	ret := C.CCall_lib3mf_object_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpartNumber, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepartNumber := neededforpartNumber
	bufferpartNumber := make([]byte, bufferSizepartNumber)
	ret = C.CCall_lib3mf_object_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepartNumber, &filledinpartNumber, (*C.char)(unsafe.Pointer(&bufferpartNumber[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpartNumber[:(filledinpartNumber-1)]), nil
}

// SetPartNumber sets an objects partnumber string.
func (inst Object) SetPartNumber(partNumber string) error {
	ret := C.CCall_lib3mf_object_setpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(partNumber)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// IsMeshObject retrieves, if an object is a mesh object.
func (inst Object) IsMeshObject() (bool, error) {
	var isMeshObject C.bool
	ret := C.CCall_lib3mf_object_ismeshobject(inst.wrapperRef.LibraryHandle, inst.Ref, &isMeshObject)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isMeshObject), nil
}

// IsComponentsObject retrieves, if an object is a components object.
func (inst Object) IsComponentsObject() (bool, error) {
	var isComponentsObject C.bool
	ret := C.CCall_lib3mf_object_iscomponentsobject(inst.wrapperRef.LibraryHandle, inst.Ref, &isComponentsObject)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isComponentsObject), nil
}

// IsValid retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
func (inst Object) IsValid() (bool, error) {
	var isValid C.bool
	ret := C.CCall_lib3mf_object_isvalid(inst.wrapperRef.LibraryHandle, inst.Ref, &isValid)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isValid), nil
}

// SetAttachmentAsThumbnail use an existing attachment as thumbnail for this object.
func (inst Object) SetAttachmentAsThumbnail(attachment Attachment) error {
	ret := C.CCall_lib3mf_object_setattachmentasthumbnail(inst.wrapperRef.LibraryHandle, inst.Ref, attachment.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetThumbnailAttachment get the attachment containing the object thumbnail.
func (inst Object) GetThumbnailAttachment() (*Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_object_getthumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _attachmentPtr *Attachment
	if attachment != nil {
		_attachmentPtrVal := inst.wrapperRef.NewAttachment(attachment)
		_attachmentPtr = &_attachmentPtrVal
	}
	return _attachmentPtr, nil
}

// ClearThumbnailAttachment clears the attachment. The attachment instance is not removed from the package.
func (inst Object) ClearThumbnailAttachment() error {
	ret := C.CCall_lib3mf_object_clearthumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetOutbox returns the outbox of a build item.
func (inst Object) GetOutbox() (Box, error) {
	var outbox C.sLib3MFBox
	ret := C.CCall_lib3mf_object_getoutbox(inst.wrapperRef.LibraryHandle, inst.Ref, &outbox)
	if ret != 0 {
		return Box{}, makeError(uint32(ret))
	}
	return *(*Box)(unsafe.Pointer(&outbox)), nil
}

// GetUUID retrieves an object's uuid string (see production extension specification).
func (inst Object) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_object_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_object_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets a build object's uuid string (see production extension specification).
func (inst Object) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_object_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMetaDataGroup returns the metadatagroup of this object.
func (inst Object) GetMetaDataGroup() (MetaDataGroup, error) {
	var metaDataGroup ref
	ret := C.CCall_lib3mf_object_getmetadatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &metaDataGroup)
	if ret != 0 {
		return MetaDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaDataGroup(metaDataGroup), nil
}

// SetSlicesMeshResolution set the meshresolution of the mesh object.
func (inst Object) SetSlicesMeshResolution(meshResolution SlicesMeshResolution) error {
	ret := C.CCall_lib3mf_object_setslicesmeshresolution(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFSlicesMeshResolution(meshResolution))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSlicesMeshResolution get the meshresolution of the mesh object.
func (inst Object) GetSlicesMeshResolution() (SlicesMeshResolution, error) {
	var meshResolution C.eLib3MFSlicesMeshResolution
	ret := C.CCall_lib3mf_object_getslicesmeshresolution(inst.wrapperRef.LibraryHandle, inst.Ref, &meshResolution)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return SlicesMeshResolution(meshResolution), nil
}

// HasSlices returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack.
func (inst Object) HasSlices(recursive bool) (bool, error) {
	var hasSlices C.bool
	ret := C.CCall_lib3mf_object_hasslices(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(recursive), &hasSlices)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasSlices), nil
}

// ClearSliceStack unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
func (inst Object) ClearSliceStack() error {
	ret := C.CCall_lib3mf_object_clearslicestack(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSliceStack get the Slicestack attached to the object.
func (inst Object) GetSliceStack() (SliceStack, error) {
	var sliceStackInstance ref
	ret := C.CCall_lib3mf_object_getslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, &sliceStackInstance)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(sliceStackInstance), nil
}

// AssignSliceStack assigns a slicestack to the object.
func (inst Object) AssignSliceStack(sliceStackInstance SliceStack) error {
	ret := C.CCall_lib3mf_object_assignslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, sliceStackInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// MeshObject represents a Lib3MF class.
type MeshObject struct {
	Object
}

func (wrapper Wrapper) NewMeshObject(r ref) MeshObject {
	return MeshObject{wrapper.NewObject(r)}
}

// GetVertexCount returns the vertex count of a mesh object.
func (inst MeshObject) GetVertexCount() (uint32, error) {
	var vertexCount C.uint32_t
	ret := C.CCall_lib3mf_meshobject_getvertexcount(inst.wrapperRef.LibraryHandle, inst.Ref, &vertexCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(vertexCount), nil
}

// GetTriangleCount returns the triangle count of a mesh object.
func (inst MeshObject) GetTriangleCount() (uint32, error) {
	var vertexCount C.uint32_t
	ret := C.CCall_lib3mf_meshobject_gettrianglecount(inst.wrapperRef.LibraryHandle, inst.Ref, &vertexCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(vertexCount), nil
}

// GetVertex returns the vertex count of a mesh object.
func (inst MeshObject) GetVertex(index uint32) (Position, error) {
	var coordinates C.sLib3MFPosition
	ret := C.CCall_lib3mf_meshobject_getvertex(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &coordinates)
	if ret != 0 {
		return Position{}, makeError(uint32(ret))
	}
	return *(*Position)(unsafe.Pointer(&coordinates)), nil
}

// SetVertex sets the coordinates of a single vertex of a mesh object.
func (inst MeshObject) SetVertex(index uint32, coordinates Position) error {
	ret := C.CCall_lib3mf_meshobject_setvertex(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFPosition)(unsafe.Pointer(&coordinates)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddVertex adds a single vertex to a mesh object.
func (inst MeshObject) AddVertex(coordinates Position) (uint32, error) {
	var newIndex C.uint32_t
	ret := C.CCall_lib3mf_meshobject_addvertex(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFPosition)(unsafe.Pointer(&coordinates)), &newIndex)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(newIndex), nil
}

// GetVertices obtains all vertex positions of a mesh object.
func (inst MeshObject) GetVertices(vertices []Position) ([]Position, error) {
	var neededforvertices C.uint64_t
	ret := C.CCall_lib3mf_meshobject_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforvertices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(vertices) < int(neededforvertices) {
	 vertices = append(vertices, make([]Position, int(neededforvertices)-len(vertices))...)
	}
	ret = C.CCall_lib3mf_meshobject_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, neededforvertices, nil, (*C.sLib3MFPosition)(unsafe.Pointer(&vertices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return vertices[:int(neededforvertices)], nil
}

// GetTriangle returns indices of a single triangle of a mesh object.
func (inst MeshObject) GetTriangle(index uint32) (Triangle, error) {
	var indices C.sLib3MFTriangle
	ret := C.CCall_lib3mf_meshobject_gettriangle(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &indices)
	if ret != 0 {
		return Triangle{}, makeError(uint32(ret))
	}
	return *(*Triangle)(unsafe.Pointer(&indices)), nil
}

// SetTriangle sets the indices of a single triangle of a mesh object.
func (inst MeshObject) SetTriangle(index uint32, indices Triangle) error {
	ret := C.CCall_lib3mf_meshobject_settriangle(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFTriangle)(unsafe.Pointer(&indices)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddTriangle adds a single triangle to a mesh object.
func (inst MeshObject) AddTriangle(indices Triangle) (uint32, error) {
	var newIndex C.uint32_t
	ret := C.CCall_lib3mf_meshobject_addtriangle(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTriangle)(unsafe.Pointer(&indices)), &newIndex)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(newIndex), nil
}

// GetTriangleIndices get all triangles of a mesh object.
func (inst MeshObject) GetTriangleIndices(indices []Triangle) ([]Triangle, error) {
	var neededforindices C.uint64_t
	ret := C.CCall_lib3mf_meshobject_gettriangleindices(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforindices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(indices) < int(neededforindices) {
	 indices = append(indices, make([]Triangle, int(neededforindices)-len(indices))...)
	}
	ret = C.CCall_lib3mf_meshobject_gettriangleindices(inst.wrapperRef.LibraryHandle, inst.Ref, neededforindices, nil, (*C.sLib3MFTriangle)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return indices[:int(neededforindices)], nil
}

// SetObjectLevelProperty sets the property at the object-level of the mesh object.
func (inst MeshObject) SetObjectLevelProperty(uniqueResourceID uint32, propertyID uint32) error {
	ret := C.CCall_lib3mf_meshobject_setobjectlevelproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetObjectLevelProperty gets the property at the object-level of the mesh object.
func (inst MeshObject) GetObjectLevelProperty() (uint32, uint32, bool, error) {
	var uniqueResourceID C.uint32_t
	var propertyID C.uint32_t
	var hasObjectLevelProperty C.bool
	ret := C.CCall_lib3mf_meshobject_getobjectlevelproperty(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID, &propertyID, &hasObjectLevelProperty)
	if ret != 0 {
		return 0, 0, false, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), uint32(propertyID), bool(hasObjectLevelProperty), nil
}

// SetTriangleProperties sets the properties of a single triangle of a mesh object.
func (inst MeshObject) SetTriangleProperties(index uint32, properties TriangleProperties) error {
	ret := C.CCall_lib3mf_meshobject_settriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFTriangleProperties)(unsafe.Pointer(&properties)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTriangleProperties gets the properties of a single triangle of a mesh object.
func (inst MeshObject) GetTriangleProperties(index uint32) (TriangleProperties, error) {
	var property C.sLib3MFTriangleProperties
	ret := C.CCall_lib3mf_meshobject_gettriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &property)
	if ret != 0 {
		return TriangleProperties{}, makeError(uint32(ret))
	}
	return *(*TriangleProperties)(unsafe.Pointer(&property)), nil
}

// SetAllTriangleProperties sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
func (inst MeshObject) SetAllTriangleProperties(propertiesArray []TriangleProperties) error {
	ret := C.CCall_lib3mf_meshobject_setalltriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(propertiesArray)), (*C.sLib3MFTriangleProperties)(unsafe.Pointer(&propertiesArray[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetAllTriangleProperties gets the properties of all triangles of a mesh object.
func (inst MeshObject) GetAllTriangleProperties(propertiesArray []TriangleProperties) ([]TriangleProperties, error) {
	var neededforpropertiesArray C.uint64_t
	ret := C.CCall_lib3mf_meshobject_getalltriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertiesArray, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertiesArray) < int(neededforpropertiesArray) {
	 propertiesArray = append(propertiesArray, make([]TriangleProperties, int(neededforpropertiesArray)-len(propertiesArray))...)
	}
	ret = C.CCall_lib3mf_meshobject_getalltriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertiesArray, nil, (*C.sLib3MFTriangleProperties)(unsafe.Pointer(&propertiesArray[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertiesArray[:int(neededforpropertiesArray)], nil
}

// ClearAllProperties clears all properties of this mesh object (triangle and object-level).
func (inst MeshObject) ClearAllProperties() error {
	ret := C.CCall_lib3mf_meshobject_clearallproperties(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetGeometry set all triangles of a mesh object.
func (inst MeshObject) SetGeometry(vertices []Position, indices []Triangle) error {
	ret := C.CCall_lib3mf_meshobject_setgeometry(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(vertices)), (*C.sLib3MFPosition)(unsafe.Pointer(&vertices[0])), C.uint64_t(len(indices)), (*C.sLib3MFTriangle)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// IsManifoldAndOriented retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
func (inst MeshObject) IsManifoldAndOriented() (bool, error) {
	var isManifoldAndOriented C.bool
	ret := C.CCall_lib3mf_meshobject_ismanifoldandoriented(inst.wrapperRef.LibraryHandle, inst.Ref, &isManifoldAndOriented)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isManifoldAndOriented), nil
}

// BeamLattice retrieves the BeamLattice within this MeshObject.
func (inst MeshObject) BeamLattice() (BeamLattice, error) {
	var theBeamLattice ref
	ret := C.CCall_lib3mf_meshobject_beamlattice(inst.wrapperRef.LibraryHandle, inst.Ref, &theBeamLattice)
	if ret != 0 {
		return BeamLattice{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBeamLattice(theBeamLattice), nil
}


// BeamLattice represents a Lib3MF class.
type BeamLattice struct {
	Base
}

func (wrapper Wrapper) NewBeamLattice(r ref) BeamLattice {
	return BeamLattice{wrapper.NewBase(r)}
}

// GetMinLength returns the minimal length of beams for the beamlattice.
func (inst BeamLattice) GetMinLength() (float64, error) {
	var minLength C.double
	ret := C.CCall_lib3mf_beamlattice_getminlength(inst.wrapperRef.LibraryHandle, inst.Ref, &minLength)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(minLength), nil
}

// SetMinLength sets the minimal length of beams for the beamlattice.
func (inst BeamLattice) SetMinLength(minLength float64) error {
	ret := C.CCall_lib3mf_beamlattice_setminlength(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(minLength))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetClipping returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
func (inst BeamLattice) GetClipping() (BeamLatticeClipMode, uint32, error) {
	var clipMode C.eLib3MFBeamLatticeClipMode
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getclipping(inst.wrapperRef.LibraryHandle, inst.Ref, &clipMode, &uniqueResourceID)
	if ret != 0 {
		return 0, 0, makeError(uint32(ret))
	}
	return BeamLatticeClipMode(clipMode), uint32(uniqueResourceID), nil
}

// SetClipping sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
func (inst BeamLattice) SetClipping(clipMode BeamLatticeClipMode, uniqueResourceID uint32) error {
	ret := C.CCall_lib3mf_beamlattice_setclipping(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFBeamLatticeClipMode(clipMode), C.uint32_t(uniqueResourceID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetRepresentation returns the representation-mesh for the beamlattice of this mesh.
func (inst BeamLattice) GetRepresentation() (bool, uint32, error) {
	var hasRepresentation C.bool
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getrepresentation(inst.wrapperRef.LibraryHandle, inst.Ref, &hasRepresentation, &uniqueResourceID)
	if ret != 0 {
		return false, 0, makeError(uint32(ret))
	}
	return bool(hasRepresentation), uint32(uniqueResourceID), nil
}

// SetRepresentation sets the representation-mesh for the beamlattice of this mesh.
func (inst BeamLattice) SetRepresentation(uniqueResourceID uint32) error {
	ret := C.CCall_lib3mf_beamlattice_setrepresentation(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBallOptions returns the ball mode and the default ball radius for the beamlattice of this mesh.
func (inst BeamLattice) GetBallOptions() (BeamLatticeBallMode, float64, error) {
	var ballMode C.eLib3MFBeamLatticeBallMode
	var ballRadius C.double
	ret := C.CCall_lib3mf_beamlattice_getballoptions(inst.wrapperRef.LibraryHandle, inst.Ref, &ballMode, &ballRadius)
	if ret != 0 {
		return 0, 0, makeError(uint32(ret))
	}
	return BeamLatticeBallMode(ballMode), float64(ballRadius), nil
}

// SetBallOptions sets the ball mode and thedefault ball radius for the beamlattice.
func (inst BeamLattice) SetBallOptions(ballMode BeamLatticeBallMode, ballRadius float64) error {
	ret := C.CCall_lib3mf_beamlattice_setballoptions(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFBeamLatticeBallMode(ballMode), C.double(ballRadius))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBeamCount returns the beam count of a mesh object.
func (inst BeamLattice) GetBeamCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getbeamcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetBeam returns indices, radii and capmodes of a single beam of a mesh object.
func (inst BeamLattice) GetBeam(index uint32) (Beam, error) {
	var beamInfo C.sLib3MFBeam
	ret := C.CCall_lib3mf_beamlattice_getbeam(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &beamInfo)
	if ret != 0 {
		return Beam{}, makeError(uint32(ret))
	}
	return *(*Beam)(unsafe.Pointer(&beamInfo)), nil
}

// AddBeam adds a single beam to a mesh object.
func (inst BeamLattice) AddBeam(beamInfo Beam) (uint32, error) {
	var index C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_addbeam(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo)), &index)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(index), nil
}

// SetBeam sets the indices, radii and capmodes of a single beam of a mesh object.
func (inst BeamLattice) SetBeam(index uint32, beamInfo Beam) error {
	ret := C.CCall_lib3mf_beamlattice_setbeam(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetBeams sets all beam indices, radii and capmodes of a mesh object.
func (inst BeamLattice) SetBeams(beamInfo []Beam) error {
	ret := C.CCall_lib3mf_beamlattice_setbeams(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(beamInfo)), (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBeams obtains all beam indices, radii and capmodes of a mesh object.
func (inst BeamLattice) GetBeams(beamInfo []Beam) ([]Beam, error) {
	var neededforbeamInfo C.uint64_t
	ret := C.CCall_lib3mf_beamlattice_getbeams(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbeamInfo, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(beamInfo) < int(neededforbeamInfo) {
	 beamInfo = append(beamInfo, make([]Beam, int(neededforbeamInfo)-len(beamInfo))...)
	}
	ret = C.CCall_lib3mf_beamlattice_getbeams(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbeamInfo, nil, (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return beamInfo[:int(neededforbeamInfo)], nil
}

// GetBallCount returns the ball count of a mesh object.
func (inst BeamLattice) GetBallCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getballcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetBall returns index and radius of a single ball of a mesh object.
func (inst BeamLattice) GetBall(index uint32) (Ball, error) {
	var ballInfo C.sLib3MFBall
	ret := C.CCall_lib3mf_beamlattice_getball(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &ballInfo)
	if ret != 0 {
		return Ball{}, makeError(uint32(ret))
	}
	return *(*Ball)(unsafe.Pointer(&ballInfo)), nil
}

// AddBall adds a single ball to a mesh object.
func (inst BeamLattice) AddBall(ballInfo Ball) (uint32, error) {
	var index C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_addball(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo)), &index)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(index), nil
}

// SetBall sets the index and radius of a single ball of a mesh object.
func (inst BeamLattice) SetBall(index uint32, ballInfo Ball) error {
	ret := C.CCall_lib3mf_beamlattice_setball(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetBalls sets all ball indices and radii of a mesh object.
func (inst BeamLattice) SetBalls(ballInfo []Ball) error {
	ret := C.CCall_lib3mf_beamlattice_setballs(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(ballInfo)), (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBalls obtains all ball indices and radii of a mesh object.
func (inst BeamLattice) GetBalls(ballInfo []Ball) ([]Ball, error) {
	var neededforballInfo C.uint64_t
	ret := C.CCall_lib3mf_beamlattice_getballs(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforballInfo, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(ballInfo) < int(neededforballInfo) {
	 ballInfo = append(ballInfo, make([]Ball, int(neededforballInfo)-len(ballInfo))...)
	}
	ret = C.CCall_lib3mf_beamlattice_getballs(inst.wrapperRef.LibraryHandle, inst.Ref, neededforballInfo, nil, (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return ballInfo[:int(neededforballInfo)], nil
}

// GetBeamSetCount returns the number of beamsets of a mesh object.
func (inst BeamLattice) GetBeamSetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getbeamsetcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddBeamSet adds an empty beamset to a mesh object.
func (inst BeamLattice) AddBeamSet() (BeamSet, error) {
	var beamSet ref
	ret := C.CCall_lib3mf_beamlattice_addbeamset(inst.wrapperRef.LibraryHandle, inst.Ref, &beamSet)
	if ret != 0 {
		return BeamSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBeamSet(beamSet), nil
}

// GetBeamSet returns a beamset of a mesh object.
func (inst BeamLattice) GetBeamSet(index uint32) (BeamSet, error) {
	var beamSet ref
	ret := C.CCall_lib3mf_beamlattice_getbeamset(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &beamSet)
	if ret != 0 {
		return BeamSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBeamSet(beamSet), nil
}


// Component represents a Lib3MF class.
type Component struct {
	Base
}

func (wrapper Wrapper) NewComponent(r ref) Component {
	return Component{wrapper.NewBase(r)}
}

// GetObjectResource returns the Resource Instance of the component.
func (inst Component) GetObjectResource() (Object, error) {
	var objectResource ref
	ret := C.CCall_lib3mf_component_getobjectresource(inst.wrapperRef.LibraryHandle, inst.Ref, &objectResource)
	if ret != 0 {
		return Object{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObject(objectResource), nil
}

// GetObjectResourceID returns the UniqueResourceID of the component.
func (inst Component) GetObjectResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_component_getobjectresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// GetUUID returns, whether a component has a UUID and, if true, the component's UUID.
func (inst Component) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_component_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_component_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets the component's UUID.
func (inst Component) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_component_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// HasTransform returns, if the component has a different transformation than the identity matrix.
func (inst Component) HasTransform() (bool, error) {
	var hasTransform C.bool
	ret := C.CCall_lib3mf_component_hastransform(inst.wrapperRef.LibraryHandle, inst.Ref, &hasTransform)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasTransform), nil
}

// GetTransform returns the transformation matrix of the component.
func (inst Component) GetTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_component_gettransform(inst.wrapperRef.LibraryHandle, inst.Ref, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// SetTransform sets the transformation matrix of the component.
func (inst Component) SetTransform(transform Transform) error {
	ret := C.CCall_lib3mf_component_settransform(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// ComponentsObject represents a Lib3MF class.
type ComponentsObject struct {
	Object
}

func (wrapper Wrapper) NewComponentsObject(r ref) ComponentsObject {
	return ComponentsObject{wrapper.NewObject(r)}
}

// AddComponent adds a new component to a components object.
func (inst ComponentsObject) AddComponent(objectResource Object, transform Transform) (Component, error) {
	var componentInstance ref
	ret := C.CCall_lib3mf_componentsobject_addcomponent(inst.wrapperRef.LibraryHandle, inst.Ref, objectResource.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)), &componentInstance)
	if ret != 0 {
		return Component{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponent(componentInstance), nil
}

// GetComponent retrieves a component from a component object.
func (inst ComponentsObject) GetComponent(index uint32) (Component, error) {
	var componentInstance ref
	ret := C.CCall_lib3mf_componentsobject_getcomponent(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &componentInstance)
	if ret != 0 {
		return Component{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponent(componentInstance), nil
}

// GetComponentCount retrieves a component count of a component object.
func (inst ComponentsObject) GetComponentCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_componentsobject_getcomponentcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}


// BeamSet represents a Lib3MF class.
type BeamSet struct {
	Base
}

func (wrapper Wrapper) NewBeamSet(r ref) BeamSet {
	return BeamSet{wrapper.NewBase(r)}
}

// SetName sets a beamset's name string.
func (inst BeamSet) SetName(name string) error {
	ret := C.CCall_lib3mf_beamset_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName retrieves a beamset's name string.
func (inst BeamSet) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_beamset_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_beamset_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetIdentifier sets a beamset's identifier string.
func (inst BeamSet) SetIdentifier(identifier string) error {
	ret := C.CCall_lib3mf_beamset_setidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetIdentifier retrieves a beamset's identifier string.
func (inst BeamSet) GetIdentifier() (string, error) {
	var neededforidentifier C.uint32_t
	var filledinidentifier C.uint32_t
	ret := C.CCall_lib3mf_beamset_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforidentifier, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeidentifier := neededforidentifier
	bufferidentifier := make([]byte, bufferSizeidentifier)
	ret = C.CCall_lib3mf_beamset_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeidentifier, &filledinidentifier, (*C.char)(unsafe.Pointer(&bufferidentifier[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferidentifier[:(filledinidentifier-1)]), nil
}

// GetReferenceCount retrieves the reference count of a beamset.
func (inst BeamSet) GetReferenceCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamset_getreferencecount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// SetReferences sets the references of a beamset.
func (inst BeamSet) SetReferences(references []uint32) error {
	ret := C.CCall_lib3mf_beamset_setreferences(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(references)), (*C.uint32_t)(unsafe.Pointer(&references[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetReferences retrieves the references of a beamset.
func (inst BeamSet) GetReferences(references []uint32) ([]uint32, error) {
	var neededforreferences C.uint64_t
	ret := C.CCall_lib3mf_beamset_getreferences(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforreferences, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(references) < int(neededforreferences) {
	 references = append(references, make([]uint32, int(neededforreferences)-len(references))...)
	}
	ret = C.CCall_lib3mf_beamset_getreferences(inst.wrapperRef.LibraryHandle, inst.Ref, neededforreferences, nil, (*C.uint32_t)(unsafe.Pointer(&references[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return references[:int(neededforreferences)], nil
}

// GetBallReferenceCount retrieves the ball reference count of a beamset.
func (inst BeamSet) GetBallReferenceCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamset_getballreferencecount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// SetBallReferences sets the ball references of a beamset.
func (inst BeamSet) SetBallReferences(ballReferences []uint32) error {
	ret := C.CCall_lib3mf_beamset_setballreferences(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(ballReferences)), (*C.uint32_t)(unsafe.Pointer(&ballReferences[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBallReferences retrieves the ball references of a beamset.
func (inst BeamSet) GetBallReferences(ballReferences []uint32) ([]uint32, error) {
	var neededforballReferences C.uint64_t
	ret := C.CCall_lib3mf_beamset_getballreferences(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforballReferences, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(ballReferences) < int(neededforballReferences) {
	 ballReferences = append(ballReferences, make([]uint32, int(neededforballReferences)-len(ballReferences))...)
	}
	ret = C.CCall_lib3mf_beamset_getballreferences(inst.wrapperRef.LibraryHandle, inst.Ref, neededforballReferences, nil, (*C.uint32_t)(unsafe.Pointer(&ballReferences[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return ballReferences[:int(neededforballReferences)], nil
}


// BaseMaterialGroup represents a Lib3MF class.
type BaseMaterialGroup struct {
	Resource
}

func (wrapper Wrapper) NewBaseMaterialGroup(r ref) BaseMaterialGroup {
	return BaseMaterialGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of base materials in the material group.
func (inst BaseMaterialGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_basematerialgroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all materials in this group.
func (inst BaseMaterialGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_basematerialgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_basematerialgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddMaterial adds a new material to the material group.
func (inst BaseMaterialGroup) AddMaterial(name string, displayColor Color) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_basematerialgroup_addmaterial(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])), (*C.sLib3MFColor)(unsafe.Pointer(&displayColor)), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// RemoveMaterial removes a material from the material group.
func (inst BaseMaterialGroup) RemoveMaterial(propertyID uint32) error {
	ret := C.CCall_lib3mf_basematerialgroup_removematerial(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName returns the base material's name.
func (inst BaseMaterialGroup) GetName(propertyID uint32) (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_basematerialgroup_getname(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_basematerialgroup_getname(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets a base material's name.
func (inst BaseMaterialGroup) SetName(propertyID uint32, name string) error {
	ret := C.CCall_lib3mf_basematerialgroup_setname(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetDisplayColor sets a base material's display color.
func (inst BaseMaterialGroup) SetDisplayColor(propertyID uint32, theColor Color) error {
	ret := C.CCall_lib3mf_basematerialgroup_setdisplaycolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), (*C.sLib3MFColor)(unsafe.Pointer(&theColor)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetDisplayColor returns a base material's display color.
func (inst BaseMaterialGroup) GetDisplayColor(propertyID uint32) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_basematerialgroup_getdisplaycolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}


// ColorGroup represents a Lib3MF class.
type ColorGroup struct {
	Resource
}

func (wrapper Wrapper) NewColorGroup(r ref) ColorGroup {
	return ColorGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of base materials in this Color Group.
func (inst ColorGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_colorgroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all colors within this group.
func (inst ColorGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_colorgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_colorgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddColor adds a new value.
func (inst ColorGroup) AddColor(theColor Color) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_colorgroup_addcolor(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFColor)(unsafe.Pointer(&theColor)), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// RemoveColor removes a color from the color group.
func (inst ColorGroup) RemoveColor(propertyID uint32) error {
	ret := C.CCall_lib3mf_colorgroup_removecolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetColor sets a color value.
func (inst ColorGroup) SetColor(propertyID uint32, theColor Color) error {
	ret := C.CCall_lib3mf_colorgroup_setcolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), (*C.sLib3MFColor)(unsafe.Pointer(&theColor)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetColor sets a color value.
func (inst ColorGroup) GetColor(propertyID uint32) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_colorgroup_getcolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}


// Texture2DGroup represents a Lib3MF class.
type Texture2DGroup struct {
	Resource
}

func (wrapper Wrapper) NewTexture2DGroup(r ref) Texture2DGroup {
	return Texture2DGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of tex2coords in the Texture2DGroup.
func (inst Texture2DGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_texture2dgroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all tex2coords in this Texture2DGroup.
func (inst Texture2DGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_texture2dgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_texture2dgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddTex2Coord adds a new tex2coord to the Texture2DGroup.
func (inst Texture2DGroup) AddTex2Coord(uVCoordinate Tex2Coord) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_texture2dgroup_addtex2coord(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTex2Coord)(unsafe.Pointer(&uVCoordinate)), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// GetTex2Coord obtains a tex2coord to the Texture2DGroup.
func (inst Texture2DGroup) GetTex2Coord(propertyID uint32) (Tex2Coord, error) {
	var uVCoordinate C.sLib3MFTex2Coord
	ret := C.CCall_lib3mf_texture2dgroup_gettex2coord(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), &uVCoordinate)
	if ret != 0 {
		return Tex2Coord{}, makeError(uint32(ret))
	}
	return *(*Tex2Coord)(unsafe.Pointer(&uVCoordinate)), nil
}

// RemoveTex2Coord removes a tex2coords from the Texture2DGroup.
func (inst Texture2DGroup) RemoveTex2Coord(propertyID uint32) error {
	ret := C.CCall_lib3mf_texture2dgroup_removetex2coord(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTexture2D obtains the texture2D instance of this group.
func (inst Texture2DGroup) GetTexture2D() (Texture2D, error) {
	var texture2DInstance ref
	ret := C.CCall_lib3mf_texture2dgroup_gettexture2d(inst.wrapperRef.LibraryHandle, inst.Ref, &texture2DInstance)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(texture2DInstance), nil
}


// CompositeMaterials represents a Lib3MF class.
type CompositeMaterials struct {
	Resource
}

func (wrapper Wrapper) NewCompositeMaterials(r ref) CompositeMaterials {
	return CompositeMaterials{wrapper.NewResource(r)}
}

// GetCount retrieves the count of Composite-s in the CompositeMaterials.
func (inst CompositeMaterials) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_compositematerials_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials.
func (inst CompositeMaterials) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_compositematerials_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_compositematerials_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// GetBaseMaterialGroup obtains the BaseMaterialGroup instance of this CompositeMaterials.
func (inst CompositeMaterials) GetBaseMaterialGroup() (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_compositematerials_getbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// AddComposite adds a new Composite-Mixing Values to the CompositeMaterials.
func (inst CompositeMaterials) AddComposite(composite []CompositeConstituent) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_compositematerials_addcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(composite)), (*C.sLib3MFCompositeConstituent)(unsafe.Pointer(&composite[0])), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// RemoveComposite removes a Composite-Maxing Ratio from the CompositeMaterials.
func (inst CompositeMaterials) RemoveComposite(propertyID uint32) error {
	ret := C.CCall_lib3mf_compositematerials_removecomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetComposite obtains a Composite-Maxing Ratio of this CompositeMaterials.
func (inst CompositeMaterials) GetComposite(propertyID uint32, composite []CompositeConstituent) ([]CompositeConstituent, error) {
	var neededforcomposite C.uint64_t
	ret := C.CCall_lib3mf_compositematerials_getcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), 0, &neededforcomposite, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(composite) < int(neededforcomposite) {
	 composite = append(composite, make([]CompositeConstituent, int(neededforcomposite)-len(composite))...)
	}
	ret = C.CCall_lib3mf_compositematerials_getcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), neededforcomposite, nil, (*C.sLib3MFCompositeConstituent)(unsafe.Pointer(&composite[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return composite[:int(neededforcomposite)], nil
}


// MultiPropertyGroup represents a Lib3MF class.
type MultiPropertyGroup struct {
	Resource
}

func (wrapper Wrapper) NewMultiPropertyGroup(r ref) MultiPropertyGroup {
	return MultiPropertyGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of MultiProperty-s in the MultiPropertyGroup.
func (inst MultiPropertyGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup.
func (inst MultiPropertyGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_multipropertygroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_multipropertygroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddMultiProperty adds a new MultiProperty to the MultiPropertyGroup.
func (inst MultiPropertyGroup) AddMultiProperty(propertyIDs []uint32) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_addmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(propertyIDs)), (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// SetMultiProperty sets the PropertyIDs of a MultiProperty.
func (inst MultiPropertyGroup) SetMultiProperty(propertyID uint32, propertyIDs []uint32) error {
	ret := C.CCall_lib3mf_multipropertygroup_setmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), C.uint64_t(len(propertyIDs)), (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMultiProperty obtains the PropertyIDs of a MultiProperty.
func (inst MultiPropertyGroup) GetMultiProperty(propertyID uint32, propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_multipropertygroup_getmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_multipropertygroup_getmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// RemoveMultiProperty removes a MultiProperty from this MultiPropertyGroup.
func (inst MultiPropertyGroup) RemoveMultiProperty(propertyID uint32) error {
	ret := C.CCall_lib3mf_multipropertygroup_removemultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetLayerCount retrieves the number of layers of this MultiPropertyGroup.
func (inst MultiPropertyGroup) GetLayerCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_getlayercount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddLayer adds a MultiPropertyLayer to this MultiPropertyGroup.
func (inst MultiPropertyGroup) AddLayer(theLayer MultiPropertyLayer) (uint32, error) {
	var layerIndex C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_addlayer(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFMultiPropertyLayer)(unsafe.Pointer(&theLayer)), &layerIndex)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(layerIndex), nil
}

// GetLayer obtains a MultiPropertyLayer of this MultiPropertyGroup.
func (inst MultiPropertyGroup) GetLayer(layerIndex uint32) (MultiPropertyLayer, error) {
	var theLayer C.sLib3MFMultiPropertyLayer
	ret := C.CCall_lib3mf_multipropertygroup_getlayer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(layerIndex), &theLayer)
	if ret != 0 {
		return MultiPropertyLayer{}, makeError(uint32(ret))
	}
	return *(*MultiPropertyLayer)(unsafe.Pointer(&theLayer)), nil
}

// RemoveLayer removes a MultiPropertyLayer from this MultiPropertyGroup.
func (inst MultiPropertyGroup) RemoveLayer(layerIndex uint32) error {
	ret := C.CCall_lib3mf_multipropertygroup_removelayer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(layerIndex))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Attachment represents a Lib3MF class.
type Attachment struct {
	Base
}

func (wrapper Wrapper) NewAttachment(r ref) Attachment {
	return Attachment{wrapper.NewBase(r)}
}

// GetPath retrieves an attachment's package path. This function will be removed in a later release.
func (inst Attachment) GetPath() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_attachment_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_attachment_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}

// SetPath sets an attachment's package path. This function will be removed in a later release.
func (inst Attachment) SetPath(path string) error {
	ret := C.CCall_lib3mf_attachment_setpath(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// PackagePart returns the PackagePart that is this attachment.
func (inst Attachment) PackagePart() (PackagePart, error) {
	var packagePart ref
	ret := C.CCall_lib3mf_attachment_packagepart(inst.wrapperRef.LibraryHandle, inst.Ref, &packagePart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(packagePart), nil
}

// GetRelationShipType retrieves an attachment's relationship type.
func (inst Attachment) GetRelationShipType() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_attachment_getrelationshiptype(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_attachment_getrelationshiptype(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}

// SetRelationShipType sets an attachment's relationship type.
func (inst Attachment) SetRelationShipType(path string) error {
	ret := C.CCall_lib3mf_attachment_setrelationshiptype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// WriteToFile writes out the attachment as file.
func (inst Attachment) WriteToFile(fileName string) error {
	ret := C.CCall_lib3mf_attachment_writetofile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(fileName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromFile reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
func (inst Attachment) ReadFromFile(fileName string) error {
	ret := C.CCall_lib3mf_attachment_readfromfile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(fileName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromCallback reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
func (inst Attachment) ReadFromCallback(theReadCallback ReadCallbackFunc, streamSize uint64, theSeekCallback SeekCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_attachment_readfromcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFReadCallback)(unsafe.Pointer(C.Lib3MFReadCallback_cgo)), C.uint64_t(streamSize), (C.Lib3MFSeekCallback)(unsafe.Pointer(C.Lib3MFSeekCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	readCallbackFunc = theReadCallback
	seekCallbackFunc = theSeekCallback
	return nil
}

// GetStreamSize retrieves the size of the attachment stream.
func (inst Attachment) GetStreamSize() (uint64, error) {
	var streamSize C.uint64_t
	ret := C.CCall_lib3mf_attachment_getstreamsize(inst.wrapperRef.LibraryHandle, inst.Ref, &streamSize)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(streamSize), nil
}

// WriteToBuffer writes out the attachment into a buffer.
func (inst Attachment) WriteToBuffer(buffer []uint8) ([]uint8, error) {
	var neededforbuffer C.uint64_t
	ret := C.CCall_lib3mf_attachment_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbuffer, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(buffer) < int(neededforbuffer) {
	 buffer = append(buffer, make([]uint8, int(neededforbuffer)-len(buffer))...)
	}
	ret = C.CCall_lib3mf_attachment_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbuffer, nil, (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return buffer[:int(neededforbuffer)], nil
}

// ReadFromBuffer reads an attachment from a memory buffer. This buffer is immediatly read (in contrast to the ReadFromCallback and ReadFromFile-methods).
func (inst Attachment) ReadFromBuffer(buffer []uint8) error {
	ret := C.CCall_lib3mf_attachment_readfrombuffer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(buffer)), (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Texture2D represents a Lib3MF class.
type Texture2D struct {
	Resource
}

func (wrapper Wrapper) NewTexture2D(r ref) Texture2D {
	return Texture2D{wrapper.NewResource(r)}
}

// GetAttachment retrieves the attachment located at the path of the texture.
func (inst Texture2D) GetAttachment() (Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_texture2d_getattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachment), nil
}

// SetAttachment sets the texture's package path to the path of the attachment.
func (inst Texture2D) SetAttachment(attachment Attachment) error {
	ret := C.CCall_lib3mf_texture2d_setattachment(inst.wrapperRef.LibraryHandle, inst.Ref, attachment.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetContentType retrieves a texture's content type.
func (inst Texture2D) GetContentType() (TextureType, error) {
	var contentType C.eLib3MFTextureType
	ret := C.CCall_lib3mf_texture2d_getcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, &contentType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return TextureType(contentType), nil
}

// SetContentType retrieves a texture's content type.
func (inst Texture2D) SetContentType(contentType TextureType) error {
	ret := C.CCall_lib3mf_texture2d_setcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureType(contentType))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTileStyleUV retrieves a texture's tilestyle type.
func (inst Texture2D) GetTileStyleUV() (TextureTileStyle, TextureTileStyle, error) {
	var tileStyleU C.eLib3MFTextureTileStyle
	var tileStyleV C.eLib3MFTextureTileStyle
	ret := C.CCall_lib3mf_texture2d_gettilestyleuv(inst.wrapperRef.LibraryHandle, inst.Ref, &tileStyleU, &tileStyleV)
	if ret != 0 {
		return 0, 0, makeError(uint32(ret))
	}
	return TextureTileStyle(tileStyleU), TextureTileStyle(tileStyleV), nil
}

// SetTileStyleUV sets a texture's tilestyle type.
func (inst Texture2D) SetTileStyleUV(tileStyleU TextureTileStyle, tileStyleV TextureTileStyle) error {
	ret := C.CCall_lib3mf_texture2d_settilestyleuv(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureTileStyle(tileStyleU), C.eLib3MFTextureTileStyle(tileStyleV))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetFilter retrieves a texture's filter type.
func (inst Texture2D) GetFilter() (TextureFilter, error) {
	var filter C.eLib3MFTextureFilter
	ret := C.CCall_lib3mf_texture2d_getfilter(inst.wrapperRef.LibraryHandle, inst.Ref, &filter)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return TextureFilter(filter), nil
}

// SetFilter sets a texture's filter type.
func (inst Texture2D) SetFilter(filter TextureFilter) error {
	ret := C.CCall_lib3mf_texture2d_setfilter(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureFilter(filter))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// BuildItem represents a Lib3MF class.
type BuildItem struct {
	Base
}

func (wrapper Wrapper) NewBuildItem(r ref) BuildItem {
	return BuildItem{wrapper.NewBase(r)}
}

// GetObjectResource retrieves the object resource associated to a build item.
func (inst BuildItem) GetObjectResource() (Object, error) {
	var objectResource ref
	ret := C.CCall_lib3mf_builditem_getobjectresource(inst.wrapperRef.LibraryHandle, inst.Ref, &objectResource)
	if ret != 0 {
		return Object{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObject(objectResource), nil
}

// GetUUID returns, whether a build item has a UUID and, if true, the build item's UUID.
func (inst BuildItem) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_builditem_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_builditem_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets the build item's UUID.
func (inst BuildItem) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_builditem_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetObjectResourceID retrieves the object UniqueResourceID associated to a build item.
func (inst BuildItem) GetObjectResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_builditem_getobjectresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// HasObjectTransform checks, if a build item has a non-identity transformation matrix.
func (inst BuildItem) HasObjectTransform() (bool, error) {
	var hasTransform C.bool
	ret := C.CCall_lib3mf_builditem_hasobjecttransform(inst.wrapperRef.LibraryHandle, inst.Ref, &hasTransform)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasTransform), nil
}

// GetObjectTransform retrieves a build item's transformation matrix.
func (inst BuildItem) GetObjectTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_builditem_getobjecttransform(inst.wrapperRef.LibraryHandle, inst.Ref, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// SetObjectTransform sets a build item's transformation matrix.
func (inst BuildItem) SetObjectTransform(transform Transform) error {
	ret := C.CCall_lib3mf_builditem_setobjecttransform(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPartNumber retrieves a build item's part number string.
func (inst BuildItem) GetPartNumber() (string, error) {
	var neededforpartNumber C.uint32_t
	var filledinpartNumber C.uint32_t
	ret := C.CCall_lib3mf_builditem_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpartNumber, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepartNumber := neededforpartNumber
	bufferpartNumber := make([]byte, bufferSizepartNumber)
	ret = C.CCall_lib3mf_builditem_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepartNumber, &filledinpartNumber, (*C.char)(unsafe.Pointer(&bufferpartNumber[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpartNumber[:(filledinpartNumber-1)]), nil
}

// SetPartNumber sets a build item's part number string.
func (inst BuildItem) SetPartNumber(setPartnumber string) error {
	ret := C.CCall_lib3mf_builditem_setpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(setPartnumber)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMetaDataGroup returns the metadatagroup of this build item.
func (inst BuildItem) GetMetaDataGroup() (MetaDataGroup, error) {
	var metaDataGroup ref
	ret := C.CCall_lib3mf_builditem_getmetadatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &metaDataGroup)
	if ret != 0 {
		return MetaDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaDataGroup(metaDataGroup), nil
}

// GetOutbox returns the outbox of a build item.
func (inst BuildItem) GetOutbox() (Box, error) {
	var outbox C.sLib3MFBox
	ret := C.CCall_lib3mf_builditem_getoutbox(inst.wrapperRef.LibraryHandle, inst.Ref, &outbox)
	if ret != 0 {
		return Box{}, makeError(uint32(ret))
	}
	return *(*Box)(unsafe.Pointer(&outbox)), nil
}


// BuildItemIterator represents a Lib3MF class.
type BuildItemIterator struct {
	Base
}

func (wrapper Wrapper) NewBuildItemIterator(r ref) BuildItemIterator {
	return BuildItemIterator{wrapper.NewBase(r)}
}

// MoveNext iterates to the next build item in the list.
func (inst BuildItemIterator) MoveNext() (bool, error) {
	var hasNext C.bool
	ret := C.CCall_lib3mf_builditemiterator_movenext(inst.wrapperRef.LibraryHandle, inst.Ref, &hasNext)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasNext), nil
}

// MovePrevious iterates to the previous build item in the list.
func (inst BuildItemIterator) MovePrevious() (bool, error) {
	var hasPrevious C.bool
	ret := C.CCall_lib3mf_builditemiterator_moveprevious(inst.wrapperRef.LibraryHandle, inst.Ref, &hasPrevious)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasPrevious), nil
}

// GetCurrent returns the build item the iterator points at.
func (inst BuildItemIterator) GetCurrent() (BuildItem, error) {
	var buildItem ref
	ret := C.CCall_lib3mf_builditemiterator_getcurrent(inst.wrapperRef.LibraryHandle, inst.Ref, &buildItem)
	if ret != 0 {
		return BuildItem{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItem(buildItem), nil
}

// Clone creates a new build item iterator with the same build item list.
func (inst BuildItemIterator) Clone() (BuildItemIterator, error) {
	var outBuildItemIterator ref
	ret := C.CCall_lib3mf_builditemiterator_clone(inst.wrapperRef.LibraryHandle, inst.Ref, &outBuildItemIterator)
	if ret != 0 {
		return BuildItemIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItemIterator(outBuildItemIterator), nil
}

// Count returns the number of build items the iterator captures.
func (inst BuildItemIterator) Count() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_builditemiterator_count(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}


// Slice represents a Lib3MF class.
type Slice struct {
	Base
}

func (wrapper Wrapper) NewSlice(r ref) Slice {
	return Slice{wrapper.NewBase(r)}
}

// SetVertices set all vertices of a slice. All polygons will be cleared.
func (inst Slice) SetVertices(vertices []Position2D) error {
	ret := C.CCall_lib3mf_slice_setvertices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(vertices)), (*C.sLib3MFPosition2D)(unsafe.Pointer(&vertices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetVertices get all vertices of a slice.
func (inst Slice) GetVertices(vertices []Position2D) ([]Position2D, error) {
	var neededforvertices C.uint64_t
	ret := C.CCall_lib3mf_slice_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforvertices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(vertices) < int(neededforvertices) {
	 vertices = append(vertices, make([]Position2D, int(neededforvertices)-len(vertices))...)
	}
	ret = C.CCall_lib3mf_slice_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, neededforvertices, nil, (*C.sLib3MFPosition2D)(unsafe.Pointer(&vertices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return vertices[:int(neededforvertices)], nil
}

// GetVertexCount get the number of vertices in a slice.
func (inst Slice) GetVertexCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slice_getvertexcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// AddPolygon add a new polygon to this slice.
func (inst Slice) AddPolygon(indices []uint32) (uint64, error) {
	var index C.uint64_t
	ret := C.CCall_lib3mf_slice_addpolygon(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(indices)), (*C.uint32_t)(unsafe.Pointer(&indices[0])), &index)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(index), nil
}

// GetPolygonCount get the number of polygons in the slice.
func (inst Slice) GetPolygonCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slice_getpolygoncount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// SetPolygonIndices set all indices of a polygon.
func (inst Slice) SetPolygonIndices(index uint64, indices []uint32) error {
	ret := C.CCall_lib3mf_slice_setpolygonindices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), C.uint64_t(len(indices)), (*C.uint32_t)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPolygonIndices get all vertices of a slice.
func (inst Slice) GetPolygonIndices(index uint64, indices []uint32) ([]uint32, error) {
	var neededforindices C.uint64_t
	ret := C.CCall_lib3mf_slice_getpolygonindices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), 0, &neededforindices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(indices) < int(neededforindices) {
	 indices = append(indices, make([]uint32, int(neededforindices)-len(indices))...)
	}
	ret = C.CCall_lib3mf_slice_getpolygonindices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), neededforindices, nil, (*C.uint32_t)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return indices[:int(neededforindices)], nil
}

// GetPolygonIndexCount get the number of vertices in a slice.
func (inst Slice) GetPolygonIndexCount(index uint64) (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slice_getpolygonindexcount(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetZTop get the upper Z-Coordinate of this slice.
func (inst Slice) GetZTop() (float64, error) {
	var zTop C.double
	ret := C.CCall_lib3mf_slice_getztop(inst.wrapperRef.LibraryHandle, inst.Ref, &zTop)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(zTop), nil
}


// SliceStack represents a Lib3MF class.
type SliceStack struct {
	Resource
}

func (wrapper Wrapper) NewSliceStack(r ref) SliceStack {
	return SliceStack{wrapper.NewResource(r)}
}

// GetBottomZ get the lower Z-Coordinate of the slice stack.
func (inst SliceStack) GetBottomZ() (float64, error) {
	var zBottom C.double
	ret := C.CCall_lib3mf_slicestack_getbottomz(inst.wrapperRef.LibraryHandle, inst.Ref, &zBottom)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(zBottom), nil
}

// GetSliceCount returns the number of slices.
func (inst SliceStack) GetSliceCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slicestack_getslicecount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetSlice query a slice from the slice stack.
func (inst SliceStack) GetSlice(sliceIndex uint64) (Slice, error) {
	var theSlice ref
	ret := C.CCall_lib3mf_slicestack_getslice(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(sliceIndex), &theSlice)
	if ret != 0 {
		return Slice{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSlice(theSlice), nil
}

// AddSlice returns the number of slices.
func (inst SliceStack) AddSlice(zTop float64) (Slice, error) {
	var theSlice ref
	ret := C.CCall_lib3mf_slicestack_addslice(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(zTop), &theSlice)
	if ret != 0 {
		return Slice{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSlice(theSlice), nil
}

// GetSliceRefCount returns the number of slice refs.
func (inst SliceStack) GetSliceRefCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slicestack_getslicerefcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// AddSliceStackReference adds another existing slicestack as sliceref in this slicestack.
func (inst SliceStack) AddSliceStackReference(theSliceStack SliceStack) error {
	ret := C.CCall_lib3mf_slicestack_addslicestackreference(inst.wrapperRef.LibraryHandle, inst.Ref, theSliceStack.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSliceStackReference adds another existing slicestack as sliceref in this slicestack.
func (inst SliceStack) GetSliceStackReference(sliceRefIndex uint64) (SliceStack, error) {
	var theSliceStack ref
	ret := C.CCall_lib3mf_slicestack_getslicestackreference(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(sliceRefIndex), &theSliceStack)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(theSliceStack), nil
}

// CollapseSliceReferences removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
func (inst SliceStack) CollapseSliceReferences() error {
	ret := C.CCall_lib3mf_slicestack_collapseslicereferences(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetOwnPath sets the package path where this Slice should be stored. Input an empty string to reset the path.
func (inst SliceStack) SetOwnPath(path string) error {
	ret := C.CCall_lib3mf_slicestack_setownpath(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetOwnPath obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
func (inst SliceStack) GetOwnPath() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_slicestack_getownpath(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_slicestack_getownpath(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}


// Consumer represents a Lib3MF class.
type Consumer struct {
	Base
}

func (wrapper Wrapper) NewConsumer(r ref) Consumer {
	return Consumer{wrapper.NewBase(r)}
}

// GetConsumerID gets the consumerid.
func (inst Consumer) GetConsumerID() (string, error) {
	var neededforconsumerID C.uint32_t
	var filledinconsumerID C.uint32_t
	ret := C.CCall_lib3mf_consumer_getconsumerid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforconsumerID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeconsumerID := neededforconsumerID
	bufferconsumerID := make([]byte, bufferSizeconsumerID)
	ret = C.CCall_lib3mf_consumer_getconsumerid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeconsumerID, &filledinconsumerID, (*C.char)(unsafe.Pointer(&bufferconsumerID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferconsumerID[:(filledinconsumerID-1)]), nil
}

// GetKeyID getts the keyid.
func (inst Consumer) GetKeyID() (string, error) {
	var neededforkeyID C.uint32_t
	var filledinkeyID C.uint32_t
	ret := C.CCall_lib3mf_consumer_getkeyid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforkeyID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizekeyID := neededforkeyID
	bufferkeyID := make([]byte, bufferSizekeyID)
	ret = C.CCall_lib3mf_consumer_getkeyid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizekeyID, &filledinkeyID, (*C.char)(unsafe.Pointer(&bufferkeyID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferkeyID[:(filledinkeyID-1)]), nil
}

// GetKeyValue gets the keyvalue associated with this consumer.
func (inst Consumer) GetKeyValue() (string, error) {
	var neededforkeyValue C.uint32_t
	var filledinkeyValue C.uint32_t
	ret := C.CCall_lib3mf_consumer_getkeyvalue(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforkeyValue, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizekeyValue := neededforkeyValue
	bufferkeyValue := make([]byte, bufferSizekeyValue)
	ret = C.CCall_lib3mf_consumer_getkeyvalue(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizekeyValue, &filledinkeyValue, (*C.char)(unsafe.Pointer(&bufferkeyValue[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferkeyValue[:(filledinkeyValue-1)]), nil
}


// AccessRight represents a Lib3MF class.
type AccessRight struct {
	Base
}

func (wrapper Wrapper) NewAccessRight(r ref) AccessRight {
	return AccessRight{wrapper.NewBase(r)}
}

// GetConsumer gets the consumer associated with this access right.
func (inst AccessRight) GetConsumer() (Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_accessright_getconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, &consumer)
	if ret != 0 {
		return Consumer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConsumer(consumer), nil
}

// GetWrappingAlgorithm gets the associated encryption algorithm.
func (inst AccessRight) GetWrappingAlgorithm() (WrappingAlgorithm, error) {
	var algorithm C.eLib3MFWrappingAlgorithm
	ret := C.CCall_lib3mf_accessright_getwrappingalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return WrappingAlgorithm(algorithm), nil
}

// GetMgfAlgorithm gets the associated mask generation function algorithm.
func (inst AccessRight) GetMgfAlgorithm() (MgfAlgorithm, error) {
	var algorithm C.eLib3MFMgfAlgorithm
	ret := C.CCall_lib3mf_accessright_getmgfalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return MgfAlgorithm(algorithm), nil
}

// GetDigestMethod gets the digest method assoicated.
func (inst AccessRight) GetDigestMethod() (DigestMethod, error) {
	var algorithm C.eLib3MFDigestMethod
	ret := C.CCall_lib3mf_accessright_getdigestmethod(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return DigestMethod(algorithm), nil
}


// ContentEncryptionParams represents a Lib3MF class.
type ContentEncryptionParams struct {
	Base
}

func (wrapper Wrapper) NewContentEncryptionParams(r ref) ContentEncryptionParams {
	return ContentEncryptionParams{wrapper.NewBase(r)}
}

// GetEncryptionAlgorithm returns the encryption method to be used in this encryption process.
func (inst ContentEncryptionParams) GetEncryptionAlgorithm() (EncryptionAlgorithm, error) {
	var algorithm C.eLib3MFEncryptionAlgorithm
	ret := C.CCall_lib3mf_contentencryptionparams_getencryptionalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return EncryptionAlgorithm(algorithm), nil
}

// GetKey gets the key for the resource associated.
func (inst ContentEncryptionParams) GetKey(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// GetInitializationVector gets the IV data.
func (inst ContentEncryptionParams) GetInitializationVector(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getinitializationvector(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getinitializationvector(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// GetAuthenticationTag a handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value.
func (inst ContentEncryptionParams) GetAuthenticationTag(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getauthenticationtag(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getauthenticationtag(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// SetAuthenticationTag sets the authentication tag.
func (inst ContentEncryptionParams) SetAuthenticationTag(byteData []uint8) error {
	ret := C.CCall_lib3mf_contentencryptionparams_setauthenticationtag(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(byteData)), (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetAdditionalAuthenticationData a handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value.
func (inst ContentEncryptionParams) GetAdditionalAuthenticationData(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// GetDescriptor a handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value.
func (inst ContentEncryptionParams) GetDescriptor() (uint64, error) {
	var descriptor C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getdescriptor(inst.wrapperRef.LibraryHandle, inst.Ref, &descriptor)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(descriptor), nil
}

// GetKeyUUID gets the resourcedatagroup keyuuid.
func (inst ContentEncryptionParams) GetKeyUUID() (string, error) {
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_contentencryptionparams_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforuUID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_contentencryptionparams_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferuUID[:(filledinuUID-1)]), nil
}


// ResourceData represents a Lib3MF class.
type ResourceData struct {
	Base
}

func (wrapper Wrapper) NewResourceData(r ref) ResourceData {
	return ResourceData{wrapper.NewBase(r)}
}

// GetPath gets the encrypted part path.
func (inst ResourceData) GetPath() (PackagePart, error) {
	var path ref
	ret := C.CCall_lib3mf_resourcedata_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, &path)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(path), nil
}

// GetEncryptionAlgorithm gets the encryption algorithm used to encrypt this ResourceData.
func (inst ResourceData) GetEncryptionAlgorithm() (EncryptionAlgorithm, error) {
	var encryptionAlgorithm C.eLib3MFEncryptionAlgorithm
	ret := C.CCall_lib3mf_resourcedata_getencryptionalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &encryptionAlgorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return EncryptionAlgorithm(encryptionAlgorithm), nil
}

// GetCompression tells whether this ResourceData is compressed or not.
func (inst ResourceData) GetCompression() (Compression, error) {
	var compression C.eLib3MFCompression
	ret := C.CCall_lib3mf_resourcedata_getcompression(inst.wrapperRef.LibraryHandle, inst.Ref, &compression)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return Compression(compression), nil
}

// GetAdditionalAuthenticationData tells whether this ResourceData is compressed or not.
func (inst ResourceData) GetAdditionalAuthenticationData(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_resourcedata_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_resourcedata_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}


// ResourceDataGroup represents a Lib3MF class.
type ResourceDataGroup struct {
	Base
}

func (wrapper Wrapper) NewResourceDataGroup(r ref) ResourceDataGroup {
	return ResourceDataGroup{wrapper.NewBase(r)}
}

// GetKeyUUID sets the resourcedatagroup keyuuid.
func (inst ResourceDataGroup) GetKeyUUID() (string, error) {
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_resourcedatagroup_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforuUID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_resourcedatagroup_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferuUID[:(filledinuUID-1)]), nil
}

// AddAccessRight add accessright to resourcedatagroup element.
func (inst ResourceDataGroup) AddAccessRight(consumer Consumer, wrappingAlgorithm WrappingAlgorithm, mgfAlgorithm MgfAlgorithm, digestMethod DigestMethod) (AccessRight, error) {
	var theAccessRight ref
	ret := C.CCall_lib3mf_resourcedatagroup_addaccessright(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref, C.eLib3MFWrappingAlgorithm(wrappingAlgorithm), C.eLib3MFMgfAlgorithm(mgfAlgorithm), C.eLib3MFDigestMethod(digestMethod), &theAccessRight)
	if ret != 0 {
		return AccessRight{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAccessRight(theAccessRight), nil
}

// FindAccessRightByConsumer finds the AccessRight associated with a Consumer.
func (inst ResourceDataGroup) FindAccessRightByConsumer(consumer Consumer) (*AccessRight, error) {
	var theAccessRight ref
	ret := C.CCall_lib3mf_resourcedatagroup_findaccessrightbyconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref, &theAccessRight)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theAccessRightPtr *AccessRight
	if theAccessRight != nil {
		_theAccessRightPtrVal := inst.wrapperRef.NewAccessRight(theAccessRight)
		_theAccessRightPtr = &_theAccessRightPtrVal
	}
	return _theAccessRightPtr, nil
}

// RemoveAccessRight removes access from a Consumer on this resource data group.
func (inst ResourceDataGroup) RemoveAccessRight(consumer Consumer) error {
	ret := C.CCall_lib3mf_resourcedatagroup_removeaccessright(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// KeyStore represents a Lib3MF class.
type KeyStore struct {
	Base
}

func (wrapper Wrapper) NewKeyStore(r ref) KeyStore {
	return KeyStore{wrapper.NewBase(r)}
}

// AddConsumer adds a consumer to the keystore.
func (inst KeyStore) AddConsumer(consumerID string, keyID string, keyValue string) (Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_keystore_addconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), (*C.char)(unsafe.Pointer(&[]byte(keyID)[0])), (*C.char)(unsafe.Pointer(&[]byte(keyValue)[0])), &consumer)
	if ret != 0 {
		return Consumer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConsumer(consumer), nil
}

// GetConsumerCount gets the number of consumers in the keystore.
func (inst KeyStore) GetConsumerCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_keystore_getconsumercount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetConsumer get a consumer from the keystore.
func (inst KeyStore) GetConsumer(consumerIndex uint64) (Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_keystore_getconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(consumerIndex), &consumer)
	if ret != 0 {
		return Consumer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConsumer(consumer), nil
}

// RemoveConsumer removes a consumer from the keystore.
func (inst KeyStore) RemoveConsumer(consumer Consumer) error {
	ret := C.CCall_lib3mf_keystore_removeconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindConsumer finds a consumer by ID.
func (inst KeyStore) FindConsumer(consumerID string) (*Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_keystore_findconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), &consumer)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _consumerPtr *Consumer
	if consumer != nil {
		_consumerPtrVal := inst.wrapperRef.NewConsumer(consumer)
		_consumerPtr = &_consumerPtrVal
	}
	return _consumerPtr, nil
}

// GetResourceDataGroupCount gets the number of resource data group in the keysore.
func (inst KeyStore) GetResourceDataGroupCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_keystore_getresourcedatagroupcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// AddResourceDataGroup adds a resource data group into the keystore.
func (inst KeyStore) AddResourceDataGroup() (ResourceDataGroup, error) {
	var resourceDataGroup ref
	ret := C.CCall_lib3mf_keystore_addresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceDataGroup)
	if ret != 0 {
		return ResourceDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceDataGroup(resourceDataGroup), nil
}

// GetResourceDataGroup gets a resource data group.
func (inst KeyStore) GetResourceDataGroup(resourceDataIndex uint64) (ResourceDataGroup, error) {
	var resourceDataGroup ref
	ret := C.CCall_lib3mf_keystore_getresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(resourceDataIndex), &resourceDataGroup)
	if ret != 0 {
		return ResourceDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceDataGroup(resourceDataGroup), nil
}

// RemoveResourceDataGroup removes a resource data group.
func (inst KeyStore) RemoveResourceDataGroup(resourceDataGroup ResourceDataGroup) error {
	ret := C.CCall_lib3mf_keystore_removeresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, resourceDataGroup.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindResourceDataGroup finds a resource data group that contains a particular resourcedata.
func (inst KeyStore) FindResourceDataGroup(partPath PackagePart) (*ResourceDataGroup, error) {
	var resourceDataGroup ref
	ret := C.CCall_lib3mf_keystore_findresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, partPath.Ref, &resourceDataGroup)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _resourceDataGroupPtr *ResourceDataGroup
	if resourceDataGroup != nil {
		_resourceDataGroupPtrVal := inst.wrapperRef.NewResourceDataGroup(resourceDataGroup)
		_resourceDataGroupPtr = &_resourceDataGroupPtrVal
	}
	return _resourceDataGroupPtr, nil
}

// AddResourceData add resourcedata to resourcedatagroup element.
func (inst KeyStore) AddResourceData(resourceDataGroup ResourceDataGroup, partPath PackagePart, algorithm EncryptionAlgorithm, compression Compression, additionalAuthenticationData []uint8) (ResourceData, error) {
	var resourceData ref
	ret := C.CCall_lib3mf_keystore_addresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, resourceDataGroup.Ref, partPath.Ref, C.eLib3MFEncryptionAlgorithm(algorithm), C.eLib3MFCompression(compression), C.uint64_t(len(additionalAuthenticationData)), (*C.uint8_t)(unsafe.Pointer(&additionalAuthenticationData[0])), &resourceData)
	if ret != 0 {
		return ResourceData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceData(resourceData), nil
}

// RemoveResourceData removes a resource data.
func (inst KeyStore) RemoveResourceData(resourceData ResourceData) error {
	ret := C.CCall_lib3mf_keystore_removeresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, resourceData.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindResourceData finds a resource data on this resource group.
func (inst KeyStore) FindResourceData(resourcePath PackagePart) (*ResourceData, error) {
	var resourceData ref
	ret := C.CCall_lib3mf_keystore_findresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, resourcePath.Ref, &resourceData)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _resourceDataPtr *ResourceData
	if resourceData != nil {
		_resourceDataPtrVal := inst.wrapperRef.NewResourceData(resourceData)
		_resourceDataPtr = &_resourceDataPtrVal
	}
	return _resourceDataPtr, nil
}

// GetResourceDataCount gets the number of resource data in the keysore.
func (inst KeyStore) GetResourceDataCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_keystore_getresourcedatacount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetResourceData gets a resource data.
func (inst KeyStore) GetResourceData(resourceDataIndex uint64) (ResourceData, error) {
	var resourceData ref
	ret := C.CCall_lib3mf_keystore_getresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(resourceDataIndex), &resourceData)
	if ret != 0 {
		return ResourceData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceData(resourceData), nil
}

// GetUUID gets the keystore UUID.
func (inst KeyStore) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_keystore_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_keystore_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets the keystore UUID.
func (inst KeyStore) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_keystore_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Model represents a Lib3MF class.
type Model struct {
	Base
}

func (wrapper Wrapper) NewModel(r ref) Model {
	return Model{wrapper.NewBase(r)}
}

// RootModelPart returns the PackagePart within the OPC package that holds the root model.
func (inst Model) RootModelPart() (PackagePart, error) {
	var rootModelPart ref
	ret := C.CCall_lib3mf_model_rootmodelpart(inst.wrapperRef.LibraryHandle, inst.Ref, &rootModelPart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(rootModelPart), nil
}

// FindOrCreatePackagePart returns a new PackagePart for use within the OPC package.
func (inst Model) FindOrCreatePackagePart(absolutePath string) (PackagePart, error) {
	var modelPart ref
	ret := C.CCall_lib3mf_model_findorcreatepackagepart(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(absolutePath)[0])), &modelPart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(modelPart), nil
}

// SetUnit sets the units of a model.
func (inst Model) SetUnit(unit ModelUnit) error {
	ret := C.CCall_lib3mf_model_setunit(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFModelUnit(unit))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetUnit returns the units of a model.
func (inst Model) GetUnit() (ModelUnit, error) {
	var unit C.eLib3MFModelUnit
	ret := C.CCall_lib3mf_model_getunit(inst.wrapperRef.LibraryHandle, inst.Ref, &unit)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return ModelUnit(unit), nil
}

// GetLanguage retrieves the language of a model.
func (inst Model) GetLanguage() (string, error) {
	var neededforlanguage C.uint32_t
	var filledinlanguage C.uint32_t
	ret := C.CCall_lib3mf_model_getlanguage(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforlanguage, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizelanguage := neededforlanguage
	bufferlanguage := make([]byte, bufferSizelanguage)
	ret = C.CCall_lib3mf_model_getlanguage(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizelanguage, &filledinlanguage, (*C.char)(unsafe.Pointer(&bufferlanguage[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferlanguage[:(filledinlanguage-1)]), nil
}

// SetLanguage sets the language of a model.
func (inst Model) SetLanguage(language string) error {
	ret := C.CCall_lib3mf_model_setlanguage(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(language)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// QueryWriter creates a model writer instance for a specific file type.
func (inst Model) QueryWriter(writerClass string) (Writer, error) {
	var writerInstance ref
	ret := C.CCall_lib3mf_model_querywriter(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(writerClass)[0])), &writerInstance)
	if ret != 0 {
		return Writer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewWriter(writerInstance), nil
}

// QueryReader creates a model reader instance for a specific file type.
func (inst Model) QueryReader(readerClass string) (Reader, error) {
	var readerInstance ref
	ret := C.CCall_lib3mf_model_queryreader(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(readerClass)[0])), &readerInstance)
	if ret != 0 {
		return Reader{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewReader(readerInstance), nil
}

// GetResourceByID finds a model resource by its UniqueResourceID.
func (inst Model) GetResourceByID(uniqueResourceID uint32) (Resource, error) {
	var resource ref
	ret := C.CCall_lib3mf_model_getresourcebyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &resource)
	if ret != 0 {
		return Resource{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResource(resource), nil
}

// GetTexture2DByID finds a model texture by its UniqueResourceID.
func (inst Model) GetTexture2DByID(uniqueResourceID uint32) (Texture2D, error) {
	var textureInstance ref
	ret := C.CCall_lib3mf_model_gettexture2dbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &textureInstance)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(textureInstance), nil
}

// GetPropertyTypeByID returns a Property's type.
func (inst Model) GetPropertyTypeByID(uniqueResourceID uint32) (PropertyType, error) {
	var thePropertyType C.eLib3MFPropertyType
	ret := C.CCall_lib3mf_model_getpropertytypebyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &thePropertyType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return PropertyType(thePropertyType), nil
}

// GetBaseMaterialGroupByID finds a model base material group by its UniqueResourceID.
func (inst Model) GetBaseMaterialGroupByID(uniqueResourceID uint32) (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_model_getbasematerialgroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// GetTexture2DGroupByID finds a model texture2d group by its UniqueResourceID.
func (inst Model) GetTexture2DGroupByID(uniqueResourceID uint32) (Texture2DGroup, error) {
	var texture2DGroupInstance ref
	ret := C.CCall_lib3mf_model_gettexture2dgroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &texture2DGroupInstance)
	if ret != 0 {
		return Texture2DGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroup(texture2DGroupInstance), nil
}

// GetCompositeMaterialsByID finds a model CompositeMaterials by its UniqueResourceID.
func (inst Model) GetCompositeMaterialsByID(uniqueResourceID uint32) (CompositeMaterials, error) {
	var compositeMaterialsInstance ref
	ret := C.CCall_lib3mf_model_getcompositematerialsbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &compositeMaterialsInstance)
	if ret != 0 {
		return CompositeMaterials{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterials(compositeMaterialsInstance), nil
}

// GetMultiPropertyGroupByID finds a model MultiPropertyGroup by its UniqueResourceID.
func (inst Model) GetMultiPropertyGroupByID(uniqueResourceID uint32) (MultiPropertyGroup, error) {
	var multiPropertyGroupInstance ref
	ret := C.CCall_lib3mf_model_getmultipropertygroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &multiPropertyGroupInstance)
	if ret != 0 {
		return MultiPropertyGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroup(multiPropertyGroupInstance), nil
}

// GetMeshObjectByID finds a mesh object by its UniqueResourceID.
func (inst Model) GetMeshObjectByID(uniqueResourceID uint32) (MeshObject, error) {
	var meshObjectInstance ref
	ret := C.CCall_lib3mf_model_getmeshobjectbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &meshObjectInstance)
	if ret != 0 {
		return MeshObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObject(meshObjectInstance), nil
}

// GetComponentsObjectByID finds a components object by its UniqueResourceID.
func (inst Model) GetComponentsObjectByID(uniqueResourceID uint32) (ComponentsObject, error) {
	var componentsObjectInstance ref
	ret := C.CCall_lib3mf_model_getcomponentsobjectbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &componentsObjectInstance)
	if ret != 0 {
		return ComponentsObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObject(componentsObjectInstance), nil
}

// GetColorGroupByID finds a model color group by its UniqueResourceID.
func (inst Model) GetColorGroupByID(uniqueResourceID uint32) (ColorGroup, error) {
	var colorGroupInstance ref
	ret := C.CCall_lib3mf_model_getcolorgroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &colorGroupInstance)
	if ret != 0 {
		return ColorGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroup(colorGroupInstance), nil
}

// GetSliceStackByID finds a model slicestack by its UniqueResourceID.
func (inst Model) GetSliceStackByID(uniqueResourceID uint32) (SliceStack, error) {
	var sliceStacInstance ref
	ret := C.CCall_lib3mf_model_getslicestackbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &sliceStacInstance)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(sliceStacInstance), nil
}

// GetBuildUUID returns, whether a build has a UUID and, if true, the build's UUID.
func (inst Model) GetBuildUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_model_getbuilduuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_model_getbuilduuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetBuildUUID sets the build's UUID.
func (inst Model) SetBuildUUID(uUID string) error {
	ret := C.CCall_lib3mf_model_setbuilduuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBuildItems creates a build item iterator instance with all build items.
func (inst Model) GetBuildItems() (BuildItemIterator, error) {
	var buildItemIterator ref
	ret := C.CCall_lib3mf_model_getbuilditems(inst.wrapperRef.LibraryHandle, inst.Ref, &buildItemIterator)
	if ret != 0 {
		return BuildItemIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItemIterator(buildItemIterator), nil
}

// GetOutbox returns the outbox of a Model.
func (inst Model) GetOutbox() (Box, error) {
	var outbox C.sLib3MFBox
	ret := C.CCall_lib3mf_model_getoutbox(inst.wrapperRef.LibraryHandle, inst.Ref, &outbox)
	if ret != 0 {
		return Box{}, makeError(uint32(ret))
	}
	return *(*Box)(unsafe.Pointer(&outbox)), nil
}

// GetResources creates a resource iterator instance with all resources.
func (inst Model) GetResources() (ResourceIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getresources(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ResourceIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceIterator(resourceIterator), nil
}

// GetObjects creates a resource iterator instance with all object resources.
func (inst Model) GetObjects() (ObjectIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getobjects(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ObjectIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObjectIterator(resourceIterator), nil
}

// GetMeshObjects creates a resource iterator instance with all mesh object resources.
func (inst Model) GetMeshObjects() (MeshObjectIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getmeshobjects(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return MeshObjectIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObjectIterator(resourceIterator), nil
}

// GetComponentsObjects creates a resource iterator instance with all components object resources.
func (inst Model) GetComponentsObjects() (ComponentsObjectIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getcomponentsobjects(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ComponentsObjectIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObjectIterator(resourceIterator), nil
}

// GetTexture2Ds creates a Texture2DIterator instance with all texture2d resources.
func (inst Model) GetTexture2Ds() (Texture2DIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_gettexture2ds(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return Texture2DIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DIterator(resourceIterator), nil
}

// GetBaseMaterialGroups creates a BaseMaterialGroupIterator instance with all base material resources.
func (inst Model) GetBaseMaterialGroups() (BaseMaterialGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getbasematerialgroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return BaseMaterialGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroupIterator(resourceIterator), nil
}

// GetColorGroups creates a ColorGroupIterator instance with all ColorGroup resources.
func (inst Model) GetColorGroups() (ColorGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getcolorgroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ColorGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroupIterator(resourceIterator), nil
}

// GetTexture2DGroups creates a Texture2DGroupIterator instance with all base material resources.
func (inst Model) GetTexture2DGroups() (Texture2DGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_gettexture2dgroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return Texture2DGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroupIterator(resourceIterator), nil
}

// GetCompositeMaterials creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
func (inst Model) GetCompositeMaterials() (CompositeMaterialsIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getcompositematerials(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return CompositeMaterialsIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterialsIterator(resourceIterator), nil
}

// GetMultiPropertyGroups creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
func (inst Model) GetMultiPropertyGroups() (MultiPropertyGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getmultipropertygroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return MultiPropertyGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroupIterator(resourceIterator), nil
}

// GetSliceStacks creates a resource iterator instance with all slice stack resources.
func (inst Model) GetSliceStacks() (SliceStackIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getslicestacks(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return SliceStackIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStackIterator(resourceIterator), nil
}

// MergeToModel merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
func (inst Model) MergeToModel() (Model, error) {
	var mergedModelInstance ref
	ret := C.CCall_lib3mf_model_mergetomodel(inst.wrapperRef.LibraryHandle, inst.Ref, &mergedModelInstance)
	if ret != 0 {
		return Model{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewModel(mergedModelInstance), nil
}

// AddMeshObject adds an empty mesh object to the model.
func (inst Model) AddMeshObject() (MeshObject, error) {
	var meshObjectInstance ref
	ret := C.CCall_lib3mf_model_addmeshobject(inst.wrapperRef.LibraryHandle, inst.Ref, &meshObjectInstance)
	if ret != 0 {
		return MeshObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObject(meshObjectInstance), nil
}

// AddComponentsObject adds an empty component object to the model.
func (inst Model) AddComponentsObject() (ComponentsObject, error) {
	var componentsObjectInstance ref
	ret := C.CCall_lib3mf_model_addcomponentsobject(inst.wrapperRef.LibraryHandle, inst.Ref, &componentsObjectInstance)
	if ret != 0 {
		return ComponentsObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObject(componentsObjectInstance), nil
}

// AddSliceStack creates a new model slicestack by its id.
func (inst Model) AddSliceStack(zBottom float64) (SliceStack, error) {
	var sliceStackInstance ref
	ret := C.CCall_lib3mf_model_addslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(zBottom), &sliceStackInstance)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(sliceStackInstance), nil
}

// AddTexture2DFromAttachment adds a texture2d resource to the model. Its path is given by that of an existing attachment.
func (inst Model) AddTexture2DFromAttachment(textureAttachment Attachment) (Texture2D, error) {
	var texture2DInstance ref
	ret := C.CCall_lib3mf_model_addtexture2dfromattachment(inst.wrapperRef.LibraryHandle, inst.Ref, textureAttachment.Ref, &texture2DInstance)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(texture2DInstance), nil
}

// AddBaseMaterialGroup adds an empty BaseMaterialGroup resource to the model.
func (inst Model) AddBaseMaterialGroup() (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_model_addbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// AddColorGroup adds an empty ColorGroup resource to the model.
func (inst Model) AddColorGroup() (ColorGroup, error) {
	var colorGroupInstance ref
	ret := C.CCall_lib3mf_model_addcolorgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &colorGroupInstance)
	if ret != 0 {
		return ColorGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroup(colorGroupInstance), nil
}

// AddTexture2DGroup adds an empty Texture2DGroup resource to the model.
func (inst Model) AddTexture2DGroup(texture2DInstance Texture2D) (Texture2DGroup, error) {
	var texture2DGroupInstance ref
	ret := C.CCall_lib3mf_model_addtexture2dgroup(inst.wrapperRef.LibraryHandle, inst.Ref, texture2DInstance.Ref, &texture2DGroupInstance)
	if ret != 0 {
		return Texture2DGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroup(texture2DGroupInstance), nil
}

// AddCompositeMaterials adds an empty CompositeMaterials resource to the model.
func (inst Model) AddCompositeMaterials(baseMaterialGroupInstance BaseMaterialGroup) (CompositeMaterials, error) {
	var compositeMaterialsInstance ref
	ret := C.CCall_lib3mf_model_addcompositematerials(inst.wrapperRef.LibraryHandle, inst.Ref, baseMaterialGroupInstance.Ref, &compositeMaterialsInstance)
	if ret != 0 {
		return CompositeMaterials{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterials(compositeMaterialsInstance), nil
}

// AddMultiPropertyGroup adds an empty MultiPropertyGroup resource to the model.
func (inst Model) AddMultiPropertyGroup() (MultiPropertyGroup, error) {
	var multiPropertyGroupInstance ref
	ret := C.CCall_lib3mf_model_addmultipropertygroup(inst.wrapperRef.LibraryHandle, inst.Ref, &multiPropertyGroupInstance)
	if ret != 0 {
		return MultiPropertyGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroup(multiPropertyGroupInstance), nil
}

// AddBuildItem adds a build item to the model.
func (inst Model) AddBuildItem(object Object, transform Transform) (BuildItem, error) {
	var buildItemInstance ref
	ret := C.CCall_lib3mf_model_addbuilditem(inst.wrapperRef.LibraryHandle, inst.Ref, object.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)), &buildItemInstance)
	if ret != 0 {
		return BuildItem{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItem(buildItemInstance), nil
}

// RemoveBuildItem removes a build item from the model.
func (inst Model) RemoveBuildItem(buildItemInstance BuildItem) error {
	ret := C.CCall_lib3mf_model_removebuilditem(inst.wrapperRef.LibraryHandle, inst.Ref, buildItemInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMetaDataGroup returns the metadata of the model as MetaDataGroup.
func (inst Model) GetMetaDataGroup() (MetaDataGroup, error) {
	var theMetaDataGroup ref
	ret := C.CCall_lib3mf_model_getmetadatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &theMetaDataGroup)
	if ret != 0 {
		return MetaDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaDataGroup(theMetaDataGroup), nil
}

// AddAttachment adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
func (inst Model) AddAttachment(uRI string, relationShipType string) (Attachment, error) {
	var attachmentInstance ref
	ret := C.CCall_lib3mf_model_addattachment(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uRI)[0])), (*C.char)(unsafe.Pointer(&[]byte(relationShipType)[0])), &attachmentInstance)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachmentInstance), nil
}

// RemoveAttachment removes attachment from the model.
func (inst Model) RemoveAttachment(attachmentInstance Attachment) error {
	ret := C.CCall_lib3mf_model_removeattachment(inst.wrapperRef.LibraryHandle, inst.Ref, attachmentInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetAttachment retrieves an attachment stream object from the model..
func (inst Model) GetAttachment(index uint32) (Attachment, error) {
	var attachmentInstance ref
	ret := C.CCall_lib3mf_model_getattachment(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &attachmentInstance)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachmentInstance), nil
}

// FindAttachment retrieves an attachment stream object from the model.
func (inst Model) FindAttachment(uRI string) (Attachment, error) {
	var attachmentInstance ref
	ret := C.CCall_lib3mf_model_findattachment(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uRI)[0])), &attachmentInstance)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachmentInstance), nil
}

// GetAttachmentCount retrieves the number of attachments of the model.
func (inst Model) GetAttachmentCount() (uint32, error) {
	var attachmentCount C.uint32_t
	ret := C.CCall_lib3mf_model_getattachmentcount(inst.wrapperRef.LibraryHandle, inst.Ref, &attachmentCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(attachmentCount), nil
}

// HasPackageThumbnailAttachment retrieve whether the OPC package contains a package thumbnail.
func (inst Model) HasPackageThumbnailAttachment() (bool, error) {
	var hasThumbnail C.bool
	ret := C.CCall_lib3mf_model_haspackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &hasThumbnail)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasThumbnail), nil
}

// CreatePackageThumbnailAttachment create a new or the existing package thumbnail for the OPC package.
func (inst Model) CreatePackageThumbnailAttachment() (Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_model_createpackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachment), nil
}

// GetPackageThumbnailAttachment get the attachment to the OPC package containing the package thumbnail.
func (inst Model) GetPackageThumbnailAttachment() (*Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_model_getpackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _attachmentPtr *Attachment
	if attachment != nil {
		_attachmentPtrVal := inst.wrapperRef.NewAttachment(attachment)
		_attachmentPtr = &_attachmentPtrVal
	}
	return _attachmentPtr, nil
}

// RemovePackageThumbnailAttachment remove the attachment to the OPC package containing the package thumbnail.
func (inst Model) RemovePackageThumbnailAttachment() error {
	ret := C.CCall_lib3mf_model_removepackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddCustomContentType adds a new Content Type to the model.
func (inst Model) AddCustomContentType(extension string, contentType string) error {
	ret := C.CCall_lib3mf_model_addcustomcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(extension)[0])), (*C.char)(unsafe.Pointer(&[]byte(contentType)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveCustomContentType removes a custom Content Type from the model (UTF8 version).
func (inst Model) RemoveCustomContentType(extension string) error {
	ret := C.CCall_lib3mf_model_removecustomcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(extension)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetRandomNumberCallback sets the random number generator callback for use in the library.
func (inst Model) SetRandomNumberCallback(theCallback RandomNumberCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_model_setrandomnumbercallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFRandomNumberCallback)(unsafe.Pointer(C.Lib3MFRandomNumberCallback_cgo)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	randomNumberCallbackFunc = theCallback
	return nil
}

// GetKeyStore gets the keystore associated with this model.
func (inst Model) GetKeyStore() (KeyStore, error) {
	var keyStore ref
	ret := C.CCall_lib3mf_model_getkeystore(inst.wrapperRef.LibraryHandle, inst.Ref, &keyStore)
	if ret != 0 {
		return KeyStore{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewKeyStore(keyStore), nil
}


// GetLibraryVersion retrieves the binary version of this library.
func (wrapper Wrapper) GetLibraryVersion() (uint32, uint32, uint32, error) {
	var major C.uint32_t
	var minor C.uint32_t
	var micro C.uint32_t
	ret := C.CCall_lib3mf_getlibraryversion(wrapper.LibraryHandle, &major, &minor, &micro)
	if ret != 0 {
		return 0, 0, 0, makeError(uint32(ret))
	}
	return uint32(major), uint32(minor), uint32(micro), nil
}

// GetPrereleaseInformation retrieves prerelease information of this library.
func (wrapper Wrapper) GetPrereleaseInformation() (bool, string, error) {
	var hasPrereleaseInfo C.bool
	var neededforprereleaseInfo C.uint32_t
	var filledinprereleaseInfo C.uint32_t
	ret := C.CCall_lib3mf_getprereleaseinformation(wrapper.LibraryHandle, &hasPrereleaseInfo, 0, &neededforprereleaseInfo, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeprereleaseInfo := neededforprereleaseInfo
	bufferprereleaseInfo := make([]byte, bufferSizeprereleaseInfo)
	ret = C.CCall_lib3mf_getprereleaseinformation(wrapper.LibraryHandle, &hasPrereleaseInfo, bufferSizeprereleaseInfo, &filledinprereleaseInfo, (*C.char)(unsafe.Pointer(&bufferprereleaseInfo[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasPrereleaseInfo), string(bufferprereleaseInfo[:(filledinprereleaseInfo-1)]), nil
}

// GetBuildInformation retrieves build information of this library.
func (wrapper Wrapper) GetBuildInformation() (bool, string, error) {
	var hasBuildInfo C.bool
	var neededforbuildInformation C.uint32_t
	var filledinbuildInformation C.uint32_t
	ret := C.CCall_lib3mf_getbuildinformation(wrapper.LibraryHandle, &hasBuildInfo, 0, &neededforbuildInformation, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizebuildInformation := neededforbuildInformation
	bufferbuildInformation := make([]byte, bufferSizebuildInformation)
	ret = C.CCall_lib3mf_getbuildinformation(wrapper.LibraryHandle, &hasBuildInfo, bufferSizebuildInformation, &filledinbuildInformation, (*C.char)(unsafe.Pointer(&bufferbuildInformation[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasBuildInfo), string(bufferbuildInformation[:(filledinbuildInformation-1)]), nil
}

// GetSpecificationVersion retrieves whether a specification is supported, and if so, which version.
func (wrapper Wrapper) GetSpecificationVersion(specificationURL string) (bool, uint32, uint32, uint32, error) {
	var isSupported C.bool
	var major C.uint32_t
	var minor C.uint32_t
	var micro C.uint32_t
	ret := C.CCall_lib3mf_getspecificationversion(wrapper.LibraryHandle, (*C.char)(unsafe.Pointer(&[]byte(specificationURL)[0])), &isSupported, &major, &minor, &micro)
	if ret != 0 {
		return false, 0, 0, 0, makeError(uint32(ret))
	}
	return bool(isSupported), uint32(major), uint32(minor), uint32(micro), nil
}

// CreateModel creates an empty model instance.
func (wrapper Wrapper) CreateModel() (Model, error) {
	var model ref
	ret := C.CCall_lib3mf_createmodel(wrapper.LibraryHandle, &model)
	if ret != 0 {
		return Model{}, makeError(uint32(ret))
	}
	return wrapper.NewModel(model), nil
}

// Release releases shared ownership of an object instance.
func (wrapper Wrapper) Release(instance Base) error {
	ret := C.CCall_lib3mf_release(wrapper.LibraryHandle, instance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// Acquire acquires shared ownership of an object instance.
func (wrapper Wrapper) Acquire(instance Base) error {
	ret := C.CCall_lib3mf_acquire(wrapper.LibraryHandle, instance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetJournal sets the journal file path.
func (wrapper Wrapper) SetJournal(journalPath string) error {
	ret := C.CCall_lib3mf_setjournal(wrapper.LibraryHandle, (*C.char)(unsafe.Pointer(&[]byte(journalPath)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetLastError retrieves the last error string of an instance.
func (wrapper Wrapper) GetLastError(instance Base) (string, bool, error) {
	var neededforlastErrorString C.uint32_t
	var filledinlastErrorString C.uint32_t
	var hasLastError C.bool
	ret := C.CCall_lib3mf_getlasterror(wrapper.LibraryHandle, instance.Ref, 0, &neededforlastErrorString, nil, &hasLastError)
	if ret != 0 {
		return "", false, makeError(uint32(ret))
	}
	bufferSizelastErrorString := neededforlastErrorString
	bufferlastErrorString := make([]byte, bufferSizelastErrorString)
	ret = C.CCall_lib3mf_getlasterror(wrapper.LibraryHandle, instance.Ref, bufferSizelastErrorString, &filledinlastErrorString, (*C.char)(unsafe.Pointer(&bufferlastErrorString[0])), &hasLastError)
	if ret != 0 {
		return "", false, makeError(uint32(ret))
	}
	return string(bufferlastErrorString[:(filledinlastErrorString-1)]), bool(hasLastError), nil
}

// GetSymbolLookupMethod returns the address of the SymbolLookupMethod.
func (wrapper Wrapper) GetSymbolLookupMethod() (uintptr, error) {
	var symbolLookupMethod C.Lib3MF_pvoid
	ret := C.CCall_lib3mf_getsymbollookupmethod(wrapper.LibraryHandle, &symbolLookupMethod)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uintptr(symbolLookupMethod), nil
}

// RetrieveProgressMessage return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
func (wrapper Wrapper) RetrieveProgressMessage(theProgressIdentifier ProgressIdentifier) (string, error) {
	var neededforprogressMessage C.uint32_t
	var filledinprogressMessage C.uint32_t
	ret := C.CCall_lib3mf_retrieveprogressmessage(wrapper.LibraryHandle, C.eLib3MFProgressIdentifier(theProgressIdentifier), 0, &neededforprogressMessage, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeprogressMessage := neededforprogressMessage
	bufferprogressMessage := make([]byte, bufferSizeprogressMessage)
	ret = C.CCall_lib3mf_retrieveprogressmessage(wrapper.LibraryHandle, C.eLib3MFProgressIdentifier(theProgressIdentifier), bufferSizeprogressMessage, &filledinprogressMessage, (*C.char)(unsafe.Pointer(&bufferprogressMessage[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferprogressMessage[:(filledinprogressMessage-1)]), nil
}

// RGBAToColor creates a Color from uint8 RGBA values.
func (wrapper Wrapper) RGBAToColor(red uint8, green uint8, blue uint8, alpha uint8) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_rgbatocolor(wrapper.LibraryHandle, C.uint8_t(red), C.uint8_t(green), C.uint8_t(blue), C.uint8_t(alpha), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}

// FloatRGBAToColor creates a Color from uint8 RGBA values.
func (wrapper Wrapper) FloatRGBAToColor(red float32, green float32, blue float32, alpha float32) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_floatrgbatocolor(wrapper.LibraryHandle, C.float(red), C.float(green), C.float(blue), C.float(alpha), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}

// ColorToRGBA calculates uint8-RGBA-values from a Color.
func (wrapper Wrapper) ColorToRGBA(theColor Color) (uint8, uint8, uint8, uint8, error) {
	var red C.uint8_t
	var green C.uint8_t
	var blue C.uint8_t
	var alpha C.uint8_t
	ret := C.CCall_lib3mf_colortorgba(wrapper.LibraryHandle, (*C.sLib3MFColor)(unsafe.Pointer(&theColor)), &red, &green, &blue, &alpha)
	if ret != 0 {
		return 0, 0, 0, 0, makeError(uint32(ret))
	}
	return uint8(red), uint8(green), uint8(blue), uint8(alpha), nil
}

// ColorToFloatRGBA calculates float-RGBA-values from a Color.
func (wrapper Wrapper) ColorToFloatRGBA(theColor Color) (float32, float32, float32, float32, error) {
	var red C.float
	var green C.float
	var blue C.float
	var alpha C.float
	ret := C.CCall_lib3mf_colortofloatrgba(wrapper.LibraryHandle, (*C.sLib3MFColor)(unsafe.Pointer(&theColor)), &red, &green, &blue, &alpha)
	if ret != 0 {
		return 0, 0, 0, 0, makeError(uint32(ret))
	}
	return float32(red), float32(green), float32(blue), float32(alpha), nil
}

// GetIdentityTransform creates an identity transform.
func (wrapper Wrapper) GetIdentityTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_getidentitytransform(wrapper.LibraryHandle, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// GetUniformScaleTransform creates a uniform scale transform.
func (wrapper Wrapper) GetUniformScaleTransform(factor float32) (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_getuniformscaletransform(wrapper.LibraryHandle, C.float(factor), &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// GetScaleTransform creates a scale transform.
func (wrapper Wrapper) GetScaleTransform(factorX float32, factorY float32, factorZ float32) (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_getscaletransform(wrapper.LibraryHandle, C.float(factorX), C.float(factorY), C.float(factorZ), &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// GetTranslationTransform creates an translation transform.
func (wrapper Wrapper) GetTranslationTransform(vectorX float32, vectorY float32, vectorZ float32) (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_gettranslationtransform(wrapper.LibraryHandle, C.float(vectorX), C.float(vectorY), C.float(vectorZ), &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

func (wrapper Wrapper) releaseC(r *ref) error {
	if r == nil || *r == nil {
		return nil
	}
	return wrapper.Release(Base{Ref: *r})
}

func (wrapper Wrapper) CheckBinaryVersion() error {
	var nBindingMajor uint32 = 2;
	var nBindingMinor uint32 = 3;
	nMajor, nMinor, _, err := wrapper.GetLibraryVersion()
	if err != nil {
		return err;
	}
	if (nMajor != nBindingMajor) || (nMinor < nBindingMinor) {
		return makeError(0)
	}
	return nil
}

func LoadLibrary (libraryPath string) (Wrapper, error) {
	var wrapper Wrapper;
	wrapper.LibraryHandle = C.loadLib3MFLibrary (C.CString (libraryPath));
	if (wrapper.LibraryHandle == nil) {
		return wrapper, makeError (LIB3MF_ERROR_COULDNOTLOADLIBRARY)
	}
	
	return wrapper, nil
	
}
