/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.ApplicationDescriptor;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.ApplicationTypeFactory;
import org.graalvm.visualvm.application.type.DefaultApplicationType;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public class JmxApplicationDescriptor
extends ApplicationDescriptor {
    private static final Image NODE_BADGE = ImageUtilities.loadImage((String)"org/graalvm/visualvm/jmx/resources/jmxBadge.png", (boolean)true);

    protected JmxApplicationDescriptor(JmxApplication application) {
        super((Application)application, JmxApplicationDescriptor.resolveApplicationType(application), JmxApplicationDescriptor.resolvePosition((DataSource)application, (int)0x7FFFFFFE, (boolean)true));
        application.addPropertyChangeListener("prop_state", WeakListeners.propertyChange((PropertyChangeListener)((Object)this), (String)"prop_state", (Object)((Object)application)));
    }

    public boolean supportsRename() {
        return true;
    }

    protected void setIcon(Image newIcon) {
        super.setIcon(newIcon);
        String iconString = Utils.imageToString((Image)newIcon, (String)"png");
        ((Application)this.getDataSource()).getStorage().setCustomProperties(new String[]{"prop_icon"}, new String[]{iconString});
    }

    public Image getIcon() {
        Image originalIcon = super.getIcon();
        return originalIcon == null ? null : ImageUtilities.mergeImages((Image)originalIcon, (Image)NODE_BADGE, (int)0, (int)0);
    }

    private static ApplicationType resolveApplicationType(JmxApplication application) {
        return application.getState() == 1 ? ApplicationTypeFactory.getApplicationTypeFor((Application)application) : new DisconnectedJmxApplicationType(application);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("prop_state".equals(evt.getPropertyName()) && Objects.equals(evt.getNewValue(), 1)) {
            final Application application = (Application)this.getDataSource();
            DataSource.EVENT_QUEUE.post(new Runnable(){

                @Override
                public void run() {
                    ApplicationType type = ApplicationTypeFactory.getApplicationTypeFor((Application)application);
                    JmxApplicationDescriptor.this.setApplicationType(type);
                    String customName = application.getStorage().getCustomProperty("prop_name");
                    if (customName != null) {
                        JmxApplicationDescriptor.this.setName(customName);
                    } else {
                        customName = JmxApplicationDescriptor.resolveCustomName((Application)application);
                        if (customName != null) {
                            JmxApplicationDescriptor.this.setImplicitName(customName, null);
                        } else {
                            JmxApplicationDescriptor.this.setImplicitName(JmxApplicationDescriptor.createGenericName((Application)application, (String)type.getName()), "prop_suggested_name");
                        }
                    }
                    JmxApplicationDescriptor.this.setDescription(type.getDescription());
                    JmxApplicationDescriptor.this.setIcon(type.getIcon());
                }
            }, 500);
        }
    }

    private static final class DisconnectedJmxApplicationType
    extends DefaultApplicationType {
        DisconnectedJmxApplicationType(JmxApplication application) {
            super((Application)application);
        }

        public String getDescription() {
            return "Unavailable application defined by a JMX connection.";
        }
    }
}

