/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;

public final class MinClusterVersionUtil {
    private static final Version MINIMAL_SUPPORTED_VERSION_DEFAULT_MODEL_ID = Version.V_2_11_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH = Version.V_2_14_0;
    private static final Map<String, Version> MINIMAL_VERSION_NEURAL = ImmutableMap.builder().put((Object)NeuralQueryBuilder.MODEL_ID_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_DEFAULT_MODEL_ID).put((Object)KNNQueryBuilder.MAX_DISTANCE_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH).put((Object)KNNQueryBuilder.MIN_SCORE_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH).build();

    public static boolean isClusterOnOrAfterMinReqVersionForDefaultModelIdSupport() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_DEFAULT_MODEL_ID);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForRadialSearch() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH);
    }

    public static boolean isClusterOnOrAfterMinReqVersion(String key) {
        Version version = MINIMAL_VERSION_NEURAL.containsKey(key) ? MINIMAL_VERSION_NEURAL.get(key) : (Version)IndexUtil.minimalRequiredVersionMap.get(key);
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(version);
    }
}

