/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class AddClassExpressionClosureAxiom
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public AddClassExpressionClosureAxiom(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLClass cls, @Nonnull OWLObjectPropertyExpression property, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLOntology targetOntology) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null"), OWLAPIPreconditions.checkNotNull(property, "property cannot be null"), OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"), OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"));
    }

    private void generateChanges(@Nonnull OWLClass cls, @Nonnull OWLObjectPropertyExpression property, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLOntology targetOntology) {
        FillerCollector collector = new FillerCollector(property);
        for (OWLOntology ont : ontologies) {
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(cls)) {
                ax.getSuperClass().accept(collector);
            }
        }
        Set<OWLClassExpression> fillers = collector.getFillers();
        if (fillers.isEmpty()) {
            return;
        }
        OWLObjectUnionOf closureAxiomFiller = this.getDataFactory().getOWLObjectUnionOf(fillers);
        OWLObjectAllValuesFrom closureAxiomDesc = this.getDataFactory().getOWLObjectAllValuesFrom(property, closureAxiomFiller);
        this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLSubClassOfAxiom(cls, closureAxiomDesc)));
    }

    private class FillerCollector
    extends OWLClassExpressionVisitorAdapter {
        @Nonnull
        private final Set<OWLClassExpression> fillers = new HashSet<OWLClassExpression>();
        @Nonnull
        private final OWLObjectPropertyExpression property;

        FillerCollector(OWLObjectPropertyExpression p) {
            this.property = OWLAPIPreconditions.checkNotNull(p, "p cannot be null");
        }

        @Nonnull
        public Set<OWLClassExpression> getFillers() {
            return this.fillers;
        }

        @Override
        public void visit(@Nonnull OWLObjectSomeValuesFrom ce) {
            if (ce.getProperty().equals(this.property)) {
                this.fillers.add((OWLClassExpression)ce.getFiller());
            }
        }

        @Override
        public void visit(@Nonnull OWLObjectHasValue ce) {
            if (ce.getProperty().equals(this.property)) {
                this.fillers.add(AddClassExpressionClosureAxiom.this.getDataFactory().getOWLObjectOneOf(CollectionFactory.createSet(ce.getFiller())));
            }
        }
    }
}

