'''OpenGL extension VERSION.GL_4_5

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_4_5 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_4_5.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_4_5 import *
from OpenGL.raw.GL.VERSION.GL_4_5 import _EXTENSION_NAME

def glInitGl45VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glCreateTransformFeedbacks.ids size not checked against n
glCreateTransformFeedbacks=wrapper.wrapper(glCreateTransformFeedbacks).setInputArraySize(
    'ids', None
)
# INPUT glCreateBuffers.buffers size not checked against n
glCreateBuffers=wrapper.wrapper(glCreateBuffers).setInputArraySize(
    'buffers', None
)
# INPUT glNamedBufferStorage.data size not checked against size
glNamedBufferStorage=wrapper.wrapper(glNamedBufferStorage).setInputArraySize(
    'data', None
)
# INPUT glNamedBufferSubData.data size not checked against 'size'
glNamedBufferSubData=wrapper.wrapper(glNamedBufferSubData).setInputArraySize(
    'data', None
)
# INPUT glCreateFramebuffers.framebuffers size not checked against n
glCreateFramebuffers=wrapper.wrapper(glCreateFramebuffers).setInputArraySize(
    'framebuffers', None
)
# INPUT glCreateRenderbuffers.renderbuffers size not checked against n
glCreateRenderbuffers=wrapper.wrapper(glCreateRenderbuffers).setInputArraySize(
    'renderbuffers', None
)
# INPUT glCreateTextures.textures size not checked against n
glCreateTextures=wrapper.wrapper(glCreateTextures).setInputArraySize(
    'textures', None
)
# INPUT glCreateVertexArrays.arrays size not checked against n
glCreateVertexArrays=wrapper.wrapper(glCreateVertexArrays).setInputArraySize(
    'arrays', None
)
# INPUT glCreateSamplers.samplers size not checked against n
glCreateSamplers=wrapper.wrapper(glCreateSamplers).setInputArraySize(
    'samplers', None
)
# INPUT glCreateProgramPipelines.pipelines size not checked against n
glCreateProgramPipelines=wrapper.wrapper(glCreateProgramPipelines).setInputArraySize(
    'pipelines', None
)
# INPUT glCreateQueries.ids size not checked against n
glCreateQueries=wrapper.wrapper(glCreateQueries).setInputArraySize(
    'ids', None
)
# INPUT glGetnTexImage.pixels size not checked against bufSize
glGetnTexImage=wrapper.wrapper(glGetnTexImage).setInputArraySize(
    'pixels', None
)
# INPUT glGetnUniformdv.params size not checked against bufSize
glGetnUniformdv=wrapper.wrapper(glGetnUniformdv).setInputArraySize(
    'params', None
)
# INPUT glGetnUniformfv.params size not checked against bufSize
glGetnUniformfv=wrapper.wrapper(glGetnUniformfv).setInputArraySize(
    'params', None
)
# INPUT glGetnUniformiv.params size not checked against bufSize
glGetnUniformiv=wrapper.wrapper(glGetnUniformiv).setInputArraySize(
    'params', None
)
# INPUT glGetnUniformuiv.params size not checked against bufSize
glGetnUniformuiv=wrapper.wrapper(glGetnUniformuiv).setInputArraySize(
    'params', None
)
# INPUT glReadnPixels.data size not checked against bufSize
glReadnPixels=wrapper.wrapper(glReadnPixels).setInputArraySize(
    'data', None
)
### END AUTOGENERATED SECTION
