/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.http.ResponseUtil;
import org.apache.tomcat.util.http.parser.MediaType;
import org.apache.tomcat.util.res.StringManager;

public class CorsFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    private static final StringManager sm = StringManager.getManager(CorsFilter.class);
    private transient Log log = LogFactory.getLog(CorsFilter.class);
    private final Collection<String> allowedOrigins = new HashSet<String>();
    private boolean anyOriginAllowed;
    private final Collection<String> allowedHttpMethods = new HashSet<String>();
    private final Collection<String> allowedHttpHeaders = new HashSet<String>();
    private final Collection<String> exposedHeaders = new HashSet<String>();
    private boolean supportsCredentials;
    private long preflightMaxAge;
    private boolean decorateRequest;
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String REQUEST_HEADER_ORIGIN = "Origin";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String HTTP_REQUEST_ATTRIBUTE_PREFIX = "cors.";
    public static final String HTTP_REQUEST_ATTRIBUTE_ORIGIN = "cors.request.origin";
    public static final String HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST = "cors.isCorsRequest";
    public static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE = "cors.request.type";
    public static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS = "cors.request.headers";
    public static final Collection<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain")));
    public static final String DEFAULT_ALLOWED_ORIGINS = "";
    public static final String DEFAULT_ALLOWED_HTTP_METHODS = "GET,POST,HEAD,OPTIONS";
    public static final String DEFAULT_PREFLIGHT_MAXAGE = "1800";
    public static final String DEFAULT_SUPPORTS_CREDENTIALS = "false";
    public static final String DEFAULT_ALLOWED_HTTP_HEADERS = "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers";
    public static final String DEFAULT_EXPOSED_HEADERS = "";
    public static final String DEFAULT_DECORATE_REQUEST = "true";
    public static final String PARAM_CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    public static final String PARAM_CORS_SUPPORT_CREDENTIALS = "cors.support.credentials";
    public static final String PARAM_CORS_EXPOSED_HEADERS = "cors.exposed.headers";
    public static final String PARAM_CORS_ALLOWED_HEADERS = "cors.allowed.headers";
    public static final String PARAM_CORS_ALLOWED_METHODS = "cors.allowed.methods";
    public static final String PARAM_CORS_PREFLIGHT_MAXAGE = "cors.preflight.maxage";
    public static final String PARAM_CORS_REQUEST_DECORATE = "cors.request.decorate";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException(sm.getString("corsFilter.onlyHttp"));
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        CORSRequestType cORSRequestType = this.checkRequestType(httpServletRequest);
        if (this.isDecorateRequest()) {
            CorsFilter.decorateCORSProperties(httpServletRequest, cORSRequestType);
        }
        switch (cORSRequestType) {
            case SIMPLE: 
            case ACTUAL: {
                this.handleSimpleCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            case PRE_FLIGHT: {
                this.handlePreflightCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            case NOT_CORS: {
                this.handleNonCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            default: {
                this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
            }
        }
    }

    public void init() throws ServletException {
        this.parseAndStore(this.getInitParameter(PARAM_CORS_ALLOWED_ORIGINS, ""), this.getInitParameter(PARAM_CORS_ALLOWED_METHODS, DEFAULT_ALLOWED_HTTP_METHODS), this.getInitParameter(PARAM_CORS_ALLOWED_HEADERS, DEFAULT_ALLOWED_HTTP_HEADERS), this.getInitParameter(PARAM_CORS_EXPOSED_HEADERS, ""), this.getInitParameter(PARAM_CORS_SUPPORT_CREDENTIALS, DEFAULT_SUPPORTS_CREDENTIALS), this.getInitParameter(PARAM_CORS_PREFLIGHT_MAXAGE, DEFAULT_PREFLIGHT_MAXAGE), this.getInitParameter(PARAM_CORS_REQUEST_DECORATE, DEFAULT_DECORATE_REQUEST));
    }

    private String getInitParameter(String string, String string2) {
        String string3 = this.getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    protected void handleSimpleCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType cORSRequestType = this.checkRequestType(httpServletRequest);
        if (cORSRequestType != CORSRequestType.SIMPLE && cORSRequestType != CORSRequestType.ACTUAL) {
            throw new IllegalArgumentException(sm.getString("corsFilter.wrongType2", new Object[]{CORSRequestType.SIMPLE, CORSRequestType.ACTUAL}));
        }
        String string = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        String string2 = httpServletRequest.getMethod();
        if (!this.isOriginAllowed(string)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        if (!this.getAllowedHttpMethods().contains(string2)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        this.addStandardHeaders(httpServletRequest, httpServletResponse);
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected void handlePreflightCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType cORSRequestType = this.checkRequestType(httpServletRequest);
        if (cORSRequestType != CORSRequestType.PRE_FLIGHT) {
            throw new IllegalArgumentException(sm.getString("corsFilter.wrongType1", new Object[]{CORSRequestType.PRE_FLIGHT.name().toLowerCase(Locale.ENGLISH)}));
        }
        String string = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        if (!this.isOriginAllowed(string)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String string2 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (string2 == null) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        string2 = string2.trim();
        String string3 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string3 != null && !string3.trim().isEmpty()) {
            String[] stringArray = string3.trim().split(",");
            for (String string4 : stringArray) {
                arrayList.add(string4.trim().toLowerCase(Locale.ENGLISH));
            }
        }
        if (!this.getAllowedHttpMethods().contains(string2)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        if (!arrayList.isEmpty()) {
            for (String string5 : arrayList) {
                if (this.getAllowedHttpHeaders().contains(string5)) continue;
                this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain);
                return;
            }
        }
        this.addStandardHeaders(httpServletRequest, httpServletResponse);
    }

    private void handleNonCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isAnyOriginAllowed()) {
            ResponseUtil.addVaryFieldName((HttpServletResponse)httpServletResponse, (String)REQUEST_HEADER_ORIGIN);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void handleInvalidCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) {
        String string = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        String string2 = httpServletRequest.getMethod();
        String string3 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setStatus(403);
        httpServletResponse.resetBuffer();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("corsFilter.invalidRequest", new Object[]{string, string2, string3}));
        }
    }

    private void addStandardHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Collection<String> collection;
        String string = httpServletRequest.getMethod();
        String string2 = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        boolean bl = this.isAnyOriginAllowed();
        if (!bl) {
            ResponseUtil.addVaryFieldName((HttpServletResponse)httpServletResponse, (String)REQUEST_HEADER_ORIGIN);
        }
        if (bl) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, string2);
        }
        if (this.isSupportsCredentials()) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, DEFAULT_DECORATE_REQUEST);
        }
        if ((collection = this.getExposedHeaders()) != null && collection.size() > 0) {
            String string3 = CorsFilter.join(collection, ",");
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS, string3);
        }
        if ("OPTIONS".equals(string)) {
            Collection<String> collection2;
            Collection<String> collection3;
            ResponseUtil.addVaryFieldName((HttpServletResponse)httpServletResponse, (String)REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
            ResponseUtil.addVaryFieldName((HttpServletResponse)httpServletResponse, (String)REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
            long l = this.getPreflightMaxAge();
            if (l > 0L) {
                httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE, String.valueOf(l));
            }
            if ((collection3 = this.getAllowedHttpMethods()) != null && !collection3.isEmpty()) {
                httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS, CorsFilter.join(collection3, ","));
            }
            if ((collection2 = this.getAllowedHttpHeaders()) != null && !collection2.isEmpty()) {
                httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, CorsFilter.join(collection2, ","));
            }
        }
    }

    protected static void decorateCORSProperties(HttpServletRequest httpServletRequest, CORSRequestType cORSRequestType) {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException(sm.getString("corsFilter.nullRequest"));
        }
        if (cORSRequestType == null) {
            throw new IllegalArgumentException(sm.getString("corsFilter.nullRequestType"));
        }
        switch (cORSRequestType) {
            case SIMPLE: 
            case ACTUAL: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN));
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)cORSRequestType.name().toLowerCase(Locale.ENGLISH));
                break;
            }
            case PRE_FLIGHT: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN));
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)cORSRequestType.name().toLowerCase(Locale.ENGLISH));
                String string = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
                if (string == null) {
                    string = "";
                }
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS, (Object)string);
                break;
            }
            case NOT_CORS: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.FALSE);
                break;
            }
        }
    }

    protected static String join(Collection<String> collection, String string) {
        String string2 = ",";
        if (collection == null) {
            return null;
        }
        if (string != null) {
            string2 = string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string3 : collection) {
            if (!bl) {
                stringBuilder.append(string2);
            } else {
                bl = false;
            }
            if (string3 == null) continue;
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    protected CORSRequestType checkRequestType(HttpServletRequest httpServletRequest) {
        CORSRequestType cORSRequestType = CORSRequestType.INVALID_CORS;
        if (httpServletRequest == null) {
            throw new IllegalArgumentException(sm.getString("corsFilter.nullRequest"));
        }
        String string = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        if (string != null) {
            if (string.isEmpty()) {
                cORSRequestType = CORSRequestType.INVALID_CORS;
            } else if (!RequestUtil.isValidOrigin((String)string)) {
                cORSRequestType = CORSRequestType.INVALID_CORS;
            } else {
                if (RequestUtil.isSameOrigin((HttpServletRequest)httpServletRequest, (String)string)) {
                    return CORSRequestType.NOT_CORS;
                }
                String string2 = httpServletRequest.getMethod();
                if (string2 != null) {
                    String string3;
                    String string4;
                    cORSRequestType = "OPTIONS".equals(string2) ? ((string4 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD)) != null && !string4.isEmpty() ? CORSRequestType.PRE_FLIGHT : (string4 != null && string4.isEmpty() ? CORSRequestType.INVALID_CORS : CORSRequestType.ACTUAL)) : ("GET".equals(string2) || "HEAD".equals(string2) ? CORSRequestType.SIMPLE : ("POST".equals(string2) ? ((string3 = MediaType.parseMediaTypeOnly((String)httpServletRequest.getContentType())) == null ? CORSRequestType.SIMPLE : (SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(string3) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL)) : CORSRequestType.ACTUAL));
                }
            }
        } else {
            cORSRequestType = CORSRequestType.NOT_CORS;
        }
        return cORSRequestType;
    }

    private boolean isOriginAllowed(String string) {
        if (this.isAnyOriginAllowed()) {
            return true;
        }
        return this.getAllowedOrigins().contains(string);
    }

    private void parseAndStore(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws ServletException {
        Set<String> set;
        if (string.trim().equals("*")) {
            this.anyOriginAllowed = true;
        } else {
            this.anyOriginAllowed = false;
            set = this.parseStringToSet(string);
            this.allowedOrigins.clear();
            this.allowedOrigins.addAll(set);
        }
        set = this.parseStringToSet(string2);
        this.allowedHttpMethods.clear();
        this.allowedHttpMethods.addAll(set);
        Set<String> set2 = this.parseStringToSet(string3);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string8 : set2) {
            String string9 = string8.toLowerCase(Locale.ENGLISH);
            hashSet.add(string9);
        }
        this.allowedHttpHeaders.clear();
        this.allowedHttpHeaders.addAll(hashSet);
        Set<String> set3 = this.parseStringToSet(string4);
        this.exposedHeaders.clear();
        this.exposedHeaders.addAll((Collection<String>)set3);
        this.supportsCredentials = Boolean.parseBoolean(string5);
        if (this.supportsCredentials && this.anyOriginAllowed) {
            throw new ServletException(sm.getString("corsFilter.invalidSupportsCredentials"));
        }
        try {
            this.preflightMaxAge = !string6.isEmpty() ? Long.parseLong(string6) : 0L;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException(sm.getString("corsFilter.invalidPreflightMaxAge"), (Throwable)numberFormatException);
        }
        this.decorateRequest = Boolean.parseBoolean(string7);
    }

    private Set<String> parseStringToSet(String string) {
        String[] stringArray = string != null && string.length() > 0 ? string.split(",") : new String[]{};
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray.length > 0) {
            for (String string2 : stringArray) {
                hashSet.add(string2.trim());
            }
        }
        return hashSet;
    }

    public boolean isAnyOriginAllowed() {
        return this.anyOriginAllowed;
    }

    public Collection<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public boolean isSupportsCredentials() {
        return this.supportsCredentials;
    }

    public long getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public Collection<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public Collection<String> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public Collection<String> getAllowedHttpHeaders() {
        return this.allowedHttpHeaders;
    }

    public boolean isDecorateRequest() {
        return this.decorateRequest;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog(CorsFilter.class);
    }

    protected static enum CORSRequestType {
        SIMPLE,
        ACTUAL,
        PRE_FLIGHT,
        NOT_CORS,
        INVALID_CORS;

    }
}

