/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.classdiagram.FullLayout;
import net.sourceforge.plantuml.classdiagram.RowLayout;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.svek.image.EntityImageClass;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private boolean allowMixing;
    private int useLayoutExplicit = 0;

    public ClassDiagram(UmlSource source, Map<String, String> skinMap) {
        super(source, UmlDiagramType.CLASS, skinMap);
    }

    public void setAllowMixing(boolean allowMixing) {
        this.allowMixing = allowMixing;
    }

    public boolean isAllowMixing() {
        return this.allowMixing;
    }

    public void layoutNewLine() {
        ++this.useLayoutExplicit;
        this.incRawLayout();
    }

    @Override
    protected final ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        if (this.useLayoutExplicit != 0) {
            return this.exportLayoutExplicit(os, index, fileFormatOption);
        }
        return super.exportDiagramInternal(os, index, fileFormatOption);
    }

    protected final ImageData exportLayoutExplicit(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FullLayout fullLayout = new FullLayout();
        for (int i = 0; i <= this.useLayoutExplicit; ++i) {
            RowLayout rawLayout = this.getRawLayout(i);
            fullLayout.addRowLayout(rawLayout);
        }
        return this.createImageBuilder(fileFormatOption).annotations(false).drawable(fullLayout).write(os);
    }

    private RowLayout getRawLayout(int raw) {
        RowLayout rawLayout = new RowLayout();
        for (Entity leaf : this.leafs()) {
            if (leaf.getRawLayout() != raw) continue;
            rawLayout.addLeaf(this.getEntityImageClass(leaf));
        }
        return rawLayout;
    }

    private TextBlock getEntityImageClass(Entity entity) {
        return new EntityImageClass(entity, this);
    }

    @Override
    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            int len = link.getLength();
            if (len != 1) continue;
            for (Link link2 : this.getLinks()) {
                if (!link2.sameConnections(link) || link2.getLength() == 1) continue;
                link2.setLength(1);
            }
        }
        if (!this.getPragma().useIntermediatePackages()) {
            this.packSomePackage();
        }
        this.applySingleStrategy();
        return super.checkFinalError();
    }

    public CommandExecutionResult checkIfPackageHierarchyIfOk(Entity entity) {
        Quark<Entity> current = entity.getQuark().getParent();
        while (!current.isRoot()) {
            if (current.getData() != null && !current.getData().isGroup()) {
                return CommandExecutionResult.error("Bad hierarchy for class " + entity.getQuark().getQualifiedName());
            }
            current = current.getParent();
        }
        return CommandExecutionResult.ok();
    }
}

