/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.Cookie;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.SessionConfig;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationSessionCookieConfig
implements SessionCookieConfig {
    private static final StringManager sm = StringManager.getManager(ApplicationSessionCookieConfig.class);
    private static final int DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = false;
    private static final boolean DEFAULT_SECURE = false;
    private final Map<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String name;
    private StandardContext context;

    public ApplicationSessionCookieConfig(StandardContext standardContext) {
        this.context = standardContext;
    }

    public String getComment() {
        return null;
    }

    public String getDomain() {
        return this.getAttribute("Domain");
    }

    public int getMaxAge() {
        String string = this.getAttribute("Max-Age");
        if (string == null) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.getAttribute("Path");
    }

    public boolean isHttpOnly() {
        String string = this.getAttribute("HttpOnly");
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isSecure() {
        String string = this.getAttribute("Secure");
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public void setComment(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"comment", this.context.getPath()}));
        }
    }

    public void setDomain(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"domain name", this.context.getPath()}));
        }
        this.setAttribute("Domain", string);
    }

    public void setHttpOnly(boolean bl) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"HttpOnly", this.context.getPath()}));
        }
        this.setAttribute("HttpOnly", Boolean.toString(bl));
    }

    public void setMaxAge(int n) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"max age", this.context.getPath()}));
        }
        this.setAttribute("Max-Age", Integer.toString(n));
    }

    public void setName(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"name", this.context.getPath()}));
        }
        this.name = string;
    }

    public void setPath(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"path", this.context.getPath()}));
        }
        this.setAttribute("Path", string);
    }

    public void setSecure(boolean bl) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"secure", this.context.getPath()}));
        }
        this.setAttribute("Secure", Boolean.toString(bl));
    }

    public void setAttribute(String string, String string2) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{string, this.context.getPath()}));
        }
        this.attributes.put(string, string2);
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public static Cookie createSessionCookie(Context context, String string, boolean bl) {
        SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
        Cookie cookie = new Cookie(SessionConfig.getSessionCookieName(context), string);
        cookie.setMaxAge(sessionCookieConfig.getMaxAge());
        if (context.getSessionCookieDomain() == null) {
            if (sessionCookieConfig.getDomain() != null) {
                cookie.setDomain(sessionCookieConfig.getDomain());
            }
        } else {
            cookie.setDomain(context.getSessionCookieDomain());
        }
        if (sessionCookieConfig.isSecure() || bl) {
            cookie.setSecure(true);
        }
        if (sessionCookieConfig.isHttpOnly() || context.getUseHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setAttribute("Partitioned", Boolean.toString(context.getUsePartitioned()));
        cookie.setPath(SessionConfig.getSessionCookiePath(context));
        block11: for (Map.Entry entry : sessionCookieConfig.getAttributes().entrySet()) {
            switch ((String)entry.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": {
                    continue block11;
                }
            }
            cookie.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return cookie;
    }
}

