/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ShutdownCallingLauncherAction
extends SystemInstallOrUninstallAction {
    private boolean wait = true;
    private int timeout = 60;

    public boolean isWait() {
        return this.replaceWithTextOverride("wait", this.wait);
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public int getTimeout() {
        return this.replaceWithTextOverride("timeout", this.timeout);
    }

    public void setTimeout(int timeout2) {
        this.timeout = timeout2;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        return ShutdownCallingLauncherAction.shutdownCallingLauncher(context, this.isWait(), this.getTimeout());
    }

    public static boolean shutdownCallingLauncher(Context context, boolean wait, int timeout2) {
        if (InstallerUtil.isInProcess()) {
            InstallerUtil.setShutdownOnInProcessExit(true);
            return true;
        }
        String shutdownFileName = System.getProperty("install4j.shutdownFile");
        if (shutdownFileName == null) {
            Logger.getInstance().error(null, "no shutdown file property");
            return false;
        }
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.setStatusMessage(context.getMessage(".WaitLabel"));
        progressInterface.setIndeterminateProgress(true);
        try {
            File shutdownFile = new File(shutdownFileName);
            if (shutdownFile.exists()) {
                FileOutputStream fos = new FileOutputStream(shutdownFile);
                fos.write(83);
                fos.close();
                if (wait) {
                    for (int seconds = 0; timeout2 == 0 || seconds < timeout2; ++seconds) {
                        if (!shutdownFile.exists()) {
                            ShutdownCallingLauncherAction.sleepOneSecond();
                            return true;
                        }
                        ShutdownCallingLauncherAction.sleepOneSecond();
                    }
                    Logger.getInstance().error(null, "timeout");
                    return false;
                }
            } else {
                Logger.getInstance().error(null, "calling launcher already terminated");
            }
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    private static void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

