/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeRequest;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.security.dlic.rest.api.ssl.CertificateInfo;
import org.opensearch.security.dlic.rest.api.ssl.CertificateType;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfo;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfoNodesRequest;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesNodesResponse;
import org.opensearch.security.ssl.DefaultSecurityKeyStore;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportCertificatesInfoNodesAction
extends TransportNodesAction<CertificatesInfoNodesRequest, CertificatesNodesResponse, NodeRequest, CertificatesNodesResponse.CertificatesNodeResponse> {
    private final DefaultSecurityKeyStore securityKeyStore;
    private final boolean httpsEnabled;

    @Inject
    public TransportCertificatesInfoNodesAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DefaultSecurityKeyStore securityKeyStore) {
        super("cluster:admin/security/certificates/info", threadPool, clusterService, transportService, actionFilters, CertificatesInfoNodesRequest::new, NodeRequest::new, "generic", CertificatesNodesResponse.CertificatesNodeResponse.class);
        this.httpsEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(true));
        this.securityKeyStore = securityKeyStore;
    }

    protected CertificatesNodesResponse newResponse(CertificatesInfoNodesRequest request, List<CertificatesNodesResponse.CertificatesNodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new CertificatesNodesResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodeRequest newNodeRequest(CertificatesInfoNodesRequest request) {
        return new NodeRequest(request);
    }

    protected CertificatesNodesResponse.CertificatesNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new CertificatesNodesResponse.CertificatesNodeResponse(in);
    }

    protected CertificatesNodesResponse.CertificatesNodeResponse nodeOperation(NodeRequest request) {
        CertificatesInfoNodesRequest sslCertRequest = request.sslCertsInfoNodesRequest;
        if (this.securityKeyStore == null) {
            return new CertificatesNodesResponse.CertificatesNodeResponse(this.clusterService.localNode(), new IllegalStateException("keystore is not initialized"));
        }
        try {
            return new CertificatesNodesResponse.CertificatesNodeResponse(this.clusterService.localNode(), this.loadCertificates(sslCertRequest.certificateType()));
        }
        catch (Exception e) {
            return new CertificatesNodesResponse.CertificatesNodeResponse(this.clusterService.localNode(), e);
        }
    }

    protected CertificatesInfo loadCertificates(CertificateType certificateType) {
        List httpCertificates = List.of();
        List<Object> transportsCertificates = List.of();
        if (CertificateType.isHttp(certificateType)) {
            List<Object> list = httpCertificates = this.httpsEnabled ? this.certificatesDetails(this.securityKeyStore.getHttpCerts()) : List.of();
        }
        if (CertificateType.isTransport(certificateType)) {
            transportsCertificates = this.certificatesDetails(this.securityKeyStore.getTransportCerts());
        }
        return new CertificatesInfo(Map.of(CertificateType.HTTP, httpCertificates, CertificateType.TRANSPORT, transportsCertificates));
    }

    private List<CertificateInfo> certificatesDetails(X509Certificate[] certs) {
        if (certs == null) {
            return null;
        }
        ImmutableList.Builder certificates = ImmutableList.builder();
        for (X509Certificate c : certs) {
            certificates.add((Object)CertificateInfo.from(c, this.securityKeyStore.getSubjectAlternativeNames(c)));
        }
        return certificates.build();
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        CertificatesInfoNodesRequest sslCertsInfoNodesRequest;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.sslCertsInfoNodesRequest = new CertificatesInfoNodesRequest(in);
        }

        NodeRequest(CertificatesInfoNodesRequest request) {
            this.sslCertsInfoNodesRequest = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.sslCertsInfoNodesRequest.writeTo(out);
        }
    }
}

