/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.trinkets;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blizzard;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ConfusionGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.CorrosiveGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Inferno;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Regrowth;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.SmokeScreen;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.StenchGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.StormCloud;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Regeneration;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.trinkets.Trinket;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.TargetHealthIndicator;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.BArray;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.HashMap;
import java.util.Iterator;

public class ChaoticCenser
extends Trinket {
    private static final float[][] GAS_CAT_CHANCES = new float[4][3];
    private static final HashMap<Class<? extends Blob>, Float> COMMON_GASSES;
    private static final HashMap<Class<? extends Blob>, Float> UNCOMMON_GASSES;
    private static final HashMap<Class<? extends Blob>, Float> RARE_GASSES;
    private static final HashMap<Class<? extends Blob>, Integer> MISSILE_VFX;

    public ChaoticCenser() {
        this.image = ItemSpriteSheet.CHAOTIC_CENSER;
    }

    @Override
    protected int upgradeEnergyCost() {
        return 6 + 2 * this.level();
    }

    @Override
    public String statsDesc() {
        if (this.isIdentified()) {
            return Messages.get(this, "stats_desc", ChaoticCenser.averageTurnsUntilGas(this.buffedLvl()));
        }
        return Messages.get(this, "stats_desc", ChaoticCenser.averageTurnsUntilGas(0));
    }

    public static int averageTurnsUntilGas() {
        return ChaoticCenser.averageTurnsUntilGas(ChaoticCenser.trinketLevel(ChaoticCenser.class));
    }

    public static int averageTurnsUntilGas(int level) {
        if (level <= -1) {
            return -1;
        }
        return 300 / (level + 1);
    }

    private static boolean produceGas() {
        Integer targetCell;
        float gasQuantity;
        Class<? extends Blob> gasToSpawn;
        int level = ChaoticCenser.trinketLevel(ChaoticCenser.class);
        if (level < 0 || level > 3) {
            return false;
        }
        switch (Random.chances(GAS_CAT_CHANCES[level])) {
            default: {
                do {
                    gasToSpawn = Random.element(COMMON_GASSES.keySet());
                } while (!Regeneration.regenOn() && gasToSpawn == Regrowth.class);
                gasQuantity = COMMON_GASSES.get(gasToSpawn).floatValue();
                break;
            }
            case 1: {
                gasToSpawn = Random.element(UNCOMMON_GASSES.keySet());
                gasQuantity = UNCOMMON_GASSES.get(gasToSpawn).floatValue();
                break;
            }
            case 2: {
                gasToSpawn = Random.element(RARE_GASSES.keySet());
                gasQuantity = RARE_GASSES.get(gasToSpawn).floatValue();
            }
        }
        Char target = null;
        if (TargetHealthIndicator.instance != null && TargetHealthIndicator.instance.isVisible() && TargetHealthIndicator.instance.target() != null && TargetHealthIndicator.instance.target().alignment == Char.Alignment.ENEMY && TargetHealthIndicator.instance.target().isAlive()) {
            target = TargetHealthIndicator.instance.target();
        }
        HashMap<Integer, Float> candidateCells = new HashMap<Integer, Float>();
        PathFinder.buildDistanceMap(Dungeon.hero.pos, BArray.not(Dungeon.level.solid, null), 5);
        block9: for (int i = 0; i < Dungeon.level.length(); ++i) {
            if (!Dungeon.level.heroFOV[i] || PathFinder.distance[i] >= Integer.MAX_VALUE) continue;
            switch (PathFinder.distance[i]) {
                case 3: 
                case 4: {
                    candidateCells.put(i, Float.valueOf(2.0f));
                    continue block9;
                }
                case 2: 
                case 5: {
                    candidateCells.put(i, Float.valueOf(1.0f));
                }
            }
        }
        if (target != null) {
            int cell;
            int targetpos = target.pos;
            if (Dungeon.level.trueDistance(target.pos, Dungeon.hero.pos) >= 4.0f) {
                for (int i : PathFinder.NEIGHBOURS8) {
                    while (!Dungeon.level.solid[targetpos + i] && Dungeon.level.trueDistance(target.pos + i, Dungeon.hero.pos) < Dungeon.level.trueDistance(targetpos, Dungeon.hero.pos)) {
                        targetpos = target.pos + i;
                    }
                }
            }
            float closest = 100.0f;
            Iterator iterator = candidateCells.keySet().iterator();
            while (iterator.hasNext()) {
                cell = (Integer)iterator.next();
                float dist = Dungeon.level.distance(cell, targetpos);
                if (!(dist < closest)) continue;
                closest = dist;
            }
            iterator = candidateCells.keySet().iterator();
            while (iterator.hasNext()) {
                cell = (Integer)iterator.next();
                float dist = Dungeon.level.distance(cell, targetpos);
                if (dist - closest == 0.0f) {
                    candidateCells.put(cell, Float.valueOf(4.0f));
                    continue;
                }
                if (dist - closest <= 1.0f) {
                    candidateCells.put(cell, Float.valueOf(1.0f));
                    continue;
                }
                candidateCells.put(cell, Float.valueOf(0.0f));
            }
        }
        if (!candidateCells.isEmpty() && (targetCell = (Integer)Random.chances(candidateCells)) != null) {
            GameScene.add(Blob.seed(targetCell, (int)gasQuantity, gasToSpawn));
            MagicMissile.boltFromChar(Dungeon.hero.sprite.parent, MISSILE_VFX.get(gasToSpawn), Dungeon.hero.sprite, targetCell, null);
            return true;
        }
        return false;
    }

    static {
        ChaoticCenser.GAS_CAT_CHANCES[0] = new float[]{70.0f, 25.0f, 5.0f};
        ChaoticCenser.GAS_CAT_CHANCES[1] = new float[]{60.0f, 30.0f, 10.0f};
        ChaoticCenser.GAS_CAT_CHANCES[2] = new float[]{50.0f, 35.0f, 15.0f};
        ChaoticCenser.GAS_CAT_CHANCES[3] = new float[]{40.0f, 40.0f, 20.0f};
        COMMON_GASSES = new HashMap();
        COMMON_GASSES.put(ToxicGas.class, Float.valueOf(300.0f));
        COMMON_GASSES.put(ConfusionGas.class, Float.valueOf(300.0f));
        COMMON_GASSES.put(Regrowth.class, Float.valueOf(200.0f));
        UNCOMMON_GASSES = new HashMap();
        UNCOMMON_GASSES.put(StormCloud.class, Float.valueOf(300.0f));
        UNCOMMON_GASSES.put(SmokeScreen.class, Float.valueOf(300.0f));
        UNCOMMON_GASSES.put(StenchGas.class, Float.valueOf(200.0f));
        RARE_GASSES = new HashMap();
        RARE_GASSES.put(Inferno.class, Float.valueOf(300.0f));
        RARE_GASSES.put(Blizzard.class, Float.valueOf(300.0f));
        RARE_GASSES.put(CorrosiveGas.class, Float.valueOf(200.0f));
        MISSILE_VFX = new HashMap();
        MISSILE_VFX.put(ToxicGas.class, 1107);
        MISSILE_VFX.put(ConfusionGas.class, 1113);
        MISSILE_VFX.put(Regrowth.class, 4);
        MISSILE_VFX.put(StormCloud.class, 1117);
        MISSILE_VFX.put(SmokeScreen.class, 1116);
        MISSILE_VFX.put(StenchGas.class, 1111);
        MISSILE_VFX.put(Inferno.class, 1118);
        MISSILE_VFX.put(Blizzard.class, 1119);
        MISSILE_VFX.put(CorrosiveGas.class, 1108);
    }

    public static class CenserGasTracker
    extends Buff {
        private int left = Integer.MAX_VALUE;
        private int safeAreaDelay = 100;
        private static String LEFT = "left";
        private static String SAFE_AREA_DELAY = "safe_area_delay";

        @Override
        public boolean act() {
            int avgTurns = ChaoticCenser.averageTurnsUntilGas();
            if (avgTurns == -1) {
                this.spend(Random.NormalIntRange(1, 5));
                return true;
            }
            if ((float)this.left > (float)avgTurns * 1.1f) {
                this.left = Random.IntRange((int)((float)avgTurns * 0.9f), (int)((float)avgTurns * 1.1f));
            }
            float triggerChance = 0.0f;
            if (this.left > 0 && this.left <= 30) {
                if (TargetHealthIndicator.instance != null && TargetHealthIndicator.instance.isVisible() && TargetHealthIndicator.instance.target() != null && TargetHealthIndicator.instance.target().alignment == Char.Alignment.ENEMY && TargetHealthIndicator.instance.target().isAlive()) {
                    triggerChance = 0.75f;
                }
            } else if (this.left > -30 && this.left <= 0) {
                if (TargetHealthIndicator.instance != null && TargetHealthIndicator.instance.isVisible() && TargetHealthIndicator.instance.target() != null && TargetHealthIndicator.instance.target().alignment == Char.Alignment.ENEMY && TargetHealthIndicator.instance.target().isAlive()) {
                    triggerChance = 1.0f;
                } else if (Dungeon.level.openSpace[this.target.pos]) {
                    triggerChance = 0.2f;
                }
            } else if (this.left <= -30) {
                triggerChance = 1.0f;
            }
            if (triggerChance > 0.0f && this.safeAreaDelay >= 0) {
                boolean safeArea = false;
                for (Char ch : Actor.chars()) {
                    if (!(ch instanceof Shopkeeper) || Dungeon.level.distance(this.target.pos, ch.pos) > 6 || new Ballistica((int)this.target.pos, (int)ch.pos, (int)7).collisionPos != ch.pos) continue;
                    safeArea = true;
                }
                if (!(TargetHealthIndicator.instance != null && TargetHealthIndicator.instance.target() != null && TargetHealthIndicator.instance.target().alignment == Char.Alignment.ENEMY && TargetHealthIndicator.instance.target().isAlive() || Dungeon.level.openSpace[this.target.pos])) {
                    safeArea = true;
                }
                if (safeArea) {
                    int delay = Random.NormalIntRange(1, 5);
                    this.spend(delay);
                    this.safeAreaDelay -= delay;
                    return true;
                }
            }
            if (Random.Float() < triggerChance && ChaoticCenser.produceGas()) {
                Sample.INSTANCE.play("sounds/gas.mp3");
                Dungeon.hero.interrupt();
                this.left += Random.IntRange((int)((float)avgTurns * 0.9f), (int)((float)avgTurns * 1.1f));
            }
            int delay = Random.NormalIntRange(1, 5);
            this.spend(delay);
            this.safeAreaDelay = Math.min(this.safeAreaDelay + 2 * delay, 100);
            this.left -= delay;
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(LEFT, this.left);
            bundle.put(SAFE_AREA_DELAY, this.safeAreaDelay);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            if (bundle.contains(LEFT)) {
                this.left = bundle.getInt(LEFT);
                this.safeAreaDelay = bundle.getInt(SAFE_AREA_DELAY);
            }
        }
    }
}

