/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.flattr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.SwingWorker;
import org.fibs.geotag.gui.flattr.FlattrImageLoader;
import org.fibs.geotag.gui.flattr.ImageOrTextMenuItemUI;
import org.fibs.geotag.util.BrowserLauncher;

public class FlattrMenuItem
extends JMenuItem {
    private ImageOrTextMenuItemUI menuItemUI = null;
    private static final String FLATTR = "flattr";

    public FlattrMenuItem() {
        this("http://flattr.com/thing/141685/Geotag");
    }

    public FlattrMenuItem(final String flattrUrl) {
        PropertyChangeListener imageListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE.equals(event.getNewValue())) {
                    FlattrMenuItem.this.menuItemUI.setBackgroundImage(FlattrImageLoader.getImageIcon());
                    FlattrMenuItem.this.repaint();
                }
            }
        };
        this.menuItemUI = new ImageOrTextMenuItemUI(FlattrImageLoader.getImageIcon(imageListener));
        this.setUI(this.menuItemUI);
        this.setText("Flattr this!");
        this.setActionCommand(FLATTR);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FlattrMenuItem.FLATTR.equals(actionEvent.getActionCommand())) {
                    BrowserLauncher.openURL(null, flattrUrl);
                }
            }
        });
    }
}

