/*******************************************************************************
* Copyright 2023 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER

/*!
 @file TestCustomKernels.hpp
 HPCG data structure
 */

#ifndef TESTCUSTOMKERNELS_HPP
#define TESTCUSTOMKERNELS_HPP

#include "hpcg.hpp"
#include "SparseMatrix.hpp"
#include "Vector.hpp"
#include "CustomKernels.hpp"

struct TestCustomKernelsData_STRUCT {

    TestCustomKernelsData_STRUCT()
    :
        count_pass(0),
        count_fail(0)
    {}

  public:

  int count_pass; //!< number of succesful tests
  int count_fail;  //!< number of succesful tests
};

typedef struct TestCustomKernelsData_STRUCT TestCustomKernelsData;

extern int TestCustomKernels(SparseMatrix &A, Vector &b, Vector &x, int rank, TestCustomKernelsData &testck_data, sycl::queue &queue);


#endif // TESTCUSTOMKERNELS_HPP
