/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import com.amazon.randomcutforest.parkservices.RCFCaster;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.caching.ForecastCacheProvider;
import org.opensearch.forecast.caching.ForecastPriorityCache;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.ml.ForecastCheckpointDao;
import org.opensearch.forecast.ml.ForecastColdStart;
import org.opensearch.forecast.ml.ForecastModelManager;
import org.opensearch.forecast.ml.ForecastRealTimeInferencer;
import org.opensearch.forecast.ml.RCFCasterResult;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.ratelimit.ForecastCheckpointReadWorker;
import org.opensearch.forecast.ratelimit.ForecastCheckpointWriteWorker;
import org.opensearch.forecast.ratelimit.ForecastColdEntityWorker;
import org.opensearch.forecast.ratelimit.ForecastColdStartWorker;
import org.opensearch.forecast.ratelimit.ForecastResultWriteWorker;
import org.opensearch.forecast.ratelimit.ForecastSaveResultStrategy;
import org.opensearch.forecast.transport.EntityForecastResultAction;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.transport.EntityResultProcessor;
import org.opensearch.timeseries.transport.EntityResultRequest;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.transport.TransportService;

public class EntityForecastResultTransportAction
extends HandledTransportAction<EntityResultRequest, AcknowledgedResponse> {
    private static final Logger LOG = LogManager.getLogger(EntityForecastResultTransportAction.class);
    private CircuitBreakerService circuitBreakerService;
    private CacheProvider<RCFCaster, ForecastPriorityCache> cache;
    private final NodeStateManager stateManager;
    private ThreadPool threadPool;
    private EntityResultProcessor<RCFCaster, ForecastResult, RCFCasterResult, ForecastIndex, ForecastIndexManagement, ForecastCheckpointDao, ForecastCheckpointWriteWorker, ForecastColdStart, ForecastModelManager, ForecastPriorityCache, ForecastSaveResultStrategy, ForecastColdStartWorker, ForecastRealTimeInferencer, ForecastCheckpointReadWorker, ForecastColdEntityWorker> intervalDataProcessor;
    private final ForecastCacheProvider entityCache;
    private final ForecastCheckpointReadWorker checkpointReadQueue;
    private final ForecastColdEntityWorker coldEntityQueue;
    private final ForecastRealTimeInferencer inferencer;

    @Inject
    public EntityForecastResultTransportAction(ActionFilters actionFilters, TransportService transportService, CircuitBreakerService adCircuitBreakerService, ForecastCacheProvider entityCache, NodeStateManager stateManager, ForecastIndexManagement indexUtil, ForecastResultWriteWorker resultWriteQueue, ForecastCheckpointReadWorker checkpointReadQueue, ForecastColdEntityWorker coldEntityQueue, ThreadPool threadPool, ForecastRealTimeInferencer inferencer) {
        super(EntityForecastResultAction.NAME, transportService, actionFilters, EntityResultRequest::new);
        this.circuitBreakerService = adCircuitBreakerService;
        this.cache = entityCache;
        this.stateManager = stateManager;
        this.threadPool = threadPool;
        this.intervalDataProcessor = null;
        this.entityCache = entityCache;
        this.checkpointReadQueue = checkpointReadQueue;
        this.coldEntityQueue = coldEntityQueue;
        this.inferencer = inferencer;
    }

    protected void doExecute(Task task, EntityResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (this.circuitBreakerService.isOpen().booleanValue()) {
            this.threadPool.executor("forecast-threadpool").execute(() -> ((ForecastPriorityCache)this.cache.get()).releaseMemoryForOpenCircuitBreaker());
            listener.onFailure((Exception)new LimitExceededException(request.getConfigId(), "The total OpenSearch memory usage exceeds our threshold, opening the memory circuit.", false));
            return;
        }
        try {
            String forecasterId = request.getConfigId();
            Optional<Exception> previousException = this.stateManager.fetchExceptionAndClear(forecasterId);
            if (previousException.isPresent()) {
                EndRunException endRunException;
                Exception exception = previousException.get();
                LOG.error("Previous exception of {}: {}", (Object)forecasterId, (Object)exception);
                if (exception instanceof EndRunException && (endRunException = (EndRunException)exception).isEndNow()) {
                    listener.onFailure(exception);
                    return;
                }
                listener = ExceptionUtil.wrapListener(listener, exception, forecasterId);
            }
            this.intervalDataProcessor = new EntityResultProcessor(this.entityCache, this.checkpointReadQueue, this.coldEntityQueue, this.inferencer, this.threadPool, "forecast-threadpool");
            this.stateManager.getConfig(forecasterId, request.getAnalysisType(), this.intervalDataProcessor.onGetConfig(listener, forecasterId, request, previousException, request.getAnalysisType()));
        }
        catch (Exception exception) {
            LOG.error("fail to get entity's forecasts", (Throwable)exception);
            listener.onFailure(exception);
        }
    }
}

