/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.common.model.rest;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0006H\u00d6\u0001J\t\u0010!\u001a\u00020\tH\u00d6\u0001J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006&"}, d2={"Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "size", "", "from", "sortField", "", "sortOrder", "queryString", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFrom", "()I", "getQueryString", "()Ljava/lang/String;", "getSize", "getSortField", "getSortOrder", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getSortBuilder", "Lorg/opensearch/search/sort/FieldSortBuilder;", "hashCode", "toString", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-index-management"})
public final class SearchParams
implements Writeable {
    private final int size;
    private final int from;
    @NotNull
    private final String sortField;
    @NotNull
    private final String sortOrder;
    @NotNull
    private final String queryString;

    public SearchParams(int size, int from, @NotNull String sortField, @NotNull String sortOrder, @NotNull String queryString2) {
        Intrinsics.checkNotNullParameter((Object)sortField, (String)"sortField");
        Intrinsics.checkNotNullParameter((Object)sortOrder, (String)"sortOrder");
        Intrinsics.checkNotNullParameter((Object)queryString2, (String)"queryString");
        this.size = size;
        this.from = from;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.queryString = queryString2;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getFrom() {
        return this.from;
    }

    @NotNull
    public final String getSortField() {
        return this.sortField;
    }

    @NotNull
    public final String getSortOrder() {
        return this.sortOrder;
    }

    @NotNull
    public final String getQueryString() {
        return this.queryString;
    }

    public SearchParams(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        int n = sin.readInt();
        int n2 = sin.readInt();
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sin.readString()");
        this(n, n2, string, string2, string3);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.size);
        out.writeInt(this.from);
        out.writeString(this.sortField);
        out.writeString(this.sortOrder);
        out.writeString(this.queryString);
    }

    @NotNull
    public final FieldSortBuilder getSortBuilder() {
        SortBuilder sortBuilder = SortBuilders.fieldSort((String)this.sortField).order(SortOrder.fromString((String)this.sortOrder));
        Intrinsics.checkNotNullExpressionValue((Object)sortBuilder, (String)"fieldSort(this.sortField\u2026omString(this.sortOrder))");
        return (FieldSortBuilder)sortBuilder;
    }

    public final int component1() {
        return this.size;
    }

    public final int component2() {
        return this.from;
    }

    @NotNull
    public final String component3() {
        return this.sortField;
    }

    @NotNull
    public final String component4() {
        return this.sortOrder;
    }

    @NotNull
    public final String component5() {
        return this.queryString;
    }

    @NotNull
    public final SearchParams copy(int size, int from, @NotNull String sortField, @NotNull String sortOrder, @NotNull String queryString2) {
        Intrinsics.checkNotNullParameter((Object)sortField, (String)"sortField");
        Intrinsics.checkNotNullParameter((Object)sortOrder, (String)"sortOrder");
        Intrinsics.checkNotNullParameter((Object)queryString2, (String)"queryString");
        return new SearchParams(size, from, sortField, sortOrder, queryString2);
    }

    public static /* synthetic */ SearchParams copy$default(SearchParams searchParams, int n, int n2, String string, String string2, String string3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = searchParams.size;
        }
        if ((n3 & 2) != 0) {
            n2 = searchParams.from;
        }
        if ((n3 & 4) != 0) {
            string = searchParams.sortField;
        }
        if ((n3 & 8) != 0) {
            string2 = searchParams.sortOrder;
        }
        if ((n3 & 0x10) != 0) {
            string3 = searchParams.queryString;
        }
        return searchParams.copy(n, n2, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "SearchParams(size=" + this.size + ", from=" + this.from + ", sortField=" + this.sortField + ", sortOrder=" + this.sortOrder + ", queryString=" + this.queryString + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.size);
        result2 = result2 * 31 + Integer.hashCode(this.from);
        result2 = result2 * 31 + this.sortField.hashCode();
        result2 = result2 * 31 + this.sortOrder.hashCode();
        result2 = result2 * 31 + this.queryString.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchParams)) {
            return false;
        }
        SearchParams searchParams = (SearchParams)other;
        if (this.size != searchParams.size) {
            return false;
        }
        if (this.from != searchParams.from) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sortField, (Object)searchParams.sortField)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sortOrder, (Object)searchParams.sortOrder)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.queryString, (Object)searchParams.queryString);
    }
}

