/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.profile;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.profile.MLPredictRequestStats;

public class MLModelProfile
implements ToXContentFragment,
Writeable {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelProfile.class);
    private final MLModelState modelState;
    private final String predictor;
    private final String[] targetWorkerNodes;
    private final String[] workerNodes;
    private final MLPredictRequestStats modelInferenceStats;
    private final MLPredictRequestStats predictRequestStats;
    private final Long memSizeEstimationCPU;
    private final Long memSizeEstimationGPU;
    private Boolean isHidden;

    public MLModelProfile(MLModelState modelState, String predictor, String[] targetWorkerNodes, String[] workerNodes, MLPredictRequestStats modelInferenceStats, MLPredictRequestStats predictRequestStats, Long memSizeEstimationCPU, Long memSizeEstimationGPU) {
        this.modelState = modelState;
        this.predictor = predictor;
        this.targetWorkerNodes = targetWorkerNodes;
        this.workerNodes = workerNodes;
        this.modelInferenceStats = modelInferenceStats;
        this.predictRequestStats = predictRequestStats;
        this.memSizeEstimationCPU = memSizeEstimationCPU;
        this.memSizeEstimationGPU = memSizeEstimationGPU;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelState != null) {
            builder.field("model_state", (Object)this.modelState);
        }
        if (this.predictor != null) {
            builder.field("predictor", this.predictor);
        }
        if (this.targetWorkerNodes != null) {
            builder.field("target_worker_nodes", (Object)this.targetWorkerNodes);
        }
        if (this.workerNodes != null) {
            builder.field("worker_nodes", (Object)this.workerNodes);
        }
        if (this.modelInferenceStats != null) {
            builder.field("model_inference_stats", (ToXContent)this.modelInferenceStats);
        }
        if (this.predictRequestStats != null) {
            builder.field("predict_request_stats", (ToXContent)this.predictRequestStats);
        }
        if (this.memSizeEstimationCPU != null) {
            builder.field("memory_size_estimation_cpu", this.memSizeEstimationCPU);
        }
        if (this.memSizeEstimationGPU != null) {
            builder.field("memory_size_estimation_gpu", this.memSizeEstimationGPU);
        }
        if (this.isHidden != null && this.isHidden.booleanValue()) {
            builder.field("is_hidden", true);
        }
        builder.endObject();
        return builder;
    }

    public MLModelProfile(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.modelState = in.readBoolean() ? (MLModelState)in.readEnum(MLModelState.class) : null;
        this.predictor = in.readOptionalString();
        this.targetWorkerNodes = in.readOptionalStringArray();
        this.workerNodes = in.readOptionalStringArray();
        this.modelInferenceStats = in.readBoolean() ? new MLPredictRequestStats(in) : null;
        this.predictRequestStats = in.readBoolean() ? new MLPredictRequestStats(in) : null;
        this.memSizeEstimationCPU = in.readOptionalLong();
        this.memSizeEstimationGPU = in.readOptionalLong();
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isHidden = in.readOptionalBoolean();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.predictor);
        out.writeOptionalStringArray(this.targetWorkerNodes);
        out.writeOptionalStringArray(this.workerNodes);
        if (this.modelInferenceStats != null) {
            out.writeBoolean(true);
            this.modelInferenceStats.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.predictRequestStats != null) {
            out.writeBoolean(true);
            this.predictRequestStats.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.memSizeEstimationCPU);
        out.writeOptionalLong(this.memSizeEstimationGPU);
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isHidden);
        }
    }

    @Generated
    public static MLModelProfileBuilder builder() {
        return new MLModelProfileBuilder();
    }

    @Generated
    public MLModelState getModelState() {
        return this.modelState;
    }

    @Generated
    public String getPredictor() {
        return this.predictor;
    }

    @Generated
    public String[] getTargetWorkerNodes() {
        return this.targetWorkerNodes;
    }

    @Generated
    public String[] getWorkerNodes() {
        return this.workerNodes;
    }

    @Generated
    public MLPredictRequestStats getModelInferenceStats() {
        return this.modelInferenceStats;
    }

    @Generated
    public MLPredictRequestStats getPredictRequestStats() {
        return this.predictRequestStats;
    }

    @Generated
    public Long getMemSizeEstimationCPU() {
        return this.memSizeEstimationCPU;
    }

    @Generated
    public Long getMemSizeEstimationGPU() {
        return this.memSizeEstimationGPU;
    }

    @Generated
    public Boolean getIsHidden() {
        return this.isHidden;
    }

    @Generated
    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }

    @Generated
    public static class MLModelProfileBuilder {
        @Generated
        private MLModelState modelState;
        @Generated
        private String predictor;
        @Generated
        private String[] targetWorkerNodes;
        @Generated
        private String[] workerNodes;
        @Generated
        private MLPredictRequestStats modelInferenceStats;
        @Generated
        private MLPredictRequestStats predictRequestStats;
        @Generated
        private Long memSizeEstimationCPU;
        @Generated
        private Long memSizeEstimationGPU;

        @Generated
        MLModelProfileBuilder() {
        }

        @Generated
        public MLModelProfileBuilder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        @Generated
        public MLModelProfileBuilder predictor(String predictor) {
            this.predictor = predictor;
            return this;
        }

        @Generated
        public MLModelProfileBuilder targetWorkerNodes(String[] targetWorkerNodes) {
            this.targetWorkerNodes = targetWorkerNodes;
            return this;
        }

        @Generated
        public MLModelProfileBuilder workerNodes(String[] workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        @Generated
        public MLModelProfileBuilder modelInferenceStats(MLPredictRequestStats modelInferenceStats) {
            this.modelInferenceStats = modelInferenceStats;
            return this;
        }

        @Generated
        public MLModelProfileBuilder predictRequestStats(MLPredictRequestStats predictRequestStats) {
            this.predictRequestStats = predictRequestStats;
            return this;
        }

        @Generated
        public MLModelProfileBuilder memSizeEstimationCPU(Long memSizeEstimationCPU) {
            this.memSizeEstimationCPU = memSizeEstimationCPU;
            return this;
        }

        @Generated
        public MLModelProfileBuilder memSizeEstimationGPU(Long memSizeEstimationGPU) {
            this.memSizeEstimationGPU = memSizeEstimationGPU;
            return this;
        }

        @Generated
        public MLModelProfile build() {
            return new MLModelProfile(this.modelState, this.predictor, this.targetWorkerNodes, this.workerNodes, this.modelInferenceStats, this.predictRequestStats, this.memSizeEstimationCPU, this.memSizeEstimationGPU);
        }

        @Generated
        public String toString() {
            return "MLModelProfile.MLModelProfileBuilder(modelState=" + this.modelState + ", predictor=" + this.predictor + ", targetWorkerNodes=" + Arrays.deepToString(this.targetWorkerNodes) + ", workerNodes=" + Arrays.deepToString(this.workerNodes) + ", modelInferenceStats=" + this.modelInferenceStats + ", predictRequestStats=" + this.predictRequestStats + ", memSizeEstimationCPU=" + this.memSizeEstimationCPU + ", memSizeEstimationGPU=" + this.memSizeEstimationGPU + ")";
        }
    }
}

