/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.http.netty;

import java.nio.file.Path;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.ssl.util.SSLRequestHelper;

public class ValidatingDispatcher
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(ValidatingDispatcher.class);
    private final ThreadContext threadContext;
    private final HttpServerTransport.Dispatcher originalDispatcher;
    private final SslExceptionHandler errorHandler;
    private final Settings settings;
    private final Path configPath;

    public ValidatingDispatcher(ThreadContext threadContext, HttpServerTransport.Dispatcher originalDispatcher, Settings settings, Path configPath, SslExceptionHandler errorHandler) {
        this.threadContext = threadContext;
        this.originalDispatcher = originalDispatcher;
        this.settings = settings;
        this.configPath = configPath;
        this.errorHandler = errorHandler;
    }

    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        this.checkRequest(SecurityRequestFactory.from(request, channel));
        this.originalDispatcher.dispatchRequest(request, channel, threadContext);
    }

    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        this.checkRequest(SecurityRequestFactory.from(channel.request(), channel));
        this.originalDispatcher.dispatchBadRequest(channel, threadContext, cause);
    }

    protected void checkRequest(SecurityRequestChannel request) {
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_ssl_")) {
            OpenSearchException exception = ExceptionUtils.createBadHeaderException();
            this.errorHandler.logError(exception, request, 1);
            throw exception;
        }
        try {
            if (SSLRequestHelper.getSSLInfo(this.settings, this.configPath, request, null) == null) {
                logger.error("Not an SSL request");
                throw new OpenSearchSecurityException("Not an SSL request", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            logger.error("No client certificates found but such are needed (SG 8).");
            this.errorHandler.logError(e, request, 0);
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }
}

