# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Simon Ser
# Copyright © 2019 Ivan Molodetskikh
# Copyright © 2024 Neal Gompa
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ExtDataControlSourceV1(Interface):
    """Offer to transfer data

    The ext_data_control_source object is the source side of a
    ext_data_control_offer. It is created by the source client in a data
    transfer and provides a way to describe the offered data and a way to
    respond to requests to transfer the data.
    """

    name = "ext_data_control_source_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_offer = 1


class ExtDataControlSourceV1Proxy(Proxy[ExtDataControlSourceV1]):
    interface = ExtDataControlSourceV1

    @ExtDataControlSourceV1.request(
        Argument(ArgumentType.String),
    )
    def offer(self, mime_type: str) -> None:
        """Add an offered mime type

        This request adds a MIME type to the set of MIME types advertised to
        targets. Can be called several times to offer multiple types.

        Calling this after ext_data_control_device.set_selection is a protocol
        error.

        :param mime_type:
            MIME type offered by the data source
        :type mime_type:
            `ArgumentType.String`
        """
        self._marshal(0, mime_type)

    @ExtDataControlSourceV1.request()
    def destroy(self) -> None:
        """Destroy this source

        Destroys the data source object.
        """
        self._marshal(1)
        self._destroy()


class ExtDataControlSourceV1Resource(Resource):
    interface = ExtDataControlSourceV1

    @ExtDataControlSourceV1.event(
        Argument(ArgumentType.String),
        Argument(ArgumentType.FileDescriptor),
    )
    def send(self, mime_type: str, fd: int) -> None:
        """Send the data

        Request for data from the client. Send the data as the specified MIME
        type over the passed file descriptor, then close it.

        :param mime_type:
            MIME type for the data
        :type mime_type:
            `ArgumentType.String`
        :param fd:
            file descriptor for the data
        :type fd:
            `ArgumentType.FileDescriptor`
        """
        self._post_event(0, mime_type, fd)

    @ExtDataControlSourceV1.event()
    def cancelled(self) -> None:
        """Selection was cancelled

        This data source is no longer valid. The data source has been replaced
        by another data source.

        The client should clean up and destroy this data source.
        """
        self._post_event(1)


class ExtDataControlSourceV1Global(Global):
    interface = ExtDataControlSourceV1


ExtDataControlSourceV1._gen_c()
ExtDataControlSourceV1.proxy_class = ExtDataControlSourceV1Proxy
ExtDataControlSourceV1.resource_class = ExtDataControlSourceV1Resource
ExtDataControlSourceV1.global_class = ExtDataControlSourceV1Global
