/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.ObjectStreamException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.Context;
import org.apache.catalina.Group;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.ExceptionUtils;

public class UserDatabaseRealm
extends RealmBase {
    protected volatile UserDatabase database = null;
    private final Object databaseLock = new Object();
    @Deprecated
    protected static final String name = "UserDatabaseRealm";
    protected String resourceName = "UserDatabase";
    private boolean localJndiResource = false;

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public boolean getLocalJndiResource() {
        return this.localJndiResource;
    }

    public void setLocalJndiResource(boolean bl) {
        this.localJndiResource = bl;
    }

    @Override
    @Deprecated
    protected String getName() {
        return name;
    }

    @Override
    public void backgroundProcess() {
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase instanceof MemoryUserDatabase) {
            ((MemoryUserDatabase)userDatabase).backgroundProcess();
        }
    }

    @Override
    protected String getPassword(String string) {
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase == null) {
            return null;
        }
        User user = userDatabase.findUser(string);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    @Override
    protected Principal getPrincipal(String string) {
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase == null) {
            return null;
        }
        User user = userDatabase.findUser(string);
        if (user == null) {
            return null;
        }
        return new UserDatabasePrincipal(user, userDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDatabase getUserDatabase() {
        if (this.database == null) {
            Object object = this.databaseLock;
            synchronized (object) {
                if (this.database == null) {
                    try {
                        Context context = null;
                        if (this.localJndiResource) {
                            context = ContextBindings.getClassLoader();
                            context = (Context)context.lookup("comp/env");
                        } else {
                            Server server = this.getServer();
                            if (server == null) {
                                this.containerLog.error((Object)sm.getString("userDatabaseRealm.noNamingContext"));
                                return null;
                            }
                            context = this.getServer().getGlobalNamingContext();
                        }
                        this.database = (UserDatabase)context.lookup(this.resourceName);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        if (this.containerLog != null) {
                            this.containerLog.error((Object)sm.getString("userDatabaseRealm.lookup", new Object[]{this.resourceName}), throwable);
                        }
                        this.database = null;
                    }
                }
            }
        }
        return this.database;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        UserDatabase userDatabase;
        if (!this.localJndiResource && (userDatabase = this.getUserDatabase()) == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", new Object[]{this.resourceName}));
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.database = null;
    }

    public static final class UserDatabasePrincipal
    extends GenericPrincipal {
        private static final long serialVersionUID = 1L;
        private final transient User user;
        private final transient UserDatabase database;

        public UserDatabasePrincipal(User user, UserDatabase userDatabase) {
            super(user.getName(), null, null);
            this.user = user;
            this.database = userDatabase;
        }

        @Override
        public String[] getRoles() {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            Iterator<Role> iterator = this.user.getRoles();
            while (iterator.hasNext()) {
                object = iterator.next();
                hashSet.add(object.getName());
            }
            object = this.user.getGroups();
            while (object.hasNext()) {
                Group group = (Group)object.next();
                iterator = group.getRoles();
                while (iterator.hasNext()) {
                    Role role = iterator.next();
                    hashSet.add(role.getName());
                }
            }
            return hashSet.toArray(new String[0]);
        }

        @Override
        public boolean hasRole(String string) {
            if ("*".equals(string)) {
                return true;
            }
            if (string == null) {
                return false;
            }
            if (this.database == null) {
                return super.hasRole(string);
            }
            Role role = this.database.findRole(string);
            if (role == null) {
                return false;
            }
            if (this.user.isInRole(role)) {
                return true;
            }
            Iterator<Group> iterator = this.user.getGroups();
            while (iterator.hasNext()) {
                Group group = iterator.next();
                if (!group.isInRole(role)) continue;
                return true;
            }
            return false;
        }

        private Object writeReplace() throws ObjectStreamException {
            return new GenericPrincipal(this.getName(), null, Arrays.asList(this.getRoles()));
        }
    }
}

