/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;

public class ShiftedProjecting
implements Projecting {
    private final Projecting base;
    private final EastNorth offset;

    public ShiftedProjecting(Projecting base, EastNorth offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public EastNorth latlon2eastNorth(ILatLon ll) {
        return this.base.latlon2eastNorth(ll).add(this.offset);
    }

    @Override
    public LatLon eastNorth2latlonClamped(EastNorth en) {
        return this.base.eastNorth2latlonClamped(en.subtract(this.offset));
    }

    @Override
    public Projection getBaseProjection() {
        return this.base.getBaseProjection();
    }

    @Override
    public Map<ProjectionBounds, Projecting> getProjectingsForArea(ProjectionBounds area) {
        Map<ProjectionBounds, Projecting> forArea = this.base.getProjectingsForArea(new ProjectionBounds(area.getMin().subtract(this.offset), area.getMax().subtract(this.offset)));
        HashMap<ProjectionBounds, Projecting> ret = new HashMap<ProjectionBounds, Projecting>();
        forArea.forEach((pb, projecting) -> ret.put(new ProjectionBounds(pb.getMin().add(this.offset), pb.getMax().add(this.offset)), new ShiftedProjecting((Projecting)projecting, this.offset)));
        return ret;
    }
}

