/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.security.ssl.JsseJce;

final class CloneableDigest
extends MessageDigest
implements Cloneable {
    private final MessageDigest[] digests;

    private CloneableDigest(MessageDigest digest, int n, String algorithm) throws NoSuchAlgorithmException {
        super(algorithm);
        this.digests = new MessageDigest[n];
        this.digests[0] = digest;
        for (int i = 1; i < n; ++i) {
            this.digests[i] = JsseJce.getMessageDigest(algorithm);
        }
    }

    static MessageDigest getDigest(String algorithm, int n) throws NoSuchAlgorithmException {
        MessageDigest digest = JsseJce.getMessageDigest(algorithm);
        try {
            digest.clone();
            return digest;
        }
        catch (CloneNotSupportedException e) {
            return new CloneableDigest(digest, n, algorithm);
        }
    }

    private void checkState() {
    }

    @Override
    protected int engineGetDigestLength() {
        this.checkState();
        return this.digests[0].getDigestLength();
    }

    @Override
    protected void engineUpdate(byte b) {
        this.checkState();
        for (int i = 0; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].update(b);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int offset, int len) {
        this.checkState();
        for (int i = 0; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].update(b, offset, len);
        }
    }

    @Override
    protected byte[] engineDigest() {
        this.checkState();
        byte[] digest = this.digests[0].digest();
        this.digestReset();
        return digest;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        this.checkState();
        int n = this.digests[0].digest(buf, offset, len);
        this.digestReset();
        return n;
    }

    private void digestReset() {
        for (int i = 1; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].reset();
        }
    }

    @Override
    protected void engineReset() {
        this.checkState();
        for (int i = 0; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].reset();
        }
    }

    @Override
    public Object clone() {
        this.checkState();
        for (int i = this.digests.length - 1; i >= 0; --i) {
            if (this.digests[i] == null) continue;
            MessageDigest digest = this.digests[i];
            this.digests[i] = null;
            return digest;
        }
        throw new InternalError();
    }
}

