/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.WeakCache;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.ProxyGenerator;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final WeakCache<ClassLoader, Class<?>[], Class<?>> proxyClassCache = new WeakCache(new KeyFactory(), new ProxyClassFactory());
    protected InvocationHandler h;
    private static final Object key0 = new Object();

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        this.doNewInstanceCheck();
        this.h = h;
    }

    private void doNewInstanceCheck() {
        SecurityManager sm = System.getSecurityManager();
        Class<?> proxyClass = this.getClass();
        if (sm != null && ProxyAccessHelper.needsNewInstanceCheck(proxyClass)) {
            try {
                sm.checkPermission(ProxyAccessHelper.PROXY_PERMISSION);
            }
            catch (SecurityException e) {
                throw new SecurityException("Not allowed to construct a Proxy instance that implements a non-public interface", e);
            }
        }
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        Class[] intfs = (Class[])interfaces.clone();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), loader, intfs);
        }
        return Proxy.getProxyClass0(loader, intfs);
    }

    private static void checkProxyAccess(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader ccl = caller.getClassLoader();
            if (loader == null && ccl != null && !ProxyAccessHelper.allowNullLoader) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ReflectUtil.checkProxyPackageAccess(ccl, interfaces);
        }
    }

    private static Class<?> getProxyClass0(ClassLoader loader, Class<?> ... interfaces) {
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        return proxyClassCache.get(loader, interfaces);
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h == null) {
            throw new NullPointerException();
        }
        Class[] intfs = (Class[])interfaces.clone();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), loader, intfs);
        }
        Class<?> cl = Proxy.getProxyClass0(loader, intfs);
        try {
            final Constructor<?> cons = cl.getConstructor(constructorParams);
            final InvocationHandler ih = h;
            if (sm != null && ProxyAccessHelper.needsNewInstanceCheck(cl)) {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return Proxy.newInstance(cons, ih);
                    }
                });
            }
            return Proxy.newInstance(cons, ih);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
    }

    private static Object newInstance(Constructor<?> cons, InvocationHandler h) {
        try {
            return cons.newInstance(h);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InternalError(t.toString());
        }
    }

    public static boolean isProxyClass(Class<?> cl) {
        return Proxy.class.isAssignableFrom(cl) && proxyClassCache.containsValue(cl);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        InvocationHandler ih = p.h;
        if (System.getSecurityManager() != null) {
            Class<?> ihClass = ih.getClass();
            Class caller = Reflection.getCallerClass();
            if (ReflectUtil.needsPackageAccessCheck(caller.getClassLoader(), ihClass.getClassLoader())) {
                ReflectUtil.checkPackageAccess(ihClass);
            }
        }
        return ih;
    }

    private static native Class<?> defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    private static final class ProxyClassFactory
    implements WeakCache.BiFunction<ClassLoader, Class<?>[], Class<?>> {
        private static final String proxyClassNamePrefix = "$Proxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();

        private ProxyClassFactory() {
        }

        @Override
        public Class<?> apply(ClassLoader loader, Class<?>[] interfaces) {
            IdentityHashMap interfaceSet = new IdentityHashMap(interfaces.length);
            for (Class<?> intf : interfaces) {
                Class<?> interfaceClass = null;
                try {
                    interfaceClass = Class.forName(intf.getName(), false, loader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (interfaceClass != intf) {
                    throw new IllegalArgumentException(intf + " is not visible from class loader");
                }
                if (!interfaceClass.isInterface()) {
                    throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface");
                }
                if (interfaceSet.put(interfaceClass, Boolean.TRUE) == null) continue;
                throw new IllegalArgumentException("repeated interface: " + interfaceClass.getName());
            }
            String proxyPkg = null;
            for (Class<?> intf : interfaces) {
                String pkg;
                int flags = intf.getModifiers();
                if (Modifier.isPublic(flags)) continue;
                String name = intf.getName();
                int n = name.lastIndexOf(46);
                String string = pkg = n == -1 ? "" : name.substring(0, n + 1);
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (proxyPkg == null) {
                proxyPkg = "com.sun.proxy.";
            }
            long num = nextUniqueNumber.getAndIncrement();
            String proxyName = proxyPkg + proxyClassNamePrefix + num;
            byte[] proxyClassFile = ProxyGenerator.generateProxyClass(proxyName, interfaces);
            try {
                return Proxy.defineClass0(loader, proxyName, proxyClassFile, 0, proxyClassFile.length);
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    private static final class KeyFactory
    implements WeakCache.BiFunction<ClassLoader, Class<?>[], Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, Class<?>[] interfaces) {
            switch (interfaces.length) {
                case 1: {
                    return new Key1(interfaces[0]);
                }
                case 2: {
                    return new Key2(interfaces[0], interfaces[1]);
                }
                case 0: {
                    return key0;
                }
            }
            return new KeyX(interfaces);
        }
    }

    private static final class KeyX {
        private final int hash;
        private final WeakReference<Class<?>>[] refs;

        KeyX(Class<?>[] interfaces) {
            this.hash = Arrays.hashCode(interfaces);
            this.refs = new WeakReference[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.refs[i] = new WeakReference(interfaces[i]);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == KeyX.class && KeyX.equals(this.refs, ((KeyX)obj).refs);
        }

        private static boolean equals(WeakReference<Class<?>>[] refs1, WeakReference<Class<?>>[] refs2) {
            if (refs1.length != refs2.length) {
                return false;
            }
            for (int i = 0; i < refs1.length; ++i) {
                Class intf = (Class)refs1[i].get();
                if (intf != null && intf == refs2[i].get()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Key2
    extends WeakReference<Class<?>> {
        private final int hash;
        private final WeakReference<Class<?>> ref2;

        Key2(Class<?> intf1, Class<?> intf2) {
            super(intf1);
            this.hash = 31 * intf1.hashCode() + intf2.hashCode();
            this.ref2 = new WeakReference(intf2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Class intf2;
            Class intf1;
            return this == obj || obj != null && obj.getClass() == Key2.class && (intf1 = (Class)this.get()) != null && intf1 == ((Key2)obj).get() && (intf2 = (Class)this.ref2.get()) != null && intf2 == ((Key2)obj).ref2.get();
        }
    }

    private static final class Key1
    extends WeakReference<Class<?>> {
        private final int hash;

        Key1(Class<?> intf) {
            super(intf);
            this.hash = intf.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Class intf;
            return this == obj || obj != null && obj.getClass() == Key1.class && (intf = (Class)this.get()) != null && intf == ((Key1)obj).get();
        }
    }

    private static class ProxyAccessHelper {
        static final Permission PROXY_PERMISSION = new ReflectPermission("proxyConstructorNewInstance");
        static final boolean allowNewInstance = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNewInstance");
        static final boolean allowNullLoader = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNullLoader");

        private ProxyAccessHelper() {
        }

        private static boolean getBooleanProperty(final String key) {
            String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return Boolean.valueOf(s);
        }

        static boolean needsNewInstanceCheck(Class<?> proxyClass) {
            if (!Proxy.isProxyClass(proxyClass) || allowNewInstance) {
                return false;
            }
            if (ReflectUtil.isNonPublicProxyClass(proxyClass)) {
                for (Class<?> intf : proxyClass.getInterfaces()) {
                    if (Modifier.isPublic(intf.getModifiers())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

