/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    final Object[] items;
    int takeIndex;
    int putIndex;
    int count;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    final int dec(int i) {
        return (i == 0 ? this.items.length : i) - 1;
    }

    static <E> E cast(Object item) {
        return (E)item;
    }

    final E itemAt(int i) {
        return ArrayBlockingQueue.cast(this.items[i]);
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private void insert(E x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private E extract() {
        Object[] items = this.items;
        E x = ArrayBlockingQueue.cast(items[this.takeIndex]);
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return x;
    }

    void removeAt(int i) {
        Object[] items = this.items;
        if (i == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int nexti;
            while ((nexti = this.inc(i)) != this.putIndex) {
                items[i] = items[nexti];
                i = nexti;
            }
            items[i] = null;
            this.putIndex = i;
        }
        --this.count;
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int capacity) {
        this(capacity, false);
    }

    public ArrayBlockingQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayBlockingQueue(int capacity, boolean fair, Collection<? extends E> c) {
        this(capacity, fair);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = 0;
            try {
                for (E e : c) {
                    ArrayBlockingQueue.checkNotNull(e);
                    this.items[i++] = e;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalArgumentException();
            }
            this.count = i;
            this.putIndex = i == capacity ? 0 : i;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl = false;
                return bl;
            }
            this.insert(e);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.insert(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            this.insert(e);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            E e = this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e = this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.itemAt(this.takeIndex);
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            for (int k = this.count; k > 0; --k) {
                if (o.equals(items[i])) {
                    this.removeAt(i);
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            for (int k = this.count; k > 0; --k) {
                if (o.equals(items[i])) {
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int count = this.count;
            Object[] a = new Object[count];
            int i = this.takeIndex;
            for (int k = 0; k < count; ++k) {
                a[k] = items[i];
                i = this.inc(i);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int count = this.count;
            int len = a.length;
            if (len < count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), count);
            }
            int i = this.takeIndex;
            for (int k = 0; k < count; ++k) {
                a[k] = items[i];
                i = this.inc(i);
            }
            if (len > count) {
                a[count] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int k = this.count;
            if (k == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int i = this.takeIndex;
            while (true) {
                Object e;
                sb.append((e = this.items[i]) == this ? "(this Collection)" : e);
                if (--k == 0) {
                    String string = sb.append(']').toString();
                    return string;
                }
                sb.append(',').append(' ');
                i = this.inc(i);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            for (int k = this.count; k > 0; --k) {
                items[i] = null;
                i = this.inc(i);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        ArrayBlockingQueue.checkNotNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int i = this.takeIndex;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                c.add(ArrayBlockingQueue.cast(items[i]));
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        ArrayBlockingQueue.checkNotNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int max;
            int i = this.takeIndex;
            int n2 = max = maxElements < this.count ? maxElements : this.count;
            for (n = 0; n < max; ++n) {
                c.add(ArrayBlockingQueue.cast(items[i]));
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count -= n;
                this.takeIndex = i;
                this.notFull.signalAll();
            }
            int n3 = n;
            return n3;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.items.length == 0 || this.takeIndex < 0 || this.takeIndex >= this.items.length || this.putIndex < 0 || this.putIndex >= this.items.length || this.count < 0 || this.count > this.items.length || ArrayBlockingQueue.floorMod(this.putIndex - this.takeIndex, this.items.length) != ArrayBlockingQueue.floorMod(this.count, this.items.length)) {
            throw new InvalidObjectException("invariants violated");
        }
    }

    private static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    private static int floorMod(int x, int y) {
        int r = x - ArrayBlockingQueue.floorDiv(x, y) * y;
        return r;
    }

    private class Itr
    implements Iterator<E> {
        private int remaining;
        private int nextIndex;
        private E nextItem;
        private E lastItem;
        private int lastRet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                this.lastRet = -1;
                this.remaining = ArrayBlockingQueue.this.count;
                if (this.remaining > 0) {
                    this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                }
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (this.remaining <= 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object x = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                if (x == null) {
                    x = this.nextItem;
                    this.lastItem = null;
                } else {
                    this.lastItem = x;
                }
                while (--this.remaining > 0 && (this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex))) == null) {
                }
                Object e = x;
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                int i = this.lastRet;
                if (i == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                Object x = this.lastItem;
                this.lastItem = null;
                if (x != null && x == ArrayBlockingQueue.this.items[i]) {
                    boolean removingHead = i == ArrayBlockingQueue.this.takeIndex;
                    ArrayBlockingQueue.this.removeAt(i);
                    if (!removingHead) {
                        this.nextIndex = ArrayBlockingQueue.this.dec(this.nextIndex);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }
}

