/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReflectionUtils {
    public static void callSetBoolean(Object thisObject, String methodName, boolean value) throws Exception {
        Class[] argTypes = new Class[]{Boolean.TYPE};
        Object[] args2 = new Object[]{value ? Boolean.TRUE : Boolean.FALSE};
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        method.invoke(thisObject, args2);
    }

    public static void callSetInt(Object thisObject, String methodName, int value) throws Exception {
        Class[] argTypes = new Class[]{Integer.TYPE};
        Object[] args2 = new Object[]{value};
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        method.invoke(thisObject, args2);
    }

    public static void callSet(Object thisObject, String methodName, Object value) throws Exception {
        Class[] argTypes = new Class[]{value.getClass()};
        Object[] args2 = new Object[]{value};
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        method.invoke(thisObject, args2);
    }

    public static Object callGet(Object thisObject, String methodName) throws Exception {
        Method method = thisObject.getClass().getMethod(methodName, null);
        return method.invoke(thisObject, (Object[])null);
    }

    public static void call(Object thisObject, String methodName) throws Exception {
        Method method = thisObject.getClass().getMethod(methodName, null);
        method.invoke(thisObject, (Object[])null);
    }

    public static Object callConstructor(Class<?> clazz, Class<?>[] argTypes, Object[] args2) throws Exception {
        Constructor<?> constructor = clazz.getConstructor(argTypes);
        return constructor.newInstance(args2);
    }

    public static Object callAny(Object thisObject, String methodName, Object[] args2) throws Exception {
        Class[] argTypes = null;
        if (args2 != null) {
            argTypes = new Class[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                argTypes[i] = args2[i].getClass();
            }
        }
        return ReflectionUtils.callAny(thisObject, methodName, argTypes, args2);
    }

    public static Object callAny(Object thisObject, String methodName, Class<?>[] argTypes, Object[] args2) throws Exception {
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        return method.invoke(thisObject, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callAnyWithoutException(Object thisObject, Class<?> objectClass, String methodName, Class<?>[] argTypes, Object[] args2) {
        Method m3;
        try {
            m3 = objectClass.getDeclaredMethod(methodName, argTypes);
        }
        catch (Exception e) {
            m3 = null;
        }
        if (m3 != null) {
            try {
                m3.setAccessible(true);
                Object e = m3.invoke(thisObject, args2);
                return e;
            }
            catch (Exception ignored) {
                Object var7_9 = null;
                return var7_9;
            }
            finally {
                m3.setAccessible(false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callStatic(Class<?> thisClass, String methodName, Class<?>[] argTypes, Object[] args2) throws Exception {
        Method method = thisClass.getMethod(methodName, argTypes);
        Object result = null;
        if (method != null) {
            try {
                method.setAccessible(true);
                result = method.invoke(null, args2);
            }
            finally {
                method.setAccessible(false);
            }
        }
        return result;
    }

    public static Object createInstance(String className, Class<?>[] types, Object[] args2) {
        Object instantiation = null;
        try {
            Class<?> cls = Class.forName(className);
            if (types != null && types.length != 0) {
                Constructor<?> constructor = cls.getConstructor(types);
                instantiation = constructor.newInstance(args2);
            } else {
                instantiation = cls.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instantiation;
    }

    public static boolean isSubClassOf(Object o, String className) {
        if (o == null) {
            return false;
        }
        for (Class<?> aClass = o.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().contains(className)) continue;
            return true;
        }
        return false;
    }
}

