import * as React from "react";
/**
 * An abstract component that Blueprint components can extend
 * in order to add some common functionality like runtime props validation.
 *
 * @deprecated componentWillReceiveProps is deprecated in React 16.9; use AbstractPureComponent2 instead
 */
export declare abstract class AbstractPureComponent<P, S = {}> extends React.PureComponent<P, S> {
    /** Component displayName should be `public static`. This property exists to prevent incorrect usage. */
    protected displayName: never;
    private timeoutIds;
    constructor(props: P, context?: any);
    componentWillReceiveProps(nextProps: P & {
        children?: React.ReactNode;
    }): void;
    componentWillUnmount(): void;
    /**
     * Set a timeout and remember its ID.
     * All stored timeouts will be cleared when component unmounts.
     *
     * @returns a "cancel" function that will clear timeout when invoked.
     */
    setTimeout(callback: () => void, timeout?: number): () => void;
    /**
     * Clear all known timeouts.
     */
    clearTimeouts: () => void;
    /**
     * Ensures that the props specified for a component are valid.
     * Implementations should check that props are valid and usually throw an Error if they are not.
     * Implementations should not duplicate checks that the type system already guarantees.
     *
     * This method should be used instead of React's
     * [propTypes](https://facebook.github.io/react/docs/reusable-components.html#prop-validation) feature.
     * Like propTypes, these runtime checks run only in development mode.
     */
    protected validateProps(_props: P & {
        children?: React.ReactNode;
    }): void;
}
