/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.utils.StringUtils;

public class MLCreateConnectorInput
implements ToXContentObject,
Writeable {
    public static final String CONNECTOR_NAME_FIELD = "name";
    public static final String CONNECTOR_DESCRIPTION_FIELD = "description";
    public static final String CONNECTOR_VERSION_FIELD = "version";
    public static final String CONNECTOR_PROTOCOL_FIELD = "protocol";
    public static final String CONNECTOR_PARAMETERS_FIELD = "parameters";
    public static final String CONNECTOR_CREDENTIAL_FIELD = "credential";
    public static final String CONNECTOR_ACTIONS_FIELD = "actions";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ADD_ALL_BACKEND_ROLES_FIELD = "add_all_backend_roles";
    public static final String OWNER_FIELD = "owner";
    public static final String ACCESS_MODE_FIELD = "access_mode";
    public static final String DRY_RUN_FIELD = "dry_run";
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG = CommonValue.VERSION_2_13_0;
    public static final String DRY_RUN_CONNECTOR_NAME = "dryRunConnector";
    private String name;
    private String description;
    private String version;
    private String protocol;
    private Map<String, String> parameters;
    private Map<String, String> credential;
    private List<ConnectorAction> actions;
    private List<String> backendRoles;
    private Boolean addAllBackendRoles;
    private AccessMode access;
    private boolean dryRun;
    private boolean updateConnector;
    private ConnectorClientConfig connectorClientConfig;

    public MLCreateConnectorInput(String name, String description, String version, String protocol, Map<String, String> parameters, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, Boolean addAllBackendRoles, AccessMode access, boolean dryRun, boolean updateConnector, ConnectorClientConfig connectorClientConfig) {
        if (!dryRun && !updateConnector) {
            if (name == null) {
                throw new IllegalArgumentException("Connector name is null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Connector version is null");
            }
            if (protocol == null) {
                throw new IllegalArgumentException("Connector protocol is null");
            }
        }
        this.name = name;
        this.description = description;
        this.version = version;
        this.protocol = protocol;
        this.parameters = parameters;
        this.credential = credential;
        this.actions = actions;
        this.backendRoles = backendRoles;
        this.addAllBackendRoles = addAllBackendRoles;
        this.access = access;
        this.dryRun = dryRun;
        this.updateConnector = updateConnector;
        this.connectorClientConfig = connectorClientConfig;
    }

    public static MLCreateConnectorInput parse(XContentParser parser) throws IOException {
        return MLCreateConnectorInput.parse(parser, false);
    }

    public static MLCreateConnectorInput parse(XContentParser parser, boolean updateConnector) throws IOException {
        String name = null;
        String description = null;
        String version = null;
        String protocol = null;
        Map<String, String> parameters = new HashMap<String, String>();
        Map<String, String> credential = new HashMap<String, String>();
        ArrayList<ConnectorAction> actions = null;
        ArrayList<String> backendRoles = null;
        Boolean addAllBackendRoles = null;
        AccessMode access = null;
        boolean dryRun = false;
        ConnectorClientConfig connectorClientConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block28: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block28;
                }
                case "description": {
                    description = parser.text();
                    continue block28;
                }
                case "version": {
                    version = parser.text();
                    continue block28;
                }
                case "protocol": {
                    protocol = parser.text();
                    continue block28;
                }
                case "parameters": {
                    parameters = StringUtils.getParameterMap(parser.map());
                    continue block28;
                }
                case "credential": {
                    credential = parser.mapStrings();
                    continue block28;
                }
                case "actions": {
                    actions = new ArrayList<ConnectorAction>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        actions.add(ConnectorAction.parse(parser));
                    }
                    continue block28;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    backendRoles = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block28;
                }
                case "add_all_backend_roles": {
                    addAllBackendRoles = parser.booleanValue();
                    continue block28;
                }
                case "access_mode": {
                    access = AccessMode.from(parser.text());
                    continue block28;
                }
                case "dry_run": {
                    dryRun = parser.booleanValue();
                    continue block28;
                }
                case "client_config": {
                    connectorClientConfig = ConnectorClientConfig.parse(parser);
                    continue block28;
                }
            }
            parser.skipChildren();
        }
        return new MLCreateConnectorInput(name, description, version, protocol, parameters, credential, actions, backendRoles, addAllBackendRoles, access, dryRun, updateConnector, connectorClientConfig);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(CONNECTOR_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(CONNECTOR_DESCRIPTION_FIELD, this.description);
        }
        if (this.version != null) {
            builder.field(CONNECTOR_VERSION_FIELD, this.version);
        }
        if (this.protocol != null) {
            builder.field(CONNECTOR_PROTOCOL_FIELD, this.protocol);
        }
        if (this.parameters != null) {
            builder.field(CONNECTOR_PARAMETERS_FIELD, this.parameters);
        }
        if (this.credential != null) {
            builder.field(CONNECTOR_CREDENTIAL_FIELD, this.credential);
        }
        if (this.actions != null) {
            builder.field(CONNECTOR_ACTIONS_FIELD, this.actions);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.addAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES_FIELD, this.addAllBackendRoles);
        }
        if (this.access != null) {
            builder.field(ACCESS_MODE_FIELD, (Object)this.access);
        }
        if (this.connectorClientConfig != null) {
            builder.field("client_config", (ToXContent)this.connectorClientConfig);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput output) throws IOException {
        Version streamOutputVersion = output.getVersion();
        output.writeOptionalString(this.name);
        output.writeOptionalString(this.description);
        output.writeOptionalString(this.version);
        output.writeOptionalString(this.protocol);
        if (this.parameters != null) {
            output.writeBoolean(true);
            output.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            output.writeBoolean(false);
        }
        if (this.credential != null) {
            output.writeBoolean(true);
            output.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            output.writeBoolean(false);
        }
        if (this.actions != null) {
            output.writeBoolean(true);
            output.writeInt(this.actions.size());
            for (ConnectorAction action : this.actions) {
                action.writeTo(output);
            }
        } else {
            output.writeBoolean(false);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            output.writeBoolean(true);
            output.writeStringCollection(this.backendRoles);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalBoolean(this.addAllBackendRoles);
        if (this.access != null) {
            output.writeBoolean(true);
            output.writeEnum((Enum)this.access);
        } else {
            output.writeBoolean(false);
        }
        output.writeBoolean(this.dryRun);
        output.writeBoolean(this.updateConnector);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG)) {
            if (this.connectorClientConfig != null) {
                output.writeBoolean(true);
                this.connectorClientConfig.writeTo(output);
            } else {
                output.writeBoolean(false);
            }
        }
    }

    public MLCreateConnectorInput(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        this.version = input.readOptionalString();
        this.protocol = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(s -> s.readString(), s -> s.readString());
        }
        if (input.readBoolean()) {
            this.credential = input.readMap(s -> s.readString(), s -> s.readString());
        }
        if (input.readBoolean()) {
            this.actions = new ArrayList<ConnectorAction>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.actions.add(new ConnectorAction(input));
            }
        }
        if (input.readBoolean()) {
            this.backendRoles = input.readList(StreamInput::readString);
        }
        this.addAllBackendRoles = input.readOptionalBoolean();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        this.dryRun = input.readBoolean();
        this.updateConnector = input.readBoolean();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG) && input.readBoolean()) {
            this.connectorClientConfig = new ConnectorClientConfig(input);
        }
    }

    @Generated
    public static MLCreateConnectorInputBuilder builder() {
        return new MLCreateConnectorInputBuilder();
    }

    @Generated
    public MLCreateConnectorInputBuilder toBuilder() {
        return new MLCreateConnectorInputBuilder().name(this.name).description(this.description).version(this.version).protocol(this.protocol).parameters(this.parameters).credential(this.credential).actions(this.actions).backendRoles(this.backendRoles).addAllBackendRoles(this.addAllBackendRoles).access(this.access).dryRun(this.dryRun).updateConnector(this.updateConnector).connectorClientConfig(this.connectorClientConfig);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, String> getCredential() {
        return this.credential;
    }

    @Generated
    public List<ConnectorAction> getActions() {
        return this.actions;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public Boolean getAddAllBackendRoles() {
        return this.addAllBackendRoles;
    }

    @Generated
    public AccessMode getAccess() {
        return this.access;
    }

    @Generated
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Generated
    public boolean isUpdateConnector() {
        return this.updateConnector;
    }

    @Generated
    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setCredential(Map<String, String> credential) {
        this.credential = credential;
    }

    @Generated
    public void setActions(List<ConnectorAction> actions) {
        this.actions = actions;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.addAllBackendRoles = addAllBackendRoles;
    }

    @Generated
    public void setAccess(AccessMode access) {
        this.access = access;
    }

    @Generated
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Generated
    public void setUpdateConnector(boolean updateConnector) {
        this.updateConnector = updateConnector;
    }

    @Generated
    public void setConnectorClientConfig(ConnectorClientConfig connectorClientConfig) {
        this.connectorClientConfig = connectorClientConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLCreateConnectorInput)) {
            return false;
        }
        MLCreateConnectorInput other = (MLCreateConnectorInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isUpdateConnector() != other.isUpdateConnector()) {
            return false;
        }
        Boolean this$addAllBackendRoles = this.getAddAllBackendRoles();
        Boolean other$addAllBackendRoles = other.getAddAllBackendRoles();
        if (this$addAllBackendRoles == null ? other$addAllBackendRoles != null : !((Object)this$addAllBackendRoles).equals(other$addAllBackendRoles)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, String> this$credential = this.getCredential();
        Map<String, String> other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        List<ConnectorAction> this$actions = this.getActions();
        List<ConnectorAction> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        if (this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles)) {
            return false;
        }
        AccessMode this$access = this.getAccess();
        AccessMode other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)((Object)this$access)).equals((Object)other$access)) {
            return false;
        }
        ConnectorClientConfig this$connectorClientConfig = this.getConnectorClientConfig();
        ConnectorClientConfig other$connectorClientConfig = other.getConnectorClientConfig();
        return !(this$connectorClientConfig == null ? other$connectorClientConfig != null : !((Object)this$connectorClientConfig).equals(other$connectorClientConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLCreateConnectorInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isUpdateConnector() ? 79 : 97);
        Boolean $addAllBackendRoles = this.getAddAllBackendRoles();
        result = result * 59 + ($addAllBackendRoles == null ? 43 : ((Object)$addAllBackendRoles).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, String> $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        List<ConnectorAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        AccessMode $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)((Object)$access)).hashCode());
        ConnectorClientConfig $connectorClientConfig = this.getConnectorClientConfig();
        result = result * 59 + ($connectorClientConfig == null ? 43 : ((Object)$connectorClientConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLCreateConnectorInput(name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", protocol=" + this.getProtocol() + ", parameters=" + String.valueOf(this.getParameters()) + ", credential=" + String.valueOf(this.getCredential()) + ", actions=" + String.valueOf(this.getActions()) + ", backendRoles=" + String.valueOf(this.getBackendRoles()) + ", addAllBackendRoles=" + this.getAddAllBackendRoles() + ", access=" + String.valueOf((Object)this.getAccess()) + ", dryRun=" + this.isDryRun() + ", updateConnector=" + this.isUpdateConnector() + ", connectorClientConfig=" + String.valueOf(this.getConnectorClientConfig()) + ")";
    }

    @Generated
    public static class MLCreateConnectorInputBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String protocol;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private Map<String, String> credential;
        @Generated
        private List<ConnectorAction> actions;
        @Generated
        private List<String> backendRoles;
        @Generated
        private Boolean addAllBackendRoles;
        @Generated
        private AccessMode access;
        @Generated
        private boolean dryRun;
        @Generated
        private boolean updateConnector;
        @Generated
        private ConnectorClientConfig connectorClientConfig;

        @Generated
        MLCreateConnectorInputBuilder() {
        }

        @Generated
        public MLCreateConnectorInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder addAllBackendRoles(Boolean addAllBackendRoles) {
            this.addAllBackendRoles = addAllBackendRoles;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder access(AccessMode access) {
            this.access = access;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder updateConnector(boolean updateConnector) {
            this.updateConnector = updateConnector;
            return this;
        }

        @Generated
        public MLCreateConnectorInputBuilder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        @Generated
        public MLCreateConnectorInput build() {
            return new MLCreateConnectorInput(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.addAllBackendRoles, this.access, this.dryRun, this.updateConnector, this.connectorClientConfig);
        }

        @Generated
        public String toString() {
            return "MLCreateConnectorInput.MLCreateConnectorInputBuilder(name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", protocol=" + this.protocol + ", parameters=" + String.valueOf(this.parameters) + ", credential=" + String.valueOf(this.credential) + ", actions=" + String.valueOf(this.actions) + ", backendRoles=" + String.valueOf(this.backendRoles) + ", addAllBackendRoles=" + this.addAllBackendRoles + ", access=" + String.valueOf((Object)this.access) + ", dryRun=" + this.dryRun + ", updateConnector=" + this.updateConnector + ", connectorClientConfig=" + String.valueOf(this.connectorClientConfig) + ")";
        }
    }
}

