/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.span;

import lombok.Generated;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.planner.physical.collector.Rounding;

public class SpanExpression
implements Expression {
    private final Expression field;
    private final Expression value;
    private final SpanUnit unit;

    public SpanExpression(Expression field, Expression value, SpanUnit unit) {
        this.field = field;
        this.value = value;
        this.unit = unit;
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        Rounding<?> rounding = Rounding.createRounding(this);
        return rounding.round(this.field.valueOf(valueEnv));
    }

    @Override
    public ExprType type() {
        if (this.field.type().isCompatible(this.value.type())) {
            return this.field.type();
        }
        if (this.value.type().isCompatible(this.field.type())) {
            return this.value.type();
        }
        return this.field.type();
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitNode(this, context);
    }

    @Generated
    public Expression getField() {
        return this.field;
    }

    @Generated
    public Expression getValue() {
        return this.value;
    }

    @Generated
    public SpanUnit getUnit() {
        return this.unit;
    }

    @Generated
    public String toString() {
        return "SpanExpression(field=" + this.getField() + ", value=" + this.getValue() + ", unit=" + this.getUnit() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpanExpression)) {
            return false;
        }
        SpanExpression other = (SpanExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$field = this.getField();
        Expression other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        Expression this$value = this.getValue();
        Expression other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        SpanUnit this$unit = this.getUnit();
        SpanUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpanExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        Expression $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        SpanUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        return result;
    }
}

