/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.SortHelper;

public class SortOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<Pair<Sort.SortOption, Expression>> sortList;
    private final Comparator<ExprValue> sorter;
    private Iterator<ExprValue> iterator;

    public SortOperator(PhysicalPlan input, List<Pair<Sort.SortOption, Expression>> sortList) {
        this.input = input;
        this.sortList = sortList;
        this.sorter = SortHelper.constructExprComparator(sortList);
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    public void open() {
        super.open();
        PriorityQueue<ExprValue> sorted = new PriorityQueue<ExprValue>(1, this.sorter::compare);
        while (this.input.hasNext()) {
            sorted.add((ExprValue)this.input.next());
        }
        this.iterator = this.iterator(sorted);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }

    private Iterator<ExprValue> iterator(final PriorityQueue<ExprValue> result) {
        return new Iterator<ExprValue>(){

            @Override
            public boolean hasNext() {
                return !result.isEmpty();
            }

            @Override
            public ExprValue next() {
                return (ExprValue)result.poll();
            }
        };
    }

    @Generated
    public String toString() {
        return "SortOperator(input=" + this.getInput() + ", sortList=" + this.getSortList() + ", sorter=" + this.sorter + ", iterator=" + this.iterator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOperator)) {
            return false;
        }
        SortOperator other = (SortOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<Pair<Sort.SortOption, Expression>> this$sortList = this.getSortList();
        List<Pair<Sort.SortOption, Expression>> other$sortList = other.getSortList();
        return !(this$sortList == null ? other$sortList != null : !((Object)this$sortList).equals(other$sortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<Pair<Sort.SortOption, Expression>> $sortList = this.getSortList();
        result = result * 59 + ($sortList == null ? 43 : ((Object)$sortList).hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<Pair<Sort.SortOption, Expression>> getSortList() {
        return this.sortList;
    }
}

