/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.text.StringLocated;

public class ArobaseStringCompressor
implements StringCompressor {
    private static final Pattern2 pattern = MyPattern.cmpile("(?s)^[%s]*(@startuml[^\\n\\r]*)?[%s]*(.*?)[%s]*(@enduml)?[%s]*$");

    @Override
    public String compress(String data) throws IOException {
        UncommentReadLine r = new UncommentReadLine(ReadLineReader.create(new StringReader(data), "COMPRESS"));
        StringBuilder sb = new StringBuilder();
        StringBuilder full = new StringBuilder();
        StringLocated s2 = null;
        boolean startDone = false;
        while ((s2 = r.readLine()) != null) {
            this.append(full, s2);
            if (s2.getString().startsWith("@startuml")) {
                startDone = true;
                continue;
            }
            if (s2.getString().startsWith("@enduml")) {
                return sb.toString();
            }
            if (!startDone) continue;
            this.append(sb, s2);
        }
        if (!startDone) {
            return this.compressOld(full.toString());
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, StringLocated s2) {
        if (sb.length() > 0) {
            sb.append('\n');
        }
        sb.append(s2.getString());
    }

    private String compressOld(String s2) throws IOException {
        Matcher2 m4 = pattern.matcher(s2);
        if (m4.find()) {
            return this.clean(m4.group(2));
        }
        return "";
    }

    @Override
    public String decompress(String s2) {
        String result = this.clean(s2);
        if (result.startsWith("@start")) {
            return result;
        }
        result = "@startuml\n" + result;
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        result = result + "@enduml";
        return result;
    }

    private String clean(String s2) {
        s2 = StringUtils.trin(s2);
        s2 = this.clean1(s2);
        s2 = s2.replaceAll("@enduml[^\\n\\r]*", "");
        s2 = s2.replaceAll("@startuml[^\\n\\r]*", "");
        s2 = StringUtils.trin(s2);
        return s2;
    }

    private String clean1(String s2) {
        Matcher2 m4 = pattern.matcher(s2);
        if (m4.matches()) {
            return m4.group(2);
        }
        return s2;
    }
}

