/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    public static final String ALL_TYPES = "person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|action|process|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout";
    private static final String CODE_CORE = "[%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]";
    public static final String CODE = "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])";
    public static final String CODE_WITH_QUOTE = "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])";
    private static final String DISPLAY_CORE = "[%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]";
    public static final String DISPLAY = "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])";
    public static final String DISPLAY_WITHOUT_QUOTE = "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%pLN_.]+)";

    public CommandCreateElementFull() {
        super(CommandCreateElementFull.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateElementFull.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "(?:(person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|action|process|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout|\\(\\))[%s]+)?"), CommandCreateElementFull.color2().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), StereotypePattern.optional("STEREOTYPE2"), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), StereotypePattern.optional("STEREOTYPE3"), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), StereotypePattern.optional("STEREOTYPE4"), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE4", CODE))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), CommandCreateElementFull.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private static ColorParser color2() {
        return ColorParser.simpleColor(ColorType.BACK, "COLOR2");
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        HColor lineColor;
        USymbol usymbol;
        LeafType type;
        String symbol;
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else if (codeChar == '(' || codeDisplay == '(') {
            if (arg.get("SYMBOL", 0) != null && arg.get("SYMBOL", 0).endsWith("/")) {
                symbol = "usecase/";
            } else if (displayRaw != null && displayRaw.endsWith(")/")) {
                displayRaw = displayRaw.substring(0, displayRaw.length() - 1);
                symbol = "usecase/";
            } else if (codeRaw.endsWith(")/")) {
                codeRaw = codeRaw.substring(0, codeRaw.length() - 1);
                symbol = "usecase/";
            } else {
                symbol = "usecase";
            }
        } else if (codeChar == ':' || codeDisplay == ':') {
            if (arg.get("SYMBOL", 0) != null && arg.get("SYMBOL", 0).endsWith("/")) {
                symbol = "actor/";
            } else if (displayRaw != null && displayRaw.endsWith(":/")) {
                displayRaw = displayRaw.substring(0, displayRaw.length() - 1);
                symbol = "actor/";
            } else if (codeRaw.endsWith(":/")) {
                codeRaw = codeRaw.substring(0, codeRaw.length() - 1);
                symbol = "actor/";
            } else {
                symbol = "actor";
            }
        } else {
            symbol = codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0);
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = diagram.getSkinParam().actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("portin")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portout")) {
            type = LeafType.PORTOUT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("port")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase/")) {
            type = LeafType.USECASE_BUSINESS;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("circle")) {
            type = LeafType.CIRCLE;
            usymbol = null;
        } else {
            type = LeafType.DESCRIPTION;
            usymbol = USymbols.fromString(symbol, diagram.getSkinParam());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
        }
        Quark<Entity> quark = diagram.quarkInContext(false, diagram.cleanId(codeRaw));
        if (diagram.isGroup(quark)) {
            return CommandExecutionResult.error("This element (" + quark.getName() + ") is already defined");
        }
        String display = displayRaw;
        if (display == null) {
            display = quark.getName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (CommandCreateElementFull.existsWithBadType3(diagram, quark, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + quark.getName() + ") is already defined");
        }
        if ((type == LeafType.PORTIN || type == LeafType.PORTOUT) && diagram.getCurrentGroup().isRoot()) {
            return CommandExecutionResult.error("Port can only be used inside an element and not at root level");
        }
        Entity entity = quark.getData();
        if (entity == null) {
            entity = diagram.reallyCreateLeaf(quark, Display.getWithNewlines(diagram.getPragma(), display), type, usymbol);
        }
        entity.setDisplay(Display.getWithNewlines(diagram.getPragma(), display));
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        CommandCreateClassMultilines.addTags(entity, arg.getLazzy("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        Colors colors = CommandCreateElementFull.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String s2 = arg.get("LINECOLOR", 1);
        HColor hColor = lineColor = s2 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }

    public static boolean existsWithBadType3(AbstractEntityDiagram diagram, Quark<Entity> code, LeafType type, USymbol usymbol) {
        if (code.getData() == null) {
            return false;
        }
        Entity other = code.getData();
        if (other.getLeafType() != type) {
            return true;
        }
        return usymbol != null && other.getUSymbol() != usymbol;
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }
}

