// Code generated by wit-bindgen-go. DO NOT EDIT.

// Package types represents the imported interface "wasi:filesystem/types@0.2.0".
//
// WASI filesystem is a filesystem API primarily intended to let users run WASI
// programs that access their files on their existing filesystems, without
// significant overhead.
//
// It is intended to be roughly portable between Unix-family platforms and
// Windows, though it does not hide many of the major differences.
//
// Paths are passed as interface-type `string`s, meaning they must consist of
// a sequence of Unicode Scalar Values (USVs). Some filesystems may contain
// paths which are not accessible by this API.
//
// The directory separator in WASI is always the forward-slash (`/`).
//
// All paths in WASI are relative paths, and are interpreted relative to a
// `descriptor` referring to a base directory. If a `path` argument to any WASI
// function starts with `/`, or if any step of resolving a `path`, including
// `..` and symbolic link steps, reaches a directory outside of the base
// directory, or reaches a symlink to an absolute or rooted path in the
// underlying filesystem, the function fails with `error-code::not-permitted`.
//
// For more information about WASI path resolution and sandboxing, see
// [WASI filesystem path resolution].
//
// [WASI filesystem path resolution]: https://github.com/WebAssembly/wasi-filesystem/blob/main/path-resolution.md
package types

import (
	"internal/cm"
	wallclock "internal/wasi/clocks/v0.2.0/wall-clock"
	"internal/wasi/io/v0.2.0/streams"
)

// InputStream represents the imported type alias "wasi:filesystem/types@0.2.0#input-stream".
//
// See [streams.InputStream] for more information.
type InputStream = streams.InputStream

// OutputStream represents the imported type alias "wasi:filesystem/types@0.2.0#output-stream".
//
// See [streams.OutputStream] for more information.
type OutputStream = streams.OutputStream

// Error represents the imported type alias "wasi:filesystem/types@0.2.0#error".
//
// See [streams.Error] for more information.
type Error = streams.Error

// DateTime represents the type alias "wasi:filesystem/types@0.2.0#datetime".
//
// See [wallclock.DateTime] for more information.
type DateTime = wallclock.DateTime

// FileSize represents the u64 "wasi:filesystem/types@0.2.0#filesize".
//
// File size or length of a region within a file.
//
//	type filesize = u64
type FileSize uint64

// DescriptorType represents the enum "wasi:filesystem/types@0.2.0#descriptor-type".
//
// The type of a filesystem object referenced by a descriptor.
//
// Note: This was called `filetype` in earlier versions of WASI.
//
//	enum descriptor-type {
//		unknown,
//		block-device,
//		character-device,
//		directory,
//		fifo,
//		symbolic-link,
//		regular-file,
//		socket
//	}
type DescriptorType uint8

const (
	// The type of the descriptor or file is unknown or is different from
	// any of the other types specified.
	DescriptorTypeUnknown DescriptorType = iota

	// The descriptor refers to a block device inode.
	DescriptorTypeBlockDevice

	// The descriptor refers to a character device inode.
	DescriptorTypeCharacterDevice

	// The descriptor refers to a directory inode.
	DescriptorTypeDirectory

	// The descriptor refers to a named pipe.
	DescriptorTypeFIFO

	// The file refers to a symbolic link inode.
	DescriptorTypeSymbolicLink

	// The descriptor refers to a regular file inode.
	DescriptorTypeRegularFile

	// The descriptor refers to a socket.
	DescriptorTypeSocket
)

var stringsDescriptorType = [8]string{
	"unknown",
	"block-device",
	"character-device",
	"directory",
	"fifo",
	"symbolic-link",
	"regular-file",
	"socket",
}

// String implements [fmt.Stringer], returning the enum case name of e.
func (e DescriptorType) String() string {
	return stringsDescriptorType[e]
}

// DescriptorFlags represents the flags "wasi:filesystem/types@0.2.0#descriptor-flags".
//
// Descriptor flags.
//
// Note: This was called `fdflags` in earlier versions of WASI.
//
//	flags descriptor-flags {
//		read,
//		write,
//		file-integrity-sync,
//		data-integrity-sync,
//		requested-write-sync,
//		mutate-directory,
//	}
type DescriptorFlags uint8

const (
	// Read mode: Data can be read.
	DescriptorFlagsRead DescriptorFlags = 1 << iota

	// Write mode: Data can be written to.
	DescriptorFlagsWrite

	// Request that writes be performed according to synchronized I/O file
	// integrity completion. The data stored in the file and the file's
	// metadata are synchronized. This is similar to `O_SYNC` in POSIX.
	//
	// The precise semantics of this operation have not yet been defined for
	// WASI. At this time, it should be interpreted as a request, and not a
	// requirement.
	DescriptorFlagsFileIntegritySync

	// Request that writes be performed according to synchronized I/O data
	// integrity completion. Only the data stored in the file is
	// synchronized. This is similar to `O_DSYNC` in POSIX.
	//
	// The precise semantics of this operation have not yet been defined for
	// WASI. At this time, it should be interpreted as a request, and not a
	// requirement.
	DescriptorFlagsDataIntegritySync

	// Requests that reads be performed at the same level of integrety
	// requested for writes. This is similar to `O_RSYNC` in POSIX.
	//
	// The precise semantics of this operation have not yet been defined for
	// WASI. At this time, it should be interpreted as a request, and not a
	// requirement.
	DescriptorFlagsRequestedWriteSync

	// Mutating directories mode: Directory contents may be mutated.
	//
	// When this flag is unset on a descriptor, operations using the
	// descriptor which would create, rename, delete, modify the data or
	// metadata of filesystem objects, or obtain another handle which
	// would permit any of those, shall fail with `error-code::read-only` if
	// they would otherwise succeed.
	//
	// This may only be set on directories.
	DescriptorFlagsMutateDirectory
)

// PathFlags represents the flags "wasi:filesystem/types@0.2.0#path-flags".
//
// Flags determining the method of how paths are resolved.
//
//	flags path-flags {
//		symlink-follow,
//	}
type PathFlags uint8

const (
	// As long as the resolved path corresponds to a symbolic link, it is
	// expanded.
	PathFlagsSymlinkFollow PathFlags = 1 << iota
)

// OpenFlags represents the flags "wasi:filesystem/types@0.2.0#open-flags".
//
// Open flags used by `open-at`.
//
//	flags open-flags {
//		create,
//		directory,
//		exclusive,
//		truncate,
//	}
type OpenFlags uint8

const (
	// Create file if it does not exist, similar to `O_CREAT` in POSIX.
	OpenFlagsCreate OpenFlags = 1 << iota

	// Fail if not a directory, similar to `O_DIRECTORY` in POSIX.
	OpenFlagsDirectory

	// Fail if file already exists, similar to `O_EXCL` in POSIX.
	OpenFlagsExclusive

	// Truncate file to size 0, similar to `O_TRUNC` in POSIX.
	OpenFlagsTruncate
)

// LinkCount represents the u64 "wasi:filesystem/types@0.2.0#link-count".
//
// Number of hard links to an inode.
//
//	type link-count = u64
type LinkCount uint64

// DescriptorStat represents the record "wasi:filesystem/types@0.2.0#descriptor-stat".
//
// File attributes.
//
// Note: This was called `filestat` in earlier versions of WASI.
//
//	record descriptor-stat {
//		%type: descriptor-type,
//		link-count: link-count,
//		size: filesize,
//		data-access-timestamp: option<datetime>,
//		data-modification-timestamp: option<datetime>,
//		status-change-timestamp: option<datetime>,
//	}
type DescriptorStat struct {
	_ cm.HostLayout
	// File type.
	Type DescriptorType

	// Number of hard links to the file.
	LinkCount LinkCount

	// For regular files, the file size in bytes. For symbolic links, the
	// length in bytes of the pathname contained in the symbolic link.
	Size FileSize

	// Last data access timestamp.
	//
	// If the `option` is none, the platform doesn't maintain an access
	// timestamp for this file.
	DataAccessTimestamp cm.Option[DateTime]

	// Last data modification timestamp.
	//
	// If the `option` is none, the platform doesn't maintain a
	// modification timestamp for this file.
	DataModificationTimestamp cm.Option[DateTime]

	// Last file status-change timestamp.
	//
	// If the `option` is none, the platform doesn't maintain a
	// status-change timestamp for this file.
	StatusChangeTimestamp cm.Option[DateTime]
}

// NewTimestamp represents the variant "wasi:filesystem/types@0.2.0#new-timestamp".
//
// When setting a timestamp, this gives the value to set it to.
//
//	variant new-timestamp {
//		no-change,
//		now,
//		timestamp(datetime),
//	}
type NewTimestamp cm.Variant[uint8, DateTime, DateTime]

// NewTimestampNoChange returns a [NewTimestamp] of case "no-change".
//
// Leave the timestamp set to its previous value.
func NewTimestampNoChange() NewTimestamp {
	var data struct{}
	return cm.New[NewTimestamp](0, data)
}

// NoChange returns true if [NewTimestamp] represents the variant case "no-change".
func (self *NewTimestamp) NoChange() bool {
	return self.Tag() == 0
}

// NewTimestampNow returns a [NewTimestamp] of case "now".
//
// Set the timestamp to the current time of the system clock associated
// with the filesystem.
func NewTimestampNow() NewTimestamp {
	var data struct{}
	return cm.New[NewTimestamp](1, data)
}

// Now returns true if [NewTimestamp] represents the variant case "now".
func (self *NewTimestamp) Now() bool {
	return self.Tag() == 1
}

// NewTimestampTimestamp returns a [NewTimestamp] of case "timestamp".
//
// Set the timestamp to the given value.
func NewTimestampTimestamp(data DateTime) NewTimestamp {
	return cm.New[NewTimestamp](2, data)
}

// Timestamp returns a non-nil *[DateTime] if [NewTimestamp] represents the variant case "timestamp".
func (self *NewTimestamp) Timestamp() *DateTime {
	return cm.Case[DateTime](self, 2)
}

var stringsNewTimestamp = [3]string{
	"no-change",
	"now",
	"timestamp",
}

// String implements [fmt.Stringer], returning the variant case name of v.
func (v NewTimestamp) String() string {
	return stringsNewTimestamp[v.Tag()]
}

// DirectoryEntry represents the record "wasi:filesystem/types@0.2.0#directory-entry".
//
// A directory entry.
//
//	record directory-entry {
//		%type: descriptor-type,
//		name: string,
//	}
type DirectoryEntry struct {
	_ cm.HostLayout
	// The type of the file referred to by this directory entry.
	Type DescriptorType

	// The name of the object.
	Name string
}

// ErrorCode represents the enum "wasi:filesystem/types@0.2.0#error-code".
//
// Error codes returned by functions, similar to `errno` in POSIX.
// Not all of these error codes are returned by the functions provided by this
// API; some are used in higher-level library layers, and others are provided
// merely for alignment with POSIX.
//
//	enum error-code {
//		access,
//		would-block,
//		already,
//		bad-descriptor,
//		busy,
//		deadlock,
//		quota,
//		exist,
//		file-too-large,
//		illegal-byte-sequence,
//		in-progress,
//		interrupted,
//		invalid,
//		io,
//		is-directory,
//		loop,
//		too-many-links,
//		message-size,
//		name-too-long,
//		no-device,
//		no-entry,
//		no-lock,
//		insufficient-memory,
//		insufficient-space,
//		not-directory,
//		not-empty,
//		not-recoverable,
//		unsupported,
//		no-tty,
//		no-such-device,
//		overflow,
//		not-permitted,
//		pipe,
//		read-only,
//		invalid-seek,
//		text-file-busy,
//		cross-device
//	}
type ErrorCode uint8

const (
	// Permission denied, similar to `EACCES` in POSIX.
	ErrorCodeAccess ErrorCode = iota

	// Resource unavailable, or operation would block, similar to `EAGAIN` and `EWOULDBLOCK`
	// in POSIX.
	ErrorCodeWouldBlock

	// Connection already in progress, similar to `EALREADY` in POSIX.
	ErrorCodeAlready

	// Bad descriptor, similar to `EBADF` in POSIX.
	ErrorCodeBadDescriptor

	// Device or resource busy, similar to `EBUSY` in POSIX.
	ErrorCodeBusy

	// Resource deadlock would occur, similar to `EDEADLK` in POSIX.
	ErrorCodeDeadlock

	// Storage quota exceeded, similar to `EDQUOT` in POSIX.
	ErrorCodeQuota

	// File exists, similar to `EEXIST` in POSIX.
	ErrorCodeExist

	// File too large, similar to `EFBIG` in POSIX.
	ErrorCodeFileTooLarge

	// Illegal byte sequence, similar to `EILSEQ` in POSIX.
	ErrorCodeIllegalByteSequence

	// Operation in progress, similar to `EINPROGRESS` in POSIX.
	ErrorCodeInProgress

	// Interrupted function, similar to `EINTR` in POSIX.
	ErrorCodeInterrupted

	// Invalid argument, similar to `EINVAL` in POSIX.
	ErrorCodeInvalid

	// I/O error, similar to `EIO` in POSIX.
	ErrorCodeIO

	// Is a directory, similar to `EISDIR` in POSIX.
	ErrorCodeIsDirectory

	// Too many levels of symbolic links, similar to `ELOOP` in POSIX.
	ErrorCodeLoop

	// Too many links, similar to `EMLINK` in POSIX.
	ErrorCodeTooManyLinks

	// Message too large, similar to `EMSGSIZE` in POSIX.
	ErrorCodeMessageSize

	// Filename too long, similar to `ENAMETOOLONG` in POSIX.
	ErrorCodeNameTooLong

	// No such device, similar to `ENODEV` in POSIX.
	ErrorCodeNoDevice

	// No such file or directory, similar to `ENOENT` in POSIX.
	ErrorCodeNoEntry

	// No locks available, similar to `ENOLCK` in POSIX.
	ErrorCodeNoLock

	// Not enough space, similar to `ENOMEM` in POSIX.
	ErrorCodeInsufficientMemory

	// No space left on device, similar to `ENOSPC` in POSIX.
	ErrorCodeInsufficientSpace

	// Not a directory or a symbolic link to a directory, similar to `ENOTDIR` in POSIX.
	ErrorCodeNotDirectory

	// Directory not empty, similar to `ENOTEMPTY` in POSIX.
	ErrorCodeNotEmpty

	// State not recoverable, similar to `ENOTRECOVERABLE` in POSIX.
	ErrorCodeNotRecoverable

	// Not supported, similar to `ENOTSUP` and `ENOSYS` in POSIX.
	ErrorCodeUnsupported

	// Inappropriate I/O control operation, similar to `ENOTTY` in POSIX.
	ErrorCodeNoTTY

	// No such device or address, similar to `ENXIO` in POSIX.
	ErrorCodeNoSuchDevice

	// Value too large to be stored in data type, similar to `EOVERFLOW` in POSIX.
	ErrorCodeOverflow

	// Operation not permitted, similar to `EPERM` in POSIX.
	ErrorCodeNotPermitted

	// Broken pipe, similar to `EPIPE` in POSIX.
	ErrorCodePipe

	// Read-only file system, similar to `EROFS` in POSIX.
	ErrorCodeReadOnly

	// Invalid seek, similar to `ESPIPE` in POSIX.
	ErrorCodeInvalidSeek

	// Text file busy, similar to `ETXTBSY` in POSIX.
	ErrorCodeTextFileBusy

	// Cross-device link, similar to `EXDEV` in POSIX.
	ErrorCodeCrossDevice
)

var stringsErrorCode = [37]string{
	"access",
	"would-block",
	"already",
	"bad-descriptor",
	"busy",
	"deadlock",
	"quota",
	"exist",
	"file-too-large",
	"illegal-byte-sequence",
	"in-progress",
	"interrupted",
	"invalid",
	"io",
	"is-directory",
	"loop",
	"too-many-links",
	"message-size",
	"name-too-long",
	"no-device",
	"no-entry",
	"no-lock",
	"insufficient-memory",
	"insufficient-space",
	"not-directory",
	"not-empty",
	"not-recoverable",
	"unsupported",
	"no-tty",
	"no-such-device",
	"overflow",
	"not-permitted",
	"pipe",
	"read-only",
	"invalid-seek",
	"text-file-busy",
	"cross-device",
}

// String implements [fmt.Stringer], returning the enum case name of e.
func (e ErrorCode) String() string {
	return stringsErrorCode[e]
}

// Advice represents the enum "wasi:filesystem/types@0.2.0#advice".
//
// File or memory access pattern advisory information.
//
//	enum advice {
//		normal,
//		sequential,
//		random,
//		will-need,
//		dont-need,
//		no-reuse
//	}
type Advice uint8

const (
	// The application has no advice to give on its behavior with respect
	// to the specified data.
	AdviceNormal Advice = iota

	// The application expects to access the specified data sequentially
	// from lower offsets to higher offsets.
	AdviceSequential

	// The application expects to access the specified data in a random
	// order.
	AdviceRandom

	// The application expects to access the specified data in the near
	// future.
	AdviceWillNeed

	// The application expects that it will not access the specified data
	// in the near future.
	AdviceDontNeed

	// The application expects to access the specified data once and then
	// not reuse it thereafter.
	AdviceNoReuse
)

var stringsAdvice = [6]string{
	"normal",
	"sequential",
	"random",
	"will-need",
	"dont-need",
	"no-reuse",
}

// String implements [fmt.Stringer], returning the enum case name of e.
func (e Advice) String() string {
	return stringsAdvice[e]
}

// MetadataHashValue represents the record "wasi:filesystem/types@0.2.0#metadata-hash-value".
//
// A 128-bit hash value, split into parts because wasm doesn't have a
// 128-bit integer type.
//
//	record metadata-hash-value {
//		lower: u64,
//		upper: u64,
//	}
type MetadataHashValue struct {
	_ cm.HostLayout
	// 64 bits of a 128-bit hash value.
	Lower uint64

	// Another 64 bits of a 128-bit hash value.
	Upper uint64
}

// Descriptor represents the imported resource "wasi:filesystem/types@0.2.0#descriptor".
//
// A descriptor is a reference to a filesystem object, which may be a file,
// directory, named pipe, special file, or other object on which filesystem
// calls may be made.
//
//	resource descriptor
type Descriptor cm.Resource

// ResourceDrop represents the imported resource-drop for resource "descriptor".
//
// Drops a resource handle.
//
//go:nosplit
func (self Descriptor) ResourceDrop() {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorResourceDrop((uint32)(self0))
	return
}

// Advise represents the imported method "advise".
//
// Provide file advisory information on a descriptor.
//
// This is similar to `posix_fadvise` in POSIX.
//
//	advise: func(offset: filesize, length: filesize, advice: advice) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) Advise(offset FileSize, length FileSize, advice Advice) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	offset0 := (uint64)(offset)
	length0 := (uint64)(length)
	advice0 := (uint32)(advice)
	wasmimport_DescriptorAdvise((uint32)(self0), (uint64)(offset0), (uint64)(length0), (uint32)(advice0), &result)
	return
}

// AppendViaStream represents the imported method "append-via-stream".
//
// Return a stream for appending to a file, if available.
//
// May fail with an error-code describing why the file cannot be appended.
//
// Note: This allows using `write-stream`, which is similar to `write` with
// `O_APPEND` in in POSIX.
//
//	append-via-stream: func() -> result<output-stream, error-code>
//
//go:nosplit
func (self Descriptor) AppendViaStream() (result cm.Result[OutputStream, OutputStream, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorAppendViaStream((uint32)(self0), &result)
	return
}

// CreateDirectoryAt represents the imported method "create-directory-at".
//
// Create a directory.
//
// Note: This is similar to `mkdirat` in POSIX.
//
//	create-directory-at: func(path: string) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) CreateDirectoryAt(path string) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	path0, path1 := cm.LowerString(path)
	wasmimport_DescriptorCreateDirectoryAt((uint32)(self0), (*uint8)(path0), (uint32)(path1), &result)
	return
}

// GetFlags represents the imported method "get-flags".
//
// Get flags associated with a descriptor.
//
// Note: This returns similar flags to `fcntl(fd, F_GETFL)` in POSIX.
//
// Note: This returns the value that was the `fs_flags` value returned
// from `fdstat_get` in earlier versions of WASI.
//
//	get-flags: func() -> result<descriptor-flags, error-code>
//
//go:nosplit
func (self Descriptor) GetFlags() (result cm.Result[DescriptorFlags, DescriptorFlags, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorGetFlags((uint32)(self0), &result)
	return
}

// GetType represents the imported method "get-type".
//
// Get the dynamic type of a descriptor.
//
// Note: This returns the same value as the `type` field of the `fd-stat`
// returned by `stat`, `stat-at` and similar.
//
// Note: This returns similar flags to the `st_mode & S_IFMT` value provided
// by `fstat` in POSIX.
//
// Note: This returns the value that was the `fs_filetype` value returned
// from `fdstat_get` in earlier versions of WASI.
//
//	get-type: func() -> result<descriptor-type, error-code>
//
//go:nosplit
func (self Descriptor) GetType() (result cm.Result[DescriptorType, DescriptorType, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorGetType((uint32)(self0), &result)
	return
}

// IsSameObject represents the imported method "is-same-object".
//
// Test whether two descriptors refer to the same filesystem object.
//
// In POSIX, this corresponds to testing whether the two descriptors have the
// same device (`st_dev`) and inode (`st_ino` or `d_ino`) numbers.
// wasi-filesystem does not expose device and inode numbers, so this function
// may be used instead.
//
//	is-same-object: func(other: borrow<descriptor>) -> bool
//
//go:nosplit
func (self Descriptor) IsSameObject(other Descriptor) (result bool) {
	self0 := cm.Reinterpret[uint32](self)
	other0 := cm.Reinterpret[uint32](other)
	result0 := wasmimport_DescriptorIsSameObject((uint32)(self0), (uint32)(other0))
	result = cm.U32ToBool((uint32)(result0))
	return
}

// LinkAt represents the imported method "link-at".
//
// Create a hard link.
//
// Note: This is similar to `linkat` in POSIX.
//
//	link-at: func(old-path-flags: path-flags, old-path: string, new-descriptor: borrow<descriptor>,
//	new-path: string) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) LinkAt(oldPathFlags PathFlags, oldPath string, newDescriptor Descriptor, newPath string) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	oldPathFlags0 := (uint32)(oldPathFlags)
	oldPath0, oldPath1 := cm.LowerString(oldPath)
	newDescriptor0 := cm.Reinterpret[uint32](newDescriptor)
	newPath0, newPath1 := cm.LowerString(newPath)
	wasmimport_DescriptorLinkAt((uint32)(self0), (uint32)(oldPathFlags0), (*uint8)(oldPath0), (uint32)(oldPath1), (uint32)(newDescriptor0), (*uint8)(newPath0), (uint32)(newPath1), &result)
	return
}

// MetadataHash represents the imported method "metadata-hash".
//
// Return a hash of the metadata associated with a filesystem object referred
// to by a descriptor.
//
// This returns a hash of the last-modification timestamp and file size, and
// may also include the inode number, device number, birth timestamp, and
// other metadata fields that may change when the file is modified or
// replaced. It may also include a secret value chosen by the
// implementation and not otherwise exposed.
//
// Implementations are encourated to provide the following properties:
//
// - If the file is not modified or replaced, the computed hash value should
// usually not change.
// - If the object is modified or replaced, the computed hash value should
// usually change.
// - The inputs to the hash should not be easily computable from the
// computed hash.
//
// However, none of these is required.
//
//	metadata-hash: func() -> result<metadata-hash-value, error-code>
//
//go:nosplit
func (self Descriptor) MetadataHash() (result cm.Result[MetadataHashValueShape, MetadataHashValue, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorMetadataHash((uint32)(self0), &result)
	return
}

// MetadataHashAt represents the imported method "metadata-hash-at".
//
// Return a hash of the metadata associated with a filesystem object referred
// to by a directory descriptor and a relative path.
//
// This performs the same hash computation as `metadata-hash`.
//
//	metadata-hash-at: func(path-flags: path-flags, path: string) -> result<metadata-hash-value,
//	error-code>
//
//go:nosplit
func (self Descriptor) MetadataHashAt(pathFlags PathFlags, path string) (result cm.Result[MetadataHashValueShape, MetadataHashValue, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	pathFlags0 := (uint32)(pathFlags)
	path0, path1 := cm.LowerString(path)
	wasmimport_DescriptorMetadataHashAt((uint32)(self0), (uint32)(pathFlags0), (*uint8)(path0), (uint32)(path1), &result)
	return
}

// OpenAt represents the imported method "open-at".
//
// Open a file or directory.
//
// The returned descriptor is not guaranteed to be the lowest-numbered
// descriptor not currently open/ it is randomized to prevent applications
// from depending on making assumptions about indexes, since this is
// error-prone in multi-threaded contexts. The returned descriptor is
// guaranteed to be less than 2**31.
//
// If `flags` contains `descriptor-flags::mutate-directory`, and the base
// descriptor doesn't have `descriptor-flags::mutate-directory` set,
// `open-at` fails with `error-code::read-only`.
//
// If `flags` contains `write` or `mutate-directory`, or `open-flags`
// contains `truncate` or `create`, and the base descriptor doesn't have
// `descriptor-flags::mutate-directory` set, `open-at` fails with
// `error-code::read-only`.
//
// Note: This is similar to `openat` in POSIX.
//
//	open-at: func(path-flags: path-flags, path: string, open-flags: open-flags, %flags:
//	descriptor-flags) -> result<descriptor, error-code>
//
//go:nosplit
func (self Descriptor) OpenAt(pathFlags PathFlags, path string, openFlags OpenFlags, flags DescriptorFlags) (result cm.Result[Descriptor, Descriptor, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	pathFlags0 := (uint32)(pathFlags)
	path0, path1 := cm.LowerString(path)
	openFlags0 := (uint32)(openFlags)
	flags0 := (uint32)(flags)
	wasmimport_DescriptorOpenAt((uint32)(self0), (uint32)(pathFlags0), (*uint8)(path0), (uint32)(path1), (uint32)(openFlags0), (uint32)(flags0), &result)
	return
}

// Read represents the imported method "read".
//
// Read from a descriptor, without using and updating the descriptor's offset.
//
// This function returns a list of bytes containing the data that was
// read, along with a bool which, when true, indicates that the end of the
// file was reached. The returned list will contain up to `length` bytes; it
// may return fewer than requested, if the end of the file is reached or
// if the I/O operation is interrupted.
//
// In the future, this may change to return a `stream<u8, error-code>`.
//
// Note: This is similar to `pread` in POSIX.
//
//	read: func(length: filesize, offset: filesize) -> result<tuple<list<u8>, bool>,
//	error-code>
//
//go:nosplit
func (self Descriptor) Read(length FileSize, offset FileSize) (result cm.Result[TupleListU8BoolShape, cm.Tuple[cm.List[uint8], bool], ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	length0 := (uint64)(length)
	offset0 := (uint64)(offset)
	wasmimport_DescriptorRead((uint32)(self0), (uint64)(length0), (uint64)(offset0), &result)
	return
}

// ReadDirectory represents the imported method "read-directory".
//
// Read directory entries from a directory.
//
// On filesystems where directories contain entries referring to themselves
// and their parents, often named `.` and `..` respectively, these entries
// are omitted.
//
// This always returns a new stream which starts at the beginning of the
// directory. Multiple streams may be active on the same directory, and they
// do not interfere with each other.
//
//	read-directory: func() -> result<directory-entry-stream, error-code>
//
//go:nosplit
func (self Descriptor) ReadDirectory() (result cm.Result[DirectoryEntryStream, DirectoryEntryStream, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorReadDirectory((uint32)(self0), &result)
	return
}

// ReadViaStream represents the imported method "read-via-stream".
//
// Return a stream for reading from a file, if available.
//
// May fail with an error-code describing why the file cannot be read.
//
// Multiple read, write, and append streams may be active on the same open
// file and they do not interfere with each other.
//
// Note: This allows using `read-stream`, which is similar to `read` in POSIX.
//
//	read-via-stream: func(offset: filesize) -> result<input-stream, error-code>
//
//go:nosplit
func (self Descriptor) ReadViaStream(offset FileSize) (result cm.Result[InputStream, InputStream, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	offset0 := (uint64)(offset)
	wasmimport_DescriptorReadViaStream((uint32)(self0), (uint64)(offset0), &result)
	return
}

// ReadLinkAt represents the imported method "readlink-at".
//
// Read the contents of a symbolic link.
//
// If the contents contain an absolute or rooted path in the underlying
// filesystem, this function fails with `error-code::not-permitted`.
//
// Note: This is similar to `readlinkat` in POSIX.
//
//	readlink-at: func(path: string) -> result<string, error-code>
//
//go:nosplit
func (self Descriptor) ReadLinkAt(path string) (result cm.Result[string, string, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	path0, path1 := cm.LowerString(path)
	wasmimport_DescriptorReadLinkAt((uint32)(self0), (*uint8)(path0), (uint32)(path1), &result)
	return
}

// RemoveDirectoryAt represents the imported method "remove-directory-at".
//
// Remove a directory.
//
// Return `error-code::not-empty` if the directory is not empty.
//
// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
//
//	remove-directory-at: func(path: string) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) RemoveDirectoryAt(path string) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	path0, path1 := cm.LowerString(path)
	wasmimport_DescriptorRemoveDirectoryAt((uint32)(self0), (*uint8)(path0), (uint32)(path1), &result)
	return
}

// RenameAt represents the imported method "rename-at".
//
// Rename a filesystem object.
//
// Note: This is similar to `renameat` in POSIX.
//
//	rename-at: func(old-path: string, new-descriptor: borrow<descriptor>, new-path:
//	string) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) RenameAt(oldPath string, newDescriptor Descriptor, newPath string) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	oldPath0, oldPath1 := cm.LowerString(oldPath)
	newDescriptor0 := cm.Reinterpret[uint32](newDescriptor)
	newPath0, newPath1 := cm.LowerString(newPath)
	wasmimport_DescriptorRenameAt((uint32)(self0), (*uint8)(oldPath0), (uint32)(oldPath1), (uint32)(newDescriptor0), (*uint8)(newPath0), (uint32)(newPath1), &result)
	return
}

// SetSize represents the imported method "set-size".
//
// Adjust the size of an open file. If this increases the file's size, the
// extra bytes are filled with zeros.
//
// Note: This was called `fd_filestat_set_size` in earlier versions of WASI.
//
//	set-size: func(size: filesize) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) SetSize(size FileSize) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	size0 := (uint64)(size)
	wasmimport_DescriptorSetSize((uint32)(self0), (uint64)(size0), &result)
	return
}

// SetTimes represents the imported method "set-times".
//
// Adjust the timestamps of an open file or directory.
//
// Note: This is similar to `futimens` in POSIX.
//
// Note: This was called `fd_filestat_set_times` in earlier versions of WASI.
//
//	set-times: func(data-access-timestamp: new-timestamp, data-modification-timestamp:
//	new-timestamp) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) SetTimes(dataAccessTimestamp NewTimestamp, dataModificationTimestamp NewTimestamp) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	dataAccessTimestamp0, dataAccessTimestamp1, dataAccessTimestamp2 := lower_NewTimestamp(dataAccessTimestamp)
	dataModificationTimestamp0, dataModificationTimestamp1, dataModificationTimestamp2 := lower_NewTimestamp(dataModificationTimestamp)
	wasmimport_DescriptorSetTimes((uint32)(self0), (uint32)(dataAccessTimestamp0), (uint64)(dataAccessTimestamp1), (uint32)(dataAccessTimestamp2), (uint32)(dataModificationTimestamp0), (uint64)(dataModificationTimestamp1), (uint32)(dataModificationTimestamp2), &result)
	return
}

// SetTimesAt represents the imported method "set-times-at".
//
// Adjust the timestamps of a file or directory.
//
// Note: This is similar to `utimensat` in POSIX.
//
// Note: This was called `path_filestat_set_times` in earlier versions of
// WASI.
//
//	set-times-at: func(path-flags: path-flags, path: string, data-access-timestamp:
//	new-timestamp, data-modification-timestamp: new-timestamp) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) SetTimesAt(pathFlags PathFlags, path string, dataAccessTimestamp NewTimestamp, dataModificationTimestamp NewTimestamp) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	pathFlags0 := (uint32)(pathFlags)
	path0, path1 := cm.LowerString(path)
	dataAccessTimestamp0, dataAccessTimestamp1, dataAccessTimestamp2 := lower_NewTimestamp(dataAccessTimestamp)
	dataModificationTimestamp0, dataModificationTimestamp1, dataModificationTimestamp2 := lower_NewTimestamp(dataModificationTimestamp)
	wasmimport_DescriptorSetTimesAt((uint32)(self0), (uint32)(pathFlags0), (*uint8)(path0), (uint32)(path1), (uint32)(dataAccessTimestamp0), (uint64)(dataAccessTimestamp1), (uint32)(dataAccessTimestamp2), (uint32)(dataModificationTimestamp0), (uint64)(dataModificationTimestamp1), (uint32)(dataModificationTimestamp2), &result)
	return
}

// Stat represents the imported method "stat".
//
// Return the attributes of an open file or directory.
//
// Note: This is similar to `fstat` in POSIX, except that it does not return
// device and inode information. For testing whether two descriptors refer to
// the same underlying filesystem object, use `is-same-object`. To obtain
// additional data that can be used do determine whether a file has been
// modified, use `metadata-hash`.
//
// Note: This was called `fd_filestat_get` in earlier versions of WASI.
//
//	stat: func() -> result<descriptor-stat, error-code>
//
//go:nosplit
func (self Descriptor) Stat() (result cm.Result[DescriptorStatShape, DescriptorStat, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorStat((uint32)(self0), &result)
	return
}

// StatAt represents the imported method "stat-at".
//
// Return the attributes of a file or directory.
//
// Note: This is similar to `fstatat` in POSIX, except that it does not
// return device and inode information. See the `stat` description for a
// discussion of alternatives.
//
// Note: This was called `path_filestat_get` in earlier versions of WASI.
//
//	stat-at: func(path-flags: path-flags, path: string) -> result<descriptor-stat,
//	error-code>
//
//go:nosplit
func (self Descriptor) StatAt(pathFlags PathFlags, path string) (result cm.Result[DescriptorStatShape, DescriptorStat, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	pathFlags0 := (uint32)(pathFlags)
	path0, path1 := cm.LowerString(path)
	wasmimport_DescriptorStatAt((uint32)(self0), (uint32)(pathFlags0), (*uint8)(path0), (uint32)(path1), &result)
	return
}

// SymlinkAt represents the imported method "symlink-at".
//
// Create a symbolic link (also known as a "symlink").
//
// If `old-path` starts with `/`, the function fails with
// `error-code::not-permitted`.
//
// Note: This is similar to `symlinkat` in POSIX.
//
//	symlink-at: func(old-path: string, new-path: string) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) SymlinkAt(oldPath string, newPath string) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	oldPath0, oldPath1 := cm.LowerString(oldPath)
	newPath0, newPath1 := cm.LowerString(newPath)
	wasmimport_DescriptorSymlinkAt((uint32)(self0), (*uint8)(oldPath0), (uint32)(oldPath1), (*uint8)(newPath0), (uint32)(newPath1), &result)
	return
}

// Sync represents the imported method "sync".
//
// Synchronize the data and metadata of a file to disk.
//
// This function succeeds with no effect if the file descriptor is not
// opened for writing.
//
// Note: This is similar to `fsync` in POSIX.
//
//	sync: func() -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) Sync() (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorSync((uint32)(self0), &result)
	return
}

// SyncData represents the imported method "sync-data".
//
// Synchronize the data of a file to disk.
//
// This function succeeds with no effect if the file descriptor is not
// opened for writing.
//
// Note: This is similar to `fdatasync` in POSIX.
//
//	sync-data: func() -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) SyncData() (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DescriptorSyncData((uint32)(self0), &result)
	return
}

// UnlinkFileAt represents the imported method "unlink-file-at".
//
// Unlink a filesystem object that is not a directory.
//
// Return `error-code::is-directory` if the path refers to a directory.
// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
//
//	unlink-file-at: func(path: string) -> result<_, error-code>
//
//go:nosplit
func (self Descriptor) UnlinkFileAt(path string) (result cm.Result[ErrorCode, struct{}, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	path0, path1 := cm.LowerString(path)
	wasmimport_DescriptorUnlinkFileAt((uint32)(self0), (*uint8)(path0), (uint32)(path1), &result)
	return
}

// Write represents the imported method "write".
//
// Write to a descriptor, without using and updating the descriptor's offset.
//
// It is valid to write past the end of a file; the file is extended to the
// extent of the write, with bytes between the previous end and the start of
// the write set to zero.
//
// In the future, this may change to take a `stream<u8, error-code>`.
//
// Note: This is similar to `pwrite` in POSIX.
//
//	write: func(buffer: list<u8>, offset: filesize) -> result<filesize, error-code>
//
//go:nosplit
func (self Descriptor) Write(buffer cm.List[uint8], offset FileSize) (result cm.Result[uint64, FileSize, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	buffer0, buffer1 := cm.LowerList(buffer)
	offset0 := (uint64)(offset)
	wasmimport_DescriptorWrite((uint32)(self0), (*uint8)(buffer0), (uint32)(buffer1), (uint64)(offset0), &result)
	return
}

// WriteViaStream represents the imported method "write-via-stream".
//
// Return a stream for writing to a file, if available.
//
// May fail with an error-code describing why the file cannot be written.
//
// Note: This allows using `write-stream`, which is similar to `write` in
// POSIX.
//
//	write-via-stream: func(offset: filesize) -> result<output-stream, error-code>
//
//go:nosplit
func (self Descriptor) WriteViaStream(offset FileSize) (result cm.Result[OutputStream, OutputStream, ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	offset0 := (uint64)(offset)
	wasmimport_DescriptorWriteViaStream((uint32)(self0), (uint64)(offset0), &result)
	return
}

// DirectoryEntryStream represents the imported resource "wasi:filesystem/types@0.2.0#directory-entry-stream".
//
// A stream of directory entries.
//
//	resource directory-entry-stream
type DirectoryEntryStream cm.Resource

// ResourceDrop represents the imported resource-drop for resource "directory-entry-stream".
//
// Drops a resource handle.
//
//go:nosplit
func (self DirectoryEntryStream) ResourceDrop() {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DirectoryEntryStreamResourceDrop((uint32)(self0))
	return
}

// ReadDirectoryEntry represents the imported method "read-directory-entry".
//
// Read a single directory entry from a `directory-entry-stream`.
//
//	read-directory-entry: func() -> result<option<directory-entry>, error-code>
//
//go:nosplit
func (self DirectoryEntryStream) ReadDirectoryEntry() (result cm.Result[OptionDirectoryEntryShape, cm.Option[DirectoryEntry], ErrorCode]) {
	self0 := cm.Reinterpret[uint32](self)
	wasmimport_DirectoryEntryStreamReadDirectoryEntry((uint32)(self0), &result)
	return
}

// FilesystemErrorCode represents the imported function "filesystem-error-code".
//
// Attempts to extract a filesystem-related `error-code` from the stream
// `error` provided.
//
// Stream operations which return `stream-error::last-operation-failed`
// have a payload with more information about the operation that failed.
// This payload can be passed through to this function to see if there's
// filesystem-related information about the error to return.
//
// Note that this function is fallible because not all stream-related
// errors are filesystem-related errors.
//
//	filesystem-error-code: func(err: borrow<error>) -> option<error-code>
//
//go:nosplit
func FilesystemErrorCode(err Error) (result cm.Option[ErrorCode]) {
	err0 := cm.Reinterpret[uint32](err)
	wasmimport_FilesystemErrorCode((uint32)(err0), &result)
	return
}
