/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.Type;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

class RubyObject
extends DynamicObject {
    private boolean isPrimitiveList;
    private String listType;
    private Instance array;

    RubyObject(Instance instance) {
        this(null, instance);
    }

    RubyObject(String type, Instance instance) {
        super(type, instance);
        Instance storage = (Instance)instance.getValueOfField("store");
        if (storage instanceof ObjectArrayInstance || storage instanceof PrimitiveArrayInstance) {
            this.array = storage;
        }
    }

    boolean isRubyObject() {
        return RubyObject.isRubyLangId(this.getLanguageId());
    }

    @Override
    protected String computeType() {
        Instance metaClass = (Instance)this.getInstance().getValueOfField("metaClass");
        if (metaClass == null) {
            return super.computeType();
        }
        return DetailsUtils.getInstanceFieldString((Instance)metaClass, (String)"nonSingletonClass");
    }

    List<FieldValue> getItems() {
        if (this.array != null) {
            return this.getListFields();
        }
        return Collections.EMPTY_LIST;
    }

    private List<FieldValue> getListFields() {
        return new LazyFieldValues(this.getValues());
    }

    private List getValues() {
        if (this.array != null) {
            this.listType = this.array.getJavaClass().getName().replace("[]", "");
            if (this.array instanceof ObjectArrayInstance) {
                return ((ObjectArrayInstance)this.array).getValues();
            }
            if (this.array instanceof PrimitiveArrayInstance) {
                this.isPrimitiveList = true;
                return ((PrimitiveArrayInstance)this.array).getValues();
            }
        }
        return Collections.emptyList();
    }

    static boolean isRubyObject(Instance instance) {
        return DynamicObject.isDynamicObject(instance) && RubyObject.isRubyLangId(DynamicObject.getLanguageId(instance));
    }

    private static boolean isRubyLangId(JavaClass langIdClass) {
        String className = langIdClass.getName();
        return "org.truffleruby.language.RubyObjectType".equals(className) || "org.truffleruby.interop.RubyObjectType".equals(className) || "org.truffleruby.language.objects.RubyObjectType".equals(className);
    }

    private static class RFieldType
    implements Type {
        private final String name;

        private RFieldType(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RFieldType) {
                return this.getName().equals(((RFieldType)obj).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    private class RubyField
    implements Field {
        private int index;

        private RubyField(int i) {
            this.index = i;
        }

        public JavaClass getDeclaringClass() {
            return RubyObject.this.getInstance().getJavaClass();
        }

        public String getName() {
            return "[" + this.index + "]";
        }

        public boolean isStatic() {
            return false;
        }

        public Type getType() {
            return new RFieldType(RubyObject.this.listType);
        }
    }

    private class RubyObjectFieldValue
    extends RubyFieldValue
    implements ObjectFieldValue {
        private RubyObjectFieldValue(int i, Instance val) {
            super(i, val);
        }

        @Override
        public String getValue() {
            return String.valueOf(this.getInstance().getInstanceId());
        }

        public Instance getInstance() {
            return (Instance)this.value;
        }
    }

    private class RubyFieldValue
    implements FieldValue {
        private int index;
        Object value;

        private RubyFieldValue(int i, Object val) {
            this.index = i;
            this.value = val;
        }

        public Field getField() {
            return new RubyField(this.index);
        }

        public String getValue() {
            return (String)this.value;
        }

        public Instance getDefiningInstance() {
            return RubyObject.this.getInstance();
        }
    }

    private class LazyFieldValues
    extends AbstractList<FieldValue> {
        private List values;

        private LazyFieldValues(List vals) {
            this.values = vals;
        }

        @Override
        public FieldValue get(int index) {
            if (RubyObject.this.isPrimitiveList) {
                return new RubyFieldValue(index, this.values.get(index));
            }
            return new RubyObjectFieldValue(index, (Instance)this.values.get(index));
        }

        @Override
        public int size() {
            Object size = RubyObject.this.getInstance().getValueOfField("size");
            if (size instanceof Integer) {
                return (Integer)size;
            }
            return 0;
        }
    }
}

