"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const BigInt = {
  id: 0x7F,
  type: 'INT8',
  name: 'BigInt',
  declaration: function declaration() {
    return 'bigint';
  },
  writeTypeInfo: function writeTypeInfo(buffer) {
    buffer.writeUInt8(_intn.default.id);
    buffer.writeUInt8(8);
  },
  writeParameterData: function writeParameterData(buffer, parameter, _options, cb) {
    if (parameter.value != null) {
      buffer.writeUInt8(8);
      buffer.writeInt64LE(Number(parameter.value));
    } else {
      buffer.writeUInt8(0);
    }

    cb();
  },
  validate: function validate(value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      return new TypeError('Invalid number.');
    }

    if (value < Number.MIN_SAFE_INTEGER || value > Number.MAX_SAFE_INTEGER) {
      return new TypeError(`Value must be between ${Number.MIN_SAFE_INTEGER} and ${Number.MAX_SAFE_INTEGER}, inclusive.  For smaller or bigger numbers, use VarChar type.`);
    }

    return value;
  }
};
var _default = BigInt;
exports.default = _default;
module.exports = BigInt;