/*******************************************************************************
* Copyright 2014-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER

#ifndef COMPUTESYMGS_HPP
#define COMPUTESYMGS_HPP
#include "SparseMatrix.hpp"
#include "Vector.hpp"


#ifdef HPCG_USE_CUSTOM_KERNELS

sycl::event run_SYMGS_custom(sycl::queue &main_queue,
                             const SparseMatrix & A,
                             struct optData *optData,
                             custom::sparseMatrix *sparseM,
                             const Vector &r,
                             Vector &x,
                             const std::vector<sycl::event> &deps = {});

sycl::event run_SYMGS_MV_custom(sycl::queue &main_queue,
                                const SparseMatrix & A,
                                struct optData *optData,
                                custom::sparseMatrix *sparseM,
                                const Vector &r,
                                Vector &x,
                                Vector &y,
                                const std::vector<sycl::event> &deps = {});
#endif // HPCG_USE_CUSTOM_KERNELS


#if !defined(HPCG_USE_CUSTOM_KERNELS) || defined(HPCG_TEST_CUSTOM_KERNELS)
sycl::event run_SYMGS_onemkl(sycl::queue &main_queue,
                             const SparseMatrix & A,
                             struct optData *optData,
                             oneapi::mkl::sparse::matrix_handle_t hMatrixA,
                             oneapi::mkl::sparse::matrix_handle_t hMatrixB,
                             const Vector &r,
                             Vector &x,
                             const std::vector<sycl::event> &deps = {});

sycl::event run_SYMGS_MV_onemkl(sycl::queue &main_queue,
                                const SparseMatrix & A,
                                struct optData *optData,
                                oneapi::mkl::sparse::matrix_handle_t hMatrixA,
                                oneapi::mkl::sparse::matrix_handle_t hMatrixB,
                                const Vector &r,
                                Vector &x,
                                Vector &y,
                                const std::vector<sycl::event> &deps = {});
#endif // !defined(HPCG_USE_CUSTOM_KERNELS) || defined(HPCG_TEST_CUSTOM_KERNELS)



sycl::event ComputeSYMGS( const SparseMatrix  & A, const Vector & r, Vector & x,
                          sycl::queue & main_queue, int &ierr,
                          const std::vector<sycl::event> & deps = {});
sycl::event ComputeSYMGS_MV( const SparseMatrix  & A, const Vector & r, Vector & x, Vector & y,
                             sycl::queue & main_queue, int &ierr,
                             const std::vector<sycl::event> & deps = {});


int ComputeSPMV_ref( const SparseMatrix & A, Vector  & x, Vector & y);

#endif // COMPUTESYMGS_HPP
