/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.special;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J!\u0010\u001a\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0001H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionImpl;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "isError", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Z)V", "getSubroutine", "()Lorg/jetbrains/kotlin/psi/KtElement;", "()Z", "_sink", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "value", "sink", "getSink", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "setSink", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;)V", "nextInstructions", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getNextInstructions", "()Ljava/util/Collection;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "toString", "", "createCopy", "cfg"})
public final class SubroutineExitInstruction
extends InstructionImpl {
    @NotNull
    private final KtElement subroutine;
    private final boolean isError;
    @Nullable
    private SubroutineSinkInstruction _sink;

    public SubroutineExitInstruction(@NotNull KtElement subroutine, @NotNull BlockScope blockScope, boolean isError) {
        Intrinsics.checkNotNullParameter(subroutine, "subroutine");
        Intrinsics.checkNotNullParameter(blockScope, "blockScope");
        super(blockScope);
        this.subroutine = subroutine;
        this.isError = isError;
    }

    @NotNull
    public final KtElement getSubroutine() {
        return this.subroutine;
    }

    public final boolean isError() {
        return this.isError;
    }

    @NotNull
    public final SubroutineSinkInstruction getSink() {
        SubroutineSinkInstruction subroutineSinkInstruction = this._sink;
        Intrinsics.checkNotNull(subroutineSinkInstruction);
        return subroutineSinkInstruction;
    }

    public final void setSink(@NotNull SubroutineSinkInstruction value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Instruction instruction = this.outgoingEdgeTo(value2);
        Intrinsics.checkNotNull(instruction, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction");
        this._sink = (SubroutineSinkInstruction)instruction;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        Set<SubroutineSinkInstruction> set = Collections.singleton(this.getSink());
        Intrinsics.checkNotNullExpressionValue(set, "singleton(...)");
        return set;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        visitor2.visitSubroutineExit(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitSubroutineExit(this);
    }

    @NotNull
    public String toString() {
        return this.isError ? "<ERROR>" : "<END>";
    }

    @Override
    @NotNull
    protected InstructionImpl createCopy() {
        return new SubroutineExitInstruction(this.subroutine, this.getBlockScope(), this.isError);
    }
}

