/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.startup.UserConfig;
import org.apache.catalina.startup.UserDatabase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.StringManager;

public final class PasswdUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(PasswdUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(PasswdUserDatabase.class);
    private static final String PASSWORD_FILE = "/etc/passwd";
    private final Map<String, String> homes = new HashMap<String, String>();
    private UserConfig userConfig = null;

    @Override
    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    @Override
    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
        this.init();
    }

    @Override
    public String getHome(String string) {
        return this.homes.get(string);
    }

    @Override
    public Enumeration<String> getUsers() {
        return Collections.enumeration(this.homes.keySet());
    }

    private void init() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(PASSWORD_FILE));){
            String string = bufferedReader.readLine();
            while (string != null) {
                String[] stringArray = string.split(":");
                if (stringArray.length > 5 && stringArray[0].length() > 0 && stringArray[5].length() > 0) {
                    this.homes.put(stringArray[0], stringArray[5]);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("passwdUserDatabase.readFail"), (Throwable)exception);
        }
    }
}

