# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccountKeyMetadata(_serialization.Model):
    """The metadata related to an access key for a given database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar generation_time: Generation time in UTC of the key in ISO-8601 format. If the value is
     missing from the object, it means that the last key regeneration was triggered before
     2022-06-18.
    :vartype generation_time: ~datetime.datetime
    """

    _validation = {
        "generation_time": {"readonly": True},
    }

    _attribute_map = {
        "generation_time": {"key": "generationTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.generation_time = None


class AnalyticalStorageConfiguration(_serialization.Model):
    """Analytical storage specific properties.

    :ivar schema_type: Describes the types of schema for analytical storage. Known values are:
     "WellDefined" and "FullFidelity".
    :vartype schema_type: str or ~azure.mgmt.cosmosdb.models.AnalyticalStorageSchemaType
    """

    _attribute_map = {
        "schema_type": {"key": "schemaType", "type": "str"},
    }

    def __init__(
        self, *, schema_type: Optional[Union[str, "_models.AnalyticalStorageSchemaType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword schema_type: Describes the types of schema for analytical storage. Known values are:
         "WellDefined" and "FullFidelity".
        :paramtype schema_type: str or ~azure.mgmt.cosmosdb.models.AnalyticalStorageSchemaType
        """
        super().__init__(**kwargs)
        self.schema_type = schema_type


class ApiProperties(_serialization.Model):
    """ApiProperties.

    :ivar server_version: Describes the version of the MongoDB account. Known values are: "3.2",
     "3.6", "4.0", "4.2", "5.0", "6.0", and "7.0".
    :vartype server_version: str or ~azure.mgmt.cosmosdb.models.ServerVersion
    """

    _attribute_map = {
        "server_version": {"key": "serverVersion", "type": "str"},
    }

    def __init__(self, *, server_version: Optional[Union[str, "_models.ServerVersion"]] = None, **kwargs: Any) -> None:
        """
        :keyword server_version: Describes the version of the MongoDB account. Known values are: "3.2",
         "3.6", "4.0", "4.2", "5.0", "6.0", and "7.0".
        :paramtype server_version: str or ~azure.mgmt.cosmosdb.models.ServerVersion
        """
        super().__init__(**kwargs)
        self.server_version = server_version


class ARMProxyResource(_serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ARMResourceProperties(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AuthenticationMethodLdapProperties(_serialization.Model):
    """Ldap authentication method properties. This feature is in preview.

    :ivar server_hostname: Hostname of the LDAP server.
    :vartype server_hostname: str
    :ivar server_port: Port of the LDAP server.
    :vartype server_port: int
    :ivar service_user_distinguished_name: Distinguished name of the look up user account, who can
     look up user details on authentication.
    :vartype service_user_distinguished_name: str
    :ivar service_user_password: Password of the look up user.
    :vartype service_user_password: str
    :ivar search_base_distinguished_name: Distinguished name of the object to start the recursive
     search of users from.
    :vartype search_base_distinguished_name: str
    :ivar search_filter_template: Template to use for searching. Defaults to (cn=%s) where %s will
     be replaced by the username used to login.
    :vartype search_filter_template: str
    :ivar server_certificates:
    :vartype server_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
    :ivar connection_timeout_in_ms: Timeout for connecting to the LDAP server in miliseconds. The
     default is 5000 ms.
    :vartype connection_timeout_in_ms: int
    """

    _attribute_map = {
        "server_hostname": {"key": "serverHostname", "type": "str"},
        "server_port": {"key": "serverPort", "type": "int"},
        "service_user_distinguished_name": {"key": "serviceUserDistinguishedName", "type": "str"},
        "service_user_password": {"key": "serviceUserPassword", "type": "str"},
        "search_base_distinguished_name": {"key": "searchBaseDistinguishedName", "type": "str"},
        "search_filter_template": {"key": "searchFilterTemplate", "type": "str"},
        "server_certificates": {"key": "serverCertificates", "type": "[Certificate]"},
        "connection_timeout_in_ms": {"key": "connectionTimeoutInMs", "type": "int"},
    }

    def __init__(
        self,
        *,
        server_hostname: Optional[str] = None,
        server_port: Optional[int] = None,
        service_user_distinguished_name: Optional[str] = None,
        service_user_password: Optional[str] = None,
        search_base_distinguished_name: Optional[str] = None,
        search_filter_template: Optional[str] = None,
        server_certificates: Optional[List["_models.Certificate"]] = None,
        connection_timeout_in_ms: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_hostname: Hostname of the LDAP server.
        :paramtype server_hostname: str
        :keyword server_port: Port of the LDAP server.
        :paramtype server_port: int
        :keyword service_user_distinguished_name: Distinguished name of the look up user account, who
         can look up user details on authentication.
        :paramtype service_user_distinguished_name: str
        :keyword service_user_password: Password of the look up user.
        :paramtype service_user_password: str
        :keyword search_base_distinguished_name: Distinguished name of the object to start the
         recursive search of users from.
        :paramtype search_base_distinguished_name: str
        :keyword search_filter_template: Template to use for searching. Defaults to (cn=%s) where %s
         will be replaced by the username used to login.
        :paramtype search_filter_template: str
        :keyword server_certificates:
        :paramtype server_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
        :keyword connection_timeout_in_ms: Timeout for connecting to the LDAP server in miliseconds.
         The default is 5000 ms.
        :paramtype connection_timeout_in_ms: int
        """
        super().__init__(**kwargs)
        self.server_hostname = server_hostname
        self.server_port = server_port
        self.service_user_distinguished_name = service_user_distinguished_name
        self.service_user_password = service_user_password
        self.search_base_distinguished_name = search_base_distinguished_name
        self.search_filter_template = search_filter_template
        self.server_certificates = server_certificates
        self.connection_timeout_in_ms = connection_timeout_in_ms


class AutoscaleSettings(_serialization.Model):
    """AutoscaleSettings.

    :ivar max_throughput: Represents maximum throughput, the resource can scale up to.
    :vartype max_throughput: int
    """

    _attribute_map = {
        "max_throughput": {"key": "maxThroughput", "type": "int"},
    }

    def __init__(self, *, max_throughput: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword max_throughput: Represents maximum throughput, the resource can scale up to.
        :paramtype max_throughput: int
        """
        super().__init__(**kwargs)
        self.max_throughput = max_throughput


class AutoscaleSettingsResource(_serialization.Model):
    """Cosmos DB provisioned throughput settings object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar max_throughput: Represents maximum throughput container can scale up to. Required.
    :vartype max_throughput: int
    :ivar auto_upgrade_policy: Cosmos DB resource auto-upgrade policy.
    :vartype auto_upgrade_policy: ~azure.mgmt.cosmosdb.models.AutoUpgradePolicyResource
    :ivar target_max_throughput: Represents target maximum throughput container can scale up to
     once offer is no longer in pending state.
    :vartype target_max_throughput: int
    """

    _validation = {
        "max_throughput": {"required": True},
        "target_max_throughput": {"readonly": True},
    }

    _attribute_map = {
        "max_throughput": {"key": "maxThroughput", "type": "int"},
        "auto_upgrade_policy": {"key": "autoUpgradePolicy", "type": "AutoUpgradePolicyResource"},
        "target_max_throughput": {"key": "targetMaxThroughput", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_throughput: int,
        auto_upgrade_policy: Optional["_models.AutoUpgradePolicyResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_throughput: Represents maximum throughput container can scale up to. Required.
        :paramtype max_throughput: int
        :keyword auto_upgrade_policy: Cosmos DB resource auto-upgrade policy.
        :paramtype auto_upgrade_policy: ~azure.mgmt.cosmosdb.models.AutoUpgradePolicyResource
        """
        super().__init__(**kwargs)
        self.max_throughput = max_throughput
        self.auto_upgrade_policy = auto_upgrade_policy
        self.target_max_throughput = None


class AutoUpgradePolicyResource(_serialization.Model):
    """Cosmos DB resource auto-upgrade policy.

    :ivar throughput_policy: Represents throughput policy which service must adhere to for
     auto-upgrade.
    :vartype throughput_policy: ~azure.mgmt.cosmosdb.models.ThroughputPolicyResource
    """

    _attribute_map = {
        "throughput_policy": {"key": "throughputPolicy", "type": "ThroughputPolicyResource"},
    }

    def __init__(
        self, *, throughput_policy: Optional["_models.ThroughputPolicyResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword throughput_policy: Represents throughput policy which service must adhere to for
         auto-upgrade.
        :paramtype throughput_policy: ~azure.mgmt.cosmosdb.models.ThroughputPolicyResource
        """
        super().__init__(**kwargs)
        self.throughput_policy = throughput_policy


class BackupInformation(_serialization.Model):
    """Backup information of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar continuous_backup_information: Information about the status of continuous backups.
    :vartype continuous_backup_information: ~azure.mgmt.cosmosdb.models.ContinuousBackupInformation
    """

    _validation = {
        "continuous_backup_information": {"readonly": True},
    }

    _attribute_map = {
        "continuous_backup_information": {"key": "continuousBackupInformation", "type": "ContinuousBackupInformation"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.continuous_backup_information = None


class BackupPolicy(_serialization.Model):
    """The object representing the policy for taking backups on an account.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContinuousModeBackupPolicy, PeriodicModeBackupPolicy

    All required parameters must be populated in order to send to server.

    :ivar type: Describes the mode of backups. Required. Known values are: "Periodic" and
     "Continuous".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.BackupPolicyType
    :ivar migration_state: The object representing the state of the migration between the backup
     policies.
    :vartype migration_state: ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationState
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "migration_state": {"key": "migrationState", "type": "BackupPolicyMigrationState"},
    }

    _subtype_map = {"type": {"Continuous": "ContinuousModeBackupPolicy", "Periodic": "PeriodicModeBackupPolicy"}}

    def __init__(
        self, *, migration_state: Optional["_models.BackupPolicyMigrationState"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword migration_state: The object representing the state of the migration between the backup
         policies.
        :paramtype migration_state: ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationState
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.migration_state = migration_state


class BackupPolicyMigrationState(_serialization.Model):
    """The object representing the state of the migration between the backup policies.

    :ivar status: Describes the status of migration between backup policy types. Known values are:
     "Invalid", "InProgress", "Completed", and "Failed".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationStatus
    :ivar target_type: Describes the target backup policy type of the backup policy migration.
     Known values are: "Periodic" and "Continuous".
    :vartype target_type: str or ~azure.mgmt.cosmosdb.models.BackupPolicyType
    :ivar start_time: Time at which the backup policy migration started (ISO-8601 format).
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "target_type": {"key": "targetType", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.BackupPolicyMigrationStatus"]] = None,
        target_type: Optional[Union[str, "_models.BackupPolicyType"]] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Describes the status of migration between backup policy types. Known values
         are: "Invalid", "InProgress", "Completed", and "Failed".
        :paramtype status: str or ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationStatus
        :keyword target_type: Describes the target backup policy type of the backup policy migration.
         Known values are: "Periodic" and "Continuous".
        :paramtype target_type: str or ~azure.mgmt.cosmosdb.models.BackupPolicyType
        :keyword start_time: Time at which the backup policy migration started (ISO-8601 format).
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.target_type = target_type
        self.start_time = start_time


class Capability(_serialization.Model):
    """Cosmos DB capability object.

    :ivar name: Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current
     values also include "EnableTable" and "EnableGremlin".
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the Cosmos DB capability. For example, "name": "EnableCassandra".
         Current values also include "EnableTable" and "EnableGremlin".
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class Capacity(_serialization.Model):
    """The object that represents all properties related to capacity enforcement on an account.

    :ivar total_throughput_limit: The total throughput limit imposed on the account. A
     totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned
     on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of
     throughput.
    :vartype total_throughput_limit: int
    """

    _validation = {
        "total_throughput_limit": {"minimum": -1},
    }

    _attribute_map = {
        "total_throughput_limit": {"key": "totalThroughputLimit", "type": "int"},
    }

    def __init__(self, *, total_throughput_limit: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword total_throughput_limit: The total throughput limit imposed on the account. A
         totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned
         on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of
         throughput.
        :paramtype total_throughput_limit: int
        """
        super().__init__(**kwargs)
        self.total_throughput_limit = total_throughput_limit


class CassandraClusterDataCenterNodeItem(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """CassandraClusterDataCenterNodeItem.

    :ivar address: The node's IP address.
    :vartype address: str
    :ivar state: The state of the node in Cassandra ring. Known values are: "Normal", "Leaving",
     "Joining", "Moving", and "Stopped".
    :vartype state: str or ~azure.mgmt.cosmosdb.models.NodeState
    :ivar status:
    :vartype status: str
    :ivar cassandra_process_status: Cassandra service status on this node.
    :vartype cassandra_process_status: str
    :ivar load: The amount of file system data in the data directory (e.g., 47.66 kB), excluding
     all content in the snapshots subdirectories. Because all SSTable data files are included, any
     data that is not cleaned up (such as TTL-expired cells or tombstones) is counted.
    :vartype load: str
    :ivar tokens: List of tokens this node covers.
    :vartype tokens: list[str]
    :ivar size:
    :vartype size: int
    :ivar host_id: The network ID of the node.
    :vartype host_id: str
    :ivar rack: The rack this node is part of.
    :vartype rack: str
    :ivar timestamp: The timestamp when these statistics were captured.
    :vartype timestamp: str
    :ivar disk_used_kb: The amount of disk used, in kB, of the directory /var/lib/cassandra.
    :vartype disk_used_kb: int
    :ivar disk_free_kb: The amount of disk free, in kB, of the directory /var/lib/cassandra.
    :vartype disk_free_kb: int
    :ivar memory_used_kb: Used memory (calculated as total - free - buffers - cache), in kB.
    :vartype memory_used_kb: int
    :ivar memory_buffers_and_cached_kb: Memory used by kernel buffers (Buffers in /proc/meminfo)
     and page cache and slabs (Cached and SReclaimable in /proc/meminfo), in kB.
    :vartype memory_buffers_and_cached_kb: int
    :ivar memory_free_kb: Unused memory (MemFree and SwapFree in /proc/meminfo), in kB.
    :vartype memory_free_kb: int
    :ivar memory_total_kb: Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in kB.
    :vartype memory_total_kb: int
    :ivar cpu_usage: A float representing the current system-wide CPU utilization as a percentage.
    :vartype cpu_usage: float
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "cassandra_process_status": {"key": "cassandraProcessStatus", "type": "str"},
        "load": {"key": "load", "type": "str"},
        "tokens": {"key": "tokens", "type": "[str]"},
        "size": {"key": "size", "type": "int"},
        "host_id": {"key": "hostID", "type": "str"},
        "rack": {"key": "rack", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "str"},
        "disk_used_kb": {"key": "diskUsedKB", "type": "int"},
        "disk_free_kb": {"key": "diskFreeKB", "type": "int"},
        "memory_used_kb": {"key": "memoryUsedKB", "type": "int"},
        "memory_buffers_and_cached_kb": {"key": "memoryBuffersAndCachedKB", "type": "int"},
        "memory_free_kb": {"key": "memoryFreeKB", "type": "int"},
        "memory_total_kb": {"key": "memoryTotalKB", "type": "int"},
        "cpu_usage": {"key": "cpuUsage", "type": "float"},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        state: Optional[Union[str, "_models.NodeState"]] = None,
        status: Optional[str] = None,
        cassandra_process_status: Optional[str] = None,
        load: Optional[str] = None,
        tokens: Optional[List[str]] = None,
        size: Optional[int] = None,
        host_id: Optional[str] = None,
        rack: Optional[str] = None,
        timestamp: Optional[str] = None,
        disk_used_kb: Optional[int] = None,
        disk_free_kb: Optional[int] = None,
        memory_used_kb: Optional[int] = None,
        memory_buffers_and_cached_kb: Optional[int] = None,
        memory_free_kb: Optional[int] = None,
        memory_total_kb: Optional[int] = None,
        cpu_usage: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address: The node's IP address.
        :paramtype address: str
        :keyword state: The state of the node in Cassandra ring. Known values are: "Normal", "Leaving",
         "Joining", "Moving", and "Stopped".
        :paramtype state: str or ~azure.mgmt.cosmosdb.models.NodeState
        :keyword status:
        :paramtype status: str
        :keyword cassandra_process_status: Cassandra service status on this node.
        :paramtype cassandra_process_status: str
        :keyword load: The amount of file system data in the data directory (e.g., 47.66 kB), excluding
         all content in the snapshots subdirectories. Because all SSTable data files are included, any
         data that is not cleaned up (such as TTL-expired cells or tombstones) is counted.
        :paramtype load: str
        :keyword tokens: List of tokens this node covers.
        :paramtype tokens: list[str]
        :keyword size:
        :paramtype size: int
        :keyword host_id: The network ID of the node.
        :paramtype host_id: str
        :keyword rack: The rack this node is part of.
        :paramtype rack: str
        :keyword timestamp: The timestamp when these statistics were captured.
        :paramtype timestamp: str
        :keyword disk_used_kb: The amount of disk used, in kB, of the directory /var/lib/cassandra.
        :paramtype disk_used_kb: int
        :keyword disk_free_kb: The amount of disk free, in kB, of the directory /var/lib/cassandra.
        :paramtype disk_free_kb: int
        :keyword memory_used_kb: Used memory (calculated as total - free - buffers - cache), in kB.
        :paramtype memory_used_kb: int
        :keyword memory_buffers_and_cached_kb: Memory used by kernel buffers (Buffers in /proc/meminfo)
         and page cache and slabs (Cached and SReclaimable in /proc/meminfo), in kB.
        :paramtype memory_buffers_and_cached_kb: int
        :keyword memory_free_kb: Unused memory (MemFree and SwapFree in /proc/meminfo), in kB.
        :paramtype memory_free_kb: int
        :keyword memory_total_kb: Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in
         kB.
        :paramtype memory_total_kb: int
        :keyword cpu_usage: A float representing the current system-wide CPU utilization as a
         percentage.
        :paramtype cpu_usage: float
        """
        super().__init__(**kwargs)
        self.address = address
        self.state = state
        self.status = status
        self.cassandra_process_status = cassandra_process_status
        self.load = load
        self.tokens = tokens
        self.size = size
        self.host_id = host_id
        self.rack = rack
        self.timestamp = timestamp
        self.disk_used_kb = disk_used_kb
        self.disk_free_kb = disk_free_kb
        self.memory_used_kb = memory_used_kb
        self.memory_buffers_and_cached_kb = memory_buffers_and_cached_kb
        self.memory_free_kb = memory_free_kb
        self.memory_total_kb = memory_total_kb
        self.cpu_usage = cpu_usage


class CassandraClusterPublicStatus(_serialization.Model):
    """Properties of a managed Cassandra cluster public status.

    :ivar e_tag:
    :vartype e_tag: str
    :ivar reaper_status:
    :vartype reaper_status: ~azure.mgmt.cosmosdb.models.ManagedCassandraReaperStatus
    :ivar connection_errors: List relevant information about any connection errors to the
     Datacenters.
    :vartype connection_errors: list[~azure.mgmt.cosmosdb.models.ConnectionError]
    :ivar errors: List relevant information about any errors about cluster, data center and
     connection error.
    :vartype errors: list[~azure.mgmt.cosmosdb.models.CassandraError]
    :ivar data_centers: List of the status of each datacenter in this cluster.
    :vartype data_centers:
     list[~azure.mgmt.cosmosdb.models.CassandraClusterPublicStatusDataCentersItem]
    """

    _attribute_map = {
        "e_tag": {"key": "eTag", "type": "str"},
        "reaper_status": {"key": "reaperStatus", "type": "ManagedCassandraReaperStatus"},
        "connection_errors": {"key": "connectionErrors", "type": "[ConnectionError]"},
        "errors": {"key": "errors", "type": "[CassandraError]"},
        "data_centers": {"key": "dataCenters", "type": "[CassandraClusterPublicStatusDataCentersItem]"},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        reaper_status: Optional["_models.ManagedCassandraReaperStatus"] = None,
        connection_errors: Optional[List["_models.ConnectionError"]] = None,
        errors: Optional[List["_models.CassandraError"]] = None,
        data_centers: Optional[List["_models.CassandraClusterPublicStatusDataCentersItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword e_tag:
        :paramtype e_tag: str
        :keyword reaper_status:
        :paramtype reaper_status: ~azure.mgmt.cosmosdb.models.ManagedCassandraReaperStatus
        :keyword connection_errors: List relevant information about any connection errors to the
         Datacenters.
        :paramtype connection_errors: list[~azure.mgmt.cosmosdb.models.ConnectionError]
        :keyword errors: List relevant information about any errors about cluster, data center and
         connection error.
        :paramtype errors: list[~azure.mgmt.cosmosdb.models.CassandraError]
        :keyword data_centers: List of the status of each datacenter in this cluster.
        :paramtype data_centers:
         list[~azure.mgmt.cosmosdb.models.CassandraClusterPublicStatusDataCentersItem]
        """
        super().__init__(**kwargs)
        self.e_tag = e_tag
        self.reaper_status = reaper_status
        self.connection_errors = connection_errors
        self.errors = errors
        self.data_centers = data_centers


class CassandraClusterPublicStatusDataCentersItem(_serialization.Model):  # pylint: disable=name-too-long
    """CassandraClusterPublicStatusDataCentersItem.

    :ivar name: The name of this Datacenter.
    :vartype name: str
    :ivar seed_nodes: A list of all seed nodes in the cluster, managed and unmanaged.
    :vartype seed_nodes: list[str]
    :ivar nodes:
    :vartype nodes: list[~azure.mgmt.cosmosdb.models.CassandraClusterDataCenterNodeItem]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "seed_nodes": {"key": "seedNodes", "type": "[str]"},
        "nodes": {"key": "nodes", "type": "[CassandraClusterDataCenterNodeItem]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        seed_nodes: Optional[List[str]] = None,
        nodes: Optional[List["_models.CassandraClusterDataCenterNodeItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of this Datacenter.
        :paramtype name: str
        :keyword seed_nodes: A list of all seed nodes in the cluster, managed and unmanaged.
        :paramtype seed_nodes: list[str]
        :keyword nodes:
        :paramtype nodes: list[~azure.mgmt.cosmosdb.models.CassandraClusterDataCenterNodeItem]
        """
        super().__init__(**kwargs)
        self.name = name
        self.seed_nodes = seed_nodes
        self.nodes = nodes


class CassandraError(_serialization.Model):
    """CassandraError.

    :ivar code: The code of error that occurred.
    :vartype code: str
    :ivar message: The message of the error.
    :vartype message: str
    :ivar target: The target resource of the error.
    :vartype target: str
    :ivar additional_error_info: Additional information about the error.
    :vartype additional_error_info: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "additional_error_info": {"key": "additionalErrorInfo", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        additional_error_info: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The code of error that occurred.
        :paramtype code: str
        :keyword message: The message of the error.
        :paramtype message: str
        :keyword target: The target resource of the error.
        :paramtype target: str
        :keyword additional_error_info: Additional information about the error.
        :paramtype additional_error_info: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.additional_error_info = additional_error_info


class CassandraKeyspaceCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Cassandra keyspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a Cassandra keyspace. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "CassandraKeyspaceResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.CassandraKeyspaceResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a Cassandra keyspace. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class OptionsResource(_serialization.Model):
    """Cosmos DB options resource object.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        "throughput": {"key": "throughput", "type": "int"},
        "autoscale_settings": {"key": "autoscaleSettings", "type": "AutoscaleSettings"},
    }

    def __init__(
        self,
        *,
        throughput: Optional[int] = None,
        autoscale_settings: Optional["_models.AutoscaleSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
         ThroughputSetting resource when retrieving offer details.
        :paramtype throughput: int
        :keyword autoscale_settings: Specifies the Autoscale settings.
        :paramtype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
        """
        super().__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings


class CassandraKeyspaceGetPropertiesOptions(OptionsResource):
    """CassandraKeyspaceGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class ExtendedResourceProperties(_serialization.Model):
    """The system generated resource properties associated with SQL databases, SQL containers, Gremlin
    databases and Gremlin graphs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rid = None
        self.ts = None
        self.etag = None


class CassandraKeyspaceResource(_serialization.Model):
    """Cosmos DB Cassandra keyspace resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB Cassandra keyspace. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Name of the Cosmos DB Cassandra keyspace. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class CassandraKeyspaceGetPropertiesResource(CassandraKeyspaceResource, ExtendedResourceProperties):
    """CassandraKeyspaceGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB Cassandra keyspace. Required.
    :vartype id: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Name of the Cosmos DB Cassandra keyspace. Required.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id


class CassandraKeyspaceGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Cassandra keyspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "CassandraKeyspaceGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "CassandraKeyspaceGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.CassandraKeyspaceGetPropertiesResource"] = None,
        options: Optional["_models.CassandraKeyspaceGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class CassandraKeyspaceListResult(_serialization.Model):
    """The List operation response, that contains the Cassandra keyspaces and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Cassandra keyspaces and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CassandraKeyspaceGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class CassandraPartitionKey(_serialization.Model):
    """Cosmos DB Cassandra table partition key.

    :ivar name: Name of the Cosmos DB Cassandra table partition key.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the Cosmos DB Cassandra table partition key.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CassandraSchema(_serialization.Model):
    """Cosmos DB Cassandra table schema.

    :ivar columns: List of Cassandra table columns.
    :vartype columns: list[~azure.mgmt.cosmosdb.models.Column]
    :ivar partition_keys: List of partition key.
    :vartype partition_keys: list[~azure.mgmt.cosmosdb.models.CassandraPartitionKey]
    :ivar cluster_keys: List of cluster key.
    :vartype cluster_keys: list[~azure.mgmt.cosmosdb.models.ClusterKey]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[Column]"},
        "partition_keys": {"key": "partitionKeys", "type": "[CassandraPartitionKey]"},
        "cluster_keys": {"key": "clusterKeys", "type": "[ClusterKey]"},
    }

    def __init__(
        self,
        *,
        columns: Optional[List["_models.Column"]] = None,
        partition_keys: Optional[List["_models.CassandraPartitionKey"]] = None,
        cluster_keys: Optional[List["_models.ClusterKey"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword columns: List of Cassandra table columns.
        :paramtype columns: list[~azure.mgmt.cosmosdb.models.Column]
        :keyword partition_keys: List of partition key.
        :paramtype partition_keys: list[~azure.mgmt.cosmosdb.models.CassandraPartitionKey]
        :keyword cluster_keys: List of cluster key.
        :paramtype cluster_keys: list[~azure.mgmt.cosmosdb.models.ClusterKey]
        """
        super().__init__(**kwargs)
        self.columns = columns
        self.partition_keys = partition_keys
        self.cluster_keys = cluster_keys


class CassandraTableCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Cassandra table.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a Cassandra table. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.CassandraTableResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "CassandraTableResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.CassandraTableResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a Cassandra table. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.CassandraTableResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class CassandraTableGetPropertiesOptions(OptionsResource):
    """CassandraTableGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class CassandraTableResource(_serialization.Model):
    """Cosmos DB Cassandra table resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB Cassandra table. Required.
    :vartype id: str
    :ivar default_ttl: Time to live of the Cosmos DB Cassandra table.
    :vartype default_ttl: int
    :ivar schema: Schema of the Cosmos DB Cassandra table.
    :vartype schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "schema": {"key": "schema", "type": "CassandraSchema"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        default_ttl: Optional[int] = None,
        schema: Optional["_models.CassandraSchema"] = None,
        analytical_storage_ttl: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB Cassandra table. Required.
        :paramtype id: str
        :keyword default_ttl: Time to live of the Cosmos DB Cassandra table.
        :paramtype default_ttl: int
        :keyword schema: Schema of the Cosmos DB Cassandra table.
        :paramtype schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.default_ttl = default_ttl
        self.schema = schema
        self.analytical_storage_ttl = analytical_storage_ttl


class CassandraTableGetPropertiesResource(CassandraTableResource, ExtendedResourceProperties):
    """CassandraTableGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB Cassandra table. Required.
    :vartype id: str
    :ivar default_ttl: Time to live of the Cosmos DB Cassandra table.
    :vartype default_ttl: int
    :ivar schema: Schema of the Cosmos DB Cassandra table.
    :vartype schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "schema": {"key": "schema", "type": "CassandraSchema"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        default_ttl: Optional[int] = None,
        schema: Optional["_models.CassandraSchema"] = None,
        analytical_storage_ttl: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB Cassandra table. Required.
        :paramtype id: str
        :keyword default_ttl: Time to live of the Cosmos DB Cassandra table.
        :paramtype default_ttl: int
        :keyword schema: Schema of the Cosmos DB Cassandra table.
        :paramtype schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        """
        super().__init__(
            id=id, default_ttl=default_ttl, schema=schema, analytical_storage_ttl=analytical_storage_ttl, **kwargs
        )
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.default_ttl = default_ttl
        self.schema = schema
        self.analytical_storage_ttl = analytical_storage_ttl


class CassandraTableGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Cassandra table.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.CassandraTableGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.CassandraTableGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "CassandraTableGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "CassandraTableGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.CassandraTableGetPropertiesResource"] = None,
        options: Optional["_models.CassandraTableGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.CassandraTableGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.CassandraTableGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class CassandraTableListResult(_serialization.Model):
    """The List operation response, that contains the Cassandra tables and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Cassandra tables and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.CassandraTableGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CassandraTableGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class Certificate(_serialization.Model):
    """Certificate.

    :ivar pem: PEM formatted public key.
    :vartype pem: str
    """

    _attribute_map = {
        "pem": {"key": "pem", "type": "str"},
    }

    def __init__(self, *, pem: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword pem: PEM formatted public key.
        :paramtype pem: str
        """
        super().__init__(**kwargs)
        self.pem = pem


class ClientEncryptionIncludedPath(_serialization.Model):
    """.

    All required parameters must be populated in order to send to server.

    :ivar path: Path that needs to be encrypted. Required.
    :vartype path: str
    :ivar client_encryption_key_id: The identifier of the Client Encryption Key to be used to
     encrypt the path. Required.
    :vartype client_encryption_key_id: str
    :ivar encryption_type: The type of encryption to be performed. Eg - Deterministic, Randomized.
     Required.
    :vartype encryption_type: str
    :ivar encryption_algorithm: The encryption algorithm which will be used. Eg -
     AEAD_AES_256_CBC_HMAC_SHA256. Required.
    :vartype encryption_algorithm: str
    """

    _validation = {
        "path": {"required": True},
        "client_encryption_key_id": {"required": True},
        "encryption_type": {"required": True},
        "encryption_algorithm": {"required": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "client_encryption_key_id": {"key": "clientEncryptionKeyId", "type": "str"},
        "encryption_type": {"key": "encryptionType", "type": "str"},
        "encryption_algorithm": {"key": "encryptionAlgorithm", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: str,
        client_encryption_key_id: str,
        encryption_type: str,
        encryption_algorithm: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: Path that needs to be encrypted. Required.
        :paramtype path: str
        :keyword client_encryption_key_id: The identifier of the Client Encryption Key to be used to
         encrypt the path. Required.
        :paramtype client_encryption_key_id: str
        :keyword encryption_type: The type of encryption to be performed. Eg - Deterministic,
         Randomized. Required.
        :paramtype encryption_type: str
        :keyword encryption_algorithm: The encryption algorithm which will be used. Eg -
         AEAD_AES_256_CBC_HMAC_SHA256. Required.
        :paramtype encryption_algorithm: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.client_encryption_key_id = client_encryption_key_id
        self.encryption_type = encryption_type
        self.encryption_algorithm = encryption_algorithm


class ClientEncryptionKeyCreateUpdateParameters(_serialization.Model):  # pylint: disable=name-too-long
    """Parameters to create and update ClientEncryptionKey.

    All required parameters must be populated in order to send to server.

    :ivar resource: The standard JSON format of a ClientEncryptionKey. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.ClientEncryptionKeyResource
    """

    _validation = {
        "resource": {"required": True},
    }

    _attribute_map = {
        "resource": {"key": "properties.resource", "type": "ClientEncryptionKeyResource"},
    }

    def __init__(self, *, resource: "_models.ClientEncryptionKeyResource", **kwargs: Any) -> None:
        """
        :keyword resource: The standard JSON format of a ClientEncryptionKey. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.ClientEncryptionKeyResource
        """
        super().__init__(**kwargs)
        self.resource = resource


class ClientEncryptionKeyResource(_serialization.Model):
    """Cosmos DB client encryption key resource object.

    :ivar id: Name of the ClientEncryptionKey.
    :vartype id: str
    :ivar encryption_algorithm: Encryption algorithm that will be used along with this client
     encryption key to encrypt/decrypt data.
    :vartype encryption_algorithm: str
    :ivar wrapped_data_encryption_key: Wrapped (encrypted) form of the key represented as a byte
     array.
    :vartype wrapped_data_encryption_key: bytes
    :ivar key_wrap_metadata: Metadata for the wrapping provider that can be used to unwrap the
     wrapped client encryption key.
    :vartype key_wrap_metadata: ~azure.mgmt.cosmosdb.models.KeyWrapMetadata
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "encryption_algorithm": {"key": "encryptionAlgorithm", "type": "str"},
        "wrapped_data_encryption_key": {"key": "wrappedDataEncryptionKey", "type": "bytearray"},
        "key_wrap_metadata": {"key": "keyWrapMetadata", "type": "KeyWrapMetadata"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        encryption_algorithm: Optional[str] = None,
        wrapped_data_encryption_key: Optional[bytes] = None,
        key_wrap_metadata: Optional["_models.KeyWrapMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the ClientEncryptionKey.
        :paramtype id: str
        :keyword encryption_algorithm: Encryption algorithm that will be used along with this client
         encryption key to encrypt/decrypt data.
        :paramtype encryption_algorithm: str
        :keyword wrapped_data_encryption_key: Wrapped (encrypted) form of the key represented as a byte
         array.
        :paramtype wrapped_data_encryption_key: bytes
        :keyword key_wrap_metadata: Metadata for the wrapping provider that can be used to unwrap the
         wrapped client encryption key.
        :paramtype key_wrap_metadata: ~azure.mgmt.cosmosdb.models.KeyWrapMetadata
        """
        super().__init__(**kwargs)
        self.id = id
        self.encryption_algorithm = encryption_algorithm
        self.wrapped_data_encryption_key = wrapped_data_encryption_key
        self.key_wrap_metadata = key_wrap_metadata


class ClientEncryptionKeyGetPropertiesResource(ClientEncryptionKeyResource, ExtendedResourceProperties):
    """ClientEncryptionKeyGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the ClientEncryptionKey.
    :vartype id: str
    :ivar encryption_algorithm: Encryption algorithm that will be used along with this client
     encryption key to encrypt/decrypt data.
    :vartype encryption_algorithm: str
    :ivar wrapped_data_encryption_key: Wrapped (encrypted) form of the key represented as a byte
     array.
    :vartype wrapped_data_encryption_key: bytes
    :ivar key_wrap_metadata: Metadata for the wrapping provider that can be used to unwrap the
     wrapped client encryption key.
    :vartype key_wrap_metadata: ~azure.mgmt.cosmosdb.models.KeyWrapMetadata
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "encryption_algorithm": {"key": "encryptionAlgorithm", "type": "str"},
        "wrapped_data_encryption_key": {"key": "wrappedDataEncryptionKey", "type": "bytearray"},
        "key_wrap_metadata": {"key": "keyWrapMetadata", "type": "KeyWrapMetadata"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        encryption_algorithm: Optional[str] = None,
        wrapped_data_encryption_key: Optional[bytes] = None,
        key_wrap_metadata: Optional["_models.KeyWrapMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the ClientEncryptionKey.
        :paramtype id: str
        :keyword encryption_algorithm: Encryption algorithm that will be used along with this client
         encryption key to encrypt/decrypt data.
        :paramtype encryption_algorithm: str
        :keyword wrapped_data_encryption_key: Wrapped (encrypted) form of the key represented as a byte
         array.
        :paramtype wrapped_data_encryption_key: bytes
        :keyword key_wrap_metadata: Metadata for the wrapping provider that can be used to unwrap the
         wrapped client encryption key.
        :paramtype key_wrap_metadata: ~azure.mgmt.cosmosdb.models.KeyWrapMetadata
        """
        super().__init__(
            id=id,
            encryption_algorithm=encryption_algorithm,
            wrapped_data_encryption_key=wrapped_data_encryption_key,
            key_wrap_metadata=key_wrap_metadata,
            **kwargs
        )
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.encryption_algorithm = encryption_algorithm
        self.wrapped_data_encryption_key = wrapped_data_encryption_key
        self.key_wrap_metadata = key_wrap_metadata


class ClientEncryptionKeyGetResults(ARMProxyResource):
    """Client Encryption Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.ClientEncryptionKeyGetPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "ClientEncryptionKeyGetPropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.ClientEncryptionKeyGetPropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.ClientEncryptionKeyGetPropertiesResource
        """
        super().__init__(**kwargs)
        self.resource = resource


class ClientEncryptionKeysListResult(_serialization.Model):
    """The List operation response, that contains the client encryption keys and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of client encryption keys and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.ClientEncryptionKeyGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClientEncryptionKeyGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class ClientEncryptionPolicy(_serialization.Model):
    """Cosmos DB client encryption policy.

    All required parameters must be populated in order to send to server.

    :ivar included_paths: Paths of the item that need encryption along with path-specific settings.
     Required.
    :vartype included_paths: list[~azure.mgmt.cosmosdb.models.ClientEncryptionIncludedPath]
    :ivar policy_format_version: Version of the client encryption policy definition. Supported
     versions are 1 and 2. Version 2 supports id and partition key path encryption. Required.
    :vartype policy_format_version: int
    """

    _validation = {
        "included_paths": {"required": True},
        "policy_format_version": {"required": True, "maximum": 2, "minimum": 1},
    }

    _attribute_map = {
        "included_paths": {"key": "includedPaths", "type": "[ClientEncryptionIncludedPath]"},
        "policy_format_version": {"key": "policyFormatVersion", "type": "int"},
    }

    def __init__(
        self, *, included_paths: List["_models.ClientEncryptionIncludedPath"], policy_format_version: int, **kwargs: Any
    ) -> None:
        """
        :keyword included_paths: Paths of the item that need encryption along with path-specific
         settings. Required.
        :paramtype included_paths: list[~azure.mgmt.cosmosdb.models.ClientEncryptionIncludedPath]
        :keyword policy_format_version: Version of the client encryption policy definition. Supported
         versions are 1 and 2. Version 2 supports id and partition key path encryption. Required.
        :paramtype policy_format_version: int
        """
        super().__init__(**kwargs)
        self.included_paths = included_paths
        self.policy_format_version = policy_format_version


class ClusterKey(_serialization.Model):
    """Cosmos DB Cassandra table cluster key.

    :ivar name: Name of the Cosmos DB Cassandra table cluster key.
    :vartype name: str
    :ivar order_by: Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and
     "Desc".
    :vartype order_by: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "order_by": {"key": "orderBy", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, order_by: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the Cosmos DB Cassandra table cluster key.
        :paramtype name: str
        :keyword order_by: Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and
         "Desc".
        :paramtype order_by: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.order_by = order_by


class ManagedCassandraARMResourceProperties(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.cosmosdb.models.ManagedCassandraManagedServiceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedCassandraManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedCassandraManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.cosmosdb.models.ManagedCassandraManagedServiceIdentity
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.identity = identity


class ClusterResource(ManagedCassandraARMResourceProperties):
    """Representation of a managed Cassandra cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.cosmosdb.models.ManagedCassandraManagedServiceIdentity
    :ivar properties: Properties of a managed Cassandra cluster.
    :vartype properties: ~azure.mgmt.cosmosdb.models.ClusterResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedCassandraManagedServiceIdentity"},
        "properties": {"key": "properties", "type": "ClusterResourceProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedCassandraManagedServiceIdentity"] = None,
        properties: Optional["_models.ClusterResourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.cosmosdb.models.ManagedCassandraManagedServiceIdentity
        :keyword properties: Properties of a managed Cassandra cluster.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.ClusterResourceProperties
        """
        super().__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.properties = properties


class ClusterResourceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of a managed Cassandra cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the resource at the time the operation was called.
     Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.cosmosdb.models.ManagedCassandraProvisioningState
    :ivar restore_from_backup_id: To create an empty cluster, omit this field or set it to null. To
     restore a backup into a new cluster, set this field to the resource id of the backup.
    :vartype restore_from_backup_id: str
    :ivar delegated_management_subnet_id: Resource id of a subnet that this cluster's management
     service should have its network interface attached to. The subnet must be routable to all
     subnets that will be delegated to data centers. The resource id must be of the form
     '/subscriptions/:code:`<subscription id>`/resourceGroups/:code:`<resource
     group>`/providers/Microsoft.Network/virtualNetworks/:code:`<virtual
     network>`/subnets/:code:`<subnet>`'.
    :vartype delegated_management_subnet_id: str
    :ivar cassandra_version: Which version of Cassandra should this cluster converge to running
     (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
    :vartype cassandra_version: str
    :ivar cluster_name_override: If you need to set the clusterName property in cassandra.yaml to
     something besides the resource name of the cluster, set the value to use on this property.
    :vartype cluster_name_override: str
    :ivar authentication_method: Which authentication method Cassandra should use to authenticate
     clients. 'None' turns off authentication, so should not be used except in emergencies.
     'Cassandra' is the default password based authentication. The default is 'Cassandra'. Known
     values are: "None", "Cassandra", and "Ldap".
    :vartype authentication_method: str or ~azure.mgmt.cosmosdb.models.AuthenticationMethod
    :ivar initial_cassandra_admin_password: Initial password for clients connecting as admin to the
     cluster. Should be changed after cluster creation. Returns null on GET. This field only applies
     when the authenticationMethod field is 'Cassandra'.
    :vartype initial_cassandra_admin_password: str
    :ivar prometheus_endpoint: Hostname or IP address where the Prometheus endpoint containing data
     about the managed Cassandra nodes can be reached.
    :vartype prometheus_endpoint: ~azure.mgmt.cosmosdb.models.SeedNode
    :ivar repair_enabled: Should automatic repairs run on this cluster? If omitted, this is true,
     and should stay true unless you are running a hybrid cluster where you are already doing your
     own repairs.
    :vartype repair_enabled: bool
    :ivar client_certificates: List of TLS certificates used to authorize clients connecting to the
     cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if
     clientCertificates is set, the managed Cassandra cluster will reject all connections not
     bearing a TLS client certificate that can be validated from one or more of the public
     certificates in this property.
    :vartype client_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
    :ivar external_gossip_certificates: List of TLS certificates used to authorize gossip from
     unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be
     verifiable using one of the certificates provided in this property.
    :vartype external_gossip_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
    :ivar gossip_certificates: List of TLS certificates that unmanaged nodes must trust for gossip
     with managed nodes. All managed nodes will present TLS client certificates that are verifiable
     using one of the certificates provided in this property.
    :vartype gossip_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
    :ivar external_seed_nodes: List of IP addresses of seed nodes in unmanaged data centers. These
     will be added to the seed node lists of all managed nodes.
    :vartype external_seed_nodes: list[~azure.mgmt.cosmosdb.models.SeedNode]
    :ivar seed_nodes: List of IP addresses of seed nodes in the managed data centers. These should
     be added to the seed node lists of all unmanaged nodes.
    :vartype seed_nodes: list[~azure.mgmt.cosmosdb.models.SeedNode]
    :ivar hours_between_backups: (Deprecated) Number of hours to wait between taking a backup of
     the cluster.
    :vartype hours_between_backups: int
    :ivar deallocated: Whether the cluster and associated data centers has been deallocated.
    :vartype deallocated: bool
    :ivar cassandra_audit_logging_enabled: Whether Cassandra audit logging is enabled.
    :vartype cassandra_audit_logging_enabled: bool
    :ivar provision_error: Error related to resource provisioning.
    :vartype provision_error: ~azure.mgmt.cosmosdb.models.CassandraError
    :ivar azure_connection_method: How to connect to the azure services needed for running the
     cluster. Known values are: "None" and "VPN".
    :vartype azure_connection_method: str or ~azure.mgmt.cosmosdb.models.AzureConnectionType
    :ivar private_link_resource_id: If the Connection Method is VPN, this is the Id of the private
     link resource that the datacenters need to connect to.
    :vartype private_link_resource_id: str
    """

    _validation = {
        "gossip_certificates": {"readonly": True},
        "seed_nodes": {"readonly": True},
        "private_link_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "restore_from_backup_id": {"key": "restoreFromBackupId", "type": "str"},
        "delegated_management_subnet_id": {"key": "delegatedManagementSubnetId", "type": "str"},
        "cassandra_version": {"key": "cassandraVersion", "type": "str"},
        "cluster_name_override": {"key": "clusterNameOverride", "type": "str"},
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
        "initial_cassandra_admin_password": {"key": "initialCassandraAdminPassword", "type": "str"},
        "prometheus_endpoint": {"key": "prometheusEndpoint", "type": "SeedNode"},
        "repair_enabled": {"key": "repairEnabled", "type": "bool"},
        "client_certificates": {"key": "clientCertificates", "type": "[Certificate]"},
        "external_gossip_certificates": {"key": "externalGossipCertificates", "type": "[Certificate]"},
        "gossip_certificates": {"key": "gossipCertificates", "type": "[Certificate]"},
        "external_seed_nodes": {"key": "externalSeedNodes", "type": "[SeedNode]"},
        "seed_nodes": {"key": "seedNodes", "type": "[SeedNode]"},
        "hours_between_backups": {"key": "hoursBetweenBackups", "type": "int"},
        "deallocated": {"key": "deallocated", "type": "bool"},
        "cassandra_audit_logging_enabled": {"key": "cassandraAuditLoggingEnabled", "type": "bool"},
        "provision_error": {"key": "provisionError", "type": "CassandraError"},
        "azure_connection_method": {"key": "azureConnectionMethod", "type": "str"},
        "private_link_resource_id": {"key": "privateLinkResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ManagedCassandraProvisioningState"]] = None,
        restore_from_backup_id: Optional[str] = None,
        delegated_management_subnet_id: Optional[str] = None,
        cassandra_version: Optional[str] = None,
        cluster_name_override: Optional[str] = None,
        authentication_method: Optional[Union[str, "_models.AuthenticationMethod"]] = None,
        initial_cassandra_admin_password: Optional[str] = None,
        prometheus_endpoint: Optional["_models.SeedNode"] = None,
        repair_enabled: Optional[bool] = None,
        client_certificates: Optional[List["_models.Certificate"]] = None,
        external_gossip_certificates: Optional[List["_models.Certificate"]] = None,
        external_seed_nodes: Optional[List["_models.SeedNode"]] = None,
        hours_between_backups: Optional[int] = None,
        deallocated: Optional[bool] = None,
        cassandra_audit_logging_enabled: Optional[bool] = None,
        provision_error: Optional["_models.CassandraError"] = None,
        azure_connection_method: Optional[Union[str, "_models.AzureConnectionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the resource at the time the operation was called.
         Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.cosmosdb.models.ManagedCassandraProvisioningState
        :keyword restore_from_backup_id: To create an empty cluster, omit this field or set it to null.
         To restore a backup into a new cluster, set this field to the resource id of the backup.
        :paramtype restore_from_backup_id: str
        :keyword delegated_management_subnet_id: Resource id of a subnet that this cluster's management
         service should have its network interface attached to. The subnet must be routable to all
         subnets that will be delegated to data centers. The resource id must be of the form
         '/subscriptions/:code:`<subscription id>`/resourceGroups/:code:`<resource
         group>`/providers/Microsoft.Network/virtualNetworks/:code:`<virtual
         network>`/subnets/:code:`<subnet>`'.
        :paramtype delegated_management_subnet_id: str
        :keyword cassandra_version: Which version of Cassandra should this cluster converge to running
         (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
        :paramtype cassandra_version: str
        :keyword cluster_name_override: If you need to set the clusterName property in cassandra.yaml
         to something besides the resource name of the cluster, set the value to use on this property.
        :paramtype cluster_name_override: str
        :keyword authentication_method: Which authentication method Cassandra should use to
         authenticate clients. 'None' turns off authentication, so should not be used except in
         emergencies. 'Cassandra' is the default password based authentication. The default is
         'Cassandra'. Known values are: "None", "Cassandra", and "Ldap".
        :paramtype authentication_method: str or ~azure.mgmt.cosmosdb.models.AuthenticationMethod
        :keyword initial_cassandra_admin_password: Initial password for clients connecting as admin to
         the cluster. Should be changed after cluster creation. Returns null on GET. This field only
         applies when the authenticationMethod field is 'Cassandra'.
        :paramtype initial_cassandra_admin_password: str
        :keyword prometheus_endpoint: Hostname or IP address where the Prometheus endpoint containing
         data about the managed Cassandra nodes can be reached.
        :paramtype prometheus_endpoint: ~azure.mgmt.cosmosdb.models.SeedNode
        :keyword repair_enabled: Should automatic repairs run on this cluster? If omitted, this is
         true, and should stay true unless you are running a hybrid cluster where you are already doing
         your own repairs.
        :paramtype repair_enabled: bool
        :keyword client_certificates: List of TLS certificates used to authorize clients connecting to
         the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if
         clientCertificates is set, the managed Cassandra cluster will reject all connections not
         bearing a TLS client certificate that can be validated from one or more of the public
         certificates in this property.
        :paramtype client_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
        :keyword external_gossip_certificates: List of TLS certificates used to authorize gossip from
         unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be
         verifiable using one of the certificates provided in this property.
        :paramtype external_gossip_certificates: list[~azure.mgmt.cosmosdb.models.Certificate]
        :keyword external_seed_nodes: List of IP addresses of seed nodes in unmanaged data centers.
         These will be added to the seed node lists of all managed nodes.
        :paramtype external_seed_nodes: list[~azure.mgmt.cosmosdb.models.SeedNode]
        :keyword hours_between_backups: (Deprecated) Number of hours to wait between taking a backup of
         the cluster.
        :paramtype hours_between_backups: int
        :keyword deallocated: Whether the cluster and associated data centers has been deallocated.
        :paramtype deallocated: bool
        :keyword cassandra_audit_logging_enabled: Whether Cassandra audit logging is enabled.
        :paramtype cassandra_audit_logging_enabled: bool
        :keyword provision_error: Error related to resource provisioning.
        :paramtype provision_error: ~azure.mgmt.cosmosdb.models.CassandraError
        :keyword azure_connection_method: How to connect to the azure services needed for running the
         cluster. Known values are: "None" and "VPN".
        :paramtype azure_connection_method: str or ~azure.mgmt.cosmosdb.models.AzureConnectionType
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.restore_from_backup_id = restore_from_backup_id
        self.delegated_management_subnet_id = delegated_management_subnet_id
        self.cassandra_version = cassandra_version
        self.cluster_name_override = cluster_name_override
        self.authentication_method = authentication_method
        self.initial_cassandra_admin_password = initial_cassandra_admin_password
        self.prometheus_endpoint = prometheus_endpoint
        self.repair_enabled = repair_enabled
        self.client_certificates = client_certificates
        self.external_gossip_certificates = external_gossip_certificates
        self.gossip_certificates = None
        self.external_seed_nodes = external_seed_nodes
        self.seed_nodes = None
        self.hours_between_backups = hours_between_backups
        self.deallocated = deallocated
        self.cassandra_audit_logging_enabled = cassandra_audit_logging_enabled
        self.provision_error = provision_error
        self.azure_connection_method = azure_connection_method
        self.private_link_resource_id = None


class Column(_serialization.Model):
    """Cosmos DB Cassandra table column.

    :ivar name: Name of the Cosmos DB Cassandra table column.
    :vartype name: str
    :ivar type: Type of the Cosmos DB Cassandra table column.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the Cosmos DB Cassandra table column.
        :paramtype name: str
        :keyword type: Type of the Cosmos DB Cassandra table column.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CommandOutput(_serialization.Model):
    """Response of /command api.

    :ivar command_output: Output of the command.
    :vartype command_output: str
    """

    _attribute_map = {
        "command_output": {"key": "commandOutput", "type": "str"},
    }

    def __init__(self, *, command_output: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword command_output: Output of the command.
        :paramtype command_output: str
        """
        super().__init__(**kwargs)
        self.command_output = command_output


class CommandPostBody(_serialization.Model):
    """Specification of which command to run where.

    All required parameters must be populated in order to send to server.

    :ivar command: The command which should be run. Required.
    :vartype command: str
    :ivar arguments: The arguments for the command to be run.
    :vartype arguments: dict[str, str]
    :ivar host: IP address of the cassandra host to run the command on. Required.
    :vartype host: str
    :ivar cassandra_stop_start: If true, stops cassandra before executing the command and then
     start it again.
    :vartype cassandra_stop_start: bool
    :ivar readwrite: If true, allows the command to *write* to the cassandra directory, otherwise
     read-only.
    :vartype readwrite: bool
    """

    _validation = {
        "command": {"required": True},
        "host": {"required": True},
    }

    _attribute_map = {
        "command": {"key": "command", "type": "str"},
        "arguments": {"key": "arguments", "type": "{str}"},
        "host": {"key": "host", "type": "str"},
        "cassandra_stop_start": {"key": "cassandra-stop-start", "type": "bool"},
        "readwrite": {"key": "readwrite", "type": "bool"},
    }

    def __init__(
        self,
        *,
        command: str,
        host: str,
        arguments: Optional[Dict[str, str]] = None,
        cassandra_stop_start: Optional[bool] = None,
        readwrite: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword command: The command which should be run. Required.
        :paramtype command: str
        :keyword arguments: The arguments for the command to be run.
        :paramtype arguments: dict[str, str]
        :keyword host: IP address of the cassandra host to run the command on. Required.
        :paramtype host: str
        :keyword cassandra_stop_start: If true, stops cassandra before executing the command and then
         start it again.
        :paramtype cassandra_stop_start: bool
        :keyword readwrite: If true, allows the command to *write* to the cassandra directory,
         otherwise read-only.
        :paramtype readwrite: bool
        """
        super().__init__(**kwargs)
        self.command = command
        self.arguments = arguments
        self.host = host
        self.cassandra_stop_start = cassandra_stop_start
        self.readwrite = readwrite


class CompositePath(_serialization.Model):
    """CompositePath.

    :ivar path: The path for which the indexing behavior applies to. Index paths typically start
     with root and end with wildcard (/path/*).
    :vartype path: str
    :ivar order: Sort order for composite paths. Known values are: "ascending" and "descending".
    :vartype order: str or ~azure.mgmt.cosmosdb.models.CompositePathSortOrder
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "order": {"key": "order", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        order: Optional[Union[str, "_models.CompositePathSortOrder"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path for which the indexing behavior applies to. Index paths typically start
         with root and end with wildcard (/path/*).
        :paramtype path: str
        :keyword order: Sort order for composite paths. Known values are: "ascending" and "descending".
        :paramtype order: str or ~azure.mgmt.cosmosdb.models.CompositePathSortOrder
        """
        super().__init__(**kwargs)
        self.path = path
        self.order = order


class ComputedProperty(_serialization.Model):
    """The definition of a computed property.

    :ivar name: The name of a computed property, for example - "cp_lowerName".
    :vartype name: str
    :ivar query: The query that evaluates the value for computed property, for example - "SELECT
     VALUE LOWER(c.name) FROM c".
    :vartype query: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, query: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of a computed property, for example - "cp_lowerName".
        :paramtype name: str
        :keyword query: The query that evaluates the value for computed property, for example - "SELECT
         VALUE LOWER(c.name) FROM c".
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.query = query


class ConflictResolutionPolicy(_serialization.Model):
    """The conflict resolution policy for the container.

    :ivar mode: Indicates the conflict resolution mode. Known values are: "LastWriterWins" and
     "Custom".
    :vartype mode: str or ~azure.mgmt.cosmosdb.models.ConflictResolutionMode
    :ivar conflict_resolution_path: The conflict resolution path in the case of LastWriterWins
     mode.
    :vartype conflict_resolution_path: str
    :ivar conflict_resolution_procedure: The procedure to resolve conflicts in the case of custom
     mode.
    :vartype conflict_resolution_procedure: str
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "conflict_resolution_path": {"key": "conflictResolutionPath", "type": "str"},
        "conflict_resolution_procedure": {"key": "conflictResolutionProcedure", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.ConflictResolutionMode"] = "LastWriterWins",
        conflict_resolution_path: Optional[str] = None,
        conflict_resolution_procedure: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Indicates the conflict resolution mode. Known values are: "LastWriterWins" and
         "Custom".
        :paramtype mode: str or ~azure.mgmt.cosmosdb.models.ConflictResolutionMode
        :keyword conflict_resolution_path: The conflict resolution path in the case of LastWriterWins
         mode.
        :paramtype conflict_resolution_path: str
        :keyword conflict_resolution_procedure: The procedure to resolve conflicts in the case of
         custom mode.
        :paramtype conflict_resolution_procedure: str
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.conflict_resolution_path = conflict_resolution_path
        self.conflict_resolution_procedure = conflict_resolution_procedure


class ConnectionError(_serialization.Model):
    """ConnectionError.

    :ivar connection_state: The kind of connection error that occurred. Known values are:
     "Unknown", "OK", "OperatorToDataCenterNetworkError", "DatacenterToDatacenterNetworkError",
     "InternalOperatorToDataCenterCertificateError", and "InternalError".
    :vartype connection_state: str or ~azure.mgmt.cosmosdb.models.ConnectionState
    :ivar i_p_from: The IP of host that originated the failed connection.
    :vartype i_p_from: str
    :ivar i_p_to: The IP that the connection attempted to reach.
    :vartype i_p_to: str
    :ivar port: The TCP port the connection was attempted on.
    :vartype port: int
    :ivar exception: Detailed error message about the failed connection.
    :vartype exception: str
    """

    _attribute_map = {
        "connection_state": {"key": "connectionState", "type": "str"},
        "i_p_from": {"key": "iPFrom", "type": "str"},
        "i_p_to": {"key": "iPTo", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "exception": {"key": "exception", "type": "str"},
    }

    def __init__(
        self,
        *,
        connection_state: Optional[Union[str, "_models.ConnectionState"]] = None,
        i_p_from: Optional[str] = None,
        i_p_to: Optional[str] = None,
        port: Optional[int] = None,
        exception: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connection_state: The kind of connection error that occurred. Known values are:
         "Unknown", "OK", "OperatorToDataCenterNetworkError", "DatacenterToDatacenterNetworkError",
         "InternalOperatorToDataCenterCertificateError", and "InternalError".
        :paramtype connection_state: str or ~azure.mgmt.cosmosdb.models.ConnectionState
        :keyword i_p_from: The IP of host that originated the failed connection.
        :paramtype i_p_from: str
        :keyword i_p_to: The IP that the connection attempted to reach.
        :paramtype i_p_to: str
        :keyword port: The TCP port the connection was attempted on.
        :paramtype port: int
        :keyword exception: Detailed error message about the failed connection.
        :paramtype exception: str
        """
        super().__init__(**kwargs)
        self.connection_state = connection_state
        self.i_p_from = i_p_from
        self.i_p_to = i_p_to
        self.port = port
        self.exception = exception


class ConsistencyPolicy(_serialization.Model):
    """The consistency policy for the Cosmos DB database account.

    All required parameters must be populated in order to send to server.

    :ivar default_consistency_level: The default consistency level and configuration settings of
     the Cosmos DB account. Required. Known values are: "Eventual", "Session", "BoundedStaleness",
     "Strong", and "ConsistentPrefix".
    :vartype default_consistency_level: str or ~azure.mgmt.cosmosdb.models.DefaultConsistencyLevel
    :ivar max_staleness_prefix: When used with the Bounded Staleness consistency level, this value
     represents the number of stale requests tolerated. Accepted range for this value is 1 –
     2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :vartype max_staleness_prefix: int
    :ivar max_interval_in_seconds: When used with the Bounded Staleness consistency level, this
     value represents the time amount of staleness (in seconds) tolerated. Accepted range for this
     value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :vartype max_interval_in_seconds: int
    """

    _validation = {
        "default_consistency_level": {"required": True},
        "max_staleness_prefix": {"maximum": 2147483647, "minimum": 1},
        "max_interval_in_seconds": {"maximum": 86400, "minimum": 5},
    }

    _attribute_map = {
        "default_consistency_level": {"key": "defaultConsistencyLevel", "type": "str"},
        "max_staleness_prefix": {"key": "maxStalenessPrefix", "type": "int"},
        "max_interval_in_seconds": {"key": "maxIntervalInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        default_consistency_level: Union[str, "_models.DefaultConsistencyLevel"],
        max_staleness_prefix: Optional[int] = None,
        max_interval_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_consistency_level: The default consistency level and configuration settings of
         the Cosmos DB account. Required. Known values are: "Eventual", "Session", "BoundedStaleness",
         "Strong", and "ConsistentPrefix".
        :paramtype default_consistency_level: str or
         ~azure.mgmt.cosmosdb.models.DefaultConsistencyLevel
        :keyword max_staleness_prefix: When used with the Bounded Staleness consistency level, this
         value represents the number of stale requests tolerated. Accepted range for this value is 1 –
         2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        :paramtype max_staleness_prefix: int
        :keyword max_interval_in_seconds: When used with the Bounded Staleness consistency level, this
         value represents the time amount of staleness (in seconds) tolerated. Accepted range for this
         value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        :paramtype max_interval_in_seconds: int
        """
        super().__init__(**kwargs)
        self.default_consistency_level = default_consistency_level
        self.max_staleness_prefix = max_staleness_prefix
        self.max_interval_in_seconds = max_interval_in_seconds


class ContainerPartitionKey(_serialization.Model):
    """The configuration of the partition key to be used for partitioning data into multiple
    partitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar paths: List of paths using which data within the container can be partitioned.
    :vartype paths: list[str]
    :ivar kind: Indicates the kind of algorithm used for partitioning. For MultiHash, multiple
     partition keys (upto three maximum) are supported for container create. Known values are:
     "Hash", "Range", and "MultiHash".
    :vartype kind: str or ~azure.mgmt.cosmosdb.models.PartitionKind
    :ivar version: Indicates the version of the partition key definition.
    :vartype version: int
    :ivar system_key: Indicates if the container is using a system generated partition key.
    :vartype system_key: bool
    """

    _validation = {
        "version": {"maximum": 2, "minimum": 1},
        "system_key": {"readonly": True},
    }

    _attribute_map = {
        "paths": {"key": "paths", "type": "[str]"},
        "kind": {"key": "kind", "type": "str"},
        "version": {"key": "version", "type": "int"},
        "system_key": {"key": "systemKey", "type": "bool"},
    }

    def __init__(
        self,
        *,
        paths: Optional[List[str]] = None,
        kind: Union[str, "_models.PartitionKind"] = "Hash",
        version: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword paths: List of paths using which data within the container can be partitioned.
        :paramtype paths: list[str]
        :keyword kind: Indicates the kind of algorithm used for partitioning. For MultiHash, multiple
         partition keys (upto three maximum) are supported for container create. Known values are:
         "Hash", "Range", and "MultiHash".
        :paramtype kind: str or ~azure.mgmt.cosmosdb.models.PartitionKind
        :keyword version: Indicates the version of the partition key definition.
        :paramtype version: int
        """
        super().__init__(**kwargs)
        self.paths = paths
        self.kind = kind
        self.version = version
        self.system_key = None


class ContinuousBackupInformation(_serialization.Model):
    """Information about the status of continuous backups.

    :ivar latest_restorable_timestamp: The latest restorable timestamp for a resource.
    :vartype latest_restorable_timestamp: str
    """

    _attribute_map = {
        "latest_restorable_timestamp": {"key": "latestRestorableTimestamp", "type": "str"},
    }

    def __init__(self, *, latest_restorable_timestamp: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword latest_restorable_timestamp: The latest restorable timestamp for a resource.
        :paramtype latest_restorable_timestamp: str
        """
        super().__init__(**kwargs)
        self.latest_restorable_timestamp = latest_restorable_timestamp


class ContinuousBackupRestoreLocation(_serialization.Model):
    """Properties of the regional restorable account.

    :ivar location: The name of the continuous backup restore location.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: The name of the continuous backup restore location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class ContinuousModeBackupPolicy(BackupPolicy):
    """The object representing continuous mode backup policy.

    All required parameters must be populated in order to send to server.

    :ivar type: Describes the mode of backups. Required. Known values are: "Periodic" and
     "Continuous".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.BackupPolicyType
    :ivar migration_state: The object representing the state of the migration between the backup
     policies.
    :vartype migration_state: ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationState
    :ivar continuous_mode_properties: Configuration values for continuous mode backup.
    :vartype continuous_mode_properties: ~azure.mgmt.cosmosdb.models.ContinuousModeProperties
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "migration_state": {"key": "migrationState", "type": "BackupPolicyMigrationState"},
        "continuous_mode_properties": {"key": "continuousModeProperties", "type": "ContinuousModeProperties"},
    }

    def __init__(
        self,
        *,
        migration_state: Optional["_models.BackupPolicyMigrationState"] = None,
        continuous_mode_properties: Optional["_models.ContinuousModeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword migration_state: The object representing the state of the migration between the backup
         policies.
        :paramtype migration_state: ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationState
        :keyword continuous_mode_properties: Configuration values for continuous mode backup.
        :paramtype continuous_mode_properties: ~azure.mgmt.cosmosdb.models.ContinuousModeProperties
        """
        super().__init__(migration_state=migration_state, **kwargs)
        self.type: str = "Continuous"
        self.continuous_mode_properties = continuous_mode_properties


class ContinuousModeProperties(_serialization.Model):
    """Configuration values for periodic mode backup.

    :ivar tier: Enum to indicate type of Continuous backup mode. Known values are:
     "Continuous7Days" and "Continuous30Days".
    :vartype tier: str or ~azure.mgmt.cosmosdb.models.ContinuousTier
    """

    _attribute_map = {
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, tier: Optional[Union[str, "_models.ContinuousTier"]] = None, **kwargs: Any) -> None:
        """
        :keyword tier: Enum to indicate type of Continuous backup mode. Known values are:
         "Continuous7Days" and "Continuous30Days".
        :paramtype tier: str or ~azure.mgmt.cosmosdb.models.ContinuousTier
        """
        super().__init__(**kwargs)
        self.tier = tier


class CorsPolicy(_serialization.Model):
    """The CORS policy for the Cosmos DB database account.

    All required parameters must be populated in order to send to server.

    :ivar allowed_origins: The origin domains that are permitted to make a request against the
     service via CORS. Required.
    :vartype allowed_origins: str
    :ivar allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a
     CORS request.
    :vartype allowed_methods: str
    :ivar allowed_headers: The request headers that the origin domain may specify on the CORS
     request.
    :vartype allowed_headers: str
    :ivar exposed_headers: The response headers that may be sent in the response to the CORS
     request and exposed by the browser to the request issuer.
    :vartype exposed_headers: str
    :ivar max_age_in_seconds: The maximum amount time that a browser should cache the preflight
     OPTIONS request.
    :vartype max_age_in_seconds: int
    """

    _validation = {
        "allowed_origins": {"required": True},
        "max_age_in_seconds": {"maximum": 2147483647, "minimum": 1},
    }

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "str"},
        "allowed_methods": {"key": "allowedMethods", "type": "str"},
        "allowed_headers": {"key": "allowedHeaders", "type": "str"},
        "exposed_headers": {"key": "exposedHeaders", "type": "str"},
        "max_age_in_seconds": {"key": "maxAgeInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        allowed_origins: str,
        allowed_methods: Optional[str] = None,
        allowed_headers: Optional[str] = None,
        exposed_headers: Optional[str] = None,
        max_age_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: The origin domains that are permitted to make a request against the
         service via CORS. Required.
        :paramtype allowed_origins: str
        :keyword allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a
         CORS request.
        :paramtype allowed_methods: str
        :keyword allowed_headers: The request headers that the origin domain may specify on the CORS
         request.
        :paramtype allowed_headers: str
        :keyword exposed_headers: The response headers that may be sent in the response to the CORS
         request and exposed by the browser to the request issuer.
        :paramtype exposed_headers: str
        :keyword max_age_in_seconds: The maximum amount time that a browser should cache the preflight
         OPTIONS request.
        :paramtype max_age_in_seconds: int
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.exposed_headers = exposed_headers
        self.max_age_in_seconds = max_age_in_seconds


class CreateUpdateOptions(_serialization.Model):
    """CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys
    are "If-Match", "If-None-Match", "Session-Token" and "Throughput".

    :ivar throughput: Request Units per second. For example, "throughput": 10000.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings. Note: Either throughput or
     autoscaleSettings is required, but not both.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        "throughput": {"key": "throughput", "type": "int"},
        "autoscale_settings": {"key": "autoscaleSettings", "type": "AutoscaleSettings"},
    }

    def __init__(
        self,
        *,
        throughput: Optional[int] = None,
        autoscale_settings: Optional["_models.AutoscaleSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword throughput: Request Units per second. For example, "throughput": 10000.
        :paramtype throughput: int
        :keyword autoscale_settings: Specifies the Autoscale settings. Note: Either throughput or
         autoscaleSettings is required, but not both.
        :paramtype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
        """
        super().__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings


class DatabaseAccountConnectionString(_serialization.Model):
    """Connection string for the Cosmos DB account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connection_string: Value of the connection string.
    :vartype connection_string: str
    :ivar description: Description of the connection string.
    :vartype description: str
    :ivar key_kind: Kind of the connection string key. Known values are: "Primary", "Secondary",
     "PrimaryReadonly", and "SecondaryReadonly".
    :vartype key_kind: str or ~azure.mgmt.cosmosdb.models.Kind
    :ivar type: Type of the connection string. Known values are: "Sql", "Table", "MongoDB",
     "Cassandra", "CassandraConnectorMetadata", "Gremlin", "SqlDedicatedGateway", "GremlinV2", and
     "Undefined".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.Type
    """

    _validation = {
        "connection_string": {"readonly": True},
        "description": {"readonly": True},
        "key_kind": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "key_kind": {"key": "keyKind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.connection_string = None
        self.description = None
        self.key_kind = None
        self.type = None


class DatabaseAccountCreateUpdateParameters(ARMResourceProperties):  # pylint: disable=too-many-instance-attributes
    """Parameters to create and update Cosmos DB database accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar kind: Indicates the type of database account. This can only be set at database account
     creation. Known values are: "GlobalDocumentDB", "MongoDB", and "Parse".
    :vartype kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :ivar consistency_policy: The consistency policy for the Cosmos DB account.
    :vartype consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :ivar locations: An array that contains the georeplication locations enabled for the Cosmos DB
     account. Required.
    :vartype locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar database_account_offer_type: The offer type for the database. Required. Default value is
     "Standard".
    :vartype database_account_offer_type: str
    :ivar ip_rules: List of IpRules.
    :vartype ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :ivar is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual
     Network ACL rules.
    :vartype is_virtual_network_filter_enabled: bool
    :ivar enable_automatic_failover: Enables automatic failover of the write region in the rare
     event that the region is unavailable due to an outage. Automatic failover will result in a new
     write region for the account and is chosen based on the failover priorities configured for the
     account.
    :vartype enable_automatic_failover: bool
    :ivar capabilities: List of Cosmos DB capabilities for the account.
    :vartype capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :ivar virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB
     account.
    :vartype virtual_network_rules: list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :ivar enable_multiple_write_locations: Enables the account to write in multiple locations.
    :vartype enable_multiple_write_locations: bool
    :ivar enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C* account.
    :vartype enable_cassandra_connector: bool
    :ivar connector_offer: The cassandra connector offer type for the Cosmos DB database C*
     account. "Small"
    :vartype connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :ivar disable_key_based_metadata_write_access: Disable write operations on metadata resources
     (databases, containers, throughput) via account keys.
    :vartype disable_key_based_metadata_write_access: bool
    :ivar key_vault_key_uri: The URI of the key vault.
    :vartype key_vault_key_uri: str
    :ivar default_identity: The default identity for accessing key vault used in features like
     customer managed keys. The default identity needs to be explicitly set by the users. It can be
     "FirstPartyIdentity", "SystemAssignedIdentity" and more.
    :vartype default_identity: str
    :ivar public_network_access: Whether requests from Public Network are allowed. Known values
     are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :ivar enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :vartype enable_free_tier: bool
    :ivar api_properties: API specific properties. Currently, supported only for MongoDB API.
    :vartype api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :ivar enable_analytical_storage: Flag to indicate whether to enable storage analytics.
    :vartype enable_analytical_storage: bool
    :ivar analytical_storage_configuration: Analytical storage specific properties.
    :vartype analytical_storage_configuration:
     ~azure.mgmt.cosmosdb.models.AnalyticalStorageConfiguration
    :ivar create_mode: Enum to indicate the mode of account creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar backup_policy: The object representing the policy for taking backups on an account.
    :vartype backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :ivar cors: The CORS policy for the Cosmos DB database account.
    :vartype cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :ivar network_acl_bypass: Indicates what services are allowed to bypass firewall checks. Known
     values are: "None" and "AzureServices".
    :vartype network_acl_bypass: str or ~azure.mgmt.cosmosdb.models.NetworkAclBypass
    :ivar network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network Acl
     Bypass for the Cosmos DB account.
    :vartype network_acl_bypass_resource_ids: list[str]
    :ivar disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be
     used exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.RestoreParameters
    :ivar capacity: The object that represents all properties related to capacity enforcement on an
     account.
    :vartype capacity: ~azure.mgmt.cosmosdb.models.Capacity
    :ivar keys_metadata: This property is ignored during the update/create operation, as the
     metadata is read-only. The object represents the metadata for the Account Keys of the Cosmos DB
     account.
    :vartype keys_metadata: ~azure.mgmt.cosmosdb.models.DatabaseAccountKeysMetadata
    :ivar enable_partition_merge: Flag to indicate enabling/disabling of Partition Merge feature on
     the account.
    :vartype enable_partition_merge: bool
    :ivar minimal_tls_version: Indicates the minimum allowed Tls version. The default value is Tls
     1.2. Cassandra and Mongo APIs only work with Tls 1.2. Known values are: "Tls", "Tls11", and
     "Tls12".
    :vartype minimal_tls_version: str or ~azure.mgmt.cosmosdb.models.MinimalTlsVersion
    :ivar enable_burst_capacity: Flag to indicate enabling/disabling of Burst Capacity feature on
     the account.
    :vartype enable_burst_capacity: bool
    :ivar customer_managed_key_status: Indicates the status of the Customer Managed Key feature on
     the account. In case there are errors, the property provides troubleshooting guidance.
    :vartype customer_managed_key_status: str
    :ivar enable_per_region_per_partition_autoscale: Flag to indicate enabling/disabling of
     PerRegionPerPartitionAutoscale feature on the account.
    :vartype enable_per_region_per_partition_autoscale: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "locations": {"required": True},
        "database_account_offer_type": {"required": True, "constant": True},
        "keys_metadata": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "consistency_policy": {"key": "properties.consistencyPolicy", "type": "ConsistencyPolicy"},
        "locations": {"key": "properties.locations", "type": "[Location]"},
        "database_account_offer_type": {"key": "properties.databaseAccountOfferType", "type": "str"},
        "ip_rules": {"key": "properties.ipRules", "type": "[IpAddressOrRange]"},
        "is_virtual_network_filter_enabled": {"key": "properties.isVirtualNetworkFilterEnabled", "type": "bool"},
        "enable_automatic_failover": {"key": "properties.enableAutomaticFailover", "type": "bool"},
        "capabilities": {"key": "properties.capabilities", "type": "[Capability]"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "enable_multiple_write_locations": {"key": "properties.enableMultipleWriteLocations", "type": "bool"},
        "enable_cassandra_connector": {"key": "properties.enableCassandraConnector", "type": "bool"},
        "connector_offer": {"key": "properties.connectorOffer", "type": "str"},
        "disable_key_based_metadata_write_access": {
            "key": "properties.disableKeyBasedMetadataWriteAccess",
            "type": "bool",
        },
        "key_vault_key_uri": {"key": "properties.keyVaultKeyUri", "type": "str"},
        "default_identity": {"key": "properties.defaultIdentity", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "enable_free_tier": {"key": "properties.enableFreeTier", "type": "bool"},
        "api_properties": {"key": "properties.apiProperties", "type": "ApiProperties"},
        "enable_analytical_storage": {"key": "properties.enableAnalyticalStorage", "type": "bool"},
        "analytical_storage_configuration": {
            "key": "properties.analyticalStorageConfiguration",
            "type": "AnalyticalStorageConfiguration",
        },
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "backup_policy": {"key": "properties.backupPolicy", "type": "BackupPolicy"},
        "cors": {"key": "properties.cors", "type": "[CorsPolicy]"},
        "network_acl_bypass": {"key": "properties.networkAclBypass", "type": "str"},
        "network_acl_bypass_resource_ids": {"key": "properties.networkAclBypassResourceIds", "type": "[str]"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "restore_parameters": {"key": "properties.restoreParameters", "type": "RestoreParameters"},
        "capacity": {"key": "properties.capacity", "type": "Capacity"},
        "keys_metadata": {"key": "properties.keysMetadata", "type": "DatabaseAccountKeysMetadata"},
        "enable_partition_merge": {"key": "properties.enablePartitionMerge", "type": "bool"},
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "enable_burst_capacity": {"key": "properties.enableBurstCapacity", "type": "bool"},
        "customer_managed_key_status": {"key": "properties.customerManagedKeyStatus", "type": "str"},
        "enable_per_region_per_partition_autoscale": {
            "key": "properties.enablePerRegionPerPartitionAutoscale",
            "type": "bool",
        },
    }

    database_account_offer_type = "Standard"

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        locations: List["_models.Location"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.DatabaseAccountKind"]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        consistency_policy: Optional["_models.ConsistencyPolicy"] = None,
        ip_rules: Optional[List["_models.IpAddressOrRange"]] = None,
        is_virtual_network_filter_enabled: Optional[bool] = None,
        enable_automatic_failover: Optional[bool] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        enable_multiple_write_locations: Optional[bool] = None,
        enable_cassandra_connector: Optional[bool] = None,
        connector_offer: Optional[Union[str, "_models.ConnectorOffer"]] = None,
        disable_key_based_metadata_write_access: Optional[bool] = None,
        key_vault_key_uri: Optional[str] = None,
        default_identity: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        enable_free_tier: Optional[bool] = None,
        api_properties: Optional["_models.ApiProperties"] = None,
        enable_analytical_storage: Optional[bool] = None,
        analytical_storage_configuration: Optional["_models.AnalyticalStorageConfiguration"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        backup_policy: Optional["_models.BackupPolicy"] = None,
        cors: Optional[List["_models.CorsPolicy"]] = None,
        network_acl_bypass: Optional[Union[str, "_models.NetworkAclBypass"]] = None,
        network_acl_bypass_resource_ids: Optional[List[str]] = None,
        disable_local_auth: Optional[bool] = None,
        restore_parameters: Optional["_models.RestoreParameters"] = None,
        capacity: Optional["_models.Capacity"] = None,
        enable_partition_merge: Optional[bool] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersion"]] = None,
        enable_burst_capacity: Optional[bool] = None,
        customer_managed_key_status: Optional[str] = None,
        enable_per_region_per_partition_autoscale: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword kind: Indicates the type of database account. This can only be set at database account
         creation. Known values are: "GlobalDocumentDB", "MongoDB", and "Parse".
        :paramtype kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
        :keyword consistency_policy: The consistency policy for the Cosmos DB account.
        :paramtype consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
        :keyword locations: An array that contains the georeplication locations enabled for the Cosmos
         DB account. Required.
        :paramtype locations: list[~azure.mgmt.cosmosdb.models.Location]
        :keyword ip_rules: List of IpRules.
        :paramtype ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
        :keyword is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual
         Network ACL rules.
        :paramtype is_virtual_network_filter_enabled: bool
        :keyword enable_automatic_failover: Enables automatic failover of the write region in the rare
         event that the region is unavailable due to an outage. Automatic failover will result in a new
         write region for the account and is chosen based on the failover priorities configured for the
         account.
        :paramtype enable_automatic_failover: bool
        :keyword capabilities: List of Cosmos DB capabilities for the account.
        :paramtype capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
        :keyword virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB
         account.
        :paramtype virtual_network_rules: list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
        :keyword enable_multiple_write_locations: Enables the account to write in multiple locations.
        :paramtype enable_multiple_write_locations: bool
        :keyword enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C*
         account.
        :paramtype enable_cassandra_connector: bool
        :keyword connector_offer: The cassandra connector offer type for the Cosmos DB database C*
         account. "Small"
        :paramtype connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
        :keyword disable_key_based_metadata_write_access: Disable write operations on metadata
         resources (databases, containers, throughput) via account keys.
        :paramtype disable_key_based_metadata_write_access: bool
        :keyword key_vault_key_uri: The URI of the key vault.
        :paramtype key_vault_key_uri: str
        :keyword default_identity: The default identity for accessing key vault used in features like
         customer managed keys. The default identity needs to be explicitly set by the users. It can be
         "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        :paramtype default_identity: str
        :keyword public_network_access: Whether requests from Public Network are allowed. Known values
         are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
        :keyword enable_free_tier: Flag to indicate whether Free Tier is enabled.
        :paramtype enable_free_tier: bool
        :keyword api_properties: API specific properties. Currently, supported only for MongoDB API.
        :paramtype api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
        :keyword enable_analytical_storage: Flag to indicate whether to enable storage analytics.
        :paramtype enable_analytical_storage: bool
        :keyword analytical_storage_configuration: Analytical storage specific properties.
        :paramtype analytical_storage_configuration:
         ~azure.mgmt.cosmosdb.models.AnalyticalStorageConfiguration
        :keyword create_mode: Enum to indicate the mode of account creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        :keyword backup_policy: The object representing the policy for taking backups on an account.
        :paramtype backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
        :keyword cors: The CORS policy for the Cosmos DB database account.
        :paramtype cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
        :keyword network_acl_bypass: Indicates what services are allowed to bypass firewall checks.
         Known values are: "None" and "AzureServices".
        :paramtype network_acl_bypass: str or ~azure.mgmt.cosmosdb.models.NetworkAclBypass
        :keyword network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network
         Acl Bypass for the Cosmos DB account.
        :paramtype network_acl_bypass_resource_ids: list[str]
        :keyword disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be
         used exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.RestoreParameters
        :keyword capacity: The object that represents all properties related to capacity enforcement on
         an account.
        :paramtype capacity: ~azure.mgmt.cosmosdb.models.Capacity
        :keyword enable_partition_merge: Flag to indicate enabling/disabling of Partition Merge feature
         on the account.
        :paramtype enable_partition_merge: bool
        :keyword minimal_tls_version: Indicates the minimum allowed Tls version. The default value is
         Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2. Known values are: "Tls", "Tls11", and
         "Tls12".
        :paramtype minimal_tls_version: str or ~azure.mgmt.cosmosdb.models.MinimalTlsVersion
        :keyword enable_burst_capacity: Flag to indicate enabling/disabling of Burst Capacity feature
         on the account.
        :paramtype enable_burst_capacity: bool
        :keyword customer_managed_key_status: Indicates the status of the Customer Managed Key feature
         on the account. In case there are errors, the property provides troubleshooting guidance.
        :paramtype customer_managed_key_status: str
        :keyword enable_per_region_per_partition_autoscale: Flag to indicate enabling/disabling of
         PerRegionPerPartitionAutoscale feature on the account.
        :paramtype enable_per_region_per_partition_autoscale: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.identity = identity
        self.consistency_policy = consistency_policy
        self.locations = locations
        self.ip_rules = ip_rules
        self.is_virtual_network_filter_enabled = is_virtual_network_filter_enabled
        self.enable_automatic_failover = enable_automatic_failover
        self.capabilities = capabilities
        self.virtual_network_rules = virtual_network_rules
        self.enable_multiple_write_locations = enable_multiple_write_locations
        self.enable_cassandra_connector = enable_cassandra_connector
        self.connector_offer = connector_offer
        self.disable_key_based_metadata_write_access = disable_key_based_metadata_write_access
        self.key_vault_key_uri = key_vault_key_uri
        self.default_identity = default_identity
        self.public_network_access = public_network_access
        self.enable_free_tier = enable_free_tier
        self.api_properties = api_properties
        self.enable_analytical_storage = enable_analytical_storage
        self.analytical_storage_configuration = analytical_storage_configuration
        self.create_mode = create_mode
        self.backup_policy = backup_policy
        self.cors = cors
        self.network_acl_bypass = network_acl_bypass
        self.network_acl_bypass_resource_ids = network_acl_bypass_resource_ids
        self.disable_local_auth = disable_local_auth
        self.restore_parameters = restore_parameters
        self.capacity = capacity
        self.keys_metadata = None
        self.enable_partition_merge = enable_partition_merge
        self.minimal_tls_version = minimal_tls_version
        self.enable_burst_capacity = enable_burst_capacity
        self.customer_managed_key_status = customer_managed_key_status
        self.enable_per_region_per_partition_autoscale = enable_per_region_per_partition_autoscale


class DatabaseAccountGetResults(ARMResourceProperties):  # pylint: disable=too-many-instance-attributes
    """An Azure Cosmos DB database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar kind: Indicates the type of database account. This can only be set at database account
     creation. Known values are: "GlobalDocumentDB", "MongoDB", and "Parse".
    :vartype kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.cosmosdb.models.SystemData
    :ivar provisioning_state: The status of the Cosmos DB account at the time the operation was
     called. The status can be one of following. 'Creating' – the Cosmos DB account is being
     created. When an account is in Creating state, only properties that are specified as input for
     the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is
     active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB
     account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' –
     the Cosmos DB account deletion failed.
    :vartype provisioning_state: str
    :ivar document_endpoint: The connection endpoint for the Cosmos DB database account.
    :vartype document_endpoint: str
    :ivar database_account_offer_type: The offer type for the Cosmos DB database account. Default
     value: Standard. Default value is "Standard".
    :vartype database_account_offer_type: str
    :ivar ip_rules: List of IpRules.
    :vartype ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :ivar is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual
     Network ACL rules.
    :vartype is_virtual_network_filter_enabled: bool
    :ivar enable_automatic_failover: Enables automatic failover of the write region in the rare
     event that the region is unavailable due to an outage. Automatic failover will result in a new
     write region for the account and is chosen based on the failover priorities configured for the
     account.
    :vartype enable_automatic_failover: bool
    :ivar consistency_policy: The consistency policy for the Cosmos DB database account.
    :vartype consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :ivar capabilities: List of Cosmos DB capabilities for the account.
    :vartype capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :ivar write_locations: An array that contains the write location for the Cosmos DB account.
    :vartype write_locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar read_locations: An array that contains of the read locations enabled for the Cosmos DB
     account.
    :vartype read_locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar locations: An array that contains all of the locations enabled for the Cosmos DB account.
    :vartype locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar failover_policies: An array that contains the regions ordered by their failover
     priorities.
    :vartype failover_policies: list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
    :ivar virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB
     account.
    :vartype virtual_network_rules: list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :ivar private_endpoint_connections: List of Private Endpoint Connections configured for the
     Cosmos DB account.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.cosmosdb.models.PrivateEndpointConnection]
    :ivar enable_multiple_write_locations: Enables the account to write in multiple locations.
    :vartype enable_multiple_write_locations: bool
    :ivar enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C* account.
    :vartype enable_cassandra_connector: bool
    :ivar connector_offer: The cassandra connector offer type for the Cosmos DB database C*
     account. "Small"
    :vartype connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :ivar disable_key_based_metadata_write_access: Disable write operations on metadata resources
     (databases, containers, throughput) via account keys.
    :vartype disable_key_based_metadata_write_access: bool
    :ivar key_vault_key_uri: The URI of the key vault.
    :vartype key_vault_key_uri: str
    :ivar default_identity: The default identity for accessing key vault used in features like
     customer managed keys. The default identity needs to be explicitly set by the users. It can be
     "FirstPartyIdentity", "SystemAssignedIdentity" and more.
    :vartype default_identity: str
    :ivar public_network_access: Whether requests from Public Network are allowed. Known values
     are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :ivar enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :vartype enable_free_tier: bool
    :ivar api_properties: API specific properties.
    :vartype api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :ivar enable_analytical_storage: Flag to indicate whether to enable storage analytics.
    :vartype enable_analytical_storage: bool
    :ivar analytical_storage_configuration: Analytical storage specific properties.
    :vartype analytical_storage_configuration:
     ~azure.mgmt.cosmosdb.models.AnalyticalStorageConfiguration
    :ivar instance_id: A unique identifier assigned to the database account.
    :vartype instance_id: str
    :ivar create_mode: Enum to indicate the mode of account creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.RestoreParameters
    :ivar backup_policy: The object representing the policy for taking backups on an account.
    :vartype backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :ivar cors: The CORS policy for the Cosmos DB database account.
    :vartype cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :ivar network_acl_bypass: Indicates what services are allowed to bypass firewall checks. Known
     values are: "None" and "AzureServices".
    :vartype network_acl_bypass: str or ~azure.mgmt.cosmosdb.models.NetworkAclBypass
    :ivar network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network Acl
     Bypass for the Cosmos DB account.
    :vartype network_acl_bypass_resource_ids: list[str]
    :ivar disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be
     used exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar capacity: The object that represents all properties related to capacity enforcement on an
     account.
    :vartype capacity: ~azure.mgmt.cosmosdb.models.Capacity
    :ivar keys_metadata: The object that represents the metadata for the Account Keys of the Cosmos
     DB account.
    :vartype keys_metadata: ~azure.mgmt.cosmosdb.models.DatabaseAccountKeysMetadata
    :ivar enable_partition_merge: Flag to indicate enabling/disabling of Partition Merge feature on
     the account.
    :vartype enable_partition_merge: bool
    :ivar minimal_tls_version: Indicates the minimum allowed Tls version. The default value is Tls
     1.2. Cassandra and Mongo APIs only work with Tls 1.2. Known values are: "Tls", "Tls11", and
     "Tls12".
    :vartype minimal_tls_version: str or ~azure.mgmt.cosmosdb.models.MinimalTlsVersion
    :ivar enable_burst_capacity: Flag to indicate enabling/disabling of Burst Capacity feature on
     the account.
    :vartype enable_burst_capacity: bool
    :ivar customer_managed_key_status: Indicates the status of the Customer Managed Key feature on
     the account. In case there are errors, the property provides troubleshooting guidance.
    :vartype customer_managed_key_status: str
    :ivar enable_per_region_per_partition_autoscale: Flag to indicate enabling/disabling of
     PerRegionPerPartitionAutoscale feature on the account.
    :vartype enable_per_region_per_partition_autoscale: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "document_endpoint": {"readonly": True},
        "database_account_offer_type": {"readonly": True},
        "write_locations": {"readonly": True},
        "read_locations": {"readonly": True},
        "locations": {"readonly": True},
        "failover_policies": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "instance_id": {"readonly": True},
        "keys_metadata": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "document_endpoint": {"key": "properties.documentEndpoint", "type": "str"},
        "database_account_offer_type": {"key": "properties.databaseAccountOfferType", "type": "str"},
        "ip_rules": {"key": "properties.ipRules", "type": "[IpAddressOrRange]"},
        "is_virtual_network_filter_enabled": {"key": "properties.isVirtualNetworkFilterEnabled", "type": "bool"},
        "enable_automatic_failover": {"key": "properties.enableAutomaticFailover", "type": "bool"},
        "consistency_policy": {"key": "properties.consistencyPolicy", "type": "ConsistencyPolicy"},
        "capabilities": {"key": "properties.capabilities", "type": "[Capability]"},
        "write_locations": {"key": "properties.writeLocations", "type": "[Location]"},
        "read_locations": {"key": "properties.readLocations", "type": "[Location]"},
        "locations": {"key": "properties.locations", "type": "[Location]"},
        "failover_policies": {"key": "properties.failoverPolicies", "type": "[FailoverPolicy]"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "enable_multiple_write_locations": {"key": "properties.enableMultipleWriteLocations", "type": "bool"},
        "enable_cassandra_connector": {"key": "properties.enableCassandraConnector", "type": "bool"},
        "connector_offer": {"key": "properties.connectorOffer", "type": "str"},
        "disable_key_based_metadata_write_access": {
            "key": "properties.disableKeyBasedMetadataWriteAccess",
            "type": "bool",
        },
        "key_vault_key_uri": {"key": "properties.keyVaultKeyUri", "type": "str"},
        "default_identity": {"key": "properties.defaultIdentity", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "enable_free_tier": {"key": "properties.enableFreeTier", "type": "bool"},
        "api_properties": {"key": "properties.apiProperties", "type": "ApiProperties"},
        "enable_analytical_storage": {"key": "properties.enableAnalyticalStorage", "type": "bool"},
        "analytical_storage_configuration": {
            "key": "properties.analyticalStorageConfiguration",
            "type": "AnalyticalStorageConfiguration",
        },
        "instance_id": {"key": "properties.instanceId", "type": "str"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "restore_parameters": {"key": "properties.restoreParameters", "type": "RestoreParameters"},
        "backup_policy": {"key": "properties.backupPolicy", "type": "BackupPolicy"},
        "cors": {"key": "properties.cors", "type": "[CorsPolicy]"},
        "network_acl_bypass": {"key": "properties.networkAclBypass", "type": "str"},
        "network_acl_bypass_resource_ids": {"key": "properties.networkAclBypassResourceIds", "type": "[str]"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "capacity": {"key": "properties.capacity", "type": "Capacity"},
        "keys_metadata": {"key": "properties.keysMetadata", "type": "DatabaseAccountKeysMetadata"},
        "enable_partition_merge": {"key": "properties.enablePartitionMerge", "type": "bool"},
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "enable_burst_capacity": {"key": "properties.enableBurstCapacity", "type": "bool"},
        "customer_managed_key_status": {"key": "properties.customerManagedKeyStatus", "type": "str"},
        "enable_per_region_per_partition_autoscale": {
            "key": "properties.enablePerRegionPerPartitionAutoscale",
            "type": "bool",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.DatabaseAccountKind"]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        ip_rules: Optional[List["_models.IpAddressOrRange"]] = None,
        is_virtual_network_filter_enabled: Optional[bool] = None,
        enable_automatic_failover: Optional[bool] = None,
        consistency_policy: Optional["_models.ConsistencyPolicy"] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        enable_multiple_write_locations: Optional[bool] = None,
        enable_cassandra_connector: Optional[bool] = None,
        connector_offer: Optional[Union[str, "_models.ConnectorOffer"]] = None,
        disable_key_based_metadata_write_access: Optional[bool] = None,
        key_vault_key_uri: Optional[str] = None,
        default_identity: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        enable_free_tier: Optional[bool] = None,
        api_properties: Optional["_models.ApiProperties"] = None,
        enable_analytical_storage: Optional[bool] = None,
        analytical_storage_configuration: Optional["_models.AnalyticalStorageConfiguration"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        restore_parameters: Optional["_models.RestoreParameters"] = None,
        backup_policy: Optional["_models.BackupPolicy"] = None,
        cors: Optional[List["_models.CorsPolicy"]] = None,
        network_acl_bypass: Optional[Union[str, "_models.NetworkAclBypass"]] = None,
        network_acl_bypass_resource_ids: Optional[List[str]] = None,
        disable_local_auth: Optional[bool] = None,
        capacity: Optional["_models.Capacity"] = None,
        enable_partition_merge: Optional[bool] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersion"]] = None,
        enable_burst_capacity: Optional[bool] = None,
        customer_managed_key_status: Optional[str] = None,
        enable_per_region_per_partition_autoscale: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword kind: Indicates the type of database account. This can only be set at database account
         creation. Known values are: "GlobalDocumentDB", "MongoDB", and "Parse".
        :paramtype kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
        :keyword ip_rules: List of IpRules.
        :paramtype ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
        :keyword is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual
         Network ACL rules.
        :paramtype is_virtual_network_filter_enabled: bool
        :keyword enable_automatic_failover: Enables automatic failover of the write region in the rare
         event that the region is unavailable due to an outage. Automatic failover will result in a new
         write region for the account and is chosen based on the failover priorities configured for the
         account.
        :paramtype enable_automatic_failover: bool
        :keyword consistency_policy: The consistency policy for the Cosmos DB database account.
        :paramtype consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
        :keyword capabilities: List of Cosmos DB capabilities for the account.
        :paramtype capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
        :keyword virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB
         account.
        :paramtype virtual_network_rules: list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
        :keyword enable_multiple_write_locations: Enables the account to write in multiple locations.
        :paramtype enable_multiple_write_locations: bool
        :keyword enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C*
         account.
        :paramtype enable_cassandra_connector: bool
        :keyword connector_offer: The cassandra connector offer type for the Cosmos DB database C*
         account. "Small"
        :paramtype connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
        :keyword disable_key_based_metadata_write_access: Disable write operations on metadata
         resources (databases, containers, throughput) via account keys.
        :paramtype disable_key_based_metadata_write_access: bool
        :keyword key_vault_key_uri: The URI of the key vault.
        :paramtype key_vault_key_uri: str
        :keyword default_identity: The default identity for accessing key vault used in features like
         customer managed keys. The default identity needs to be explicitly set by the users. It can be
         "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        :paramtype default_identity: str
        :keyword public_network_access: Whether requests from Public Network are allowed. Known values
         are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
        :keyword enable_free_tier: Flag to indicate whether Free Tier is enabled.
        :paramtype enable_free_tier: bool
        :keyword api_properties: API specific properties.
        :paramtype api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
        :keyword enable_analytical_storage: Flag to indicate whether to enable storage analytics.
        :paramtype enable_analytical_storage: bool
        :keyword analytical_storage_configuration: Analytical storage specific properties.
        :paramtype analytical_storage_configuration:
         ~azure.mgmt.cosmosdb.models.AnalyticalStorageConfiguration
        :keyword create_mode: Enum to indicate the mode of account creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.RestoreParameters
        :keyword backup_policy: The object representing the policy for taking backups on an account.
        :paramtype backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
        :keyword cors: The CORS policy for the Cosmos DB database account.
        :paramtype cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
        :keyword network_acl_bypass: Indicates what services are allowed to bypass firewall checks.
         Known values are: "None" and "AzureServices".
        :paramtype network_acl_bypass: str or ~azure.mgmt.cosmosdb.models.NetworkAclBypass
        :keyword network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network
         Acl Bypass for the Cosmos DB account.
        :paramtype network_acl_bypass_resource_ids: list[str]
        :keyword disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be
         used exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword capacity: The object that represents all properties related to capacity enforcement on
         an account.
        :paramtype capacity: ~azure.mgmt.cosmosdb.models.Capacity
        :keyword enable_partition_merge: Flag to indicate enabling/disabling of Partition Merge feature
         on the account.
        :paramtype enable_partition_merge: bool
        :keyword minimal_tls_version: Indicates the minimum allowed Tls version. The default value is
         Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2. Known values are: "Tls", "Tls11", and
         "Tls12".
        :paramtype minimal_tls_version: str or ~azure.mgmt.cosmosdb.models.MinimalTlsVersion
        :keyword enable_burst_capacity: Flag to indicate enabling/disabling of Burst Capacity feature
         on the account.
        :paramtype enable_burst_capacity: bool
        :keyword customer_managed_key_status: Indicates the status of the Customer Managed Key feature
         on the account. In case there are errors, the property provides troubleshooting guidance.
        :paramtype customer_managed_key_status: str
        :keyword enable_per_region_per_partition_autoscale: Flag to indicate enabling/disabling of
         PerRegionPerPartitionAutoscale feature on the account.
        :paramtype enable_per_region_per_partition_autoscale: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.identity = identity
        self.system_data = None
        self.provisioning_state = None
        self.document_endpoint = None
        self.database_account_offer_type = None
        self.ip_rules = ip_rules
        self.is_virtual_network_filter_enabled = is_virtual_network_filter_enabled
        self.enable_automatic_failover = enable_automatic_failover
        self.consistency_policy = consistency_policy
        self.capabilities = capabilities
        self.write_locations = None
        self.read_locations = None
        self.locations = None
        self.failover_policies = None
        self.virtual_network_rules = virtual_network_rules
        self.private_endpoint_connections = None
        self.enable_multiple_write_locations = enable_multiple_write_locations
        self.enable_cassandra_connector = enable_cassandra_connector
        self.connector_offer = connector_offer
        self.disable_key_based_metadata_write_access = disable_key_based_metadata_write_access
        self.key_vault_key_uri = key_vault_key_uri
        self.default_identity = default_identity
        self.public_network_access = public_network_access
        self.enable_free_tier = enable_free_tier
        self.api_properties = api_properties
        self.enable_analytical_storage = enable_analytical_storage
        self.analytical_storage_configuration = analytical_storage_configuration
        self.instance_id = None
        self.create_mode = create_mode
        self.restore_parameters = restore_parameters
        self.backup_policy = backup_policy
        self.cors = cors
        self.network_acl_bypass = network_acl_bypass
        self.network_acl_bypass_resource_ids = network_acl_bypass_resource_ids
        self.disable_local_auth = disable_local_auth
        self.capacity = capacity
        self.keys_metadata = None
        self.enable_partition_merge = enable_partition_merge
        self.minimal_tls_version = minimal_tls_version
        self.enable_burst_capacity = enable_burst_capacity
        self.customer_managed_key_status = customer_managed_key_status
        self.enable_per_region_per_partition_autoscale = enable_per_region_per_partition_autoscale


class DatabaseAccountKeysMetadata(_serialization.Model):
    """The metadata related to each access key for the given Cosmos DB database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_master_key: The metadata related to the Primary Read-Write Key for the given
     Cosmos DB database account.
    :vartype primary_master_key: ~azure.mgmt.cosmosdb.models.AccountKeyMetadata
    :ivar secondary_master_key: The metadata related to the Secondary Read-Write Key for the given
     Cosmos DB database account.
    :vartype secondary_master_key: ~azure.mgmt.cosmosdb.models.AccountKeyMetadata
    :ivar primary_readonly_master_key: The metadata related to the Primary Read-Only Key for the
     given Cosmos DB database account.
    :vartype primary_readonly_master_key: ~azure.mgmt.cosmosdb.models.AccountKeyMetadata
    :ivar secondary_readonly_master_key: The metadata related to the Secondary Read-Only Key for
     the given Cosmos DB database account.
    :vartype secondary_readonly_master_key: ~azure.mgmt.cosmosdb.models.AccountKeyMetadata
    """

    _validation = {
        "primary_master_key": {"readonly": True},
        "secondary_master_key": {"readonly": True},
        "primary_readonly_master_key": {"readonly": True},
        "secondary_readonly_master_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_master_key": {"key": "primaryMasterKey", "type": "AccountKeyMetadata"},
        "secondary_master_key": {"key": "secondaryMasterKey", "type": "AccountKeyMetadata"},
        "primary_readonly_master_key": {"key": "primaryReadonlyMasterKey", "type": "AccountKeyMetadata"},
        "secondary_readonly_master_key": {"key": "secondaryReadonlyMasterKey", "type": "AccountKeyMetadata"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_master_key = None
        self.secondary_master_key = None
        self.primary_readonly_master_key = None
        self.secondary_readonly_master_key = None


class DatabaseAccountListConnectionStringsResult(_serialization.Model):  # pylint: disable=name-too-long
    """The connection strings for the given database account.

    :ivar connection_strings: An array that contains the connection strings for the Cosmos DB
     account.
    :vartype connection_strings: list[~azure.mgmt.cosmosdb.models.DatabaseAccountConnectionString]
    """

    _attribute_map = {
        "connection_strings": {"key": "connectionStrings", "type": "[DatabaseAccountConnectionString]"},
    }

    def __init__(
        self, *, connection_strings: Optional[List["_models.DatabaseAccountConnectionString"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connection_strings: An array that contains the connection strings for the Cosmos DB
         account.
        :paramtype connection_strings:
         list[~azure.mgmt.cosmosdb.models.DatabaseAccountConnectionString]
        """
        super().__init__(**kwargs)
        self.connection_strings = connection_strings


class DatabaseAccountListReadOnlyKeysResult(_serialization.Model):
    """The read-only access keys for the given database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_readonly_master_key: Base 64 encoded value of the primary read-only key.
    :vartype primary_readonly_master_key: str
    :ivar secondary_readonly_master_key: Base 64 encoded value of the secondary read-only key.
    :vartype secondary_readonly_master_key: str
    """

    _validation = {
        "primary_readonly_master_key": {"readonly": True},
        "secondary_readonly_master_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_readonly_master_key": {"key": "primaryReadonlyMasterKey", "type": "str"},
        "secondary_readonly_master_key": {"key": "secondaryReadonlyMasterKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_readonly_master_key = None
        self.secondary_readonly_master_key = None


class DatabaseAccountListKeysResult(DatabaseAccountListReadOnlyKeysResult):
    """The access keys for the given database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_readonly_master_key: Base 64 encoded value of the primary read-only key.
    :vartype primary_readonly_master_key: str
    :ivar secondary_readonly_master_key: Base 64 encoded value of the secondary read-only key.
    :vartype secondary_readonly_master_key: str
    :ivar primary_master_key: Base 64 encoded value of the primary read-write key.
    :vartype primary_master_key: str
    :ivar secondary_master_key: Base 64 encoded value of the secondary read-write key.
    :vartype secondary_master_key: str
    """

    _validation = {
        "primary_readonly_master_key": {"readonly": True},
        "secondary_readonly_master_key": {"readonly": True},
        "primary_master_key": {"readonly": True},
        "secondary_master_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_readonly_master_key": {"key": "primaryReadonlyMasterKey", "type": "str"},
        "secondary_readonly_master_key": {"key": "secondaryReadonlyMasterKey", "type": "str"},
        "primary_master_key": {"key": "primaryMasterKey", "type": "str"},
        "secondary_master_key": {"key": "secondaryMasterKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_master_key = None
        self.secondary_master_key = None


class DatabaseAccountRegenerateKeyParameters(_serialization.Model):
    """Parameters to regenerate the keys within the database account.

    All required parameters must be populated in order to send to server.

    :ivar key_kind: The access key to regenerate. Required. Known values are: "primary",
     "secondary", "primaryReadonly", and "secondaryReadonly".
    :vartype key_kind: str or ~azure.mgmt.cosmosdb.models.KeyKind
    """

    _validation = {
        "key_kind": {"required": True},
    }

    _attribute_map = {
        "key_kind": {"key": "keyKind", "type": "str"},
    }

    def __init__(self, *, key_kind: Union[str, "_models.KeyKind"], **kwargs: Any) -> None:
        """
        :keyword key_kind: The access key to regenerate. Required. Known values are: "primary",
         "secondary", "primaryReadonly", and "secondaryReadonly".
        :paramtype key_kind: str or ~azure.mgmt.cosmosdb.models.KeyKind
        """
        super().__init__(**kwargs)
        self.key_kind = key_kind


class DatabaseAccountsListResult(_serialization.Model):
    """The List operation response, that contains the database accounts and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of database account and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.DatabaseAccountGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseAccountGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class DatabaseAccountUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Parameters for patching Azure Cosmos DB database account properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :ivar consistency_policy: The consistency policy for the Cosmos DB account.
    :vartype consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :ivar locations: An array that contains the georeplication locations enabled for the Cosmos DB
     account.
    :vartype locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar ip_rules: List of IpRules.
    :vartype ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :ivar is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual
     Network ACL rules.
    :vartype is_virtual_network_filter_enabled: bool
    :ivar enable_automatic_failover: Enables automatic failover of the write region in the rare
     event that the region is unavailable due to an outage. Automatic failover will result in a new
     write region for the account and is chosen based on the failover priorities configured for the
     account.
    :vartype enable_automatic_failover: bool
    :ivar capabilities: List of Cosmos DB capabilities for the account.
    :vartype capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :ivar virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB
     account.
    :vartype virtual_network_rules: list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :ivar enable_multiple_write_locations: Enables the account to write in multiple locations.
    :vartype enable_multiple_write_locations: bool
    :ivar enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C* account.
    :vartype enable_cassandra_connector: bool
    :ivar connector_offer: The cassandra connector offer type for the Cosmos DB database C*
     account. "Small"
    :vartype connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :ivar disable_key_based_metadata_write_access: Disable write operations on metadata resources
     (databases, containers, throughput) via account keys.
    :vartype disable_key_based_metadata_write_access: bool
    :ivar key_vault_key_uri: The URI of the key vault.
    :vartype key_vault_key_uri: str
    :ivar default_identity: The default identity for accessing key vault used in features like
     customer managed keys. The default identity needs to be explicitly set by the users. It can be
     "FirstPartyIdentity", "SystemAssignedIdentity" and more.
    :vartype default_identity: str
    :ivar public_network_access: Whether requests from Public Network are allowed. Known values
     are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :ivar enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :vartype enable_free_tier: bool
    :ivar api_properties: API specific properties. Currently, supported only for MongoDB API.
    :vartype api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :ivar enable_analytical_storage: Flag to indicate whether to enable storage analytics.
    :vartype enable_analytical_storage: bool
    :ivar analytical_storage_configuration: Analytical storage specific properties.
    :vartype analytical_storage_configuration:
     ~azure.mgmt.cosmosdb.models.AnalyticalStorageConfiguration
    :ivar backup_policy: The object representing the policy for taking backups on an account.
    :vartype backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :ivar cors: The CORS policy for the Cosmos DB database account.
    :vartype cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :ivar network_acl_bypass: Indicates what services are allowed to bypass firewall checks. Known
     values are: "None" and "AzureServices".
    :vartype network_acl_bypass: str or ~azure.mgmt.cosmosdb.models.NetworkAclBypass
    :ivar network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network Acl
     Bypass for the Cosmos DB account.
    :vartype network_acl_bypass_resource_ids: list[str]
    :ivar disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be
     used exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar capacity: The object that represents all properties related to capacity enforcement on an
     account.
    :vartype capacity: ~azure.mgmt.cosmosdb.models.Capacity
    :ivar keys_metadata: This property is ignored during the update operation, as the metadata is
     read-only. The object represents the metadata for the Account Keys of the Cosmos DB account.
    :vartype keys_metadata: ~azure.mgmt.cosmosdb.models.DatabaseAccountKeysMetadata
    :ivar enable_partition_merge: Flag to indicate enabling/disabling of Partition Merge feature on
     the account.
    :vartype enable_partition_merge: bool
    :ivar minimal_tls_version: Indicates the minimum allowed Tls version. The default value is Tls
     1.2. Cassandra and Mongo APIs only work with Tls 1.2. Known values are: "Tls", "Tls11", and
     "Tls12".
    :vartype minimal_tls_version: str or ~azure.mgmt.cosmosdb.models.MinimalTlsVersion
    :ivar enable_burst_capacity: Flag to indicate enabling/disabling of Burst Capacity feature on
     the account.
    :vartype enable_burst_capacity: bool
    :ivar customer_managed_key_status: Indicates the status of the Customer Managed Key feature on
     the account. In case there are errors, the property provides troubleshooting guidance.
    :vartype customer_managed_key_status: str
    :ivar enable_per_region_per_partition_autoscale: Flag to indicate enabling/disabling of
     PerRegionPerPartitionAutoscale feature on the account.
    :vartype enable_per_region_per_partition_autoscale: bool
    """

    _validation = {
        "keys_metadata": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "consistency_policy": {"key": "properties.consistencyPolicy", "type": "ConsistencyPolicy"},
        "locations": {"key": "properties.locations", "type": "[Location]"},
        "ip_rules": {"key": "properties.ipRules", "type": "[IpAddressOrRange]"},
        "is_virtual_network_filter_enabled": {"key": "properties.isVirtualNetworkFilterEnabled", "type": "bool"},
        "enable_automatic_failover": {"key": "properties.enableAutomaticFailover", "type": "bool"},
        "capabilities": {"key": "properties.capabilities", "type": "[Capability]"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "enable_multiple_write_locations": {"key": "properties.enableMultipleWriteLocations", "type": "bool"},
        "enable_cassandra_connector": {"key": "properties.enableCassandraConnector", "type": "bool"},
        "connector_offer": {"key": "properties.connectorOffer", "type": "str"},
        "disable_key_based_metadata_write_access": {
            "key": "properties.disableKeyBasedMetadataWriteAccess",
            "type": "bool",
        },
        "key_vault_key_uri": {"key": "properties.keyVaultKeyUri", "type": "str"},
        "default_identity": {"key": "properties.defaultIdentity", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "enable_free_tier": {"key": "properties.enableFreeTier", "type": "bool"},
        "api_properties": {"key": "properties.apiProperties", "type": "ApiProperties"},
        "enable_analytical_storage": {"key": "properties.enableAnalyticalStorage", "type": "bool"},
        "analytical_storage_configuration": {
            "key": "properties.analyticalStorageConfiguration",
            "type": "AnalyticalStorageConfiguration",
        },
        "backup_policy": {"key": "properties.backupPolicy", "type": "BackupPolicy"},
        "cors": {"key": "properties.cors", "type": "[CorsPolicy]"},
        "network_acl_bypass": {"key": "properties.networkAclBypass", "type": "str"},
        "network_acl_bypass_resource_ids": {"key": "properties.networkAclBypassResourceIds", "type": "[str]"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "capacity": {"key": "properties.capacity", "type": "Capacity"},
        "keys_metadata": {"key": "properties.keysMetadata", "type": "DatabaseAccountKeysMetadata"},
        "enable_partition_merge": {"key": "properties.enablePartitionMerge", "type": "bool"},
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "enable_burst_capacity": {"key": "properties.enableBurstCapacity", "type": "bool"},
        "customer_managed_key_status": {"key": "properties.customerManagedKeyStatus", "type": "str"},
        "enable_per_region_per_partition_autoscale": {
            "key": "properties.enablePerRegionPerPartitionAutoscale",
            "type": "bool",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        consistency_policy: Optional["_models.ConsistencyPolicy"] = None,
        locations: Optional[List["_models.Location"]] = None,
        ip_rules: Optional[List["_models.IpAddressOrRange"]] = None,
        is_virtual_network_filter_enabled: Optional[bool] = None,
        enable_automatic_failover: Optional[bool] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        enable_multiple_write_locations: Optional[bool] = None,
        enable_cassandra_connector: Optional[bool] = None,
        connector_offer: Optional[Union[str, "_models.ConnectorOffer"]] = None,
        disable_key_based_metadata_write_access: Optional[bool] = None,
        key_vault_key_uri: Optional[str] = None,
        default_identity: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        enable_free_tier: Optional[bool] = None,
        api_properties: Optional["_models.ApiProperties"] = None,
        enable_analytical_storage: Optional[bool] = None,
        analytical_storage_configuration: Optional["_models.AnalyticalStorageConfiguration"] = None,
        backup_policy: Optional["_models.BackupPolicy"] = None,
        cors: Optional[List["_models.CorsPolicy"]] = None,
        network_acl_bypass: Optional[Union[str, "_models.NetworkAclBypass"]] = None,
        network_acl_bypass_resource_ids: Optional[List[str]] = None,
        disable_local_auth: Optional[bool] = None,
        capacity: Optional["_models.Capacity"] = None,
        enable_partition_merge: Optional[bool] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersion"]] = None,
        enable_burst_capacity: Optional[bool] = None,
        customer_managed_key_status: Optional[str] = None,
        enable_per_region_per_partition_autoscale: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
        :keyword consistency_policy: The consistency policy for the Cosmos DB account.
        :paramtype consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
        :keyword locations: An array that contains the georeplication locations enabled for the Cosmos
         DB account.
        :paramtype locations: list[~azure.mgmt.cosmosdb.models.Location]
        :keyword ip_rules: List of IpRules.
        :paramtype ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
        :keyword is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual
         Network ACL rules.
        :paramtype is_virtual_network_filter_enabled: bool
        :keyword enable_automatic_failover: Enables automatic failover of the write region in the rare
         event that the region is unavailable due to an outage. Automatic failover will result in a new
         write region for the account and is chosen based on the failover priorities configured for the
         account.
        :paramtype enable_automatic_failover: bool
        :keyword capabilities: List of Cosmos DB capabilities for the account.
        :paramtype capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
        :keyword virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB
         account.
        :paramtype virtual_network_rules: list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
        :keyword enable_multiple_write_locations: Enables the account to write in multiple locations.
        :paramtype enable_multiple_write_locations: bool
        :keyword enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C*
         account.
        :paramtype enable_cassandra_connector: bool
        :keyword connector_offer: The cassandra connector offer type for the Cosmos DB database C*
         account. "Small"
        :paramtype connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
        :keyword disable_key_based_metadata_write_access: Disable write operations on metadata
         resources (databases, containers, throughput) via account keys.
        :paramtype disable_key_based_metadata_write_access: bool
        :keyword key_vault_key_uri: The URI of the key vault.
        :paramtype key_vault_key_uri: str
        :keyword default_identity: The default identity for accessing key vault used in features like
         customer managed keys. The default identity needs to be explicitly set by the users. It can be
         "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        :paramtype default_identity: str
        :keyword public_network_access: Whether requests from Public Network are allowed. Known values
         are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
        :keyword enable_free_tier: Flag to indicate whether Free Tier is enabled.
        :paramtype enable_free_tier: bool
        :keyword api_properties: API specific properties. Currently, supported only for MongoDB API.
        :paramtype api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
        :keyword enable_analytical_storage: Flag to indicate whether to enable storage analytics.
        :paramtype enable_analytical_storage: bool
        :keyword analytical_storage_configuration: Analytical storage specific properties.
        :paramtype analytical_storage_configuration:
         ~azure.mgmt.cosmosdb.models.AnalyticalStorageConfiguration
        :keyword backup_policy: The object representing the policy for taking backups on an account.
        :paramtype backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
        :keyword cors: The CORS policy for the Cosmos DB database account.
        :paramtype cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
        :keyword network_acl_bypass: Indicates what services are allowed to bypass firewall checks.
         Known values are: "None" and "AzureServices".
        :paramtype network_acl_bypass: str or ~azure.mgmt.cosmosdb.models.NetworkAclBypass
        :keyword network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network
         Acl Bypass for the Cosmos DB account.
        :paramtype network_acl_bypass_resource_ids: list[str]
        :keyword disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be
         used exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword capacity: The object that represents all properties related to capacity enforcement on
         an account.
        :paramtype capacity: ~azure.mgmt.cosmosdb.models.Capacity
        :keyword enable_partition_merge: Flag to indicate enabling/disabling of Partition Merge feature
         on the account.
        :paramtype enable_partition_merge: bool
        :keyword minimal_tls_version: Indicates the minimum allowed Tls version. The default value is
         Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2. Known values are: "Tls", "Tls11", and
         "Tls12".
        :paramtype minimal_tls_version: str or ~azure.mgmt.cosmosdb.models.MinimalTlsVersion
        :keyword enable_burst_capacity: Flag to indicate enabling/disabling of Burst Capacity feature
         on the account.
        :paramtype enable_burst_capacity: bool
        :keyword customer_managed_key_status: Indicates the status of the Customer Managed Key feature
         on the account. In case there are errors, the property provides troubleshooting guidance.
        :paramtype customer_managed_key_status: str
        :keyword enable_per_region_per_partition_autoscale: Flag to indicate enabling/disabling of
         PerRegionPerPartitionAutoscale feature on the account.
        :paramtype enable_per_region_per_partition_autoscale: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.identity = identity
        self.consistency_policy = consistency_policy
        self.locations = locations
        self.ip_rules = ip_rules
        self.is_virtual_network_filter_enabled = is_virtual_network_filter_enabled
        self.enable_automatic_failover = enable_automatic_failover
        self.capabilities = capabilities
        self.virtual_network_rules = virtual_network_rules
        self.enable_multiple_write_locations = enable_multiple_write_locations
        self.enable_cassandra_connector = enable_cassandra_connector
        self.connector_offer = connector_offer
        self.disable_key_based_metadata_write_access = disable_key_based_metadata_write_access
        self.key_vault_key_uri = key_vault_key_uri
        self.default_identity = default_identity
        self.public_network_access = public_network_access
        self.enable_free_tier = enable_free_tier
        self.api_properties = api_properties
        self.enable_analytical_storage = enable_analytical_storage
        self.analytical_storage_configuration = analytical_storage_configuration
        self.backup_policy = backup_policy
        self.cors = cors
        self.network_acl_bypass = network_acl_bypass
        self.network_acl_bypass_resource_ids = network_acl_bypass_resource_ids
        self.disable_local_auth = disable_local_auth
        self.capacity = capacity
        self.keys_metadata = None
        self.enable_partition_merge = enable_partition_merge
        self.minimal_tls_version = minimal_tls_version
        self.enable_burst_capacity = enable_burst_capacity
        self.customer_managed_key_status = customer_managed_key_status
        self.enable_per_region_per_partition_autoscale = enable_per_region_per_partition_autoscale


class DatabaseRestoreResource(_serialization.Model):
    """Specific Databases to restore.

    :ivar database_name: The name of the database available for restore.
    :vartype database_name: str
    :ivar collection_names: The names of the collections available for restore.
    :vartype collection_names: list[str]
    """

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "collection_names": {"key": "collectionNames", "type": "[str]"},
    }

    def __init__(
        self, *, database_name: Optional[str] = None, collection_names: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database_name: The name of the database available for restore.
        :paramtype database_name: str
        :keyword collection_names: The names of the collections available for restore.
        :paramtype collection_names: list[str]
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.collection_names = collection_names


class DataCenterResource(ARMProxyResource):
    """A managed Cassandra data center.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar properties: Properties of a managed Cassandra data center.
    :vartype properties: ~azure.mgmt.cosmosdb.models.DataCenterResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DataCenterResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DataCenterResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of a managed Cassandra data center.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.DataCenterResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataCenterResourceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of a managed Cassandra data center.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the resource at the time the operation was called.
     Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.cosmosdb.models.ManagedCassandraProvisioningState
    :ivar data_center_location: The region this data center should be created in.
    :vartype data_center_location: str
    :ivar delegated_subnet_id: Resource id of a subnet the nodes in this data center should have
     their network interfaces connected to. The subnet must be in the same region specified in
     'dataCenterLocation' and must be able to route to the subnet specified in the cluster's
     'delegatedManagementSubnetId' property. This resource id will be of the form
     '/subscriptions/:code:`<subscription id>`/resourceGroups/:code:`<resource
     group>`/providers/Microsoft.Network/virtualNetworks/:code:`<virtual
     network>`/subnets/:code:`<subnet>`'.
    :vartype delegated_subnet_id: str
    :ivar node_count: The number of nodes the data center should have. This is the desired number.
     After it is set, it may take some time for the data center to be scaled to match. To monitor
     the number of nodes and their status, use the fetchNodeStatus method on the cluster.
    :vartype node_count: int
    :ivar seed_nodes: IP addresses for seed nodes in this data center. This is for reference.
     Generally you will want to use the seedNodes property on the cluster, which aggregates the seed
     nodes from all data centers in the cluster.
    :vartype seed_nodes: list[~azure.mgmt.cosmosdb.models.SeedNode]
    :ivar base64_encoded_cassandra_yaml_fragment: A fragment of a cassandra.yaml configuration file
     to be included in the cassandra.yaml for all nodes in this data center. The fragment should be
     Base64 encoded, and only a subset of keys are allowed.
    :vartype base64_encoded_cassandra_yaml_fragment: str
    :ivar managed_disk_customer_key_uri: Key uri to use for encryption of managed disks. Ensure the
     system assigned identity of the cluster has been assigned appropriate permissions(key
     get/wrap/unwrap permissions) on the key.
    :vartype managed_disk_customer_key_uri: str
    :ivar backup_storage_customer_key_uri: Indicates the Key Uri of the customer key to use for
     encryption of the backup storage account.
    :vartype backup_storage_customer_key_uri: str
    :ivar sku: Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2.
    :vartype sku: str
    :ivar disk_sku: Disk SKU used for data centers. Default value is P30.
    :vartype disk_sku: str
    :ivar disk_capacity: Number of disks attached to each node. Default is 4.
    :vartype disk_capacity: int
    :ivar availability_zone: If the data center has Availability Zone support, apply it to the
     Virtual Machine ScaleSet that host the cassandra data center virtual machines.
    :vartype availability_zone: bool
    :ivar authentication_method_ldap_properties: Ldap authentication method properties. This
     feature is in preview.
    :vartype authentication_method_ldap_properties:
     ~azure.mgmt.cosmosdb.models.AuthenticationMethodLdapProperties
    :ivar deallocated: Whether the data center has been deallocated.
    :vartype deallocated: bool
    :ivar provision_error: Error related to resource provisioning.
    :vartype provision_error: ~azure.mgmt.cosmosdb.models.CassandraError
    :ivar private_endpoint_ip_address: Ip of the VPN Endpoint for this data center.
    :vartype private_endpoint_ip_address: str
    """

    _validation = {
        "seed_nodes": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "data_center_location": {"key": "dataCenterLocation", "type": "str"},
        "delegated_subnet_id": {"key": "delegatedSubnetId", "type": "str"},
        "node_count": {"key": "nodeCount", "type": "int"},
        "seed_nodes": {"key": "seedNodes", "type": "[SeedNode]"},
        "base64_encoded_cassandra_yaml_fragment": {"key": "base64EncodedCassandraYamlFragment", "type": "str"},
        "managed_disk_customer_key_uri": {"key": "managedDiskCustomerKeyUri", "type": "str"},
        "backup_storage_customer_key_uri": {"key": "backupStorageCustomerKeyUri", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "disk_sku": {"key": "diskSku", "type": "str"},
        "disk_capacity": {"key": "diskCapacity", "type": "int"},
        "availability_zone": {"key": "availabilityZone", "type": "bool"},
        "authentication_method_ldap_properties": {
            "key": "authenticationMethodLdapProperties",
            "type": "AuthenticationMethodLdapProperties",
        },
        "deallocated": {"key": "deallocated", "type": "bool"},
        "provision_error": {"key": "provisionError", "type": "CassandraError"},
        "private_endpoint_ip_address": {"key": "privateEndpointIpAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ManagedCassandraProvisioningState"]] = None,
        data_center_location: Optional[str] = None,
        delegated_subnet_id: Optional[str] = None,
        node_count: Optional[int] = None,
        base64_encoded_cassandra_yaml_fragment: Optional[str] = None,
        managed_disk_customer_key_uri: Optional[str] = None,
        backup_storage_customer_key_uri: Optional[str] = None,
        sku: Optional[str] = None,
        disk_sku: Optional[str] = None,
        disk_capacity: Optional[int] = None,
        availability_zone: Optional[bool] = None,
        authentication_method_ldap_properties: Optional["_models.AuthenticationMethodLdapProperties"] = None,
        deallocated: Optional[bool] = None,
        provision_error: Optional["_models.CassandraError"] = None,
        private_endpoint_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the resource at the time the operation was called.
         Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.cosmosdb.models.ManagedCassandraProvisioningState
        :keyword data_center_location: The region this data center should be created in.
        :paramtype data_center_location: str
        :keyword delegated_subnet_id: Resource id of a subnet the nodes in this data center should have
         their network interfaces connected to. The subnet must be in the same region specified in
         'dataCenterLocation' and must be able to route to the subnet specified in the cluster's
         'delegatedManagementSubnetId' property. This resource id will be of the form
         '/subscriptions/:code:`<subscription id>`/resourceGroups/:code:`<resource
         group>`/providers/Microsoft.Network/virtualNetworks/:code:`<virtual
         network>`/subnets/:code:`<subnet>`'.
        :paramtype delegated_subnet_id: str
        :keyword node_count: The number of nodes the data center should have. This is the desired
         number. After it is set, it may take some time for the data center to be scaled to match. To
         monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
        :paramtype node_count: int
        :keyword base64_encoded_cassandra_yaml_fragment: A fragment of a cassandra.yaml configuration
         file to be included in the cassandra.yaml for all nodes in this data center. The fragment
         should be Base64 encoded, and only a subset of keys are allowed.
        :paramtype base64_encoded_cassandra_yaml_fragment: str
        :keyword managed_disk_customer_key_uri: Key uri to use for encryption of managed disks. Ensure
         the system assigned identity of the cluster has been assigned appropriate permissions(key
         get/wrap/unwrap permissions) on the key.
        :paramtype managed_disk_customer_key_uri: str
        :keyword backup_storage_customer_key_uri: Indicates the Key Uri of the customer key to use for
         encryption of the backup storage account.
        :paramtype backup_storage_customer_key_uri: str
        :keyword sku: Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2.
        :paramtype sku: str
        :keyword disk_sku: Disk SKU used for data centers. Default value is P30.
        :paramtype disk_sku: str
        :keyword disk_capacity: Number of disks attached to each node. Default is 4.
        :paramtype disk_capacity: int
        :keyword availability_zone: If the data center has Availability Zone support, apply it to the
         Virtual Machine ScaleSet that host the cassandra data center virtual machines.
        :paramtype availability_zone: bool
        :keyword authentication_method_ldap_properties: Ldap authentication method properties. This
         feature is in preview.
        :paramtype authentication_method_ldap_properties:
         ~azure.mgmt.cosmosdb.models.AuthenticationMethodLdapProperties
        :keyword deallocated: Whether the data center has been deallocated.
        :paramtype deallocated: bool
        :keyword provision_error: Error related to resource provisioning.
        :paramtype provision_error: ~azure.mgmt.cosmosdb.models.CassandraError
        :keyword private_endpoint_ip_address: Ip of the VPN Endpoint for this data center.
        :paramtype private_endpoint_ip_address: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.data_center_location = data_center_location
        self.delegated_subnet_id = delegated_subnet_id
        self.node_count = node_count
        self.seed_nodes = None
        self.base64_encoded_cassandra_yaml_fragment = base64_encoded_cassandra_yaml_fragment
        self.managed_disk_customer_key_uri = managed_disk_customer_key_uri
        self.backup_storage_customer_key_uri = backup_storage_customer_key_uri
        self.sku = sku
        self.disk_sku = disk_sku
        self.disk_capacity = disk_capacity
        self.availability_zone = availability_zone
        self.authentication_method_ldap_properties = authentication_method_ldap_properties
        self.deallocated = deallocated
        self.provision_error = provision_error
        self.private_endpoint_ip_address = private_endpoint_ip_address


class RegionalServiceResource(_serialization.Model):
    """Resource for a regional service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The regional service name.
    :vartype name: str
    :ivar location: The location name.
    :vartype location: str
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.location = None
        self.status = None


class DataTransferRegionalServiceResource(RegionalServiceResource):
    """Resource for a regional service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The regional service name.
    :vartype name: str
    :ivar location: The location name.
    :vartype location: str
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    """


class DataTransferServiceResource(_serialization.Model):
    """Describes the service response property.

    :ivar properties: Properties for DataTransferServiceResource.
    :vartype properties: ~azure.mgmt.cosmosdb.models.DataTransferServiceResourceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "DataTransferServiceResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.DataTransferServiceResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties for DataTransferServiceResource.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.DataTransferServiceResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServiceResourceCreateUpdateProperties(_serialization.Model):
    """Properties in ServiceResourceCreateUpdateParameters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataTransferServiceResourceCreateUpdateProperties,
    GraphAPIComputeServiceResourceCreateUpdateProperties,
    MaterializedViewsBuilderServiceResourceCreateUpdateProperties,
    SqlDedicatedGatewayServiceResourceCreateUpdateProperties

    All required parameters must be populated in order to send to server.

    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    """

    _validation = {
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
    }

    _attribute_map = {
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
    }

    _subtype_map = {
        "service_type": {
            "DataTransfer": "DataTransferServiceResourceCreateUpdateProperties",
            "GraphAPICompute": "GraphAPIComputeServiceResourceCreateUpdateProperties",
            "MaterializedViewsBuilder": "MaterializedViewsBuilderServiceResourceCreateUpdateProperties",
            "SqlDedicatedGateway": "SqlDedicatedGatewayServiceResourceCreateUpdateProperties",
        }
    }

    def __init__(
        self,
        *,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(**kwargs)
        self.instance_size = instance_size
        self.instance_count = instance_count
        self.service_type: Optional[str] = None


class DataTransferServiceResourceCreateUpdateProperties(
    ServiceResourceCreateUpdateProperties
):  # pylint: disable=name-too-long
    """Properties for Create or Update request for DataTransferServiceResource.

    All required parameters must be populated in order to send to server.

    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    """

    _validation = {
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
    }

    _attribute_map = {
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(instance_size=instance_size, instance_count=instance_count, **kwargs)
        self.service_type: str = "DataTransfer"


class ServiceResourceProperties(_serialization.Model):
    """Services response resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataTransferServiceResourceProperties, GraphAPIComputeServiceResourceProperties,
    MaterializedViewsBuilderServiceResourceProperties, SqlDedicatedGatewayServiceResourceProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_time: Time of the last state change (ISO-8601 format).
    :vartype creation_time: ~datetime.datetime
    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    """

    _validation = {
        "creation_time": {"readonly": True},
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    _subtype_map = {
        "service_type": {
            "DataTransfer": "DataTransferServiceResourceProperties",
            "GraphAPICompute": "GraphAPIComputeServiceResourceProperties",
            "MaterializedViewsBuilder": "MaterializedViewsBuilderServiceResourceProperties",
            "SqlDedicatedGateway": "SqlDedicatedGatewayServiceResourceProperties",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.creation_time = None
        self.instance_size = instance_size
        self.instance_count = instance_count
        self.service_type: Optional[str] = None
        self.status = None


class DataTransferServiceResourceProperties(ServiceResourceProperties):
    """Properties for DataTransferServiceResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_time: Time of the last state change (ISO-8601 format).
    :vartype creation_time: ~datetime.datetime
    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    :ivar locations: An array that contains all of the locations for the service.
    :vartype locations: list[~azure.mgmt.cosmosdb.models.DataTransferRegionalServiceResource]
    """

    _validation = {
        "creation_time": {"readonly": True},
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
        "status": {"readonly": True},
        "locations": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "locations": {"key": "locations", "type": "[DataTransferRegionalServiceResource]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(
            additional_properties=additional_properties,
            instance_size=instance_size,
            instance_count=instance_count,
            **kwargs
        )
        self.service_type: str = "DataTransfer"
        self.locations = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.cosmosdb.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.cosmosdb.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Error Response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseAutoGenerated(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cosmosdb.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cosmosdb.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExcludedPath(_serialization.Model):
    """ExcludedPath.

    :ivar path: The path for which the indexing behavior applies to. Index paths typically start
     with root and end with wildcard (/path/*).
    :vartype path: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: The path for which the indexing behavior applies to. Index paths typically start
         with root and end with wildcard (/path/*).
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.path = path


class FailoverPolicies(_serialization.Model):
    """The list of new failover policies for the failover priority change.

    All required parameters must be populated in order to send to server.

    :ivar failover_policies: List of failover policies. Required.
    :vartype failover_policies: list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
    """

    _validation = {
        "failover_policies": {"required": True},
    }

    _attribute_map = {
        "failover_policies": {"key": "failoverPolicies", "type": "[FailoverPolicy]"},
    }

    def __init__(self, *, failover_policies: List["_models.FailoverPolicy"], **kwargs: Any) -> None:
        """
        :keyword failover_policies: List of failover policies. Required.
        :paramtype failover_policies: list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
        """
        super().__init__(**kwargs)
        self.failover_policies = failover_policies


class FailoverPolicy(_serialization.Model):
    """The failover policy for a given region of a database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique identifier of the region in which the database account replicates to.
     Example: &lt;accountName&gt;-&lt;locationName&gt;.
    :vartype id: str
    :ivar location_name: The name of the region in which the database account exists.
    :vartype location_name: str
    :ivar failover_priority: The failover priority of the region. A failover priority of 0
     indicates a write region. The maximum value for a failover priority = (total number of regions
     - 1). Failover priority values must be unique for each of the regions in which the database
     account exists.
    :vartype failover_priority: int
    """

    _validation = {
        "id": {"readonly": True},
        "failover_priority": {"minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location_name": {"key": "locationName", "type": "str"},
        "failover_priority": {"key": "failoverPriority", "type": "int"},
    }

    def __init__(
        self, *, location_name: Optional[str] = None, failover_priority: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location_name: The name of the region in which the database account exists.
        :paramtype location_name: str
        :keyword failover_priority: The failover priority of the region. A failover priority of 0
         indicates a write region. The maximum value for a failover priority = (total number of regions
         - 1). Failover priority values must be unique for each of the regions in which the database
         account exists.
        :paramtype failover_priority: int
        """
        super().__init__(**kwargs)
        self.id = None
        self.location_name = location_name
        self.failover_priority = failover_priority


class GraphAPIComputeRegionalServiceResource(RegionalServiceResource):
    """Resource for a regional service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The regional service name.
    :vartype name: str
    :ivar location: The location name.
    :vartype location: str
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    :ivar graph_api_compute_endpoint: The regional endpoint for GraphAPICompute.
    :vartype graph_api_compute_endpoint: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "status": {"readonly": True},
        "graph_api_compute_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "graph_api_compute_endpoint": {"key": "graphApiComputeEndpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.graph_api_compute_endpoint = None


class GraphAPIComputeServiceResource(_serialization.Model):
    """Describes the service response property for GraphAPICompute.

    :ivar properties: Properties for GraphAPIComputeServiceResource.
    :vartype properties: ~azure.mgmt.cosmosdb.models.GraphAPIComputeServiceResourceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "GraphAPIComputeServiceResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.GraphAPIComputeServiceResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties for GraphAPIComputeServiceResource.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.GraphAPIComputeServiceResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GraphAPIComputeServiceResourceCreateUpdateProperties(
    ServiceResourceCreateUpdateProperties
):  # pylint: disable=name-too-long
    """Properties for Create or Update request for GraphAPIComputeServiceResource.

    All required parameters must be populated in order to send to server.

    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    """

    _validation = {
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
    }

    _attribute_map = {
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(instance_size=instance_size, instance_count=instance_count, **kwargs)
        self.service_type: str = "GraphAPICompute"


class GraphAPIComputeServiceResourceProperties(ServiceResourceProperties):
    """Properties for GraphAPIComputeServiceResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_time: Time of the last state change (ISO-8601 format).
    :vartype creation_time: ~datetime.datetime
    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    :ivar graph_api_compute_endpoint: GraphAPICompute endpoint for the service.
    :vartype graph_api_compute_endpoint: str
    :ivar locations: An array that contains all of the locations for the service.
    :vartype locations: list[~azure.mgmt.cosmosdb.models.GraphAPIComputeRegionalServiceResource]
    """

    _validation = {
        "creation_time": {"readonly": True},
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
        "status": {"readonly": True},
        "locations": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "graph_api_compute_endpoint": {"key": "graphApiComputeEndpoint", "type": "str"},
        "locations": {"key": "locations", "type": "[GraphAPIComputeRegionalServiceResource]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        graph_api_compute_endpoint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        :keyword graph_api_compute_endpoint: GraphAPICompute endpoint for the service.
        :paramtype graph_api_compute_endpoint: str
        """
        super().__init__(
            additional_properties=additional_properties,
            instance_size=instance_size,
            instance_count=instance_count,
            **kwargs
        )
        self.service_type: str = "GraphAPICompute"
        self.graph_api_compute_endpoint = graph_api_compute_endpoint
        self.locations = None


class GremlinDatabaseCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Gremlin database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a Gremlin database. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.GremlinDatabaseResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "GremlinDatabaseResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.GremlinDatabaseResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a Gremlin database. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.GremlinDatabaseResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class GremlinDatabaseGetPropertiesOptions(OptionsResource):
    """GremlinDatabaseGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class GremlinDatabaseResource(_serialization.Model):
    """Cosmos DB Gremlin database resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB Gremlin database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB Gremlin database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(**kwargs)
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class GremlinDatabaseGetPropertiesResource(GremlinDatabaseResource, ExtendedResourceProperties):
    """GremlinDatabaseGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB Gremlin database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB Gremlin database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(id=id, restore_parameters=restore_parameters, create_mode=create_mode, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class GremlinDatabaseGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Gremlin database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.GremlinDatabaseGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.GremlinDatabaseGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "GremlinDatabaseGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "GremlinDatabaseGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.GremlinDatabaseGetPropertiesResource"] = None,
        options: Optional["_models.GremlinDatabaseGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.GremlinDatabaseGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.GremlinDatabaseGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class GremlinDatabaseListResult(_serialization.Model):
    """The List operation response, that contains the Gremlin databases and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Gremlin databases and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.GremlinDatabaseGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GremlinDatabaseGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class GremlinDatabaseRestoreResource(_serialization.Model):
    """Specific Gremlin Databases to restore.

    :ivar database_name: The name of the gremlin database available for restore.
    :vartype database_name: str
    :ivar graph_names: The names of the graphs available for restore.
    :vartype graph_names: list[str]
    """

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "graph_names": {"key": "graphNames", "type": "[str]"},
    }

    def __init__(
        self, *, database_name: Optional[str] = None, graph_names: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database_name: The name of the gremlin database available for restore.
        :paramtype database_name: str
        :keyword graph_names: The names of the graphs available for restore.
        :paramtype graph_names: list[str]
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.graph_names = graph_names


class GremlinGraphCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Gremlin graph.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a Gremlin graph. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.GremlinGraphResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "GremlinGraphResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.GremlinGraphResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a Gremlin graph. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.GremlinGraphResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class GremlinGraphGetPropertiesOptions(OptionsResource):
    """GremlinGraphGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class GremlinGraphResource(_serialization.Model):
    """Cosmos DB Gremlin graph resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB Gremlin graph. Required.
    :vartype id: str
    :ivar indexing_policy: The configuration of the indexing policy. By default, the indexing is
     automatic for all document paths within the graph.
    :vartype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :ivar partition_key: The configuration of the partition key to be used for partitioning data
     into multiple partitions.
    :vartype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :ivar default_ttl: Default time to live.
    :vartype default_ttl: int
    :ivar unique_key_policy: The unique key policy configuration for specifying uniqueness
     constraints on documents in the collection in the Azure Cosmos DB service.
    :vartype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :ivar conflict_resolution_policy: The conflict resolution policy for the graph.
    :vartype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "indexing_policy": {"key": "indexingPolicy", "type": "IndexingPolicy"},
        "partition_key": {"key": "partitionKey", "type": "ContainerPartitionKey"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "unique_key_policy": {"key": "uniqueKeyPolicy", "type": "UniqueKeyPolicy"},
        "conflict_resolution_policy": {"key": "conflictResolutionPolicy", "type": "ConflictResolutionPolicy"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        indexing_policy: Optional["_models.IndexingPolicy"] = None,
        partition_key: Optional["_models.ContainerPartitionKey"] = None,
        default_ttl: Optional[int] = None,
        unique_key_policy: Optional["_models.UniqueKeyPolicy"] = None,
        conflict_resolution_policy: Optional["_models.ConflictResolutionPolicy"] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB Gremlin graph. Required.
        :paramtype id: str
        :keyword indexing_policy: The configuration of the indexing policy. By default, the indexing is
         automatic for all document paths within the graph.
        :paramtype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
        :keyword partition_key: The configuration of the partition key to be used for partitioning data
         into multiple partitions.
        :paramtype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
        :keyword default_ttl: Default time to live.
        :paramtype default_ttl: int
        :keyword unique_key_policy: The unique key policy configuration for specifying uniqueness
         constraints on documents in the collection in the Azure Cosmos DB service.
        :paramtype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
        :keyword conflict_resolution_policy: The conflict resolution policy for the graph.
        :paramtype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class GremlinGraphGetPropertiesResource(
    GremlinGraphResource, ExtendedResourceProperties
):  # pylint: disable=too-many-instance-attributes
    """GremlinGraphGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB Gremlin graph. Required.
    :vartype id: str
    :ivar indexing_policy: The configuration of the indexing policy. By default, the indexing is
     automatic for all document paths within the graph.
    :vartype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :ivar partition_key: The configuration of the partition key to be used for partitioning data
     into multiple partitions.
    :vartype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :ivar default_ttl: Default time to live.
    :vartype default_ttl: int
    :ivar unique_key_policy: The unique key policy configuration for specifying uniqueness
     constraints on documents in the collection in the Azure Cosmos DB service.
    :vartype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :ivar conflict_resolution_policy: The conflict resolution policy for the graph.
    :vartype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "indexing_policy": {"key": "indexingPolicy", "type": "IndexingPolicy"},
        "partition_key": {"key": "partitionKey", "type": "ContainerPartitionKey"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "unique_key_policy": {"key": "uniqueKeyPolicy", "type": "UniqueKeyPolicy"},
        "conflict_resolution_policy": {"key": "conflictResolutionPolicy", "type": "ConflictResolutionPolicy"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        indexing_policy: Optional["_models.IndexingPolicy"] = None,
        partition_key: Optional["_models.ContainerPartitionKey"] = None,
        default_ttl: Optional[int] = None,
        unique_key_policy: Optional["_models.UniqueKeyPolicy"] = None,
        conflict_resolution_policy: Optional["_models.ConflictResolutionPolicy"] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB Gremlin graph. Required.
        :paramtype id: str
        :keyword indexing_policy: The configuration of the indexing policy. By default, the indexing is
         automatic for all document paths within the graph.
        :paramtype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
        :keyword partition_key: The configuration of the partition key to be used for partitioning data
         into multiple partitions.
        :paramtype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
        :keyword default_ttl: Default time to live.
        :paramtype default_ttl: int
        :keyword unique_key_policy: The unique key policy configuration for specifying uniqueness
         constraints on documents in the collection in the Azure Cosmos DB service.
        :paramtype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
        :keyword conflict_resolution_policy: The conflict resolution policy for the graph.
        :paramtype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(
            id=id,
            indexing_policy=indexing_policy,
            partition_key=partition_key,
            default_ttl=default_ttl,
            unique_key_policy=unique_key_policy,
            conflict_resolution_policy=conflict_resolution_policy,
            analytical_storage_ttl=analytical_storage_ttl,
            restore_parameters=restore_parameters,
            create_mode=create_mode,
            **kwargs
        )
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class GremlinGraphGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Gremlin graph.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.GremlinGraphGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.GremlinGraphGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "GremlinGraphGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "GremlinGraphGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.GremlinGraphGetPropertiesResource"] = None,
        options: Optional["_models.GremlinGraphGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.GremlinGraphGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.GremlinGraphGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class GremlinGraphListResult(_serialization.Model):
    """The List operation response, that contains the graphs and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of graphs and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.GremlinGraphGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GremlinGraphGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class IncludedPath(_serialization.Model):
    """The paths that are included in indexing.

    :ivar path: The path for which the indexing behavior applies to. Index paths typically start
     with root and end with wildcard (/path/*).
    :vartype path: str
    :ivar indexes: List of indexes for this path.
    :vartype indexes: list[~azure.mgmt.cosmosdb.models.Indexes]
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "indexes": {"key": "indexes", "type": "[Indexes]"},
    }

    def __init__(
        self, *, path: Optional[str] = None, indexes: Optional[List["_models.Indexes"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword path: The path for which the indexing behavior applies to. Index paths typically start
         with root and end with wildcard (/path/*).
        :paramtype path: str
        :keyword indexes: List of indexes for this path.
        :paramtype indexes: list[~azure.mgmt.cosmosdb.models.Indexes]
        """
        super().__init__(**kwargs)
        self.path = path
        self.indexes = indexes


class Indexes(_serialization.Model):
    """The indexes for the path.

    :ivar data_type: The datatype for which the indexing behavior is applied to. Known values are:
     "String", "Number", "Point", "Polygon", "LineString", and "MultiPolygon".
    :vartype data_type: str or ~azure.mgmt.cosmosdb.models.DataType
    :ivar precision: The precision of the index. -1 is maximum precision.
    :vartype precision: int
    :ivar kind: Indicates the type of index. Known values are: "Hash", "Range", and "Spatial".
    :vartype kind: str or ~azure.mgmt.cosmosdb.models.IndexKind
    """

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "precision": {"key": "precision", "type": "int"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_type: Union[str, "_models.DataType"] = "String",
        precision: Optional[int] = None,
        kind: Union[str, "_models.IndexKind"] = "Hash",
        **kwargs: Any
    ) -> None:
        """
        :keyword data_type: The datatype for which the indexing behavior is applied to. Known values
         are: "String", "Number", "Point", "Polygon", "LineString", and "MultiPolygon".
        :paramtype data_type: str or ~azure.mgmt.cosmosdb.models.DataType
        :keyword precision: The precision of the index. -1 is maximum precision.
        :paramtype precision: int
        :keyword kind: Indicates the type of index. Known values are: "Hash", "Range", and "Spatial".
        :paramtype kind: str or ~azure.mgmt.cosmosdb.models.IndexKind
        """
        super().__init__(**kwargs)
        self.data_type = data_type
        self.precision = precision
        self.kind = kind


class IndexingPolicy(_serialization.Model):
    """Cosmos DB indexing policy.

    :ivar automatic: Indicates if the indexing policy is automatic.
    :vartype automatic: bool
    :ivar indexing_mode: Indicates the indexing mode. Known values are: "consistent", "lazy", and
     "none".
    :vartype indexing_mode: str or ~azure.mgmt.cosmosdb.models.IndexingMode
    :ivar included_paths: List of paths to include in the indexing.
    :vartype included_paths: list[~azure.mgmt.cosmosdb.models.IncludedPath]
    :ivar excluded_paths: List of paths to exclude from indexing.
    :vartype excluded_paths: list[~azure.mgmt.cosmosdb.models.ExcludedPath]
    :ivar composite_indexes: List of composite path list.
    :vartype composite_indexes: list[list[~azure.mgmt.cosmosdb.models.CompositePath]]
    :ivar spatial_indexes: List of spatial specifics.
    :vartype spatial_indexes: list[~azure.mgmt.cosmosdb.models.SpatialSpec]
    :ivar vector_indexes: List of paths to include in the vector indexing.
    :vartype vector_indexes: list[~azure.mgmt.cosmosdb.models.VectorIndex]
    """

    _attribute_map = {
        "automatic": {"key": "automatic", "type": "bool"},
        "indexing_mode": {"key": "indexingMode", "type": "str"},
        "included_paths": {"key": "includedPaths", "type": "[IncludedPath]"},
        "excluded_paths": {"key": "excludedPaths", "type": "[ExcludedPath]"},
        "composite_indexes": {"key": "compositeIndexes", "type": "[[CompositePath]]"},
        "spatial_indexes": {"key": "spatialIndexes", "type": "[SpatialSpec]"},
        "vector_indexes": {"key": "vectorIndexes", "type": "[VectorIndex]"},
    }

    def __init__(
        self,
        *,
        automatic: Optional[bool] = None,
        indexing_mode: Union[str, "_models.IndexingMode"] = "consistent",
        included_paths: Optional[List["_models.IncludedPath"]] = None,
        excluded_paths: Optional[List["_models.ExcludedPath"]] = None,
        composite_indexes: Optional[List[List["_models.CompositePath"]]] = None,
        spatial_indexes: Optional[List["_models.SpatialSpec"]] = None,
        vector_indexes: Optional[List["_models.VectorIndex"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword automatic: Indicates if the indexing policy is automatic.
        :paramtype automatic: bool
        :keyword indexing_mode: Indicates the indexing mode. Known values are: "consistent", "lazy",
         and "none".
        :paramtype indexing_mode: str or ~azure.mgmt.cosmosdb.models.IndexingMode
        :keyword included_paths: List of paths to include in the indexing.
        :paramtype included_paths: list[~azure.mgmt.cosmosdb.models.IncludedPath]
        :keyword excluded_paths: List of paths to exclude from indexing.
        :paramtype excluded_paths: list[~azure.mgmt.cosmosdb.models.ExcludedPath]
        :keyword composite_indexes: List of composite path list.
        :paramtype composite_indexes: list[list[~azure.mgmt.cosmosdb.models.CompositePath]]
        :keyword spatial_indexes: List of spatial specifics.
        :paramtype spatial_indexes: list[~azure.mgmt.cosmosdb.models.SpatialSpec]
        :keyword vector_indexes: List of paths to include in the vector indexing.
        :paramtype vector_indexes: list[~azure.mgmt.cosmosdb.models.VectorIndex]
        """
        super().__init__(**kwargs)
        self.automatic = automatic
        self.indexing_mode = indexing_mode
        self.included_paths = included_paths
        self.excluded_paths = excluded_paths
        self.composite_indexes = composite_indexes
        self.spatial_indexes = spatial_indexes
        self.vector_indexes = vector_indexes


class IpAddressOrRange(_serialization.Model):
    """IpAddressOrRange object.

    :ivar ip_address_or_range: A single IPv4 address or a single IPv4 address range in CIDR format.
     Provided IPs must be well-formatted and cannot be contained in one of the following ranges:
     10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by
     the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
    :vartype ip_address_or_range: str
    """

    _attribute_map = {
        "ip_address_or_range": {"key": "ipAddressOrRange", "type": "str"},
    }

    def __init__(self, *, ip_address_or_range: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address_or_range: A single IPv4 address or a single IPv4 address range in CIDR
         format. Provided IPs must be well-formatted and cannot be contained in one of the following
         ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not
         enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or
         “23.40.210.0/8”.
        :paramtype ip_address_or_range: str
        """
        super().__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range


class KeyWrapMetadata(_serialization.Model):
    """Represents key wrap metadata that a key wrapping provider can use to wrap/unwrap a client
    encryption key.

    :ivar name: The name of associated KeyEncryptionKey (aka CustomerManagedKey).
    :vartype name: str
    :ivar type: ProviderName of KeyStoreProvider.
    :vartype type: str
    :ivar value: Reference / link to the KeyEncryptionKey.
    :vartype value: str
    :ivar algorithm: Algorithm used in wrapping and unwrapping of the data encryption key.
    :vartype algorithm: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "algorithm": {"key": "algorithm", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        value: Optional[str] = None,
        algorithm: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of associated KeyEncryptionKey (aka CustomerManagedKey).
        :paramtype name: str
        :keyword type: ProviderName of KeyStoreProvider.
        :paramtype type: str
        :keyword value: Reference / link to the KeyEncryptionKey.
        :paramtype value: str
        :keyword algorithm: Algorithm used in wrapping and unwrapping of the data encryption key.
        :paramtype algorithm: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.value = value
        self.algorithm = algorithm


class ListClusters(_serialization.Model):
    """List of managed Cassandra clusters.

    :ivar value: Container for the array of clusters.
    :vartype value: list[~azure.mgmt.cosmosdb.models.ClusterResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.ClusterResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Container for the array of clusters.
        :paramtype value: list[~azure.mgmt.cosmosdb.models.ClusterResource]
        """
        super().__init__(**kwargs)
        self.value = value


class ListDataCenters(_serialization.Model):
    """List of managed Cassandra data centers and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Container for array of data centers.
    :vartype value: list[~azure.mgmt.cosmosdb.models.DataCenterResource]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataCenterResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class Location(_serialization.Model):
    """A region in which the Azure Cosmos DB database account is deployed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique identifier of the region within the database account. Example:
     &lt;accountName&gt;-&lt;locationName&gt;.
    :vartype id: str
    :ivar location_name: The name of the region.
    :vartype location_name: str
    :ivar document_endpoint: The connection endpoint for the specific region. Example:
     https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/.
    :vartype document_endpoint: str
    :ivar provisioning_state: The status of the Cosmos DB account at the time the operation was
     called. The status can be one of following. 'Creating' – the Cosmos DB account is being
     created. When an account is in Creating state, only properties that are specified as input for
     the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is
     active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB
     account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' –
     the Cosmos DB account deletion failed.
    :vartype provisioning_state: str
    :ivar failover_priority: The failover priority of the region. A failover priority of 0
     indicates a write region. The maximum value for a failover priority = (total number of regions
     - 1). Failover priority values must be unique for each of the regions in which the database
     account exists.
    :vartype failover_priority: int
    :ivar is_zone_redundant: Flag to indicate whether or not this region is an AvailabilityZone
     region.
    :vartype is_zone_redundant: bool
    """

    _validation = {
        "id": {"readonly": True},
        "document_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "failover_priority": {"minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location_name": {"key": "locationName", "type": "str"},
        "document_endpoint": {"key": "documentEndpoint", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "failover_priority": {"key": "failoverPriority", "type": "int"},
        "is_zone_redundant": {"key": "isZoneRedundant", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location_name: Optional[str] = None,
        failover_priority: Optional[int] = None,
        is_zone_redundant: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location_name: The name of the region.
        :paramtype location_name: str
        :keyword failover_priority: The failover priority of the region. A failover priority of 0
         indicates a write region. The maximum value for a failover priority = (total number of regions
         - 1). Failover priority values must be unique for each of the regions in which the database
         account exists.
        :paramtype failover_priority: int
        :keyword is_zone_redundant: Flag to indicate whether or not this region is an AvailabilityZone
         region.
        :paramtype is_zone_redundant: bool
        """
        super().__init__(**kwargs)
        self.id = None
        self.location_name = location_name
        self.document_endpoint = None
        self.provisioning_state = None
        self.failover_priority = failover_priority
        self.is_zone_redundant = is_zone_redundant


class LocationGetResult(ARMProxyResource):
    """Cosmos DB location get result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar properties: Cosmos DB location metadata.
    :vartype properties: ~azure.mgmt.cosmosdb.models.LocationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "LocationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.LocationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Cosmos DB location metadata.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.LocationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class LocationListResult(_serialization.Model):
    """The List operation response, that contains Cosmos DB locations and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Cosmos DB locations and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.LocationGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocationGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class LocationProperties(_serialization.Model):
    """Cosmos DB location metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar supports_availability_zone: Flag indicating whether the location supports availability
     zones or not.
    :vartype supports_availability_zone: bool
    :ivar is_residency_restricted: Flag indicating whether the location is residency sensitive.
    :vartype is_residency_restricted: bool
    :ivar backup_storage_redundancies: The properties of available backup storage redundancies.
    :vartype backup_storage_redundancies: list[str or
     ~azure.mgmt.cosmosdb.models.BackupStorageRedundancy]
    :ivar is_subscription_region_access_allowed_for_regular: Flag indicating whether the
     subscription have access in region for Non-Availability Zones.
    :vartype is_subscription_region_access_allowed_for_regular: bool
    :ivar is_subscription_region_access_allowed_for_az: Flag indicating whether the subscription
     have access in region for Availability Zones(Az).
    :vartype is_subscription_region_access_allowed_for_az: bool
    :ivar status: Enum to indicate current buildout status of the region. Known values are:
     "Uninitialized", "Initializing", "InternallyReady", "Online", and "Deleting".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.Status
    """

    _validation = {
        "supports_availability_zone": {"readonly": True},
        "is_residency_restricted": {"readonly": True},
        "backup_storage_redundancies": {"readonly": True},
        "is_subscription_region_access_allowed_for_regular": {"readonly": True},
        "is_subscription_region_access_allowed_for_az": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "supports_availability_zone": {"key": "supportsAvailabilityZone", "type": "bool"},
        "is_residency_restricted": {"key": "isResidencyRestricted", "type": "bool"},
        "backup_storage_redundancies": {"key": "backupStorageRedundancies", "type": "[str]"},
        "is_subscription_region_access_allowed_for_regular": {
            "key": "isSubscriptionRegionAccessAllowedForRegular",
            "type": "bool",
        },
        "is_subscription_region_access_allowed_for_az": {
            "key": "isSubscriptionRegionAccessAllowedForAz",
            "type": "bool",
        },
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.supports_availability_zone = None
        self.is_residency_restricted = None
        self.backup_storage_redundancies = None
        self.is_subscription_region_access_allowed_for_regular = None
        self.is_subscription_region_access_allowed_for_az = None
        self.status = None


class ManagedCassandraManagedServiceIdentity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The object id of the identity resource.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the resource.
    :vartype tenant_id: str
    :ivar type: The type of the resource. Known values are: "SystemAssigned" and "None".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.ManagedCassandraResourceIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.ManagedCassandraResourceIdentityType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the resource. Known values are: "SystemAssigned" and "None".
        :paramtype type: str or ~azure.mgmt.cosmosdb.models.ManagedCassandraResourceIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ManagedCassandraReaperStatus(_serialization.Model):
    """ManagedCassandraReaperStatus.

    :ivar healthy:
    :vartype healthy: bool
    :ivar repair_run_ids: Dictionary of :code:`<string>`.
    :vartype repair_run_ids: dict[str, str]
    :ivar repair_schedules: Dictionary of :code:`<string>`.
    :vartype repair_schedules: dict[str, str]
    """

    _attribute_map = {
        "healthy": {"key": "healthy", "type": "bool"},
        "repair_run_ids": {"key": "repairRunIds", "type": "{str}"},
        "repair_schedules": {"key": "repairSchedules", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        healthy: Optional[bool] = None,
        repair_run_ids: Optional[Dict[str, str]] = None,
        repair_schedules: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword healthy:
        :paramtype healthy: bool
        :keyword repair_run_ids: Dictionary of :code:`<string>`.
        :paramtype repair_run_ids: dict[str, str]
        :keyword repair_schedules: Dictionary of :code:`<string>`.
        :paramtype repair_schedules: dict[str, str]
        """
        super().__init__(**kwargs)
        self.healthy = healthy
        self.repair_run_ids = repair_run_ids
        self.repair_schedules = repair_schedules


class ManagedServiceIdentity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity. This property will only
     be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the resource. The type 'SystemAssigned,UserAssigned'
     includes both an implicitly created identity and a set of user assigned identities. The type
     'None' will remove any identities from the service. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with resource. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.cosmosdb.models.ManagedServiceIdentityUserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{ManagedServiceIdentityUserAssignedIdentity}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.ManagedServiceIdentityUserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the resource. The type
         'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user
         assigned identities. The type 'None' will remove any identities from the service. Known values
         are: "SystemAssigned", "UserAssigned", "SystemAssigned,UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.cosmosdb.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with resource. The
         user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.cosmosdb.models.ManagedServiceIdentityUserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedServiceIdentityUserAssignedIdentity(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedServiceIdentityUserAssignedIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class MaterializedViewsBuilderRegionalServiceResource(RegionalServiceResource):  # pylint: disable=name-too-long
    """Resource for a regional service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The regional service name.
    :vartype name: str
    :ivar location: The location name.
    :vartype location: str
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    """


class MaterializedViewsBuilderServiceResource(_serialization.Model):
    """Describes the service response property for MaterializedViewsBuilder.

    :ivar properties: Properties for MaterializedViewsBuilderServiceResource.
    :vartype properties:
     ~azure.mgmt.cosmosdb.models.MaterializedViewsBuilderServiceResourceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "MaterializedViewsBuilderServiceResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.MaterializedViewsBuilderServiceResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties for MaterializedViewsBuilderServiceResource.
        :paramtype properties:
         ~azure.mgmt.cosmosdb.models.MaterializedViewsBuilderServiceResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MaterializedViewsBuilderServiceResourceCreateUpdateProperties(
    ServiceResourceCreateUpdateProperties
):  # pylint: disable=name-too-long
    """Properties for Create or Update request for MaterializedViewsBuilderServiceResource.

    All required parameters must be populated in order to send to server.

    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    """

    _validation = {
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
    }

    _attribute_map = {
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(instance_size=instance_size, instance_count=instance_count, **kwargs)
        self.service_type: str = "MaterializedViewsBuilder"


class MaterializedViewsBuilderServiceResourceProperties(ServiceResourceProperties):  # pylint: disable=name-too-long
    """Properties for MaterializedViewsBuilderServiceResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_time: Time of the last state change (ISO-8601 format).
    :vartype creation_time: ~datetime.datetime
    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    :ivar locations: An array that contains all of the locations for the service.
    :vartype locations:
     list[~azure.mgmt.cosmosdb.models.MaterializedViewsBuilderRegionalServiceResource]
    """

    _validation = {
        "creation_time": {"readonly": True},
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
        "status": {"readonly": True},
        "locations": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "locations": {"key": "locations", "type": "[MaterializedViewsBuilderRegionalServiceResource]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        """
        super().__init__(
            additional_properties=additional_properties,
            instance_size=instance_size,
            instance_count=instance_count,
            **kwargs
        )
        self.service_type: str = "MaterializedViewsBuilder"
        self.locations = None


class Metric(_serialization.Model):
    """Metric data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: The time grain to be used to summarize the metric values.
    :vartype time_grain: str
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The metric values for the specified time window and timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.MetricValue]
    """

    _validation = {
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "time_grain": {"readonly": True},
        "unit": {"readonly": True},
        "name": {"readonly": True},
        "metric_values": {"readonly": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
        "metric_values": {"key": "metricValues", "type": "[MetricValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = None
        self.name = None
        self.metric_values = None


class MetricAvailability(_serialization.Model):
    """The availability of the metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: The time grain to be used to summarize the metric values.
    :vartype time_grain: str
    :ivar retention: The retention for the metric values.
    :vartype retention: str
    """

    _validation = {
        "time_grain": {"readonly": True},
        "retention": {"readonly": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class MetricDefinition(_serialization.Model):
    """The definition of a metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metric_availabilities: The list of metric availabilities for the account.
    :vartype metric_availabilities: list[~azure.mgmt.cosmosdb.models.MetricAvailability]
    :ivar primary_aggregation_type: The primary aggregation type of the metric. Known values are:
     "None", "Average", "Total", "Minimum", "Maximum", and "Last".
    :vartype primary_aggregation_type: str or ~azure.mgmt.cosmosdb.models.PrimaryAggregationType
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar resource_uri: The resource uri of the database.
    :vartype resource_uri: str
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    """

    _validation = {
        "metric_availabilities": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "unit": {"readonly": True},
        "resource_uri": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "metric_availabilities": {"key": "metricAvailabilities", "type": "[MetricAvailability]"},
        "primary_aggregation_type": {"key": "primaryAggregationType", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.metric_availabilities = None
        self.primary_aggregation_type = None
        self.unit = None
        self.resource_uri = None
        self.name = None


class MetricDefinitionsListResult(_serialization.Model):
    """The response to a list metric definitions request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of metric definitions for the account.
    :vartype value: list[~azure.mgmt.cosmosdb.models.MetricDefinition]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricDefinition]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class MetricListResult(_serialization.Model):
    """The response to a list metrics request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of metrics for the account.
    :vartype value: list[~azure.mgmt.cosmosdb.models.Metric]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Metric]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class MetricName(_serialization.Model):
    """A metric name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the metric.
    :vartype value: str
    :ivar localized_value: The friendly name of the metric.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"readonly": True},
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.localized_value = None


class MetricValue(_serialization.Model):
    """Represents metrics values.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: The number of values for the metric.
    :vartype count: int
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: ~datetime.datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    """

    _validation = {
        "count": {"readonly": True},
        "average": {"readonly": True},
        "maximum": {"readonly": True},
        "minimum": {"readonly": True},
        "timestamp": {"readonly": True},
        "total": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "_count", "type": "int"},
        "average": {"key": "average", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "total": {"key": "total", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.count = None
        self.average = None
        self.maximum = None
        self.minimum = None
        self.timestamp = None
        self.total = None


class MongoDBCollectionCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB MongoDB collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a MongoDB collection. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.MongoDBCollectionResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "MongoDBCollectionResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.MongoDBCollectionResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a MongoDB collection. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.MongoDBCollectionResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBCollectionGetPropertiesOptions(OptionsResource):
    """MongoDBCollectionGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class MongoDBCollectionResource(_serialization.Model):
    """Cosmos DB MongoDB collection resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB MongoDB collection. Required.
    :vartype id: str
    :ivar shard_key: A key-value pair of shard keys to be applied for the request.
    :vartype shard_key: dict[str, str]
    :ivar indexes: List of index keys.
    :vartype indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "shard_key": {"key": "shardKey", "type": "{str}"},
        "indexes": {"key": "indexes", "type": "[MongoIndex]"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        shard_key: Optional[Dict[str, str]] = None,
        indexes: Optional[List["_models.MongoIndex"]] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB MongoDB collection. Required.
        :paramtype id: str
        :keyword shard_key: A key-value pair of shard keys to be applied for the request.
        :paramtype shard_key: dict[str, str]
        :keyword indexes: List of index keys.
        :paramtype indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(**kwargs)
        self.id = id
        self.shard_key = shard_key
        self.indexes = indexes
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class MongoDBCollectionGetPropertiesResource(MongoDBCollectionResource, ExtendedResourceProperties):
    """MongoDBCollectionGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB MongoDB collection. Required.
    :vartype id: str
    :ivar shard_key: A key-value pair of shard keys to be applied for the request.
    :vartype shard_key: dict[str, str]
    :ivar indexes: List of index keys.
    :vartype indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "shard_key": {"key": "shardKey", "type": "{str}"},
        "indexes": {"key": "indexes", "type": "[MongoIndex]"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        shard_key: Optional[Dict[str, str]] = None,
        indexes: Optional[List["_models.MongoIndex"]] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB MongoDB collection. Required.
        :paramtype id: str
        :keyword shard_key: A key-value pair of shard keys to be applied for the request.
        :paramtype shard_key: dict[str, str]
        :keyword indexes: List of index keys.
        :paramtype indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(
            id=id,
            shard_key=shard_key,
            indexes=indexes,
            analytical_storage_ttl=analytical_storage_ttl,
            restore_parameters=restore_parameters,
            create_mode=create_mode,
            **kwargs
        )
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.shard_key = shard_key
        self.indexes = indexes
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class MongoDBCollectionGetResults(ARMResourceProperties):
    """An Azure Cosmos DB MongoDB collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.MongoDBCollectionGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.MongoDBCollectionGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "MongoDBCollectionGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "MongoDBCollectionGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.MongoDBCollectionGetPropertiesResource"] = None,
        options: Optional["_models.MongoDBCollectionGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.MongoDBCollectionGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.MongoDBCollectionGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBCollectionListResult(_serialization.Model):
    """The List operation response, that contains the MongoDB collections and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of MongoDB collections and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.MongoDBCollectionGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MongoDBCollectionGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class MongoDBDatabaseCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB MongoDB database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a MongoDB database. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "MongoDBDatabaseResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.MongoDBDatabaseResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a MongoDB database. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBDatabaseGetPropertiesOptions(OptionsResource):
    """MongoDBDatabaseGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class MongoDBDatabaseResource(_serialization.Model):
    """Cosmos DB MongoDB database resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB MongoDB database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB MongoDB database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(**kwargs)
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class MongoDBDatabaseGetPropertiesResource(MongoDBDatabaseResource, ExtendedResourceProperties):
    """MongoDBDatabaseGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB MongoDB database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB MongoDB database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(id=id, restore_parameters=restore_parameters, create_mode=create_mode, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class MongoDBDatabaseGetResults(ARMResourceProperties):
    """An Azure Cosmos DB MongoDB database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "MongoDBDatabaseGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "MongoDBDatabaseGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.MongoDBDatabaseGetPropertiesResource"] = None,
        options: Optional["_models.MongoDBDatabaseGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBDatabaseListResult(_serialization.Model):
    """The List operation response, that contains the MongoDB databases and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of MongoDB databases and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MongoDBDatabaseGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class MongoIndex(_serialization.Model):
    """Cosmos DB MongoDB collection index key.

    :ivar key: Cosmos DB MongoDB collection index keys.
    :vartype key: ~azure.mgmt.cosmosdb.models.MongoIndexKeys
    :ivar options: Cosmos DB MongoDB collection index key options.
    :vartype options: ~azure.mgmt.cosmosdb.models.MongoIndexOptions
    """

    _attribute_map = {
        "key": {"key": "key", "type": "MongoIndexKeys"},
        "options": {"key": "options", "type": "MongoIndexOptions"},
    }

    def __init__(
        self,
        *,
        key: Optional["_models.MongoIndexKeys"] = None,
        options: Optional["_models.MongoIndexOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: Cosmos DB MongoDB collection index keys.
        :paramtype key: ~azure.mgmt.cosmosdb.models.MongoIndexKeys
        :keyword options: Cosmos DB MongoDB collection index key options.
        :paramtype options: ~azure.mgmt.cosmosdb.models.MongoIndexOptions
        """
        super().__init__(**kwargs)
        self.key = key
        self.options = options


class MongoIndexKeys(_serialization.Model):
    """Cosmos DB MongoDB collection resource object.

    :ivar keys: List of keys for each MongoDB collection in the Azure Cosmos DB service.
    :vartype keys: list[str]
    """

    _attribute_map = {
        "keys": {"key": "keys", "type": "[str]"},
    }

    def __init__(self, *, keys: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword keys: List of keys for each MongoDB collection in the Azure Cosmos DB service.
        :paramtype keys: list[str]
        """
        super().__init__(**kwargs)
        self.keys = keys


class MongoIndexOptions(_serialization.Model):
    """Cosmos DB MongoDB collection index options.

    :ivar expire_after_seconds: Expire after seconds.
    :vartype expire_after_seconds: int
    :ivar unique: Is unique or not.
    :vartype unique: bool
    """

    _attribute_map = {
        "expire_after_seconds": {"key": "expireAfterSeconds", "type": "int"},
        "unique": {"key": "unique", "type": "bool"},
    }

    def __init__(
        self, *, expire_after_seconds: Optional[int] = None, unique: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword expire_after_seconds: Expire after seconds.
        :paramtype expire_after_seconds: int
        :keyword unique: Is unique or not.
        :paramtype unique: bool
        """
        super().__init__(**kwargs)
        self.expire_after_seconds = expire_after_seconds
        self.unique = unique


class MongoRoleDefinitionCreateUpdateParameters(_serialization.Model):  # pylint: disable=name-too-long
    """Parameters to create and update an Azure Cosmos DB Mongo Role Definition.

    :ivar role_name: A user-friendly name for the Role Definition. Must be unique for the database
     account.
    :vartype role_name: str
    :ivar type: Indicates whether the Role Definition was built-in or user created. Known values
     are: "BuiltInRole" and "CustomRole".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.MongoRoleDefinitionType
    :ivar database_name: The database name for which access is being granted for this Role
     Definition.
    :vartype database_name: str
    :ivar privileges: A set of privileges contained by the Role Definition. This will allow
     application of this Role Definition on the entire database account or any underlying Database /
     Collection. Scopes higher than Database are not enforceable as privilege.
    :vartype privileges: list[~azure.mgmt.cosmosdb.models.Privilege]
    :ivar roles: The set of roles inherited by this Role Definition.
    :vartype roles: list[~azure.mgmt.cosmosdb.models.Role]
    """

    _attribute_map = {
        "role_name": {"key": "properties.roleName", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "privileges": {"key": "properties.privileges", "type": "[Privilege]"},
        "roles": {"key": "properties.roles", "type": "[Role]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        type: Optional[Union[str, "_models.MongoRoleDefinitionType"]] = None,
        database_name: Optional[str] = None,
        privileges: Optional[List["_models.Privilege"]] = None,
        roles: Optional[List["_models.Role"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: A user-friendly name for the Role Definition. Must be unique for the
         database account.
        :paramtype role_name: str
        :keyword type: Indicates whether the Role Definition was built-in or user created. Known values
         are: "BuiltInRole" and "CustomRole".
        :paramtype type: str or ~azure.mgmt.cosmosdb.models.MongoRoleDefinitionType
        :keyword database_name: The database name for which access is being granted for this Role
         Definition.
        :paramtype database_name: str
        :keyword privileges: A set of privileges contained by the Role Definition. This will allow
         application of this Role Definition on the entire database account or any underlying Database /
         Collection. Scopes higher than Database are not enforceable as privilege.
        :paramtype privileges: list[~azure.mgmt.cosmosdb.models.Privilege]
        :keyword roles: The set of roles inherited by this Role Definition.
        :paramtype roles: list[~azure.mgmt.cosmosdb.models.Role]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.type = type
        self.database_name = database_name
        self.privileges = privileges
        self.roles = roles


class MongoRoleDefinitionGetResults(ARMProxyResource):
    """An Azure Cosmos DB Mongo Role Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar role_name: A user-friendly name for the Role Definition. Must be unique for the database
     account.
    :vartype role_name: str
    :ivar type_properties_type: Indicates whether the Role Definition was built-in or user created.
     Known values are: "BuiltInRole" and "CustomRole".
    :vartype type_properties_type: str or ~azure.mgmt.cosmosdb.models.MongoRoleDefinitionType
    :ivar database_name: The database name for which access is being granted for this Role
     Definition.
    :vartype database_name: str
    :ivar privileges: A set of privileges contained by the Role Definition. This will allow
     application of this Role Definition on the entire database account or any underlying Database /
     Collection. Scopes higher than Database are not enforceable as privilege.
    :vartype privileges: list[~azure.mgmt.cosmosdb.models.Privilege]
    :ivar roles: The set of roles inherited by this Role Definition.
    :vartype roles: list[~azure.mgmt.cosmosdb.models.Role]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "role_name": {"key": "properties.roleName", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "privileges": {"key": "properties.privileges", "type": "[Privilege]"},
        "roles": {"key": "properties.roles", "type": "[Role]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        type_properties_type: Optional[Union[str, "_models.MongoRoleDefinitionType"]] = None,
        database_name: Optional[str] = None,
        privileges: Optional[List["_models.Privilege"]] = None,
        roles: Optional[List["_models.Role"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: A user-friendly name for the Role Definition. Must be unique for the
         database account.
        :paramtype role_name: str
        :keyword type_properties_type: Indicates whether the Role Definition was built-in or user
         created. Known values are: "BuiltInRole" and "CustomRole".
        :paramtype type_properties_type: str or ~azure.mgmt.cosmosdb.models.MongoRoleDefinitionType
        :keyword database_name: The database name for which access is being granted for this Role
         Definition.
        :paramtype database_name: str
        :keyword privileges: A set of privileges contained by the Role Definition. This will allow
         application of this Role Definition on the entire database account or any underlying Database /
         Collection. Scopes higher than Database are not enforceable as privilege.
        :paramtype privileges: list[~azure.mgmt.cosmosdb.models.Privilege]
        :keyword roles: The set of roles inherited by this Role Definition.
        :paramtype roles: list[~azure.mgmt.cosmosdb.models.Role]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.type_properties_type = type_properties_type
        self.database_name = database_name
        self.privileges = privileges
        self.roles = roles


class MongoRoleDefinitionListResult(_serialization.Model):
    """The relevant Mongo Role Definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Mongo Role Definitions and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.MongoRoleDefinitionGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MongoRoleDefinitionGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class MongoUserDefinitionCreateUpdateParameters(_serialization.Model):  # pylint: disable=name-too-long
    """Parameters to create and update an Azure Cosmos DB Mongo User Definition.

    :ivar user_name: The user name for User Definition.
    :vartype user_name: str
    :ivar password: The password for User Definition. Response does not contain user password.
    :vartype password: str
    :ivar database_name: The database name for which access is being granted for this User
     Definition.
    :vartype database_name: str
    :ivar custom_data: A custom definition for the USer Definition.
    :vartype custom_data: str
    :ivar roles: The set of roles inherited by the User Definition.
    :vartype roles: list[~azure.mgmt.cosmosdb.models.Role]
    :ivar mechanisms: The Mongo Auth mechanism. For now, we only support auth mechanism
     SCRAM-SHA-256.
    :vartype mechanisms: str
    """

    _attribute_map = {
        "user_name": {"key": "properties.userName", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "custom_data": {"key": "properties.customData", "type": "str"},
        "roles": {"key": "properties.roles", "type": "[Role]"},
        "mechanisms": {"key": "properties.mechanisms", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        database_name: Optional[str] = None,
        custom_data: Optional[str] = None,
        roles: Optional[List["_models.Role"]] = None,
        mechanisms: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: The user name for User Definition.
        :paramtype user_name: str
        :keyword password: The password for User Definition. Response does not contain user password.
        :paramtype password: str
        :keyword database_name: The database name for which access is being granted for this User
         Definition.
        :paramtype database_name: str
        :keyword custom_data: A custom definition for the USer Definition.
        :paramtype custom_data: str
        :keyword roles: The set of roles inherited by the User Definition.
        :paramtype roles: list[~azure.mgmt.cosmosdb.models.Role]
        :keyword mechanisms: The Mongo Auth mechanism. For now, we only support auth mechanism
         SCRAM-SHA-256.
        :paramtype mechanisms: str
        """
        super().__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.database_name = database_name
        self.custom_data = custom_data
        self.roles = roles
        self.mechanisms = mechanisms


class MongoUserDefinitionGetResults(ARMProxyResource):
    """An Azure Cosmos DB User Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar user_name: The user name for User Definition.
    :vartype user_name: str
    :ivar password: The password for User Definition. Response does not contain user password.
    :vartype password: str
    :ivar database_name: The database name for which access is being granted for this User
     Definition.
    :vartype database_name: str
    :ivar custom_data: A custom definition for the USer Definition.
    :vartype custom_data: str
    :ivar roles: The set of roles inherited by the User Definition.
    :vartype roles: list[~azure.mgmt.cosmosdb.models.Role]
    :ivar mechanisms: The Mongo Auth mechanism. For now, we only support auth mechanism
     SCRAM-SHA-256.
    :vartype mechanisms: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "custom_data": {"key": "properties.customData", "type": "str"},
        "roles": {"key": "properties.roles", "type": "[Role]"},
        "mechanisms": {"key": "properties.mechanisms", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        database_name: Optional[str] = None,
        custom_data: Optional[str] = None,
        roles: Optional[List["_models.Role"]] = None,
        mechanisms: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: The user name for User Definition.
        :paramtype user_name: str
        :keyword password: The password for User Definition. Response does not contain user password.
        :paramtype password: str
        :keyword database_name: The database name for which access is being granted for this User
         Definition.
        :paramtype database_name: str
        :keyword custom_data: A custom definition for the USer Definition.
        :paramtype custom_data: str
        :keyword roles: The set of roles inherited by the User Definition.
        :paramtype roles: list[~azure.mgmt.cosmosdb.models.Role]
        :keyword mechanisms: The Mongo Auth mechanism. For now, we only support auth mechanism
         SCRAM-SHA-256.
        :paramtype mechanisms: str
        """
        super().__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.database_name = database_name
        self.custom_data = custom_data
        self.roles = roles
        self.mechanisms = mechanisms


class MongoUserDefinitionListResult(_serialization.Model):
    """The relevant User Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of User Definition and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.MongoUserDefinitionGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MongoUserDefinitionGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class NotebookWorkspace(ARMProxyResource):
    """A notebook workspace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar notebook_server_endpoint: Specifies the endpoint of Notebook server.
    :vartype notebook_server_endpoint: str
    :ivar status: Status of the notebook workspace. Possible values are: Creating, Online,
     Deleting, Failed, Updating.
    :vartype status: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "notebook_server_endpoint": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "notebook_server_endpoint": {"key": "properties.notebookServerEndpoint", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.notebook_server_endpoint = None
        self.status = None


class NotebookWorkspaceConnectionInfoResult(_serialization.Model):
    """The connection info for the given notebook workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar auth_token: Specifies auth token used for connecting to Notebook server (uses token-based
     auth).
    :vartype auth_token: str
    :ivar notebook_server_endpoint: Specifies the endpoint of Notebook server.
    :vartype notebook_server_endpoint: str
    """

    _validation = {
        "auth_token": {"readonly": True},
        "notebook_server_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "auth_token": {"key": "authToken", "type": "str"},
        "notebook_server_endpoint": {"key": "notebookServerEndpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.auth_token = None
        self.notebook_server_endpoint = None


class NotebookWorkspaceCreateUpdateParameters(ARMProxyResource):
    """Parameters to create a notebook workspace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    """


class NotebookWorkspaceListResult(_serialization.Model):
    """A list of notebook workspace resources.

    :ivar value: Array of notebook workspace resources.
    :vartype value: list[~azure.mgmt.cosmosdb.models.NotebookWorkspace]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NotebookWorkspace]"},
    }

    def __init__(self, *, value: Optional[List["_models.NotebookWorkspace"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of notebook workspace resources.
        :paramtype value: list[~azure.mgmt.cosmosdb.models.NotebookWorkspace]
        """
        super().__init__(**kwargs)
        self.value = value


class Operation(_serialization.Model):
    """REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.cosmosdb.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.cosmosdb.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.ResourceProvider.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "Provider", "type": "str"},
        "resource": {"key": "Resource", "type": "str"},
        "operation": {"key": "Operation", "type": "str"},
        "description": {"key": "Description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.ResourceProvider.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Resource Provider operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of operations supported by the Resource Provider.
    :vartype value: list[~azure.mgmt.cosmosdb.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Resource Provider.
        :paramtype value: list[~azure.mgmt.cosmosdb.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartitionMetric(Metric):
    """The metric values for a single partition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: The time grain to be used to summarize the metric values.
    :vartype time_grain: str
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The metric values for the specified time window and timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.MetricValue]
    :ivar partition_id: The partition id (GUID identifier) of the metric values.
    :vartype partition_id: str
    :ivar partition_key_range_id: The partition key range id (integer identifier) of the metric
     values.
    :vartype partition_key_range_id: str
    """

    _validation = {
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "time_grain": {"readonly": True},
        "unit": {"readonly": True},
        "name": {"readonly": True},
        "metric_values": {"readonly": True},
        "partition_id": {"readonly": True},
        "partition_key_range_id": {"readonly": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
        "metric_values": {"key": "metricValues", "type": "[MetricValue]"},
        "partition_id": {"key": "partitionId", "type": "str"},
        "partition_key_range_id": {"key": "partitionKeyRangeId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.partition_id = None
        self.partition_key_range_id = None


class PartitionMetricListResult(_serialization.Model):
    """The response to a list partition metrics request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of partition-level metrics for the account.
    :vartype value: list[~azure.mgmt.cosmosdb.models.PartitionMetric]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PartitionMetric]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class Usage(_serialization.Model):
    """The usage data for a usage request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric.
    :vartype limit: int
    :ivar current_value: Current value for this metric.
    :vartype current_value: int
    """

    _validation = {
        "unit": {"readonly": True},
        "name": {"readonly": True},
        "quota_period": {"readonly": True},
        "limit": {"readonly": True},
        "current_value": {"readonly": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "limit": {"key": "limit", "type": "int"},
        "current_value": {"key": "currentValue", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unit = None
        self.name = None
        self.quota_period = None
        self.limit = None
        self.current_value = None


class PartitionUsage(Usage):
    """The partition level usage data for a usage request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric.
    :vartype limit: int
    :ivar current_value: Current value for this metric.
    :vartype current_value: int
    :ivar partition_id: The partition id (GUID identifier) of the usages.
    :vartype partition_id: str
    :ivar partition_key_range_id: The partition key range id (integer identifier) of the usages.
    :vartype partition_key_range_id: str
    """

    _validation = {
        "unit": {"readonly": True},
        "name": {"readonly": True},
        "quota_period": {"readonly": True},
        "limit": {"readonly": True},
        "current_value": {"readonly": True},
        "partition_id": {"readonly": True},
        "partition_key_range_id": {"readonly": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "limit": {"key": "limit", "type": "int"},
        "current_value": {"key": "currentValue", "type": "int"},
        "partition_id": {"key": "partitionId", "type": "str"},
        "partition_key_range_id": {"key": "partitionKeyRangeId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.partition_id = None
        self.partition_key_range_id = None


class PartitionUsagesResult(_serialization.Model):
    """The response to a list partition level usage request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of partition-level usages for the database. A usage is a point in time
     metric.
    :vartype value: list[~azure.mgmt.cosmosdb.models.PartitionUsage]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PartitionUsage]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class PercentileMetric(_serialization.Model):
    """Percentile Metric data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: The time grain to be used to summarize the metric values.
    :vartype time_grain: str
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The percentile metric values for the specified time window and timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.PercentileMetricValue]
    """

    _validation = {
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "time_grain": {"readonly": True},
        "unit": {"readonly": True},
        "name": {"readonly": True},
        "metric_values": {"readonly": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
        "metric_values": {"key": "metricValues", "type": "[PercentileMetricValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = None
        self.name = None
        self.metric_values = None


class PercentileMetricListResult(_serialization.Model):
    """The response to a list percentile metrics request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of percentile metrics for the account.
    :vartype value: list[~azure.mgmt.cosmosdb.models.PercentileMetric]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PercentileMetric]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class PercentileMetricValue(MetricValue):  # pylint: disable=too-many-instance-attributes
    """Represents percentile metrics values.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: The number of values for the metric.
    :vartype count: int
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: ~datetime.datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    :ivar p10: The 10th percentile value for the metric.
    :vartype p10: float
    :ivar p25: The 25th percentile value for the metric.
    :vartype p25: float
    :ivar p50: The 50th percentile value for the metric.
    :vartype p50: float
    :ivar p75: The 75th percentile value for the metric.
    :vartype p75: float
    :ivar p90: The 90th percentile value for the metric.
    :vartype p90: float
    :ivar p95: The 95th percentile value for the metric.
    :vartype p95: float
    :ivar p99: The 99th percentile value for the metric.
    :vartype p99: float
    """

    _validation = {
        "count": {"readonly": True},
        "average": {"readonly": True},
        "maximum": {"readonly": True},
        "minimum": {"readonly": True},
        "timestamp": {"readonly": True},
        "total": {"readonly": True},
        "p10": {"readonly": True},
        "p25": {"readonly": True},
        "p50": {"readonly": True},
        "p75": {"readonly": True},
        "p90": {"readonly": True},
        "p95": {"readonly": True},
        "p99": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "_count", "type": "int"},
        "average": {"key": "average", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "total": {"key": "total", "type": "float"},
        "p10": {"key": "P10", "type": "float"},
        "p25": {"key": "P25", "type": "float"},
        "p50": {"key": "P50", "type": "float"},
        "p75": {"key": "P75", "type": "float"},
        "p90": {"key": "P90", "type": "float"},
        "p95": {"key": "P95", "type": "float"},
        "p99": {"key": "P99", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.p10 = None
        self.p25 = None
        self.p50 = None
        self.p75 = None
        self.p90 = None
        self.p95 = None
        self.p99 = None


class PeriodicModeBackupPolicy(BackupPolicy):
    """The object representing periodic mode backup policy.

    All required parameters must be populated in order to send to server.

    :ivar type: Describes the mode of backups. Required. Known values are: "Periodic" and
     "Continuous".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.BackupPolicyType
    :ivar migration_state: The object representing the state of the migration between the backup
     policies.
    :vartype migration_state: ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationState
    :ivar periodic_mode_properties: Configuration values for periodic mode backup.
    :vartype periodic_mode_properties: ~azure.mgmt.cosmosdb.models.PeriodicModeProperties
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "migration_state": {"key": "migrationState", "type": "BackupPolicyMigrationState"},
        "periodic_mode_properties": {"key": "periodicModeProperties", "type": "PeriodicModeProperties"},
    }

    def __init__(
        self,
        *,
        migration_state: Optional["_models.BackupPolicyMigrationState"] = None,
        periodic_mode_properties: Optional["_models.PeriodicModeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword migration_state: The object representing the state of the migration between the backup
         policies.
        :paramtype migration_state: ~azure.mgmt.cosmosdb.models.BackupPolicyMigrationState
        :keyword periodic_mode_properties: Configuration values for periodic mode backup.
        :paramtype periodic_mode_properties: ~azure.mgmt.cosmosdb.models.PeriodicModeProperties
        """
        super().__init__(migration_state=migration_state, **kwargs)
        self.type: str = "Periodic"
        self.periodic_mode_properties = periodic_mode_properties


class PeriodicModeProperties(_serialization.Model):
    """Configuration values for periodic mode backup.

    :ivar backup_interval_in_minutes: An integer representing the interval in minutes between two
     backups.
    :vartype backup_interval_in_minutes: int
    :ivar backup_retention_interval_in_hours: An integer representing the time (in hours) that each
     backup is retained.
    :vartype backup_retention_interval_in_hours: int
    :ivar backup_storage_redundancy: Enum to indicate type of backup residency. Known values are:
     "Geo", "Local", and "Zone".
    :vartype backup_storage_redundancy: str or ~azure.mgmt.cosmosdb.models.BackupStorageRedundancy
    """

    _validation = {
        "backup_interval_in_minutes": {"minimum": 0},
        "backup_retention_interval_in_hours": {"minimum": 0},
    }

    _attribute_map = {
        "backup_interval_in_minutes": {"key": "backupIntervalInMinutes", "type": "int"},
        "backup_retention_interval_in_hours": {"key": "backupRetentionIntervalInHours", "type": "int"},
        "backup_storage_redundancy": {"key": "backupStorageRedundancy", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_interval_in_minutes: Optional[int] = None,
        backup_retention_interval_in_hours: Optional[int] = None,
        backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_interval_in_minutes: An integer representing the interval in minutes between
         two backups.
        :paramtype backup_interval_in_minutes: int
        :keyword backup_retention_interval_in_hours: An integer representing the time (in hours) that
         each backup is retained.
        :paramtype backup_retention_interval_in_hours: int
        :keyword backup_storage_redundancy: Enum to indicate type of backup residency. Known values
         are: "Geo", "Local", and "Zone".
        :paramtype backup_storage_redundancy: str or
         ~azure.mgmt.cosmosdb.models.BackupStorageRedundancy
        """
        super().__init__(**kwargs)
        self.backup_interval_in_minutes = backup_interval_in_minutes
        self.backup_retention_interval_in_hours = backup_retention_interval_in_hours
        self.backup_storage_redundancy = backup_storage_redundancy


class Permission(_serialization.Model):
    """The set of data plane operations permitted through this Role Definition.

    :ivar data_actions: An array of data actions that are allowed.
    :vartype data_actions: list[str]
    :ivar not_data_actions: An array of data actions that are denied.
    :vartype not_data_actions: list[str]
    """

    _attribute_map = {
        "data_actions": {"key": "dataActions", "type": "[str]"},
        "not_data_actions": {"key": "notDataActions", "type": "[str]"},
    }

    def __init__(
        self, *, data_actions: Optional[List[str]] = None, not_data_actions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword data_actions: An array of data actions that are allowed.
        :paramtype data_actions: list[str]
        :keyword not_data_actions: An array of data actions that are denied.
        :paramtype not_data_actions: list[str]
        """
        super().__init__(**kwargs)
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.cosmosdb.models.PrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection State of the Private Endpoint
     Connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.cosmosdb.models.PrivateLinkServiceConnectionStateProperty
    :ivar group_id: Group id of the private endpoint.
    :vartype group_id: str
    :ivar provisioning_state: Provisioning state of the private endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpointProperty"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionStateProperty",
        },
        "group_id": {"key": "properties.groupId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionStateProperty"] = None,
        group_id: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.cosmosdb.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection State of the Private Endpoint
         Connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.cosmosdb.models.PrivateLinkServiceConnectionStateProperty
        :keyword group_id: Group id of the private endpoint.
        :paramtype group_id: str
        :keyword provisioning_state: Provisioning state of the private endpoint.
        :paramtype provisioning_state: str
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.group_id = group_id
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.cosmosdb.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.cosmosdb.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateEndpointProperty(_serialization.Model):
    """Private endpoint which the connection belongs to.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ARMProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource required zone names.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.cosmosdb.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.cosmosdb.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionStateProperty(_serialization.Model):  # pylint: disable=name-too-long
    """Connection State of the Private Endpoint Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The private link service connection status.
    :vartype status: str
    :ivar description: The private link service connection description.
    :vartype description: str
    :ivar actions_required: Any action that is required beyond basic workflow (approve/ reject/
     disconnect).
    :vartype actions_required: str
    """

    _validation = {
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword status: The private link service connection status.
        :paramtype status: str
        :keyword description: The private link service connection description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class Privilege(_serialization.Model):
    """The set of data plane operations permitted through this Role Definition.

    :ivar resource: An Azure Cosmos DB Mongo DB Resource.
    :vartype resource: ~azure.mgmt.cosmosdb.models.PrivilegeResource
    :ivar actions: An array of actions that are allowed.
    :vartype actions: list[str]
    """

    _attribute_map = {
        "resource": {"key": "resource", "type": "PrivilegeResource"},
        "actions": {"key": "actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        resource: Optional["_models.PrivilegeResource"] = None,
        actions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource: An Azure Cosmos DB Mongo DB Resource.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.PrivilegeResource
        :keyword actions: An array of actions that are allowed.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.resource = resource
        self.actions = actions


class PrivilegeResource(_serialization.Model):
    """An Azure Cosmos DB Mongo DB Resource.

    :ivar db: The database name the role is applied.
    :vartype db: str
    :ivar collection: The collection name the role is applied.
    :vartype collection: str
    """

    _attribute_map = {
        "db": {"key": "db", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
    }

    def __init__(self, *, db: Optional[str] = None, collection: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword db: The database name the role is applied.
        :paramtype db: str
        :keyword collection: The collection name the role is applied.
        :paramtype collection: str
        """
        super().__init__(**kwargs)
        self.db = db
        self.collection = collection


class RegionForOnlineOffline(_serialization.Model):
    """Cosmos DB region to online or offline.

    All required parameters must be populated in order to send to server.

    :ivar region: Cosmos DB region, with spaces between words and each word capitalized. Required.
    :vartype region: str
    """

    _validation = {
        "region": {"required": True},
    }

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
    }

    def __init__(self, *, region: str, **kwargs: Any) -> None:
        """
        :keyword region: Cosmos DB region, with spaces between words and each word capitalized.
         Required.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.region = region


class RestoreParametersBase(_serialization.Model):
    """Parameters to indicate the information about the restore.

    :ivar restore_source: The id of the restorable database account from which the restore has to
     be initiated. For example:
     /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.  # pylint: disable=line-too-long
    :vartype restore_source: str
    :ivar restore_timestamp_in_utc: Time to which the account has to be restored (ISO-8601 format).
    :vartype restore_timestamp_in_utc: ~datetime.datetime
    :ivar restore_with_ttl_disabled: Specifies whether the restored account will have Time-To-Live
     disabled upon the successful restore.
    :vartype restore_with_ttl_disabled: bool
    """

    _attribute_map = {
        "restore_source": {"key": "restoreSource", "type": "str"},
        "restore_timestamp_in_utc": {"key": "restoreTimestampInUtc", "type": "iso-8601"},
        "restore_with_ttl_disabled": {"key": "restoreWithTtlDisabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        restore_source: Optional[str] = None,
        restore_timestamp_in_utc: Optional[datetime.datetime] = None,
        restore_with_ttl_disabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword restore_source: The id of the restorable database account from which the restore has
         to be initiated. For example:
         /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.  # pylint: disable=line-too-long
        :paramtype restore_source: str
        :keyword restore_timestamp_in_utc: Time to which the account has to be restored (ISO-8601
         format).
        :paramtype restore_timestamp_in_utc: ~datetime.datetime
        :keyword restore_with_ttl_disabled: Specifies whether the restored account will have
         Time-To-Live disabled upon the successful restore.
        :paramtype restore_with_ttl_disabled: bool
        """
        super().__init__(**kwargs)
        self.restore_source = restore_source
        self.restore_timestamp_in_utc = restore_timestamp_in_utc
        self.restore_with_ttl_disabled = restore_with_ttl_disabled


class ResourceRestoreParameters(RestoreParametersBase):
    """Parameters to indicate the information about the restore.

    :ivar restore_source: The id of the restorable database account from which the restore has to
     be initiated. For example:
     /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.  # pylint: disable=line-too-long
    :vartype restore_source: str
    :ivar restore_timestamp_in_utc: Time to which the account has to be restored (ISO-8601 format).
    :vartype restore_timestamp_in_utc: ~datetime.datetime
    :ivar restore_with_ttl_disabled: Specifies whether the restored account will have Time-To-Live
     disabled upon the successful restore.
    :vartype restore_with_ttl_disabled: bool
    """


class RestorableDatabaseAccountGetResult(_serialization.Model):
    """A Azure Cosmos DB restorable database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar account_name: The name of the global database account.
    :vartype account_name: str
    :ivar creation_time: The creation time of the restorable database account (ISO-8601 format).
    :vartype creation_time: ~datetime.datetime
    :ivar deletion_time: The time at which the restorable database account has been deleted
     (ISO-8601 format).
    :vartype deletion_time: ~datetime.datetime
    :ivar oldest_restorable_time: The least recent time at which the database account can be
     restored to (ISO-8601 format).
    :vartype oldest_restorable_time: ~datetime.datetime
    :ivar api_type: The API type of the restorable database account. Known values are: "MongoDB",
     "Gremlin", "Cassandra", "Table", "Sql", and "GremlinV2".
    :vartype api_type: str or ~azure.mgmt.cosmosdb.models.ApiType
    :ivar restorable_locations: List of regions where the of the database account can be restored
     from.
    :vartype restorable_locations: list[~azure.mgmt.cosmosdb.models.RestorableLocationResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "api_type": {"readonly": True},
        "restorable_locations": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "deletion_time": {"key": "properties.deletionTime", "type": "iso-8601"},
        "oldest_restorable_time": {"key": "properties.oldestRestorableTime", "type": "iso-8601"},
        "api_type": {"key": "properties.apiType", "type": "str"},
        "restorable_locations": {"key": "properties.restorableLocations", "type": "[RestorableLocationResource]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        account_name: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        deletion_time: Optional[datetime.datetime] = None,
        oldest_restorable_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword account_name: The name of the global database account.
        :paramtype account_name: str
        :keyword creation_time: The creation time of the restorable database account (ISO-8601 format).
        :paramtype creation_time: ~datetime.datetime
        :keyword deletion_time: The time at which the restorable database account has been deleted
         (ISO-8601 format).
        :paramtype deletion_time: ~datetime.datetime
        :keyword oldest_restorable_time: The least recent time at which the database account can be
         restored to (ISO-8601 format).
        :paramtype oldest_restorable_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.account_name = account_name
        self.creation_time = creation_time
        self.deletion_time = deletion_time
        self.oldest_restorable_time = oldest_restorable_time
        self.api_type = None
        self.restorable_locations = None


class RestorableDatabaseAccountsListResult(_serialization.Model):
    """The List operation response, that contains the restorable database accounts and their
    properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of restorable database accounts and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableDatabaseAccountGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableDatabaseAccountGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableGremlinDatabaseGetResult(_serialization.Model):
    """An Azure Cosmos DB Gremlin database event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB Gremlin database event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableGremlinDatabasePropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableGremlinDatabasePropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableGremlinDatabasePropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB Gremlin database event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableGremlinDatabasePropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableGremlinDatabasePropertiesResource(_serialization.Model):  # pylint: disable=name-too-long
    """The resource of an Azure Cosmos DB Gremlin database event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this database event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this database to identify if this database is restorable in same
     account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this database can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The time when this database event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this Gremlin database.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of this Gremlin database.
    :vartype owner_resource_id: str
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableGremlinDatabasesListResult(_serialization.Model):
    """The List operation response, that contains the Gremlin database events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Gremlin database events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableGremlinDatabaseGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableGremlinDatabaseGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableGremlinGraphGetResult(_serialization.Model):
    """An Azure Cosmos DB Gremlin graph event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB Gremlin graph event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableGremlinGraphPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableGremlinGraphPropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableGremlinGraphPropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB Gremlin graph event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableGremlinGraphPropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableGremlinGraphPropertiesResource(_serialization.Model):
    """The resource of an Azure Cosmos DB Gremlin graph event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this graph event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this graph to identify if this graph is restorable in same
     account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this graph can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The time when this graph event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this Gremlin graph.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of this Gremlin graph.
    :vartype owner_resource_id: str
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableGremlinGraphsListResult(_serialization.Model):
    """The List operation response, that contains the Gremlin graph events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Gremlin graph events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableGremlinGraphGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableGremlinGraphGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableGremlinResourcesGetResult(_serialization.Model):
    """Specific Databases to restore.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar database_name: The name of the gremlin database available for restore.
    :vartype database_name: str
    :ivar graph_names: The names of the graphs available for restore.
    :vartype graph_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "graph_names": {"key": "graphNames", "type": "[str]"},
    }

    def __init__(
        self, *, database_name: Optional[str] = None, graph_names: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database_name: The name of the gremlin database available for restore.
        :paramtype database_name: str
        :keyword graph_names: The names of the graphs available for restore.
        :paramtype graph_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.database_name = database_name
        self.graph_names = graph_names


class RestorableGremlinResourcesListResult(_serialization.Model):
    """The List operation response, that contains the restorable Gremlin resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of restorable Gremlin resources, including the gremlin database and graph
     names.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableGremlinResourcesGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableGremlinResourcesGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableLocationResource(_serialization.Model):
    """Properties of the regional restorable account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location_name: The location of the regional restorable account.
    :vartype location_name: str
    :ivar regional_database_account_instance_id: The instance id of the regional restorable
     account.
    :vartype regional_database_account_instance_id: str
    :ivar creation_time: The creation time of the regional restorable database account (ISO-8601
     format).
    :vartype creation_time: ~datetime.datetime
    :ivar deletion_time: The time at which the regional restorable database account has been
     deleted (ISO-8601 format).
    :vartype deletion_time: ~datetime.datetime
    """

    _validation = {
        "location_name": {"readonly": True},
        "regional_database_account_instance_id": {"readonly": True},
        "creation_time": {"readonly": True},
        "deletion_time": {"readonly": True},
    }

    _attribute_map = {
        "location_name": {"key": "locationName", "type": "str"},
        "regional_database_account_instance_id": {"key": "regionalDatabaseAccountInstanceId", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "deletion_time": {"key": "deletionTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location_name = None
        self.regional_database_account_instance_id = None
        self.creation_time = None
        self.deletion_time = None


class RestorableMongodbCollectionGetResult(_serialization.Model):
    """An Azure Cosmos DB MongoDB collection event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB MongoDB collection event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableMongodbCollectionPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableMongodbCollectionPropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableMongodbCollectionPropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB MongoDB collection event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableMongodbCollectionPropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableMongodbCollectionPropertiesResource(_serialization.Model):  # pylint: disable=name-too-long
    """The resource of an Azure Cosmos DB MongoDB collection event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this collection event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this collection to identify if this container is restorable in
     same account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this collection can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The time when this collection event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this MongoDB collection.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of this MongoDB collection.
    :vartype owner_resource_id: str
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableMongodbCollectionsListResult(_serialization.Model):
    """The List operation response, that contains the MongoDB collection events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of MongoDB collection events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableMongodbCollectionGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableMongodbCollectionGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableMongodbDatabaseGetResult(_serialization.Model):
    """An Azure Cosmos DB MongoDB database event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB MongoDB database event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableMongodbDatabasePropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableMongodbDatabasePropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableMongodbDatabasePropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB MongoDB database event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableMongodbDatabasePropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableMongodbDatabasePropertiesResource(_serialization.Model):  # pylint: disable=name-too-long
    """The resource of an Azure Cosmos DB MongoDB database event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this database event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this database to identify if this database is restorable in same
     account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this database can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The time when this database event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this MongoDB database.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of this MongoDB database.
    :vartype owner_resource_id: str
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableMongodbDatabasesListResult(_serialization.Model):
    """The List operation response, that contains the MongoDB database events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of MongoDB database events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableMongodbDatabaseGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableMongodbDatabaseGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableMongodbResourcesGetResult(_serialization.Model):
    """Specific Databases to restore.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar database_name: The name of the database available for restore.
    :vartype database_name: str
    :ivar collection_names: The names of the collections available for restore.
    :vartype collection_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "collection_names": {"key": "collectionNames", "type": "[str]"},
    }

    def __init__(
        self, *, database_name: Optional[str] = None, collection_names: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database_name: The name of the database available for restore.
        :paramtype database_name: str
        :keyword collection_names: The names of the collections available for restore.
        :paramtype collection_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.database_name = database_name
        self.collection_names = collection_names


class RestorableMongodbResourcesListResult(_serialization.Model):
    """The List operation response, that contains the restorable MongoDB resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of restorable MongoDB resources, including the database and collection names.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableMongodbResourcesGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableMongodbResourcesGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableSqlContainerGetResult(_serialization.Model):
    """An Azure Cosmos DB SQL container event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB SQL container event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableSqlContainerPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableSqlContainerPropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableSqlContainerPropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB SQL container event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableSqlContainerPropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableSqlContainerPropertiesResource(_serialization.Model):
    """The resource of an Azure Cosmos DB SQL container event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this container event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this container to identify if this container is restorable in
     same account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this container can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The when this container event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this SQL container.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of this SQL container.
    :vartype owner_resource_id: str
    :ivar container: Cosmos DB SQL container resource object.
    :vartype container:
     ~azure.mgmt.cosmosdb.models.RestorableSqlContainerPropertiesResourceContainer
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
        "container": {"key": "container", "type": "RestorableSqlContainerPropertiesResourceContainer"},
    }

    def __init__(
        self, *, container: Optional["_models.RestorableSqlContainerPropertiesResourceContainer"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword container: Cosmos DB SQL container resource object.
        :paramtype container:
         ~azure.mgmt.cosmosdb.models.RestorableSqlContainerPropertiesResourceContainer
        """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None
        self.container = container


class SqlContainerResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Cosmos DB SQL container resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB SQL container. Required.
    :vartype id: str
    :ivar indexing_policy: The configuration of the indexing policy. By default, the indexing is
     automatic for all document paths within the container.
    :vartype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :ivar partition_key: The configuration of the partition key to be used for partitioning data
     into multiple partitions.
    :vartype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :ivar default_ttl: Default time to live.
    :vartype default_ttl: int
    :ivar unique_key_policy: The unique key policy configuration for specifying uniqueness
     constraints on documents in the collection in the Azure Cosmos DB service.
    :vartype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :ivar conflict_resolution_policy: The conflict resolution policy for the container.
    :vartype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar client_encryption_policy: The client encryption policy for the container.
    :vartype client_encryption_policy: ~azure.mgmt.cosmosdb.models.ClientEncryptionPolicy
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar computed_properties: List of computed properties.
    :vartype computed_properties: list[~azure.mgmt.cosmosdb.models.ComputedProperty]
    :ivar vector_embedding_policy: The vector embedding policy for the container.
    :vartype vector_embedding_policy: ~azure.mgmt.cosmosdb.models.VectorEmbeddingPolicy
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "indexing_policy": {"key": "indexingPolicy", "type": "IndexingPolicy"},
        "partition_key": {"key": "partitionKey", "type": "ContainerPartitionKey"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "unique_key_policy": {"key": "uniqueKeyPolicy", "type": "UniqueKeyPolicy"},
        "conflict_resolution_policy": {"key": "conflictResolutionPolicy", "type": "ConflictResolutionPolicy"},
        "client_encryption_policy": {"key": "clientEncryptionPolicy", "type": "ClientEncryptionPolicy"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
        "computed_properties": {"key": "computedProperties", "type": "[ComputedProperty]"},
        "vector_embedding_policy": {"key": "vectorEmbeddingPolicy", "type": "VectorEmbeddingPolicy"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        indexing_policy: Optional["_models.IndexingPolicy"] = None,
        partition_key: Optional["_models.ContainerPartitionKey"] = None,
        default_ttl: Optional[int] = None,
        unique_key_policy: Optional["_models.UniqueKeyPolicy"] = None,
        conflict_resolution_policy: Optional["_models.ConflictResolutionPolicy"] = None,
        client_encryption_policy: Optional["_models.ClientEncryptionPolicy"] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        computed_properties: Optional[List["_models.ComputedProperty"]] = None,
        vector_embedding_policy: Optional["_models.VectorEmbeddingPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL container. Required.
        :paramtype id: str
        :keyword indexing_policy: The configuration of the indexing policy. By default, the indexing is
         automatic for all document paths within the container.
        :paramtype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
        :keyword partition_key: The configuration of the partition key to be used for partitioning data
         into multiple partitions.
        :paramtype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
        :keyword default_ttl: Default time to live.
        :paramtype default_ttl: int
        :keyword unique_key_policy: The unique key policy configuration for specifying uniqueness
         constraints on documents in the collection in the Azure Cosmos DB service.
        :paramtype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
        :keyword conflict_resolution_policy: The conflict resolution policy for the container.
        :paramtype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
        :keyword client_encryption_policy: The client encryption policy for the container.
        :paramtype client_encryption_policy: ~azure.mgmt.cosmosdb.models.ClientEncryptionPolicy
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        :keyword computed_properties: List of computed properties.
        :paramtype computed_properties: list[~azure.mgmt.cosmosdb.models.ComputedProperty]
        :keyword vector_embedding_policy: The vector embedding policy for the container.
        :paramtype vector_embedding_policy: ~azure.mgmt.cosmosdb.models.VectorEmbeddingPolicy
        """
        super().__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self.client_encryption_policy = client_encryption_policy
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode
        self.computed_properties = computed_properties
        self.vector_embedding_policy = vector_embedding_policy


class RestorableSqlContainerPropertiesResourceContainer(
    SqlContainerResource, ExtendedResourceProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Cosmos DB SQL container resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL container. Required.
    :vartype id: str
    :ivar indexing_policy: The configuration of the indexing policy. By default, the indexing is
     automatic for all document paths within the container.
    :vartype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :ivar partition_key: The configuration of the partition key to be used for partitioning data
     into multiple partitions.
    :vartype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :ivar default_ttl: Default time to live.
    :vartype default_ttl: int
    :ivar unique_key_policy: The unique key policy configuration for specifying uniqueness
     constraints on documents in the collection in the Azure Cosmos DB service.
    :vartype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :ivar conflict_resolution_policy: The conflict resolution policy for the container.
    :vartype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar client_encryption_policy: The client encryption policy for the container.
    :vartype client_encryption_policy: ~azure.mgmt.cosmosdb.models.ClientEncryptionPolicy
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar computed_properties: List of computed properties.
    :vartype computed_properties: list[~azure.mgmt.cosmosdb.models.ComputedProperty]
    :ivar vector_embedding_policy: The vector embedding policy for the container.
    :vartype vector_embedding_policy: ~azure.mgmt.cosmosdb.models.VectorEmbeddingPolicy
    :ivar self_property: A system generated property that specifies the addressable path of the
     container resource.
    :vartype self_property: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
        "self_property": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "indexing_policy": {"key": "indexingPolicy", "type": "IndexingPolicy"},
        "partition_key": {"key": "partitionKey", "type": "ContainerPartitionKey"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "unique_key_policy": {"key": "uniqueKeyPolicy", "type": "UniqueKeyPolicy"},
        "conflict_resolution_policy": {"key": "conflictResolutionPolicy", "type": "ConflictResolutionPolicy"},
        "client_encryption_policy": {"key": "clientEncryptionPolicy", "type": "ClientEncryptionPolicy"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
        "computed_properties": {"key": "computedProperties", "type": "[ComputedProperty]"},
        "vector_embedding_policy": {"key": "vectorEmbeddingPolicy", "type": "VectorEmbeddingPolicy"},
        "self_property": {"key": "_self", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        indexing_policy: Optional["_models.IndexingPolicy"] = None,
        partition_key: Optional["_models.ContainerPartitionKey"] = None,
        default_ttl: Optional[int] = None,
        unique_key_policy: Optional["_models.UniqueKeyPolicy"] = None,
        conflict_resolution_policy: Optional["_models.ConflictResolutionPolicy"] = None,
        client_encryption_policy: Optional["_models.ClientEncryptionPolicy"] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        computed_properties: Optional[List["_models.ComputedProperty"]] = None,
        vector_embedding_policy: Optional["_models.VectorEmbeddingPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL container. Required.
        :paramtype id: str
        :keyword indexing_policy: The configuration of the indexing policy. By default, the indexing is
         automatic for all document paths within the container.
        :paramtype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
        :keyword partition_key: The configuration of the partition key to be used for partitioning data
         into multiple partitions.
        :paramtype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
        :keyword default_ttl: Default time to live.
        :paramtype default_ttl: int
        :keyword unique_key_policy: The unique key policy configuration for specifying uniqueness
         constraints on documents in the collection in the Azure Cosmos DB service.
        :paramtype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
        :keyword conflict_resolution_policy: The conflict resolution policy for the container.
        :paramtype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
        :keyword client_encryption_policy: The client encryption policy for the container.
        :paramtype client_encryption_policy: ~azure.mgmt.cosmosdb.models.ClientEncryptionPolicy
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        :keyword computed_properties: List of computed properties.
        :paramtype computed_properties: list[~azure.mgmt.cosmosdb.models.ComputedProperty]
        :keyword vector_embedding_policy: The vector embedding policy for the container.
        :paramtype vector_embedding_policy: ~azure.mgmt.cosmosdb.models.VectorEmbeddingPolicy
        """
        super().__init__(
            id=id,
            indexing_policy=indexing_policy,
            partition_key=partition_key,
            default_ttl=default_ttl,
            unique_key_policy=unique_key_policy,
            conflict_resolution_policy=conflict_resolution_policy,
            client_encryption_policy=client_encryption_policy,
            analytical_storage_ttl=analytical_storage_ttl,
            restore_parameters=restore_parameters,
            create_mode=create_mode,
            computed_properties=computed_properties,
            vector_embedding_policy=vector_embedding_policy,
            **kwargs
        )
        self.rid = None
        self.ts = None
        self.etag = None
        self.self_property = None
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self.client_encryption_policy = client_encryption_policy
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode
        self.computed_properties = computed_properties
        self.vector_embedding_policy = vector_embedding_policy


class RestorableSqlContainersListResult(_serialization.Model):
    """The List operation response, that contains the SQL container events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of SQL container events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableSqlContainerGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableSqlContainerGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableSqlDatabaseGetResult(_serialization.Model):
    """An Azure Cosmos DB SQL database event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB SQL database event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableSqlDatabasePropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableSqlDatabasePropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableSqlDatabasePropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB SQL database event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableSqlDatabasePropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableSqlDatabasePropertiesResource(_serialization.Model):
    """The resource of an Azure Cosmos DB SQL database event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this database event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this database to identify if this database is restorable in same
     account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this database can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The time when this database event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of the SQL database.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of the SQL database.
    :vartype owner_resource_id: str
    :ivar database: Cosmos DB SQL database resource object.
    :vartype database: ~azure.mgmt.cosmosdb.models.RestorableSqlDatabasePropertiesResourceDatabase
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
        "database": {"key": "database", "type": "RestorableSqlDatabasePropertiesResourceDatabase"},
    }

    def __init__(
        self, *, database: Optional["_models.RestorableSqlDatabasePropertiesResourceDatabase"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database: Cosmos DB SQL database resource object.
        :paramtype database:
         ~azure.mgmt.cosmosdb.models.RestorableSqlDatabasePropertiesResourceDatabase
        """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None
        self.database = database


class SqlDatabaseResource(_serialization.Model):
    """Cosmos DB SQL database resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB SQL database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(**kwargs)
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class RestorableSqlDatabasePropertiesResourceDatabase(
    SqlDatabaseResource, ExtendedResourceProperties
):  # pylint: disable=name-too-long
    """Cosmos DB SQL database resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar colls: A system generated property that specified the addressable path of the collections
     resource.
    :vartype colls: str
    :ivar users: A system generated property that specifies the addressable path of the users
     resource.
    :vartype users: str
    :ivar self_property: A system generated property that specifies the addressable path of the
     database resource.
    :vartype self_property: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
        "colls": {"readonly": True},
        "users": {"readonly": True},
        "self_property": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
        "colls": {"key": "_colls", "type": "str"},
        "users": {"key": "_users", "type": "str"},
        "self_property": {"key": "_self", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(id=id, restore_parameters=restore_parameters, create_mode=create_mode, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.colls = None
        self.users = None
        self.self_property = None
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class RestorableSqlDatabasesListResult(_serialization.Model):
    """The List operation response, that contains the SQL database events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of SQL database events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableSqlDatabaseGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableSqlDatabaseGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableSqlResourcesGetResult(_serialization.Model):
    """Specific Databases to restore.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar database_name: The name of the database available for restore.
    :vartype database_name: str
    :ivar collection_names: The names of the collections available for restore.
    :vartype collection_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "collection_names": {"key": "collectionNames", "type": "[str]"},
    }

    def __init__(
        self, *, database_name: Optional[str] = None, collection_names: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database_name: The name of the database available for restore.
        :paramtype database_name: str
        :keyword collection_names: The names of the collections available for restore.
        :paramtype collection_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.database_name = database_name
        self.collection_names = collection_names


class RestorableSqlResourcesListResult(_serialization.Model):
    """The List operation response, that contains the restorable SQL resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of restorable SQL resources, including the database and collection names.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableSqlResourcesGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableSqlResourcesGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableTableGetResult(_serialization.Model):
    """An Azure Cosmos DB Table event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource Identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar resource: The resource of an Azure Cosmos DB Table event.
    :vartype resource: ~azure.mgmt.cosmosdb.models.RestorableTablePropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource": {"key": "properties.resource", "type": "RestorableTablePropertiesResource"},
    }

    def __init__(
        self, *, resource: Optional["_models.RestorableTablePropertiesResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource of an Azure Cosmos DB Table event.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.RestorableTablePropertiesResource
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.resource = resource


class RestorableTablePropertiesResource(_serialization.Model):
    """The resource of an Azure Cosmos DB Table event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar operation_type: The operation type of this table event. Known values are: "Create",
     "Replace", "Delete", "Recreate", and "SystemOperation".
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar can_undelete: A state of this table to identify if this table is restorable in same
     account.
    :vartype can_undelete: str
    :ivar can_undelete_reason: The reason why this table can not be restored in same account.
    :vartype can_undelete_reason: str
    :ivar event_timestamp: The time when this table event happened.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this Table.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource ID of this Table.
    :vartype owner_resource_id: str
    """

    _validation = {
        "rid": {"readonly": True},
        "operation_type": {"readonly": True},
        "can_undelete": {"readonly": True},
        "can_undelete_reason": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "owner_id": {"readonly": True},
        "owner_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "can_undelete": {"key": "canUndelete", "type": "str"},
        "can_undelete_reason": {"key": "canUndeleteReason", "type": "str"},
        "event_timestamp": {"key": "eventTimestamp", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_resource_id": {"key": "ownerResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rid = None
        self.operation_type = None
        self.can_undelete = None
        self.can_undelete_reason = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableTableResourcesGetResult(_serialization.Model):
    """Specific Databases to restore.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the Table.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class RestorableTableResourcesListResult(_serialization.Model):
    """List of restorable table names.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of restorable table names.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableTableResourcesGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableTableResourcesGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestorableTablesListResult(_serialization.Model):
    """The List operation response, that contains the Table events and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Table events and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.RestorableTableGetResult]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableTableGetResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class RestoreParameters(RestoreParametersBase):
    """Parameters to indicate the information about the restore.

    :ivar restore_source: The id of the restorable database account from which the restore has to
     be initiated. For example:
     /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.  # pylint: disable=line-too-long
    :vartype restore_source: str
    :ivar restore_timestamp_in_utc: Time to which the account has to be restored (ISO-8601 format).
    :vartype restore_timestamp_in_utc: ~datetime.datetime
    :ivar restore_with_ttl_disabled: Specifies whether the restored account will have Time-To-Live
     disabled upon the successful restore.
    :vartype restore_with_ttl_disabled: bool
    :ivar restore_mode: Describes the mode of the restore. "PointInTime"
    :vartype restore_mode: str or ~azure.mgmt.cosmosdb.models.RestoreMode
    :ivar databases_to_restore: List of specific databases available for restore.
    :vartype databases_to_restore: list[~azure.mgmt.cosmosdb.models.DatabaseRestoreResource]
    :ivar gremlin_databases_to_restore: List of specific gremlin databases available for restore.
    :vartype gremlin_databases_to_restore:
     list[~azure.mgmt.cosmosdb.models.GremlinDatabaseRestoreResource]
    :ivar tables_to_restore: List of specific tables available for restore.
    :vartype tables_to_restore: list[str]
    """

    _attribute_map = {
        "restore_source": {"key": "restoreSource", "type": "str"},
        "restore_timestamp_in_utc": {"key": "restoreTimestampInUtc", "type": "iso-8601"},
        "restore_with_ttl_disabled": {"key": "restoreWithTtlDisabled", "type": "bool"},
        "restore_mode": {"key": "restoreMode", "type": "str"},
        "databases_to_restore": {"key": "databasesToRestore", "type": "[DatabaseRestoreResource]"},
        "gremlin_databases_to_restore": {
            "key": "gremlinDatabasesToRestore",
            "type": "[GremlinDatabaseRestoreResource]",
        },
        "tables_to_restore": {"key": "tablesToRestore", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        restore_source: Optional[str] = None,
        restore_timestamp_in_utc: Optional[datetime.datetime] = None,
        restore_with_ttl_disabled: Optional[bool] = None,
        restore_mode: Optional[Union[str, "_models.RestoreMode"]] = None,
        databases_to_restore: Optional[List["_models.DatabaseRestoreResource"]] = None,
        gremlin_databases_to_restore: Optional[List["_models.GremlinDatabaseRestoreResource"]] = None,
        tables_to_restore: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword restore_source: The id of the restorable database account from which the restore has
         to be initiated. For example:
         /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.  # pylint: disable=line-too-long
        :paramtype restore_source: str
        :keyword restore_timestamp_in_utc: Time to which the account has to be restored (ISO-8601
         format).
        :paramtype restore_timestamp_in_utc: ~datetime.datetime
        :keyword restore_with_ttl_disabled: Specifies whether the restored account will have
         Time-To-Live disabled upon the successful restore.
        :paramtype restore_with_ttl_disabled: bool
        :keyword restore_mode: Describes the mode of the restore. "PointInTime"
        :paramtype restore_mode: str or ~azure.mgmt.cosmosdb.models.RestoreMode
        :keyword databases_to_restore: List of specific databases available for restore.
        :paramtype databases_to_restore: list[~azure.mgmt.cosmosdb.models.DatabaseRestoreResource]
        :keyword gremlin_databases_to_restore: List of specific gremlin databases available for
         restore.
        :paramtype gremlin_databases_to_restore:
         list[~azure.mgmt.cosmosdb.models.GremlinDatabaseRestoreResource]
        :keyword tables_to_restore: List of specific tables available for restore.
        :paramtype tables_to_restore: list[str]
        """
        super().__init__(
            restore_source=restore_source,
            restore_timestamp_in_utc=restore_timestamp_in_utc,
            restore_with_ttl_disabled=restore_with_ttl_disabled,
            **kwargs
        )
        self.restore_mode = restore_mode
        self.databases_to_restore = databases_to_restore
        self.gremlin_databases_to_restore = gremlin_databases_to_restore
        self.tables_to_restore = tables_to_restore


class Role(_serialization.Model):
    """The set of roles permitted through this Role Definition.

    :ivar db: The database name the role is applied.
    :vartype db: str
    :ivar role: The role name.
    :vartype role: str
    """

    _attribute_map = {
        "db": {"key": "db", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(self, *, db: Optional[str] = None, role: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword db: The database name the role is applied.
        :paramtype db: str
        :keyword role: The role name.
        :paramtype role: str
        """
        super().__init__(**kwargs)
        self.db = db
        self.role = role


class SeedNode(_serialization.Model):
    """SeedNode.

    :ivar ip_address: IP address of this seed node.
    :vartype ip_address: str
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, ip_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address: IP address of this seed node.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address


class ServiceResource(ARMProxyResource):
    """Properties for the database account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar properties: Services response resource.
    :vartype properties: ~azure.mgmt.cosmosdb.models.ServiceResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ServiceResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ServiceResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Services response resource.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.ServiceResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServiceResourceCreateUpdateParameters(_serialization.Model):
    """Parameters for Create or Update request for ServiceResource.

    :ivar properties: Properties in ServiceResourceCreateUpdateParameters.
    :vartype properties: ~azure.mgmt.cosmosdb.models.ServiceResourceCreateUpdateProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ServiceResourceCreateUpdateProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ServiceResourceCreateUpdateProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties in ServiceResourceCreateUpdateParameters.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.ServiceResourceCreateUpdateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServiceResourceListResult(_serialization.Model):
    """The List operation response, that contains the Service Resource and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Service Resource and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.ServiceResource]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SpatialSpec(_serialization.Model):
    """SpatialSpec.

    :ivar path: The path for which the indexing behavior applies to. Index paths typically start
     with root and end with wildcard (/path/*).
    :vartype path: str
    :ivar types: List of path's spatial type.
    :vartype types: list[str or ~azure.mgmt.cosmosdb.models.SpatialType]
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "types": {"key": "types", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        types: Optional[List[Union[str, "_models.SpatialType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path for which the indexing behavior applies to. Index paths typically start
         with root and end with wildcard (/path/*).
        :paramtype path: str
        :keyword types: List of path's spatial type.
        :paramtype types: list[str or ~azure.mgmt.cosmosdb.models.SpatialType]
        """
        super().__init__(**kwargs)
        self.path = path
        self.types = types


class SqlContainerCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a container. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlContainerResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlContainerResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.SqlContainerResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a container. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlContainerResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlContainerGetPropertiesOptions(OptionsResource):
    """SqlContainerGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class SqlContainerGetPropertiesResource(
    SqlContainerResource, ExtendedResourceProperties
):  # pylint: disable=too-many-instance-attributes
    """SqlContainerGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL container. Required.
    :vartype id: str
    :ivar indexing_policy: The configuration of the indexing policy. By default, the indexing is
     automatic for all document paths within the container.
    :vartype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :ivar partition_key: The configuration of the partition key to be used for partitioning data
     into multiple partitions.
    :vartype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :ivar default_ttl: Default time to live.
    :vartype default_ttl: int
    :ivar unique_key_policy: The unique key policy configuration for specifying uniqueness
     constraints on documents in the collection in the Azure Cosmos DB service.
    :vartype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :ivar conflict_resolution_policy: The conflict resolution policy for the container.
    :vartype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar client_encryption_policy: The client encryption policy for the container.
    :vartype client_encryption_policy: ~azure.mgmt.cosmosdb.models.ClientEncryptionPolicy
    :ivar analytical_storage_ttl: Analytical TTL.
    :vartype analytical_storage_ttl: int
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar computed_properties: List of computed properties.
    :vartype computed_properties: list[~azure.mgmt.cosmosdb.models.ComputedProperty]
    :ivar vector_embedding_policy: The vector embedding policy for the container.
    :vartype vector_embedding_policy: ~azure.mgmt.cosmosdb.models.VectorEmbeddingPolicy
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "indexing_policy": {"key": "indexingPolicy", "type": "IndexingPolicy"},
        "partition_key": {"key": "partitionKey", "type": "ContainerPartitionKey"},
        "default_ttl": {"key": "defaultTtl", "type": "int"},
        "unique_key_policy": {"key": "uniqueKeyPolicy", "type": "UniqueKeyPolicy"},
        "conflict_resolution_policy": {"key": "conflictResolutionPolicy", "type": "ConflictResolutionPolicy"},
        "client_encryption_policy": {"key": "clientEncryptionPolicy", "type": "ClientEncryptionPolicy"},
        "analytical_storage_ttl": {"key": "analyticalStorageTtl", "type": "int"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
        "computed_properties": {"key": "computedProperties", "type": "[ComputedProperty]"},
        "vector_embedding_policy": {"key": "vectorEmbeddingPolicy", "type": "VectorEmbeddingPolicy"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        indexing_policy: Optional["_models.IndexingPolicy"] = None,
        partition_key: Optional["_models.ContainerPartitionKey"] = None,
        default_ttl: Optional[int] = None,
        unique_key_policy: Optional["_models.UniqueKeyPolicy"] = None,
        conflict_resolution_policy: Optional["_models.ConflictResolutionPolicy"] = None,
        client_encryption_policy: Optional["_models.ClientEncryptionPolicy"] = None,
        analytical_storage_ttl: Optional[int] = None,
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        computed_properties: Optional[List["_models.ComputedProperty"]] = None,
        vector_embedding_policy: Optional["_models.VectorEmbeddingPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL container. Required.
        :paramtype id: str
        :keyword indexing_policy: The configuration of the indexing policy. By default, the indexing is
         automatic for all document paths within the container.
        :paramtype indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
        :keyword partition_key: The configuration of the partition key to be used for partitioning data
         into multiple partitions.
        :paramtype partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
        :keyword default_ttl: Default time to live.
        :paramtype default_ttl: int
        :keyword unique_key_policy: The unique key policy configuration for specifying uniqueness
         constraints on documents in the collection in the Azure Cosmos DB service.
        :paramtype unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
        :keyword conflict_resolution_policy: The conflict resolution policy for the container.
        :paramtype conflict_resolution_policy: ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
        :keyword client_encryption_policy: The client encryption policy for the container.
        :paramtype client_encryption_policy: ~azure.mgmt.cosmosdb.models.ClientEncryptionPolicy
        :keyword analytical_storage_ttl: Analytical TTL.
        :paramtype analytical_storage_ttl: int
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        :keyword computed_properties: List of computed properties.
        :paramtype computed_properties: list[~azure.mgmt.cosmosdb.models.ComputedProperty]
        :keyword vector_embedding_policy: The vector embedding policy for the container.
        :paramtype vector_embedding_policy: ~azure.mgmt.cosmosdb.models.VectorEmbeddingPolicy
        """
        super().__init__(
            id=id,
            indexing_policy=indexing_policy,
            partition_key=partition_key,
            default_ttl=default_ttl,
            unique_key_policy=unique_key_policy,
            conflict_resolution_policy=conflict_resolution_policy,
            client_encryption_policy=client_encryption_policy,
            analytical_storage_ttl=analytical_storage_ttl,
            restore_parameters=restore_parameters,
            create_mode=create_mode,
            computed_properties=computed_properties,
            vector_embedding_policy=vector_embedding_policy,
            **kwargs
        )
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self.client_encryption_policy = client_encryption_policy
        self.analytical_storage_ttl = analytical_storage_ttl
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode
        self.computed_properties = computed_properties
        self.vector_embedding_policy = vector_embedding_policy


class SqlContainerGetResults(ARMResourceProperties):
    """An Azure Cosmos DB container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlContainerGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.SqlContainerGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlContainerGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "SqlContainerGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.SqlContainerGetPropertiesResource"] = None,
        options: Optional["_models.SqlContainerGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlContainerGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.SqlContainerGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlContainerListResult(_serialization.Model):
    """The List operation response, that contains the containers and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of containers and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlContainerGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlContainerGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SqlDatabaseCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB SQL database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a SQL database. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlDatabaseResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlDatabaseResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.SqlDatabaseResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a SQL database. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlDatabaseResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlDatabaseGetPropertiesOptions(OptionsResource):
    """SqlDatabaseGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class SqlDatabaseGetPropertiesResource(SqlDatabaseResource, ExtendedResourceProperties):
    """SqlDatabaseGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL database. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :ivar colls: A system generated property that specified the addressable path of the collections
     resource.
    :vartype colls: str
    :ivar users: A system generated property that specifies the addressable path of the users
     resource.
    :vartype users: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
        "colls": {"key": "_colls", "type": "str"},
        "users": {"key": "_users", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        colls: Optional[str] = None,
        users: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL database. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        :keyword colls: A system generated property that specified the addressable path of the
         collections resource.
        :paramtype colls: str
        :keyword users: A system generated property that specifies the addressable path of the users
         resource.
        :paramtype users: str
        """
        super().__init__(id=id, restore_parameters=restore_parameters, create_mode=create_mode, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.colls = colls
        self.users = users
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class SqlDatabaseGetResults(ARMResourceProperties):
    """An Azure Cosmos DB SQL database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlDatabaseGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.SqlDatabaseGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlDatabaseGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "SqlDatabaseGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.SqlDatabaseGetPropertiesResource"] = None,
        options: Optional["_models.SqlDatabaseGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlDatabaseGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.SqlDatabaseGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlDatabaseListResult(_serialization.Model):
    """The List operation response, that contains the SQL databases and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of SQL databases and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlDatabaseGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlDatabaseGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SqlDedicatedGatewayRegionalServiceResource(RegionalServiceResource):  # pylint: disable=name-too-long
    """Resource for a regional service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The regional service name.
    :vartype name: str
    :ivar location: The location name.
    :vartype location: str
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    :ivar sql_dedicated_gateway_endpoint: The regional endpoint for SqlDedicatedGateway.
    :vartype sql_dedicated_gateway_endpoint: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "status": {"readonly": True},
        "sql_dedicated_gateway_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "sql_dedicated_gateway_endpoint": {"key": "sqlDedicatedGatewayEndpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sql_dedicated_gateway_endpoint = None


class SqlDedicatedGatewayServiceResource(_serialization.Model):
    """Describes the service response property for SqlDedicatedGateway.

    :ivar properties: Properties for SqlDedicatedGatewayServiceResource.
    :vartype properties: ~azure.mgmt.cosmosdb.models.SqlDedicatedGatewayServiceResourceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "SqlDedicatedGatewayServiceResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.SqlDedicatedGatewayServiceResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties for SqlDedicatedGatewayServiceResource.
        :paramtype properties: ~azure.mgmt.cosmosdb.models.SqlDedicatedGatewayServiceResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SqlDedicatedGatewayServiceResourceCreateUpdateProperties(
    ServiceResourceCreateUpdateProperties
):  # pylint: disable=name-too-long
    """Properties for Create or Update request for SqlDedicatedGatewayServiceResource.

    All required parameters must be populated in order to send to server.

    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    :ivar dedicated_gateway_type: DedicatedGatewayType for the service. Known values are:
     "IntegratedCache" and "DistributedQuery".
    :vartype dedicated_gateway_type: str or ~azure.mgmt.cosmosdb.models.DedicatedGatewayType
    """

    _validation = {
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
    }

    _attribute_map = {
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
        "dedicated_gateway_type": {"key": "dedicatedGatewayType", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        dedicated_gateway_type: Optional[Union[str, "_models.DedicatedGatewayType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        :keyword dedicated_gateway_type: DedicatedGatewayType for the service. Known values are:
         "IntegratedCache" and "DistributedQuery".
        :paramtype dedicated_gateway_type: str or ~azure.mgmt.cosmosdb.models.DedicatedGatewayType
        """
        super().__init__(instance_size=instance_size, instance_count=instance_count, **kwargs)
        self.service_type: str = "SqlDedicatedGateway"
        self.dedicated_gateway_type = dedicated_gateway_type


class SqlDedicatedGatewayServiceResourceProperties(ServiceResourceProperties):  # pylint: disable=name-too-long
    """Properties for SqlDedicatedGatewayServiceResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_time: Time of the last state change (ISO-8601 format).
    :vartype creation_time: ~datetime.datetime
    :ivar instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
     "Cosmos.D8s", and "Cosmos.D16s".
    :vartype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
    :ivar instance_count: Instance count for the service.
    :vartype instance_count: int
    :ivar service_type: ServiceType for the service. Required. Known values are:
     "SqlDedicatedGateway", "DataTransfer", "GraphAPICompute", and "MaterializedViewsBuilder".
    :vartype service_type: str or ~azure.mgmt.cosmosdb.models.ServiceType
    :ivar status: Describes the status of a service. Known values are: "Creating", "Running",
     "Updating", "Deleting", "Error", and "Stopped".
    :vartype status: str or ~azure.mgmt.cosmosdb.models.ServiceStatus
    :ivar sql_dedicated_gateway_endpoint: SqlDedicatedGateway endpoint for the service.
    :vartype sql_dedicated_gateway_endpoint: str
    :ivar dedicated_gateway_type: DedicatedGatewayType for the service. Known values are:
     "IntegratedCache" and "DistributedQuery".
    :vartype dedicated_gateway_type: str or ~azure.mgmt.cosmosdb.models.DedicatedGatewayType
    :ivar locations: An array that contains all of the locations for the service.
    :vartype locations:
     list[~azure.mgmt.cosmosdb.models.SqlDedicatedGatewayRegionalServiceResource]
    """

    _validation = {
        "creation_time": {"readonly": True},
        "instance_count": {"minimum": 0},
        "service_type": {"required": True},
        "status": {"readonly": True},
        "locations": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "instance_size": {"key": "instanceSize", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "service_type": {"key": "serviceType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "sql_dedicated_gateway_endpoint": {"key": "sqlDedicatedGatewayEndpoint", "type": "str"},
        "dedicated_gateway_type": {"key": "dedicatedGatewayType", "type": "str"},
        "locations": {"key": "locations", "type": "[SqlDedicatedGatewayRegionalServiceResource]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        instance_size: Optional[Union[str, "_models.ServiceSize"]] = None,
        instance_count: Optional[int] = None,
        sql_dedicated_gateway_endpoint: Optional[str] = None,
        dedicated_gateway_type: Optional[Union[str, "_models.DedicatedGatewayType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword instance_size: Instance type for the service. Known values are: "Cosmos.D4s",
         "Cosmos.D8s", and "Cosmos.D16s".
        :paramtype instance_size: str or ~azure.mgmt.cosmosdb.models.ServiceSize
        :keyword instance_count: Instance count for the service.
        :paramtype instance_count: int
        :keyword sql_dedicated_gateway_endpoint: SqlDedicatedGateway endpoint for the service.
        :paramtype sql_dedicated_gateway_endpoint: str
        :keyword dedicated_gateway_type: DedicatedGatewayType for the service. Known values are:
         "IntegratedCache" and "DistributedQuery".
        :paramtype dedicated_gateway_type: str or ~azure.mgmt.cosmosdb.models.DedicatedGatewayType
        """
        super().__init__(
            additional_properties=additional_properties,
            instance_size=instance_size,
            instance_count=instance_count,
            **kwargs
        )
        self.service_type: str = "SqlDedicatedGateway"
        self.sql_dedicated_gateway_endpoint = sql_dedicated_gateway_endpoint
        self.dedicated_gateway_type = dedicated_gateway_type
        self.locations = None


class SqlRoleAssignmentCreateUpdateParameters(_serialization.Model):
    """Parameters to create and update an Azure Cosmos DB SQL Role Assignment.

    :ivar role_definition_id: The unique identifier for the associated Role Definition.
    :vartype role_definition_id: str
    :ivar scope: The data plane resource path for which access is being granted through this Role
     Assignment.
    :vartype scope: str
    :ivar principal_id: The unique identifier for the associated AAD principal in the AAD graph to
     which access is being granted through this Role Assignment. Tenant ID for the principal is
     inferred using the tenant associated with the subscription.
    :vartype principal_id: str
    """

    _attribute_map = {
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        scope: Optional[str] = None,
        principal_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_definition_id: The unique identifier for the associated Role Definition.
        :paramtype role_definition_id: str
        :keyword scope: The data plane resource path for which access is being granted through this
         Role Assignment.
        :paramtype scope: str
        :keyword principal_id: The unique identifier for the associated AAD principal in the AAD graph
         to which access is being granted through this Role Assignment. Tenant ID for the principal is
         inferred using the tenant associated with the subscription.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.role_definition_id = role_definition_id
        self.scope = scope
        self.principal_id = principal_id


class SqlRoleAssignmentGetResults(ARMProxyResource):
    """An Azure Cosmos DB Role Assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar role_definition_id: The unique identifier for the associated Role Definition.
    :vartype role_definition_id: str
    :ivar scope: The data plane resource path for which access is being granted through this Role
     Assignment.
    :vartype scope: str
    :ivar principal_id: The unique identifier for the associated AAD principal in the AAD graph to
     which access is being granted through this Role Assignment. Tenant ID for the principal is
     inferred using the tenant associated with the subscription.
    :vartype principal_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        scope: Optional[str] = None,
        principal_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_definition_id: The unique identifier for the associated Role Definition.
        :paramtype role_definition_id: str
        :keyword scope: The data plane resource path for which access is being granted through this
         Role Assignment.
        :paramtype scope: str
        :keyword principal_id: The unique identifier for the associated AAD principal in the AAD graph
         to which access is being granted through this Role Assignment. Tenant ID for the principal is
         inferred using the tenant associated with the subscription.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.role_definition_id = role_definition_id
        self.scope = scope
        self.principal_id = principal_id


class SqlRoleAssignmentListResult(_serialization.Model):
    """The relevant Role Assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Role Assignments and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlRoleAssignmentGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlRoleAssignmentGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SqlRoleDefinitionCreateUpdateParameters(_serialization.Model):
    """Parameters to create and update an Azure Cosmos DB SQL Role Definition.

    :ivar role_name: A user-friendly name for the Role Definition. Must be unique for the database
     account.
    :vartype role_name: str
    :ivar type: Indicates whether the Role Definition was built-in or user created. Known values
     are: "BuiltInRole" and "CustomRole".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.RoleDefinitionType
    :ivar assignable_scopes: A set of fully qualified Scopes at or below which Role Assignments may
     be created using this Role Definition. This will allow application of this Role Definition on
     the entire database account or any underlying Database / Collection. Must have at least one
     element. Scopes higher than Database account are not enforceable as assignable Scopes. Note
     that resources referenced in assignable Scopes need not exist.
    :vartype assignable_scopes: list[str]
    :ivar permissions: The set of operations allowed through this Role Definition.
    :vartype permissions: list[~azure.mgmt.cosmosdb.models.Permission]
    """

    _attribute_map = {
        "role_name": {"key": "properties.roleName", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "assignable_scopes": {"key": "properties.assignableScopes", "type": "[str]"},
        "permissions": {"key": "properties.permissions", "type": "[Permission]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        type: Optional[Union[str, "_models.RoleDefinitionType"]] = None,
        assignable_scopes: Optional[List[str]] = None,
        permissions: Optional[List["_models.Permission"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: A user-friendly name for the Role Definition. Must be unique for the
         database account.
        :paramtype role_name: str
        :keyword type: Indicates whether the Role Definition was built-in or user created. Known values
         are: "BuiltInRole" and "CustomRole".
        :paramtype type: str or ~azure.mgmt.cosmosdb.models.RoleDefinitionType
        :keyword assignable_scopes: A set of fully qualified Scopes at or below which Role Assignments
         may be created using this Role Definition. This will allow application of this Role Definition
         on the entire database account or any underlying Database / Collection. Must have at least one
         element. Scopes higher than Database account are not enforceable as assignable Scopes. Note
         that resources referenced in assignable Scopes need not exist.
        :paramtype assignable_scopes: list[str]
        :keyword permissions: The set of operations allowed through this Role Definition.
        :paramtype permissions: list[~azure.mgmt.cosmosdb.models.Permission]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.type = type
        self.assignable_scopes = assignable_scopes
        self.permissions = permissions


class SqlRoleDefinitionGetResults(ARMProxyResource):
    """An Azure Cosmos DB SQL Role Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar role_name: A user-friendly name for the Role Definition. Must be unique for the database
     account.
    :vartype role_name: str
    :ivar type_properties_type: Indicates whether the Role Definition was built-in or user created.
     Known values are: "BuiltInRole" and "CustomRole".
    :vartype type_properties_type: str or ~azure.mgmt.cosmosdb.models.RoleDefinitionType
    :ivar assignable_scopes: A set of fully qualified Scopes at or below which Role Assignments may
     be created using this Role Definition. This will allow application of this Role Definition on
     the entire database account or any underlying Database / Collection. Must have at least one
     element. Scopes higher than Database account are not enforceable as assignable Scopes. Note
     that resources referenced in assignable Scopes need not exist.
    :vartype assignable_scopes: list[str]
    :ivar permissions: The set of operations allowed through this Role Definition.
    :vartype permissions: list[~azure.mgmt.cosmosdb.models.Permission]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "role_name": {"key": "properties.roleName", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "assignable_scopes": {"key": "properties.assignableScopes", "type": "[str]"},
        "permissions": {"key": "properties.permissions", "type": "[Permission]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        type_properties_type: Optional[Union[str, "_models.RoleDefinitionType"]] = None,
        assignable_scopes: Optional[List[str]] = None,
        permissions: Optional[List["_models.Permission"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: A user-friendly name for the Role Definition. Must be unique for the
         database account.
        :paramtype role_name: str
        :keyword type_properties_type: Indicates whether the Role Definition was built-in or user
         created. Known values are: "BuiltInRole" and "CustomRole".
        :paramtype type_properties_type: str or ~azure.mgmt.cosmosdb.models.RoleDefinitionType
        :keyword assignable_scopes: A set of fully qualified Scopes at or below which Role Assignments
         may be created using this Role Definition. This will allow application of this Role Definition
         on the entire database account or any underlying Database / Collection. Must have at least one
         element. Scopes higher than Database account are not enforceable as assignable Scopes. Note
         that resources referenced in assignable Scopes need not exist.
        :paramtype assignable_scopes: list[str]
        :keyword permissions: The set of operations allowed through this Role Definition.
        :paramtype permissions: list[~azure.mgmt.cosmosdb.models.Permission]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.type_properties_type = type_properties_type
        self.assignable_scopes = assignable_scopes
        self.permissions = permissions


class SqlRoleDefinitionListResult(_serialization.Model):
    """The relevant Role Definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Role Definitions and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlRoleDefinitionGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlRoleDefinitionGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SqlStoredProcedureCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB storedProcedure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a storedProcedure. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlStoredProcedureResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlStoredProcedureResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.SqlStoredProcedureResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a storedProcedure. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlStoredProcedureResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlStoredProcedureResource(_serialization.Model):
    """Cosmos DB SQL storedProcedure resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB SQL storedProcedure. Required.
    :vartype id: str
    :ivar body: Body of the Stored Procedure.
    :vartype body: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "body": {"key": "body", "type": "str"},
    }

    def __init__(
        self, *, id: str, body: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL storedProcedure. Required.
        :paramtype id: str
        :keyword body: Body of the Stored Procedure.
        :paramtype body: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.body = body


class SqlStoredProcedureGetPropertiesResource(SqlStoredProcedureResource, ExtendedResourceProperties):
    """SqlStoredProcedureGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL storedProcedure. Required.
    :vartype id: str
    :ivar body: Body of the Stored Procedure.
    :vartype body: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "body": {"key": "body", "type": "str"},
    }

    def __init__(
        self, *, id: str, body: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL storedProcedure. Required.
        :paramtype id: str
        :keyword body: Body of the Stored Procedure.
        :paramtype body: str
        """
        super().__init__(id=id, body=body, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.body = body


class SqlStoredProcedureGetResults(ARMResourceProperties):
    """An Azure Cosmos DB storedProcedure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlStoredProcedureGetPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlStoredProcedureGetPropertiesResource"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.SqlStoredProcedureGetPropertiesResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlStoredProcedureGetPropertiesResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource


class SqlStoredProcedureListResult(_serialization.Model):
    """The List operation response, that contains the storedProcedures and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of storedProcedures and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlStoredProcedureGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlStoredProcedureGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SqlTriggerCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB trigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a trigger. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlTriggerResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlTriggerResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.SqlTriggerResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a trigger. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlTriggerResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlTriggerResource(_serialization.Model):
    """Cosmos DB SQL trigger resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB SQL trigger. Required.
    :vartype id: str
    :ivar body: Body of the Trigger.
    :vartype body: str
    :ivar trigger_type: Type of the Trigger. Known values are: "Pre" and "Post".
    :vartype trigger_type: str or ~azure.mgmt.cosmosdb.models.TriggerType
    :ivar trigger_operation: The operation the trigger is associated with. Known values are: "All",
     "Create", "Update", "Delete", and "Replace".
    :vartype trigger_operation: str or ~azure.mgmt.cosmosdb.models.TriggerOperation
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "body": {"key": "body", "type": "str"},
        "trigger_type": {"key": "triggerType", "type": "str"},
        "trigger_operation": {"key": "triggerOperation", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        body: Optional[str] = None,
        trigger_type: Optional[Union[str, "_models.TriggerType"]] = None,
        trigger_operation: Optional[Union[str, "_models.TriggerOperation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL trigger. Required.
        :paramtype id: str
        :keyword body: Body of the Trigger.
        :paramtype body: str
        :keyword trigger_type: Type of the Trigger. Known values are: "Pre" and "Post".
        :paramtype trigger_type: str or ~azure.mgmt.cosmosdb.models.TriggerType
        :keyword trigger_operation: The operation the trigger is associated with. Known values are:
         "All", "Create", "Update", "Delete", and "Replace".
        :paramtype trigger_operation: str or ~azure.mgmt.cosmosdb.models.TriggerOperation
        """
        super().__init__(**kwargs)
        self.id = id
        self.body = body
        self.trigger_type = trigger_type
        self.trigger_operation = trigger_operation


class SqlTriggerGetPropertiesResource(SqlTriggerResource, ExtendedResourceProperties):
    """SqlTriggerGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL trigger. Required.
    :vartype id: str
    :ivar body: Body of the Trigger.
    :vartype body: str
    :ivar trigger_type: Type of the Trigger. Known values are: "Pre" and "Post".
    :vartype trigger_type: str or ~azure.mgmt.cosmosdb.models.TriggerType
    :ivar trigger_operation: The operation the trigger is associated with. Known values are: "All",
     "Create", "Update", "Delete", and "Replace".
    :vartype trigger_operation: str or ~azure.mgmt.cosmosdb.models.TriggerOperation
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "body": {"key": "body", "type": "str"},
        "trigger_type": {"key": "triggerType", "type": "str"},
        "trigger_operation": {"key": "triggerOperation", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        body: Optional[str] = None,
        trigger_type: Optional[Union[str, "_models.TriggerType"]] = None,
        trigger_operation: Optional[Union[str, "_models.TriggerOperation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL trigger. Required.
        :paramtype id: str
        :keyword body: Body of the Trigger.
        :paramtype body: str
        :keyword trigger_type: Type of the Trigger. Known values are: "Pre" and "Post".
        :paramtype trigger_type: str or ~azure.mgmt.cosmosdb.models.TriggerType
        :keyword trigger_operation: The operation the trigger is associated with. Known values are:
         "All", "Create", "Update", "Delete", and "Replace".
        :paramtype trigger_operation: str or ~azure.mgmt.cosmosdb.models.TriggerOperation
        """
        super().__init__(id=id, body=body, trigger_type=trigger_type, trigger_operation=trigger_operation, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.body = body
        self.trigger_type = trigger_type
        self.trigger_operation = trigger_operation


class SqlTriggerGetResults(ARMResourceProperties):
    """An Azure Cosmos DB trigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlTriggerGetPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlTriggerGetPropertiesResource"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.SqlTriggerGetPropertiesResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlTriggerGetPropertiesResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource


class SqlTriggerListResult(_serialization.Model):
    """The List operation response, that contains the triggers and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of triggers and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlTriggerGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlTriggerGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SqlUserDefinedFunctionCreateUpdateParameters(ARMResourceProperties):  # pylint: disable=name-too-long
    """Parameters to create and update Cosmos DB userDefinedFunction.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a userDefinedFunction. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlUserDefinedFunctionResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.SqlUserDefinedFunctionResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a userDefinedFunction. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class SqlUserDefinedFunctionResource(_serialization.Model):
    """Cosmos DB SQL userDefinedFunction resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB SQL userDefinedFunction. Required.
    :vartype id: str
    :ivar body: Body of the User Defined Function.
    :vartype body: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "body": {"key": "body", "type": "str"},
    }

    def __init__(
        self, *, id: str, body: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL userDefinedFunction. Required.
        :paramtype id: str
        :keyword body: Body of the User Defined Function.
        :paramtype body: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.body = body


class SqlUserDefinedFunctionGetPropertiesResource(
    SqlUserDefinedFunctionResource, ExtendedResourceProperties
):  # pylint: disable=name-too-long
    """SqlUserDefinedFunctionGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB SQL userDefinedFunction. Required.
    :vartype id: str
    :ivar body: Body of the User Defined Function.
    :vartype body: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "body": {"key": "body", "type": "str"},
    }

    def __init__(
        self, *, id: str, body: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB SQL userDefinedFunction. Required.
        :paramtype id: str
        :keyword body: Body of the User Defined Function.
        :paramtype body: str
        """
        super().__init__(id=id, body=body, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.body = body


class SqlUserDefinedFunctionGetResults(ARMResourceProperties):
    """An Azure Cosmos DB userDefinedFunction.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionGetPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "SqlUserDefinedFunctionGetPropertiesResource"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.SqlUserDefinedFunctionGetPropertiesResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionGetPropertiesResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource


class SqlUserDefinedFunctionListResult(_serialization.Model):
    """The List operation response, that contains the userDefinedFunctions and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of userDefinedFunctions and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlUserDefinedFunctionGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.cosmosdb.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.cosmosdb.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.cosmosdb.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.cosmosdb.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TableCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Table.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a Table. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.TableResource
    :ivar options: A key-value pair of options to be applied for the request. This corresponds to
     the headers sent with the request.
    :vartype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "TableResource"},
        "options": {"key": "properties.options", "type": "CreateUpdateOptions"},
    }

    def __init__(
        self,
        *,
        resource: "_models.TableResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        options: Optional["_models.CreateUpdateOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a Table. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.TableResource
        :keyword options: A key-value pair of options to be applied for the request. This corresponds
         to the headers sent with the request.
        :paramtype options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class TableGetPropertiesOptions(OptionsResource):
    """TableGetPropertiesOptions.

    :ivar throughput: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     ThroughputSetting resource when retrieving offer details.
    :vartype throughput: int
    :ivar autoscale_settings: Specifies the Autoscale settings.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """


class TableResource(_serialization.Model):
    """Cosmos DB table resource object.

    All required parameters must be populated in order to send to server.

    :ivar id: Name of the Cosmos DB table. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB table. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(**kwargs)
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class TableGetPropertiesResource(TableResource, ExtendedResourceProperties):
    """TableGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar id: Name of the Cosmos DB table. Required.
    :vartype id: str
    :ivar restore_parameters: Parameters to indicate the information about the restore.
    :vartype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
    :ivar create_mode: Enum to indicate the mode of resource creation. Known values are: "Default"
     and "Restore".
    :vartype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "restore_parameters": {"key": "restoreParameters", "type": "ResourceRestoreParameters"},
        "create_mode": {"key": "createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        restore_parameters: Optional["_models.ResourceRestoreParameters"] = None,
        create_mode: Union[str, "_models.CreateMode"] = "Default",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Name of the Cosmos DB table. Required.
        :paramtype id: str
        :keyword restore_parameters: Parameters to indicate the information about the restore.
        :paramtype restore_parameters: ~azure.mgmt.cosmosdb.models.ResourceRestoreParameters
        :keyword create_mode: Enum to indicate the mode of resource creation. Known values are:
         "Default" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
        """
        super().__init__(id=id, restore_parameters=restore_parameters, create_mode=create_mode, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.id = id
        self.restore_parameters = restore_parameters
        self.create_mode = create_mode


class TableGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Table.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.TableGetPropertiesResource
    :ivar options:
    :vartype options: ~azure.mgmt.cosmosdb.models.TableGetPropertiesOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "TableGetPropertiesResource"},
        "options": {"key": "properties.options", "type": "TableGetPropertiesOptions"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.TableGetPropertiesResource"] = None,
        options: Optional["_models.TableGetPropertiesOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.TableGetPropertiesResource
        :keyword options:
        :paramtype options: ~azure.mgmt.cosmosdb.models.TableGetPropertiesOptions
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource
        self.options = options


class TableListResult(_serialization.Model):
    """The List operation response, that contains the Table and their properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Table and their properties.
    :vartype value: list[~azure.mgmt.cosmosdb.models.TableGetResults]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TableGetResults]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class ThroughputPolicyResource(_serialization.Model):
    """Cosmos DB resource throughput policy.

    :ivar is_enabled: Determines whether the ThroughputPolicy is active or not.
    :vartype is_enabled: bool
    :ivar increment_percent: Represents the percentage by which throughput can increase every time
     throughput policy kicks in.
    :vartype increment_percent: int
    """

    _attribute_map = {
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "increment_percent": {"key": "incrementPercent", "type": "int"},
    }

    def __init__(
        self, *, is_enabled: Optional[bool] = None, increment_percent: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Determines whether the ThroughputPolicy is active or not.
        :paramtype is_enabled: bool
        :keyword increment_percent: Represents the percentage by which throughput can increase every
         time throughput policy kicks in.
        :paramtype increment_percent: int
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.increment_percent = increment_percent


class ThroughputSettingsResource(_serialization.Model):
    """Cosmos DB resource throughput object. Either throughput is required or autoscaleSettings is
    required, but not both.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar throughput: Value of the Cosmos DB resource throughput. Either throughput is required or
     autoscaleSettings is required, but not both.
    :vartype throughput: int
    :ivar autoscale_settings: Cosmos DB resource for autoscale settings. Either throughput is
     required or autoscaleSettings is required, but not both.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettingsResource
    :ivar minimum_throughput: The minimum throughput of the resource.
    :vartype minimum_throughput: str
    :ivar offer_replace_pending: The throughput replace is pending.
    :vartype offer_replace_pending: str
    :ivar instant_maximum_throughput: The offer throughput value to instantly scale up without
     triggering splits.
    :vartype instant_maximum_throughput: str
    :ivar soft_allowed_maximum_throughput: The maximum throughput value or the maximum
     maxThroughput value (for autoscale) that can be specified.
    :vartype soft_allowed_maximum_throughput: str
    """

    _validation = {
        "minimum_throughput": {"readonly": True},
        "offer_replace_pending": {"readonly": True},
        "instant_maximum_throughput": {"readonly": True},
        "soft_allowed_maximum_throughput": {"readonly": True},
    }

    _attribute_map = {
        "throughput": {"key": "throughput", "type": "int"},
        "autoscale_settings": {"key": "autoscaleSettings", "type": "AutoscaleSettingsResource"},
        "minimum_throughput": {"key": "minimumThroughput", "type": "str"},
        "offer_replace_pending": {"key": "offerReplacePending", "type": "str"},
        "instant_maximum_throughput": {"key": "instantMaximumThroughput", "type": "str"},
        "soft_allowed_maximum_throughput": {"key": "softAllowedMaximumThroughput", "type": "str"},
    }

    def __init__(
        self,
        *,
        throughput: Optional[int] = None,
        autoscale_settings: Optional["_models.AutoscaleSettingsResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword throughput: Value of the Cosmos DB resource throughput. Either throughput is required
         or autoscaleSettings is required, but not both.
        :paramtype throughput: int
        :keyword autoscale_settings: Cosmos DB resource for autoscale settings. Either throughput is
         required or autoscaleSettings is required, but not both.
        :paramtype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettingsResource
        """
        super().__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings
        self.minimum_throughput = None
        self.offer_replace_pending = None
        self.instant_maximum_throughput = None
        self.soft_allowed_maximum_throughput = None


class ThroughputSettingsGetPropertiesResource(ThroughputSettingsResource, ExtendedResourceProperties):
    """ThroughputSettingsGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rid: A system generated property. A unique identifier.
    :vartype rid: str
    :ivar ts: A system generated property that denotes the last updated timestamp of the resource.
    :vartype ts: float
    :ivar etag: A system generated property representing the resource etag required for optimistic
     concurrency control.
    :vartype etag: str
    :ivar throughput: Value of the Cosmos DB resource throughput. Either throughput is required or
     autoscaleSettings is required, but not both.
    :vartype throughput: int
    :ivar autoscale_settings: Cosmos DB resource for autoscale settings. Either throughput is
     required or autoscaleSettings is required, but not both.
    :vartype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettingsResource
    :ivar minimum_throughput: The minimum throughput of the resource.
    :vartype minimum_throughput: str
    :ivar offer_replace_pending: The throughput replace is pending.
    :vartype offer_replace_pending: str
    :ivar instant_maximum_throughput: The offer throughput value to instantly scale up without
     triggering splits.
    :vartype instant_maximum_throughput: str
    :ivar soft_allowed_maximum_throughput: The maximum throughput value or the maximum
     maxThroughput value (for autoscale) that can be specified.
    :vartype soft_allowed_maximum_throughput: str
    """

    _validation = {
        "rid": {"readonly": True},
        "ts": {"readonly": True},
        "etag": {"readonly": True},
        "minimum_throughput": {"readonly": True},
        "offer_replace_pending": {"readonly": True},
        "instant_maximum_throughput": {"readonly": True},
        "soft_allowed_maximum_throughput": {"readonly": True},
    }

    _attribute_map = {
        "rid": {"key": "_rid", "type": "str"},
        "ts": {"key": "_ts", "type": "float"},
        "etag": {"key": "_etag", "type": "str"},
        "throughput": {"key": "throughput", "type": "int"},
        "autoscale_settings": {"key": "autoscaleSettings", "type": "AutoscaleSettingsResource"},
        "minimum_throughput": {"key": "minimumThroughput", "type": "str"},
        "offer_replace_pending": {"key": "offerReplacePending", "type": "str"},
        "instant_maximum_throughput": {"key": "instantMaximumThroughput", "type": "str"},
        "soft_allowed_maximum_throughput": {"key": "softAllowedMaximumThroughput", "type": "str"},
    }

    def __init__(
        self,
        *,
        throughput: Optional[int] = None,
        autoscale_settings: Optional["_models.AutoscaleSettingsResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword throughput: Value of the Cosmos DB resource throughput. Either throughput is required
         or autoscaleSettings is required, but not both.
        :paramtype throughput: int
        :keyword autoscale_settings: Cosmos DB resource for autoscale settings. Either throughput is
         required or autoscaleSettings is required, but not both.
        :paramtype autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettingsResource
        """
        super().__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)
        self.rid = None
        self.ts = None
        self.etag = None
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings
        self.minimum_throughput = None
        self.offer_replace_pending = None
        self.instant_maximum_throughput = None
        self.soft_allowed_maximum_throughput = None


class ThroughputSettingsGetResults(ARMResourceProperties):
    """An Azure Cosmos DB resource throughput.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource:
    :vartype resource: ~azure.mgmt.cosmosdb.models.ThroughputSettingsGetPropertiesResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "ThroughputSettingsGetPropertiesResource"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        resource: Optional["_models.ThroughputSettingsGetPropertiesResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource:
        :paramtype resource: ~azure.mgmt.cosmosdb.models.ThroughputSettingsGetPropertiesResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource


class ThroughputSettingsUpdateParameters(ARMResourceProperties):
    """Parameters to update Cosmos DB resource throughput.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar location: The location of the resource group to which the resource belongs.
    :vartype location: str
    :ivar tags: Tags are a list of key-value pairs that describe the resource. These tags can be
     used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
     be provided for a resource. Each tag must have a key no greater than 128 characters and value
     no greater than 256 characters. For example, the default experience for a template type is set
     with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
     "Graph", "DocumentDB", and "MongoDB".
    :vartype tags: dict[str, str]
    :ivar resource: The standard JSON format of a resource throughput. Required.
    :vartype resource: ~azure.mgmt.cosmosdb.models.ThroughputSettingsResource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "resource": {"key": "properties.resource", "type": "ThroughputSettingsResource"},
    }

    def __init__(
        self,
        *,
        resource: "_models.ThroughputSettingsResource",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource group to which the resource belongs.
        :paramtype location: str
        :keyword tags: Tags are a list of key-value pairs that describe the resource. These tags can be
         used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can
         be provided for a resource. Each tag must have a key no greater than 128 characters and value
         no greater than 256 characters. For example, the default experience for a template type is set
         with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table",
         "Graph", "DocumentDB", and "MongoDB".
        :paramtype tags: dict[str, str]
        :keyword resource: The standard JSON format of a resource throughput. Required.
        :paramtype resource: ~azure.mgmt.cosmosdb.models.ThroughputSettingsResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.resource = resource


class UniqueKey(_serialization.Model):
    """The unique key on that enforces uniqueness constraint on documents in the collection in the
    Azure Cosmos DB service.

    :ivar paths: List of paths must be unique for each document in the Azure Cosmos DB service.
    :vartype paths: list[str]
    """

    _attribute_map = {
        "paths": {"key": "paths", "type": "[str]"},
    }

    def __init__(self, *, paths: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword paths: List of paths must be unique for each document in the Azure Cosmos DB service.
        :paramtype paths: list[str]
        """
        super().__init__(**kwargs)
        self.paths = paths


class UniqueKeyPolicy(_serialization.Model):
    """The unique key policy configuration for specifying uniqueness constraints on documents in the
    collection in the Azure Cosmos DB service.

    :ivar unique_keys: List of unique keys on that enforces uniqueness constraint on documents in
     the collection in the Azure Cosmos DB service.
    :vartype unique_keys: list[~azure.mgmt.cosmosdb.models.UniqueKey]
    """

    _attribute_map = {
        "unique_keys": {"key": "uniqueKeys", "type": "[UniqueKey]"},
    }

    def __init__(self, *, unique_keys: Optional[List["_models.UniqueKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword unique_keys: List of unique keys on that enforces uniqueness constraint on documents
         in the collection in the Azure Cosmos DB service.
        :paramtype unique_keys: list[~azure.mgmt.cosmosdb.models.UniqueKey]
        """
        super().__init__(**kwargs)
        self.unique_keys = unique_keys


class UsagesResult(_serialization.Model):
    """The response to a list usage request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of usages for the database. A usage is a point in time metric.
    :vartype value: list[~azure.mgmt.cosmosdb.models.Usage]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class VectorEmbedding(_serialization.Model):
    """Represents a vector embedding. A vector embedding is used to define a vector field in the
    documents.

    All required parameters must be populated in order to send to server.

    :ivar path: The path to the vector field in the document. Required.
    :vartype path: str
    :ivar data_type: Indicates the data type of vector. Required. Known values are: "float32",
     "uint8", and "int8".
    :vartype data_type: str or ~azure.mgmt.cosmosdb.models.VectorDataType
    :ivar distance_function: The distance function to use for distance calculation in between
     vectors. Required. Known values are: "euclidean", "cosine", and "dotproduct".
    :vartype distance_function: str or ~azure.mgmt.cosmosdb.models.DistanceFunction
    :ivar dimensions: The number of dimensions in the vector. Required.
    :vartype dimensions: int
    """

    _validation = {
        "path": {"required": True},
        "data_type": {"required": True},
        "distance_function": {"required": True},
        "dimensions": {"required": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "distance_function": {"key": "distanceFunction", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "int"},
    }

    def __init__(
        self,
        *,
        path: str,
        data_type: Union[str, "_models.VectorDataType"],
        distance_function: Union[str, "_models.DistanceFunction"],
        dimensions: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path to the vector field in the document. Required.
        :paramtype path: str
        :keyword data_type: Indicates the data type of vector. Required. Known values are: "float32",
         "uint8", and "int8".
        :paramtype data_type: str or ~azure.mgmt.cosmosdb.models.VectorDataType
        :keyword distance_function: The distance function to use for distance calculation in between
         vectors. Required. Known values are: "euclidean", "cosine", and "dotproduct".
        :paramtype distance_function: str or ~azure.mgmt.cosmosdb.models.DistanceFunction
        :keyword dimensions: The number of dimensions in the vector. Required.
        :paramtype dimensions: int
        """
        super().__init__(**kwargs)
        self.path = path
        self.data_type = data_type
        self.distance_function = distance_function
        self.dimensions = dimensions


class VectorEmbeddingPolicy(_serialization.Model):
    """Cosmos DB Vector Embedding Policy.

    :ivar vector_embeddings: List of vector embeddings.
    :vartype vector_embeddings: list[~azure.mgmt.cosmosdb.models.VectorEmbedding]
    """

    _attribute_map = {
        "vector_embeddings": {"key": "vectorEmbeddings", "type": "[VectorEmbedding]"},
    }

    def __init__(self, *, vector_embeddings: Optional[List["_models.VectorEmbedding"]] = None, **kwargs: Any) -> None:
        """
        :keyword vector_embeddings: List of vector embeddings.
        :paramtype vector_embeddings: list[~azure.mgmt.cosmosdb.models.VectorEmbedding]
        """
        super().__init__(**kwargs)
        self.vector_embeddings = vector_embeddings


class VectorIndex(_serialization.Model):
    """VectorIndex.

    All required parameters must be populated in order to send to server.

    :ivar path: The path to the vector field in the document. Required.
    :vartype path: str
    :ivar type: The index type of the vector. Currently, flat, diskANN, and quantizedFlat are
     supported. Required. Known values are: "flat", "diskANN", and "quantizedFlat".
    :vartype type: str or ~azure.mgmt.cosmosdb.models.VectorIndexType
    """

    _validation = {
        "path": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, path: str, type: Union[str, "_models.VectorIndexType"], **kwargs: Any) -> None:
        """
        :keyword path: The path to the vector field in the document. Required.
        :paramtype path: str
        :keyword type: The index type of the vector. Currently, flat, diskANN, and quantizedFlat are
         supported. Required. Known values are: "flat", "diskANN", and "quantizedFlat".
        :paramtype type: str or ~azure.mgmt.cosmosdb.models.VectorIndexType
        """
        super().__init__(**kwargs)
        self.path = path
        self.type = type


class VirtualNetworkRule(_serialization.Model):
    """Virtual Network ACL Rule object.

    :ivar id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar ignore_missing_v_net_service_endpoint: Create firewall rule before the virtual network
     has vnet service endpoint enabled.
    :vartype ignore_missing_v_net_service_endpoint: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ignore_missing_v_net_service_endpoint": {"key": "ignoreMissingVNetServiceEndpoint", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        ignore_missing_v_net_service_endpoint: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype id: str
        :keyword ignore_missing_v_net_service_endpoint: Create firewall rule before the virtual network
         has vnet service endpoint enabled.
        :paramtype ignore_missing_v_net_service_endpoint: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.ignore_missing_v_net_service_endpoint = ignore_missing_v_net_service_endpoint
