/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml.rules;

import com.tngtech.archunit.library.plantuml.rules.Alias;
import com.tngtech.archunit.library.plantuml.rules.ComponentIdentifier;
import com.tngtech.archunit.library.plantuml.rules.ComponentName;
import com.tngtech.archunit.library.plantuml.rules.IllegalDiagramException;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponent;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class PlantUmlComponents {
    private final Map<ComponentName, PlantUmlComponent> componentsByName;
    private final Map<Alias, PlantUmlComponent> componentsByAlias;
    private static final Predicate<PlantUmlComponent> WITH_ALIAS = input -> input.getAlias().isPresent();

    PlantUmlComponents(Set<PlantUmlComponent> components) {
        this.componentsByName = FluentIterable.from(components).uniqueIndex(PlantUmlComponent::getComponentName);
        this.componentsByAlias = components.stream().filter(WITH_ALIAS).collect(Collectors.toMap(PlantUmlComponent.Functions.TO_EXISTING_ALIAS, Function.identity()));
    }

    Collection<PlantUmlComponent> getAllComponents() {
        return this.componentsByName.values();
    }

    Collection<PlantUmlComponent> getComponentsWithAlias() {
        return this.componentsByAlias.values();
    }

    PlantUmlComponent findComponentWith(String nameOrAlias) {
        PlantUmlComponent result;
        ComponentName componentName = new ComponentName(nameOrAlias);
        Alias alias = new Alias(nameOrAlias);
        PlantUmlComponent plantUmlComponent = result = this.componentsByAlias.containsKey(alias) ? this.componentsByAlias.get(alias) : this.componentsByName.get(componentName);
        if (result == null) {
            throw new IllegalDiagramException("There is no Component with name or alias = '%s'. %s", nameOrAlias, "Components must be specified separately from dependencies.");
        }
        return result;
    }

    PlantUmlComponent findComponentWith(ComponentIdentifier identifier) {
        return this.componentsByName.get(identifier.getComponentName());
    }
}

