/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class BaseContainer
extends JPanel {
    private Color foreground;
    private Color background;
    private Font font;
    private Color overridedBackground;
    private Color overridedForeground;
    private Font overridedFont;
    private boolean forcedOpaque = true;
    private boolean opaque = true;
    private static PanelUI UI = new PanelUI(){};

    public BaseContainer() {
        this(true);
    }

    public BaseContainer(boolean opaque) {
        this(opaque, new BorderLayout());
    }

    public BaseContainer(LayoutManager l) {
        this(true, l);
    }

    public BaseContainer(boolean opaque, LayoutManager l) {
        super(l);
        this.forcedOpaque = opaque;
        this.updateOpaque();
    }

    @Override
    public void setUI(PanelUI ui) {
        Color oBackground = this.overridedBackground;
        Color oForeground = this.overridedForeground;
        Font oFont = this.overridedFont;
        oBackground = null;
        oForeground = null;
        oFont = null;
        this.setBackground(null);
        this.setForeground(null);
        this.setFont(null);
        super.setUI(ui);
        this.background = this.getBackground();
        this.foreground = this.getForeground();
        this.font = this.getFont();
        this.overridedBackground = oBackground;
        this.overridedForeground = oForeground;
        this.overridedFont = oFont;
        if (!this.forcedOpaque) {
            super.setUI(UI);
        }
        this.updateBackground();
        this.updateForeground();
        this.updateFont();
    }

    void setForcedOpaque(boolean forcedOpaque) {
        if (this.forcedOpaque != forcedOpaque) {
            this.forcedOpaque = forcedOpaque;
            this.updateUI();
            this.updateOpaque();
        }
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
        this.updateOpaque();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.forcedOpaque) {
            super.paintComponent(g);
        }
    }

    @Override
    public void setForeground(Color fg) {
        this.foreground = fg;
        this.updateForeground();
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        this.updateBackground();
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.updateFont();
    }

    void setOverridedForeround(Color fg) {
        this.overridedForeground = fg;
        this.updateForeground();
    }

    void setOverridedBackground(Color bg) {
        this.overridedBackground = bg;
        this.updateBackground();
    }

    void setOverrideFont(Font font) {
        this.overridedFont = font;
        this.updateFont();
    }

    private void updateBackground() {
        super.setBackground(this.overridedBackground == null ? this.background : this.overridedBackground);
    }

    private void updateForeground() {
        super.setForeground(this.overridedForeground == null ? this.foreground : this.overridedForeground);
    }

    private void updateFont() {
        super.setFont(this.overridedFont == null ? this.font : this.overridedFont);
    }

    private void updateOpaque() {
        super.setOpaque(this.forcedOpaque ? this.opaque : this.forcedOpaque);
    }
}

