/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class CedillaAtom
extends Atom {
    private Atom base;

    public CedillaAtom(Atom base) {
        this.base = base;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box y;
        Box b = this.base.createBox(env);
        VerticalBox vb = new VerticalBox();
        vb.add(b);
        Char ch = env.getTeXFont().getChar("jlatexmathcedilla", env.getStyle());
        float italic = ch.getItalic();
        CharBox cedilla = new CharBox(ch);
        if (Math.abs(italic) > 1.0E-7f) {
            y = new HorizontalBox(new StrutBox(-italic, 0.0f, 0.0f, 0.0f));
            y.add(cedilla);
        } else {
            y = cedilla;
        }
        HorizontalBox ce = new HorizontalBox(y, b.getWidth(), 2);
        float x = 0.4f * SpaceAtom.getFactor(5, env);
        vb.add(new StrutBox(0.0f, -x, 0.0f, 0.0f));
        vb.add(ce);
        float f = vb.getHeight() + vb.getDepth();
        vb.setHeight(b.getHeight());
        vb.setDepth(f - b.getHeight());
        return vb;
    }
}

