/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.BDFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.videolan.CacheDir;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.bdjo.AppCache;

class VFSCache {
    boolean inAccessFile = false;
    private Object lock = new Object();
    private String cacheRoot = null;
    private String vfsRoot = null;
    private String fontRoot = null;
    private int vfsRootLength = 0;
    private boolean cacheAll = false;
    private static final String jarDir = "BDMV" + File.separator + "JAR" + File.separator;
    private static final String fontDir = "BDMV" + File.separator + "AUXDATA" + File.separator;
    private static final String streamDir = "BDMV" + File.separator + "STREAM" + File.separator;
    private static final Logger logger = Logger.getLogger(VFSCache.class.getName());

    protected static VFSCache createInstance() {
        VFSCache cache = new VFSCache();
        try {
            cache.init();
        }
        catch (IOException e) {
            return null;
        }
        return cache;
    }

    private VFSCache() {
    }

    private void init() throws IOException {
        String disable = System.getProperty("org.videolan.vfscache");
        if (disable != null && disable.equals("NO")) {
            logger.error("Cache disabled !");
            throw new IOException();
        }
        this.cacheRoot = CacheDir.create("VFSCache").getPath() + File.separator;
        this.fontRoot = CacheDir.create("Font").getPath() + File.separator;
        this.vfsRoot = System.getProperty("bluray.vfs.root");
        if (this.vfsRoot == null) {
            System.err.println("disc root is in UDF");
            System.setProperty("bluray.vfs.root", this.cacheRoot);
            this.vfsRoot = this.cacheRoot;
            this.cacheAll = true;
        }
        if (!this.vfsRoot.endsWith(File.separator)) {
            this.vfsRoot = this.vfsRoot + File.separator;
        }
        this.vfsRootLength = this.vfsRoot.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyStream(InputStream inStream, String dstPath) {
        FileOutputStream outStream = null;
        byte[] buffer = new byte[65536];
        IOException exception = null;
        try {
            int length;
            outStream = new FileOutputStream(dstPath);
            while ((length = inStream.read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            block16: {
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block16;
                        exception = e;
                    }
                }
            }
        }
        if (exception != null) {
            logger.error("Error caching to " + dstPath + ": " + exception);
            if (outStream != null && !new File(dstPath).delete()) {
                logger.info("Error removing " + dstPath);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFile(String srcPath, String dstPath) {
        FileInputStream inStream = null;
        IOException exception = null;
        boolean result = false;
        try {
            inStream = new FileInputStream(srcPath);
            result = this.copyStream(inStream, dstPath);
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            block15: {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block15;
                        exception = e;
                    }
                }
            }
        }
        if (exception != null) {
            logger.error("Error caching " + srcPath + ": " + exception);
            if (!new File(dstPath).delete()) {
                logger.info("Error removing " + dstPath);
            }
            return false;
        }
        return result;
    }

    private void copyJarFile(String name) {
        String relPath = jarDir + name;
        String dstPath = this.cacheRoot + relPath;
        if (BDFileSystem.nativeFileExists(dstPath)) {
            return;
        }
        Libbluray.cacheBdRomFile(relPath, dstPath);
        logger.info("cached " + relPath);
    }

    private void copyJarDir(String name, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            String relPath = name + File.separator + files[i];
            String[] subFiles = Libbluray.listBdFiles(relPath, true);
            if (subFiles != null) {
                this.copyJarDir(relPath, subFiles);
                continue;
            }
            Libbluray.cacheBdRomFile(relPath, this.cacheRoot + relPath);
        }
    }

    private void copyJarDir(String name) {
        String relPath = jarDir + name;
        String[] files = Libbluray.listBdFiles(relPath, true);
        if (files == null) {
            return;
        }
        this.copyJarDir(relPath, files);
        logger.info("cached " + relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(AppCache[] appCaches) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < appCaches.length; ++i) {
                if (appCaches[i].getType() == 1) {
                    this.copyJarFile(appCaches[i].getRefToName() + ".jar");
                    continue;
                }
                if (appCaches[i].getType() == 2) {
                    this.copyJarDir(appCaches[i].getRefToName());
                    continue;
                }
                logger.error("unknown AppCache type " + appCaches[i].getType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File addFont(String fontFile) {
        String relPath = fontDir + fontFile;
        String dstPath = this.fontRoot + relPath;
        File dstFile = new File(dstPath);
        Object object = this.lock;
        synchronized (object) {
            if (BDFileSystem.nativeFileExists(dstPath)) {
                return dstFile;
            }
            if (!Libbluray.cacheBdRomFile(relPath, dstPath)) {
                return null;
            }
        }
        logger.info("cached font " + fontFile);
        return dstFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File addFont(InputStream is) {
        File tmpFile = null;
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < 100; ++i) {
                tmpFile = new File(this.fontRoot + Long.toHexString(System.nanoTime() + (long)i) + ".otf");
                try {
                    tmpFile = new File(tmpFile.getCanonicalPath());
                    if (!tmpFile.exists()) {
                        break;
                    }
                }
                catch (IOException ex) {
                    logger.error("got " + ex);
                }
                tmpFile = null;
            }
            if (tmpFile == null) {
                logger.error("error creating temporary font file");
                return null;
            }
            if (!this.copyStream(is, tmpFile.getPath())) {
                return null;
            }
        }
        logger.info("cached font stream to file " + tmpFile.getPath());
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accessFile(String absPath) {
        if (!this.cacheAll) {
            return;
        }
        if (!absPath.startsWith(this.vfsRoot)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.inAccessFile) {
                return;
            }
            try {
                this.inAccessFile = true;
                this.accessFileImp(absPath);
            }
            finally {
                this.inAccessFile = false;
            }
        }
    }

    private void accessFileImp(String absPath) {
        if (BDFileSystem.nativeFileExists(absPath)) {
            return;
        }
        String relPath = absPath.substring(this.vfsRootLength);
        String[] names = Libbluray.listBdFiles(relPath, true);
        if (names != null) {
            Libbluray.cacheBdRomFile(relPath + File.separator, this.cacheRoot + relPath + File.separator);
            return;
        }
        if (relPath.startsWith(streamDir)) {
            return;
        }
        Libbluray.cacheBdRomFile(relPath, this.cacheRoot + relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(String vpFile, String budaFile) {
        String srcPath = System.getProperty("bluray.bindingunit.root") + File.separator + budaFile;
        String dstPath = this.cacheRoot + vpFile;
        Object object = this.lock;
        synchronized (object) {
            return this.copyFile(srcPath, dstPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String map(String absPath) {
        if (this.cacheAll) {
            return absPath;
        }
        if (!absPath.startsWith(this.vfsRoot)) {
            return absPath;
        }
        String cachePath = this.cacheRoot + absPath.substring(this.vfsRootLength);
        Object object = this.lock;
        synchronized (object) {
            if (!BDFileSystem.nativeFileExists(cachePath)) {
                return absPath;
            }
        }
        logger.info("using cached " + cachePath);
        return cachePath;
    }
}

